/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.copypaste;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.copypaste.Copyable;
import de.cismet.lagis.gui.copypaste.FlurstueckInfoClipboardPasteWidget;
import de.cismet.lagis.gui.copypaste.Pasteable;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagisEE.entity.basic.BasicEntity;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public final class FlurstueckInfoClipboard
implements FlurstueckChangeListener {
    private static final String[] UNUSED_COPY_OPTIONS = new String[]{"\u00dcberschreiben", "Abbrechen"};
    private final LagisApp lagisApp;
    private final JButton copyButton;
    private final JButton pasteButton;
    private FlurstueckCustomBean copyFS;
    private FlurstueckCustomBean pasteFS;
    private boolean wasCopyPastedOnce;
    private final List<Copyable> copyListeners;
    private final List<Pasteable> pasteListeners;
    private final List<BasicEntity> copiedData;
    private boolean isActive;

    public FlurstueckInfoClipboard(LagisApp lagisApp, JButton copyButton, JButton pasteButton) {
        if (lagisApp == null) {
            throw new NullPointerException("Given LagisApp instance must not be null");
        }
        if (copyButton == null) {
            throw new NullPointerException("Given copy button must not be null");
        }
        if (pasteButton == null) {
            throw new NullPointerException("Given paste button must not be null");
        }
        this.lagisApp = lagisApp;
        this.copyButton = copyButton;
        this.pasteButton = pasteButton;
        this.wasCopyPastedOnce = false;
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FlurstueckInfoClipboard.this.copy();
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FlurstueckInfoClipboard.this.paste();
            }
        });
        this.copyButton.setToolTipText("Kopiere Daten aus Flurst\u00fcck");
        this.pasteButton.setToolTipText("Es wurden noch keine Daten kopiert");
        this.copyListeners = new ArrayList<Copyable>();
        this.pasteListeners = new ArrayList<Pasteable>();
        this.copiedData = new ArrayList<BasicEntity>();
        this.setActive(false);
    }

    public void addCopyListener(Copyable copyListener) {
        this.copyListeners.add(copyListener);
    }

    public void addPasteListener(Pasteable pasteListener) {
        this.pasteListeners.add(pasteListener);
    }

    public void setActive(boolean isActive) {
        boolean active;
        this.isActive = active = isActive && this.copyFS != null && !this.copyFS.equals(this.pasteFS);
        this.pasteButton.setEnabled(active);
    }

    private void copy() {
        int answer;
        FlurstueckCustomBean oldCopyFS = this.copyFS;
        this.copyFS = LagisBroker.getInstance().getCurrentFlurstueck();
        if (oldCopyFS != null && !this.copyFS.equals(oldCopyFS) && !this.wasCopyPastedOnce && (answer = JOptionPane.showOptionDialog(this.lagisApp, "Die zuletzt kopierten Informationen zu dem Flurst\u00fcck \"" + oldCopyFS + "\" wurden nicht verwendet.\nM\u00f6chten Sie diese Daten  trotzdem mit den Informationen aus \"" + this.copyFS + "\" \u00fcberschreiben?", "Achtung", 2, 0, null, UNUSED_COPY_OPTIONS, UNUSED_COPY_OPTIONS[0])) == 1) {
            this.copyFS = oldCopyFS;
            return;
        }
        this.wasCopyPastedOnce = false;
        this.copyFS = LagisBroker.getInstance().getCurrentFlurstueck();
        this.copiedData.clear();
        for (Copyable listener : this.copyListeners) {
            this.copiedData.addAll(listener.getCopyData());
        }
        this.pasteButton.setToolTipText("Einf\u00fcgen von Daten aus Flurst\u00fcck " + this.copyFS);
    }

    private void paste() {
        if (this.pasteFS == null || this.pasteFS.equals(this.copyFS)) {
            this.pasteButton.setEnabled(false);
            return;
        }
        FlurstueckInfoClipboardPasteWidget widget = new FlurstueckInfoClipboardPasteWidget((Frame)this.lagisApp, true, this);
        StaticSwingTools.showDialog((JDialog)widget);
    }

    public List<BasicEntity> getCopiedData() {
        return this.copiedData;
    }

    public List<Copyable> getCopyListeners() {
        return this.copyListeners;
    }

    public void performPaste(List<BasicEntity> data) {
        for (Pasteable listener : this.pasteListeners) {
            listener.pasteAll(data);
        }
        this.wasCopyPastedOnce = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MappingComponent mappingComponent = LagisBroker.getInstance().getMappingComponent();
                mappingComponent.zoomToFeatureCollection();
            }
        });
        this.pasteButton.setEnabled(false);
    }

    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        this.copyButton.setToolTipText("Kopiere Daten aus Flurst\u00fcck " + newFlurstueck);
        this.copyButton.setEnabled(true);
        this.pasteFS = newFlurstueck;
        if (this.isActive && this.copyFS != null && !this.copyFS.equals(newFlurstueck)) {
            this.pasteButton.setEnabled(true);
        }
    }
}

