/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.dialogs;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.alkisfortfuehrung.FortfuehrungItem;
import de.cismet.cids.custom.alkisfortfuehrung.FortfuehrungenTableModel;
import de.cismet.cids.custom.alkisfortfuehrung.FortfuehrungsanlaesseDialog;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.GemarkungCustomBean;
import de.cismet.cids.custom.wunda_blau.search.server.BufferingGeosearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.interfaces.DoneDelegate;
import de.cismet.lagis.server.search.LagisFortfuehrungItemSearch;
import de.cismet.lagis.thread.ExtendedSwingWorker;
import de.cismet.lagis.thread.WFSRetrieverFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LagisFortfuehrungsanlaesseDialog
extends FortfuehrungsanlaesseDialog {
    private static final Logger LOG = Logger.getLogger(LagisFortfuehrungsanlaesseDialog.class);
    private static final HashMap<Integer, GemarkungCustomBean> GEMARKUNGEN_MAP = LagisBroker.getInstance().getGemarkungsHashMap();
    private static final Map<Geometry, Collection<FlurstueckSchluesselCustomBean>> geomBeansMap = new HashMap<Geometry, Collection<FlurstueckSchluesselCustomBean>>();
    private JCheckBox cbxAbgearbeitet;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JList lstFlurstuecke;

    public LagisFortfuehrungsanlaesseDialog(Frame parent, boolean modal) {
        super(parent, modal, ConnectionContext.createDeprecated());
    }

    protected JPanel getObjectsPanel() {
        if (this.jPanel1 == null) {
            this.initComponents();
        }
        return this.jPanel1;
    }

    protected String getLinkFormat() {
        return LagisApp.getInstance().getFortfuehrungLinkFormat();
    }

    protected void refreshFortfuehrungsList() {
        geomBeansMap.clear();
        super.refreshFortfuehrungsList();
    }

    private void gotoSelectedFlurstueck() {
        FlurstueckSchluesselCustomBean flurstueckSchluessel = (FlurstueckSchluesselCustomBean)this.lstFlurstuecke.getSelectedValue();
        LagisBroker.getInstance().loadFlurstueck(flurstueckSchluessel);
    }

    protected void setObjects(Collection flurstueckSchluessels) {
        if (flurstueckSchluessels == null) {
            this.cbxAbgearbeitet.setSelected(false);
        } else {
            DefaultListModel flurstueckSchluesselListModel = (DefaultListModel)this.lstFlurstuecke.getModel();
            flurstueckSchluesselListModel.removeAllElements();
            for (FlurstueckSchluesselCustomBean alkisId : flurstueckSchluessels) {
                flurstueckSchluesselListModel.addElement(alkisId);
            }
        }
    }

    protected void setDetailEnabled(boolean enabled) {
        this.lstFlurstuecke.setEnabled(enabled);
        this.cbxAbgearbeitet.setEnabled(enabled);
    }

    protected FortfuehrungItem createFortfuehrungItem(Object[] rawItem) {
        return new FortfuehrungItem((Integer)rawItem[LagisFortfuehrungItemSearch.FIELD_ID], (String)rawItem[LagisFortfuehrungItemSearch.FIELD_FFN], (String)rawItem[LagisFortfuehrungItemSearch.FIELD_ANLASSNAME], (Date)rawItem[LagisFortfuehrungItemSearch.FIELD_BEGINN], (String)rawItem[LagisFortfuehrungItemSearch.FIELD_FS_ALT], (String)rawItem[LagisFortfuehrungItemSearch.FIELD_FS_NEU], (Integer)rawItem[LagisFortfuehrungItemSearch.FIELD_FORTFUEHRUNG_ID]);
    }

    protected void searchObjects(final Geometry geom) {
        if (geom == null) {
            this.lstFlurstuecke.setEnabled(false);
            this.cbxAbgearbeitet.setEnabled(false);
        } else {
            final FortfuehrungItem selectedFortfuehrungItem = this.getSelectedFortfuehrungItem();
            new SwingWorker<Collection<FlurstueckSchluesselCustomBean>, Void>(){

                @Override
                protected Collection<FlurstueckSchluesselCustomBean> doInBackground() throws Exception {
                    if (!geomBeansMap.containsKey(geom)) {
                        int currentSrid = CrsTransformer.getCurrentSrid();
                        Geometry searchGeom = geom.buffer(0.0);
                        searchGeom.setSRID(currentSrid);
                        BufferingGeosearch search = new BufferingGeosearch();
                        MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"alkis_landparcel");
                        search.setValidClasses(Arrays.asList(mc));
                        search.setGeometry(searchGeom);
                        Collection res = CidsBroker.getInstance().executeSearch((CidsServerSearch)search);
                        ArrayList<String> alkisIds = new ArrayList<String>();
                        FortfuehrungenTableModel model = LagisFortfuehrungsanlaesseDialog.this.getTableModel();
                        for (int index = 0; index < model.getRowCount(); ++index) {
                            FortfuehrungItem item = model.getItem(index);
                            if (item == null || item.getFfn() == null || !item.getFfn().equals(selectedFortfuehrungItem.getFfn())) continue;
                            String flurstueckAlt = item.getFlurstueckAlt().replaceAll("_", "0");
                            String gemarkungAlt = flurstueckAlt.substring(0, 6);
                            String flurAlt = flurstueckAlt.substring(6, 9);
                            String zaehlerAlt = flurstueckAlt.substring(9, 14);
                            String nennerAlt = flurstueckAlt.substring(14);
                            alkisIds.add(gemarkungAlt + "-" + flurAlt + "-" + zaehlerAlt + (Integer.parseInt(nennerAlt) > 0 ? "/" + nennerAlt : ""));
                        }
                        for (MetaObjectNode mon : res) {
                            alkisIds.add(mon.toString());
                        }
                        final HashSet<FlurstueckSchluesselCustomBean> flurstueckSchluesselBeans = new HashSet<FlurstueckSchluesselCustomBean>();
                        for (String alkisId : alkisIds) {
                            String[] alkisIdParts = alkisId.split("-");
                            Integer gemarkung = Integer.parseInt(alkisIdParts[0].substring(2));
                            Integer flur = Integer.parseInt(alkisIdParts[1]);
                            String[] zaehlerNennerParts = alkisIdParts[2].split("/");
                            Integer zaehler = Integer.parseInt(zaehlerNennerParts[0]);
                            Integer nenner = zaehlerNennerParts.length > 1 ? Integer.parseInt(zaehlerNennerParts[1]) : 0;
                            MetaClass metaClass = CidsBroker.getInstance().getLagisMetaClass("flurstueck_schluessel");
                            String query = "SELECT    " + metaClass.getID() + ",    " + metaClass.getTableName() + ".id FROM " + metaClass.getTableName() + " WHERE    " + metaClass.getTableName() + ".fk_gemarkung = (SELECT id FROM gemarkung WHERE schluessel = " + gemarkung + ") AND    " + metaClass.getTableName() + ".flur = " + flur + " AND    " + metaClass.getTableName() + ".flurstueck_zaehler = " + zaehler + " AND    " + metaClass.getTableName() + ".flurstueck_nenner = " + nenner + ";";
                            MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject(query);
                            if (mos != null && mos.length > 0) {
                                flurstueckSchluesselBeans.add((FlurstueckSchluesselCustomBean)mos[0].getBean());
                                continue;
                            }
                            FlurstueckSchluesselCustomBean flurstueckSchluesselBean = FlurstueckSchluesselCustomBean.createNew();
                            flurstueckSchluesselBean.setGemarkung((GemarkungCustomBean)GEMARKUNGEN_MAP.get(gemarkung));
                            flurstueckSchluesselBean.setFlur(flur);
                            flurstueckSchluesselBean.setFlurstueckZaehler(zaehler);
                            flurstueckSchluesselBean.setFlurstueckNenner(nenner);
                            SwingWorker sw = WFSRetrieverFactory.getInstance().getWFSRetriever(flurstueckSchluesselBean, new DoneDelegate(){

                                public void jobDone(ExtendedSwingWorker worker, HashMap properties) {
                                    flurstueckSchluesselBeans.add((FlurstueckSchluesselCustomBean)worker.getKeyObject());
                                }
                            }, new HashMap<Integer, Boolean>());
                            sw.execute();
                            sw.get();
                        }
                        geomBeansMap.put(geom, flurstueckSchluesselBeans);
                    }
                    return (Collection)geomBeansMap.get(geom);
                }

                @Override
                protected void done() {
                    try {
                        ArrayList flurstueckSchluessels = new ArrayList();
                        flurstueckSchluessels.addAll((Collection)this.get());
                        LagisFortfuehrungsanlaesseDialog.this.setDetailEnabled(true);
                        LagisFortfuehrungsanlaesseDialog.this.setObjects(flurstueckSchluessels);
                        LagisFortfuehrungsanlaesseDialog.this.cbxAbgearbeitet.setSelected(selectedFortfuehrungItem.isIst_abgearbeitet());
                        String ffn = selectedFortfuehrungItem.getFfn();
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(selectedFortfuehrungItem.getBeginn());
                        int year = cal.get(1);
                        String urlFormat = LagisFortfuehrungsanlaesseDialog.this.getLinkFormat();
                        String urlString = String.format(urlFormat, year, ffn.substring(2, 6), ffn.substring(6, 11));
                        LagisFortfuehrungsanlaesseDialog.this.setDokumentLink(urlString);
                    }
                    catch (Exception ex) {
                        LagisFortfuehrungsanlaesseDialog.this.setObjects(null);
                        LagisFortfuehrungsanlaesseDialog.this.cbxAbgearbeitet.setSelected(false);
                        LOG.fatal((Object)"", (Throwable)ex);
                    }
                    LagisFortfuehrungsanlaesseDialog.this.lstFlurstuecke.setEnabled(true);
                    LagisFortfuehrungsanlaesseDialog.this.cbxAbgearbeitet.setEnabled(true);
                    LagisFortfuehrungsanlaesseDialog.this.searchDone();
                }
            }.execute();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.lstFlurstuecke = new JList();
        this.jButton1 = new JButton();
        this.cbxAbgearbeitet = new JCheckBox();
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(LagisFortfuehrungsanlaesseDialog.class, (String)"LagisFortfuehrungsanlaesseDialog.jPanel4.border.title")));
        this.jPanel4.setLayout(new GridBagLayout());
        this.lstFlurstuecke.setModel(new DefaultListModel());
        this.lstFlurstuecke.setCellRenderer(new FlurstueckSchluesselListCellRenderer());
        this.lstFlurstuecke.setEnabled(false);
        this.lstFlurstuecke.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LagisFortfuehrungsanlaesseDialog.this.lstFlurstueckeMouseClicked(evt);
            }
        });
        this.lstFlurstuecke.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LagisFortfuehrungsanlaesseDialog.this.lstFlurstueckeValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.lstFlurstuecke);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel4.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(LagisFortfuehrungsanlaesseDialog.class, (String)"LagisFortfuehrungsanlaesseDialog.jButton1.text"));
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisFortfuehrungsanlaesseDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel4.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LagisFortfuehrungsanlaesseDialog.class, (String)"LagisFortfuehrungsanlaesseDialog.jPanel4.AccessibleContext.accessibleName"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbxAbgearbeitet, (String)NbBundle.getMessage(LagisFortfuehrungsanlaesseDialog.class, (String)"LagisFortfuehrungsanlaesseDialog.cbxAbgearbeitet.text"));
        this.cbxAbgearbeitet.setEnabled(false);
        this.cbxAbgearbeitet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisFortfuehrungsanlaesseDialog.this.cbxAbgearbeitetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.cbxAbgearbeitet, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.pack();
    }

    private void lstFlurstueckeMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && this.lstFlurstuecke.getSelectedValue() != null) {
            this.gotoSelectedFlurstueck();
        }
    }

    private void lstFlurstueckeValueChanged(ListSelectionEvent evt) {
        this.jButton1.setEnabled(!this.lstFlurstuecke.getSelectionModel().isSelectionEmpty());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.gotoSelectedFlurstueck();
    }

    private void cbxAbgearbeitetActionPerformed(ActionEvent evt) {
        final FortfuehrungItem selectedFortfuehrungItem = this.getSelectedFortfuehrungItem();
        final boolean istAbgearbeitet = this.cbxAbgearbeitet.isSelected();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    if (istAbgearbeitet) {
                        CidsBean fortfuehrungBean = CidsBean.createNewCidsBeanFromTableName((String)"LAGIS", (String)"fortfuehrung");
                        fortfuehrungBean.setProperty("alkis_ffn_id", (Object)selectedFortfuehrungItem.getAnlassId());
                        fortfuehrungBean.setProperty("alkis_ffn", (Object)selectedFortfuehrungItem.getFfn());
                        fortfuehrungBean.setProperty("abgearbeitet_am", (Object)new Timestamp(new Date().getTime()));
                        fortfuehrungBean.setProperty("abgearbeitet_von", (Object)SessionManager.getSession().getUser().getName());
                        CidsBean persisted = fortfuehrungBean.persist();
                        selectedFortfuehrungItem.setFortfuehrungId(Integer.valueOf(persisted.getMetaObject().getId()));
                    } else {
                        MetaClass mc = CidsBroker.getInstance().getLagisMetaClass("fortfuehrung");
                        CidsBean fortfuehrungBean = CidsBroker.getInstance().getLagisMetaObject(selectedFortfuehrungItem.getFortfuehrungId(), mc.getId()).getBean();
                        fortfuehrungBean.delete();
                        fortfuehrungBean.persist();
                        selectedFortfuehrungItem.setFortfuehrungId(null);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"fehler beim setzen von ist_abgearbeitet", (Throwable)ex);
                }
                return null;
            }

            @Override
            protected void done() {
                LagisFortfuehrungsanlaesseDialog.this.refreshFortfuehrungsList();
            }
        }.execute();
    }

    protected CidsServerSearch createFortfuehrungItemSearch(Date fromDate, Date toDate) {
        return new LagisFortfuehrungItemSearch(fromDate, toDate);
    }

    public static LagisFortfuehrungsanlaesseDialog getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    class FlurstueckSchluesselListCellRenderer
    extends DefaultListCellRenderer {
        FlurstueckSchluesselListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            FlurstueckSchluesselCustomBean flurstueckSchluessel = (FlurstueckSchluesselCustomBean)value;
            JLabel component = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            component.setIcon(FlurstueckChooser.getIcon(FlurstueckChooser.identifyStatus(flurstueckSchluessel)));
            component.setText(flurstueckSchluessel.getKeyString());
            return component;
        }
    }

    private static final class LazyInitialiser {
        private static final LagisFortfuehrungsanlaesseDialog INSTANCE = new LagisFortfuehrungsanlaesseDialog(LagisApp.getInstance(), false);

        private LazyInitialiser() {
        }
    }
}

