/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.main;

import Sirius.navigator.DefaultNavigatorExceptionHandler;
import Sirius.navigator.ProxyCredentials;
import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.event.CatalogueSelectionListener;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.plugin.interfaces.FloatingPluginUI;
import Sirius.navigator.resource.PropertyManager;
import Sirius.navigator.tools.StaticNavigatorTools;
import Sirius.navigator.types.treenode.RootTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.DescriptionPane;
import Sirius.navigator.ui.DescriptionPaneFS;
import Sirius.navigator.ui.GUIContainer;
import Sirius.navigator.ui.LayoutedContainer;
import Sirius.navigator.ui.MutableMenuBar;
import Sirius.navigator.ui.MutablePopupMenu;
import Sirius.navigator.ui.MutableToolBar;
import Sirius.navigator.ui.attributes.AttributeViewer;
import Sirius.navigator.ui.attributes.editor.AttributeEditor;
import Sirius.navigator.ui.tree.MetaCatalogueTree;
import Sirius.navigator.ui.tree.ResultNodeListener;
import Sirius.navigator.ui.tree.SearchResultsTree;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.Node;
import Sirius.server.newuser.User;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import de.cismet.cids.client.tools.ContinueOrExitHandler;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.commons.gui.BaulastSuchDialog;
import de.cismet.cids.custom.commons.gui.ObjectRendererDialog;
import de.cismet.cids.custom.commons.gui.VermessungsrissSuchDialog;
import de.cismet.cids.custom.commons.searchgeometrylistener.BaulastblattNodesSearchCreateSearchGeometryListener;
import de.cismet.cids.custom.commons.searchgeometrylistener.FlurstueckNodesSearchCreateSearchGeometryListener;
import de.cismet.cids.custom.commons.searchgeometrylistener.RissNodesSearchCreateSearchGeometryListener;
import de.cismet.cids.custom.navigatorstartuphooks.MotdStartUpHook;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisUtils;
import de.cismet.cids.custom.wunda_blau.toolbaritem.TestSetMotdAction;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.navigatorstartuphooks.CidsServerMessageStartUpHook;
import de.cismet.cids.servermessage.CidsServerMessageNotifier;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListener;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListenerEvent;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.gui.ClipboardWaitDialog;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.printing.Scale;
import de.cismet.cismap.commons.gui.statusbar.StatusBar;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.wfsforms.AbstractWFSForm;
import de.cismet.cismap.commons.wfsforms.WFSFormFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.copypaste.Copyable;
import de.cismet.lagis.gui.copypaste.FlurstueckInfoClipboard;
import de.cismet.lagis.gui.copypaste.Pasteable;
import de.cismet.lagis.gui.dialogs.LagisFortfuehrungsanlaesseDialog;
import de.cismet.lagis.gui.panels.BaulastenPanel;
import de.cismet.lagis.gui.panels.DMSPanel;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.gui.panels.FlurstueckeByAktenzeichenSearchPanel;
import de.cismet.lagis.gui.panels.HistoryPanel;
import de.cismet.lagis.gui.panels.KartenPanel;
import de.cismet.lagis.gui.panels.KassenzeichenPanel;
import de.cismet.lagis.gui.panels.MeldungenPanel;
import de.cismet.lagis.gui.panels.NKFOverviewPanel;
import de.cismet.lagis.gui.panels.NKFPanel;
import de.cismet.lagis.gui.panels.ReBePanel;
import de.cismet.lagis.gui.panels.VerdisCrossoverPanel;
import de.cismet.lagis.gui.panels.VertraegePanel;
import de.cismet.lagis.gui.panels.VerwaltungsPanel;
import de.cismet.lagis.gui.tables.NKFTable;
import de.cismet.lagis.interfaces.FeatureSelectionChangedListener;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.Widget;
import de.cismet.lagis.report.printing.ReportPrintingWidget;
import de.cismet.lagis.thread.WFSRetrieverFactory;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.lagis.widget.RessortFactory;
import de.cismet.lagis.wizard.ContinuationWizard;
import de.cismet.lookupoptions.gui.OptionsClient;
import de.cismet.lookupoptions.gui.OptionsDialog;
import de.cismet.netutil.Proxy;
import de.cismet.netutil.ProxyHandler;
import de.cismet.netutil.ProxyProperties;
import de.cismet.remote.RESTRemoteControlStarter;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.StaticDecimalTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.gui.ContinueOrExitDialogAction;
import de.cismet.tools.gui.ContinueOrExitDialogActionEvent;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.historybutton.HistoryModelListener;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import de.cismet.tools.gui.startup.StaticStartupTools;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.mouse.DockingWindowActionMouseButtonListener;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DeveloperUtil;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.PropertiesUtil;
import net.infonode.docking.util.StringViewMap;
import net.infonode.gui.componentpainter.AlphaGradientComponentPainter;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.util.Direction;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.auth.DefaultUserNameStore;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.auth.UserNameStore;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdom.Content;
import org.jdom.Element;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.Wizard;

public class LagisApp
extends JFrame
implements FloatingPluginUI,
Configurable,
WindowListener,
HistoryModelListener,
Widget,
FlurstueckChangeListener,
FeatureSelectionChangedListener {
    private static final Logger LOG = Logger.getLogger(LagisApp.class);
    private static final Image IMAGE_MAIN = new ImageIcon(LagisApp.class.getResource("/de/cismet/lagis/ressource/icons/main.png")).getImage();
    private static final String FILENAME_LAGIS_CONFIGURATION = "defaultLagisProperties.xml";
    private static final String FILENAME_LOCAL_LAGIS_CONFIGURATION = "lagisProperties.xml";
    private static final String CLASSPATH_LAGIS_CONFIGURATION = "/de/cismet/lagis/configuration/";
    private static final String DIRECTORYPATH_HOME = System.getProperty("user.home");
    private static final String DIRECTORYEXTENSION = System.getProperty("directory.extension");
    private static final String FILESEPARATOR = System.getProperty("file.separator");
    private static final String DIRECTORYNAME_LAGISHOME = ".lagis" + (DIRECTORYEXTENSION != null ? DIRECTORYEXTENSION : "");
    private static final String DIRECTORYPATH_LAGIS = DIRECTORYPATH_HOME + FILESEPARATOR + DIRECTORYNAME_LAGISHOME;
    private static final String FILEPATH_DEFAULT_LAYOUT = DIRECTORYPATH_LAGIS + FILESEPARATOR + "lagis.layout";
    private static final String FILEPATH_SCREEN = DIRECTORYPATH_LAGIS + FILESEPARATOR + "lagis.screen";
    private static JFrame SPLASH;
    private static String onlineHelpURL;
    private static String newsURL;
    private static final String WIDGET_NAME = "Lagis Mainframe";
    private static final Image BANNER;
    private static final String HEADER_ERR_MSG = "Fehler";
    private final ConfigurationManager configManager = new ConfigurationManager();
    private RootWindow rootWindow;
    private VerwaltungsPanel pFlurstueck;
    private NKFOverviewPanel pNKFOverview;
    private MeldungenPanel pMeldungen;
    private DMSPanel pDMS;
    private KartenPanel pKarte;
    private HistoryPanel pHistory;
    private NKFPanel pNKF;
    private ReBePanel pRechteDetail;
    private VertraegePanel pVertraege;
    private BaulastenPanel pBaulasten;
    private KassenzeichenPanel pKassenzeichen;
    private View vFlurstueck;
    private View vVertraege;
    private View vNKFOverview;
    private View vMeldungen;
    private View vDMS;
    private View vKarte;
    private View vNKF;
    private View vReBe;
    private View vHistory;
    private View vBaulasten;
    private View vKassenzeichen;
    private WFSFormFactory wfsFormFactory;
    private final Set<View> wfsFormViews = new HashSet<View>();
    private final List<View> wfs = new ArrayList<View>();
    private DockingWindow[] wfsViews;
    private JDialog searchByVertragAktenzeichenDialog;
    private JDialog searchByMipaAktenzeichenDialog;
    private final Icon icoKarte = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/karte.png"));
    private final Icon icoDMS = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/docs.png"));
    private final Icon icoRessort = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/ressort.png"));
    private final Icon icoNKF = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/sum.png"));
    private final Icon icoRechteDetail = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/rebe.png"));
    private final Icon icoVerwaltungsbereich = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/verwaltungsbereich.png"));
    private final Icon icoDokumente = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/documents.png"));
    private final Icon icoBaulasten = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/Baulast.png"));
    private final Icon icoKassenzeichen = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/info.png"));
    private final Icon miniBack = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/miniBack.png"));
    private final Icon current = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/current.png"));
    private final Icon miniForward = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/miniForward.png"));
    private MappingComponent mapComponent;
    private ClipboardWaitDialog clipboarder;
    private final StringViewMap viewMap = new StringViewMap();
    private String fortfuehrungLinkFormat;
    private final ActiveLayerModel mappingModel = new ActiveLayerModel();
    private final List<Widget> widgets = new ArrayList<Widget>();
    private boolean isInit = true;
    private final Set<View> ressortViews = new HashSet<View>();
    private DockingWindow[] ressortDockingWindow;
    private final ArrayList<JMenuItem> menues = new ArrayList();
    private Dimension windowSize = null;
    private Point windowLocation = null;
    private final ArrayList<ValidationStateChangedListener> validationListeners = new ArrayList();
    private final String validationMessage = "Die Komponente ist valide";
    private FlurstueckInfoClipboard fsInfoClipboard;
    private ObjectRendererDialog alkisRendererDialog;
    private DescriptionPane descriptionPane;
    private SearchResultsTree searchResultsTree;
    private boolean listenerEnabled = true;
    private JButton btnAcceptChanges;
    private JButton btnAktenzeichenSuche;
    private JButton btnAktenzeichenSuche1;
    private JButton btnDiscardChanges;
    private JButton btnOpenWizard;
    private JButton btnReloadFlurstueck;
    private JButton btnSwitchInEditmode;
    private JButton btnVerdisCrossover;
    private JButton cmdFortfuehrung;
    private JButton cmdMeldung;
    private JButton cmdPrint;
    private JButton cmdSearchBaulasten;
    private JButton cmdSearchRisse;
    private JButton jButton1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator16;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JMenu menBookmarks;
    private JMenu menEdit;
    private JMenu menExtras;
    private JMenu menFile;
    private JMenu menHelp;
    private JMenu menHistory;
    private JMenu menWindow;
    private JMenuItem mniAbout;
    private JMenuItem mniAddBookmark;
    private JMenuItem mniAddNutzung;
    private JMenuItem mniBack;
    private JMenuItem mniBaulasten;
    private JMenuItem mniBookmarkManager;
    private JMenuItem mniBookmarkSidebar;
    private JMenuItem mniClippboard;
    private JMenuItem mniClose;
    private JMenuItem mniDMS;
    private JMenuItem mniFlurstueckassistent;
    private JMenuItem mniForward;
    private JMenuItem mniGotoPoint;
    private JMenuItem mniHistory;
    private JMenuItem mniHistorySidebar;
    private JMenuItem mniHome;
    private JMenuItem mniKassenzeichenInformation;
    private JMenuItem mniLisences;
    private JMenuItem mniLoadLayout;
    private JMenuItem mniLockLayout;
    private JMenuItem mniMap;
    private JMenuItem mniNKFOverview;
    private JMenuItem mniNews;
    private JMenuItem mniNutzung;
    private JMenuItem mniOnlineHelp;
    private JMenuItem mniOptions;
    private JMenuItem mniPrint;
    private JMenuItem mniReBe;
    private JMenuItem mniReBe1;
    private JMenuItem mniRefresh;
    private JMenuItem mniResetWindowLayout;
    private JMenuItem mniSaveLayout;
    private JMenuItem mniScale;
    private JMenuItem mniVersions;
    private JMenuItem mniVerwaltungsbereich;
    private JMenuItem mniVorgaenge;
    private JMenuBar mnuBar;
    private FlurstueckChooser pFlurstueckChooser;
    private JPanel panAll;
    private JPanel panMain;
    private JPanel panStatusbar;
    private JSeparator sepAfterPos;
    private JSeparator sepBeforePos;
    private JToolBar toolbar;
    private BindingGroup bindingGroup;

    private LagisApp() {
    }

    public WFSFormFactory getWfsFormFactory() {
        return this.wfsFormFactory;
    }

    private void init() {
        try {
            HashMap<Widget, Boolean> ressortPermission;
            ContinueOrExitDialogAction action = new ContinueOrExitDialogAction(){

                public void actionPerformed(ContinueOrExitDialogActionEvent e) {
                    if (e.getAction().equals((Object)ContinueOrExitDialogActionEvent.Action.CONTINUE_ACTION)) {
                        e.getSource().dispose();
                    } else {
                        String url = null;
                        try {
                            url = SessionManager.getProxy().getConfigAttr(SessionManager.getSession().getUser(), "lagis.desktop.url", ConnectionContext.createDeprecated());
                            BrowserLauncher.openURL((String)url);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(LagisApp.this, "Die Seite " + String.valueOf(url) + " konnte nicht im Browser ge\u00f6ffnet werden.", "Fehler beim \u00d6ffnen", 0);
                        }
                        System.exit(0);
                    }
                }
            };
            ContinueOrExitHandler.getInstance().showFromConfAttr((Frame)this, action);
            LOG.info((Object)"Starten der LaGIS Applikation");
            UIManager.put("wizard.sidebar.image", ImageIO.read(this.getClass().getResource("/de/cismet/lagis/ressource/image/wizard.png")));
            this.addWindowListener(this);
            LOG.info((Object)"Laden der Lagis Konfiguration");
            this.configManager.setDefaultFileName(FILENAME_LAGIS_CONFIGURATION);
            this.configManager.setFileName(FILENAME_LOCAL_LAGIS_CONFIGURATION);
            this.configManager.setClassPathFolder(CLASSPATH_LAGIS_CONFIGURATION);
            this.configManager.setFolder(DIRECTORYNAME_LAGISHOME);
            this.initCismetCommonsComponents();
            if (LagisBroker.getInstance().getSession() != null) {
                this.configManager.addConfigurable((Configurable)this);
                this.configManager.configure((Configurable)this);
            } else {
                LOG.fatal((Object)"Es ist kein ordentlich angemeldeter usernamen vorhanden LagIS wird beendet");
                System.exit(0);
            }
            this.configManager.addConfigurable((Configurable)OptionsClient.getInstance());
            this.configManager.configure((Configurable)OptionsClient.getInstance());
            this.configManager.configure((Configurable)LagisBroker.getInstance());
            this.initComponents();
            ((NKFTable)((Object)NKFPanel.getInstance().getNutzungTable())).getAddAction().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        LagisApp.this.mniAddNutzung.setEnabled((Boolean)evt.getNewValue());
                    }
                }
            });
            this.initComponentRegistry(this);
            this.alkisRendererDialog = new ObjectRendererDialog((Frame)this, false, this.descriptionPane);
            this.alkisRendererDialog.setSize(1000, 800);
            if (!LagisBroker.getInstance().isCoreReadOnlyMode()) {
                this.btnOpenWizard.setEnabled(true);
            } else {
                this.btnOpenWizard.setEnabled(false);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Konfiguriere ALBListener");
            }
            this.menues.add(this.menFile);
            this.menues.add(this.menEdit);
            this.menues.add(this.menHistory);
            this.menues.add(this.menBookmarks);
            this.menues.add(this.menExtras);
            this.menues.add(this.menWindow);
            this.configureReportButton();
            this.configureCopyPasteFlurstueckInfoComponents();
            this.initRessortPanels();
            this.initDefaultPanels();
            LagisBroker.getInstance().setRequester(this.pFlurstueckChooser);
            this.btnAcceptChanges.setEnabled(false);
            this.btnDiscardChanges.setEnabled(false);
            this.btnSwitchInEditmode.setEnabled(false);
            this.configManager.addConfigurable((Configurable)this.wfsFormFactory);
            this.configManager.configure((Configurable)this.wfsFormFactory);
            Set keySet = this.wfsFormFactory.getForms().keySet();
            JMenu wfsFormsMenu = new JMenu("Finde & Zeichne");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"configuriere WFSForms");
            }
            for (String key : keySet) {
                AbstractWFSForm form = (AbstractWFSForm)this.wfsFormFactory.getForms().get(key);
                form.setMappingComponent(LagisBroker.getInstance().getMappingComponent());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WFSForms: key,form" + key + "," + form));
                }
                final View formView = new View(form.getTitle(), Static2DTools.borderIcon((Icon)form.getIcon(), (int)0, (int)3, (int)0, (int)1), (Component)form);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WFSForms: formView" + formView));
                }
                this.viewMap.addView(form.getId(), formView);
                this.wfsFormViews.add(formView);
                this.wfs.add(formView);
                JMenuItem menuItem = new JMenuItem(form.getMenuString());
                menuItem.setIcon(form.getIcon());
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("showOrHideView:" + formView));
                        }
                        LagisApp.this.showOrHideView(formView);
                    }
                });
                wfsFormsMenu.add(menuItem);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("wfsFormView.size: " + this.wfsFormViews.size()));
            }
            this.wfsViews = new DockingWindow[this.wfsFormViews.size()];
            for (int i = 0; i < this.wfsViews.length; ++i) {
                this.wfsViews[i] = (DockingWindow)this.wfs.get(i);
            }
            if (keySet.size() > 0) {
                this.menues.remove(this.menHelp);
                this.menues.add(wfsFormsMenu);
                this.menues.add(this.menHelp);
                this.mnuBar.remove(this.menHelp);
                this.mnuBar.add(wfsFormsMenu);
                this.mnuBar.add(this.menHelp);
            }
            this.initInfoNode();
            this.loadLagisConfiguration();
            this.doLayoutInfoNode();
            this.doConfigKeystrokes();
            this.panMain.add((Component)this.rootWindow, "Center");
            this.initKeySearchComponents();
            this.mapComponent.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this.pFlurstueck);
            this.setWindowSize();
            this.mapComponent.setInternalLayerWidgetAvailable(true);
            for (Scale s : this.mapComponent.getScales()) {
                if (s.getDenominator() <= 0) continue;
                this.menExtras.add(this.getScaleMenuItem(s.getText(), s.getDenominator()));
            }
            this.loadLayout(FILEPATH_DEFAULT_LAYOUT);
            this.configManager.addConfigurable((Configurable)this.pFlurstueck);
            this.configManager.configure((Configurable)this.pFlurstueck);
            this.configManager.addConfigurable((Configurable)this.pNKF);
            this.configManager.configure((Configurable)this.pNKF);
            this.configManager.addConfigurable((Configurable)this.pKarte);
            this.configManager.configure((Configurable)this.pKarte);
            this.configManager.addConfigurable((Configurable)this.pFlurstueckChooser);
            this.configManager.configure((Configurable)this.pFlurstueckChooser);
            LOG.info((Object)"Konstruktion des LaGIS Objektes erfolgreich");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"ShutdownHook gestartet");
                    }
                    LagisApp.this.cleanUp();
                }
            });
            LagisBroker.getInstance().setTitle("LagIS");
            this.clipboarder = new ClipboardWaitDialog(StaticSwingTools.getParentFrame((Component)this), true);
            StatusBar statusBar = new StatusBar(this.mapComponent);
            DefaultNavigatorExceptionHandler.getInstance().addListener(statusBar.getExceptionHandlerListener());
            LagisBroker.getInstance().setStatusBar(statusBar);
            this.mapComponent.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)statusBar);
            CismapBroker.getInstance().addStatusListener((StatusListener)statusBar);
            this.panStatusbar.add((Component)statusBar);
            KeyStroke configLoggerKeyStroke = KeyStroke.getKeyStroke(76, 2);
            AbstractAction configAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Log4JQuickConfig.getSingletonInstance().setVisible(true);
                        }
                    });
                }
            };
            this.getRootPane().getInputMap(2).put(configLoggerKeyStroke, "CONFIGLOGGING");
            this.getRootPane().getActionMap().put("CONFIGLOGGING", configAction);
            this.isInit = false;
            this.pKarte.setInteractionMode();
            if (SPLASH != null) {
                SPLASH.dispose();
            }
            SPLASH = null;
            if (LagisBroker.getInstance().isCoreReadOnlyMode() && RessortFactory.getInstance().getRessortPermissions() != null && (ressortPermission = RessortFactory.getInstance().getRessortPermissions()) != null) {
                for (Widget tmp : ressortPermission.keySet()) {
                    Boolean isReadOnly = ressortPermission.get(tmp);
                    if (isReadOnly == null || isReadOnly.booleanValue()) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Mindestens ein Widget kann editiert werden");
                    }
                    LagisBroker.getInstance().setFullReadOnlyMode(false);
                    break;
                }
            }
            this.fsInfoClipboard.addCopyListener(this.pRechteDetail);
            this.fsInfoClipboard.addPasteListener(this.pRechteDetail);
            this.fsInfoClipboard.addCopyListener(this.pFlurstueck);
            this.fsInfoClipboard.addPasteListener(this.pFlurstueck);
            TestSetMotdAction testSetMotdAction = new TestSetMotdAction();
            if (testSetMotdAction.isVisible()) {
                this.toolbar.add((Action)testSetMotdAction);
            }
            PropertyChangeListener propChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("ACTION_SEARCH_STARTED".equals(propName)) {
                        ComponentRegistry.getRegistry().getSearchResultsTree().clear();
                    } else if ("ACTION_SEARCH_DONE".equals(propName)) {
                        Node[] nodes = (Node[])evt.getNewValue();
                        if (nodes == null || nodes.length == 0) {
                            JOptionPane.showMessageDialog(LagisApp.this, "<html>Es wurden in dem markierten Bereich<br/>keine Objekte gefunden.", "Keine Risse gefunden.", 1);
                        } else {
                            LagisApp.this.showRenderer(nodes);
                        }
                    } else if ("ACTION_SEARCH_FAILED".equals(propName)) {
                        LOG.error((Object)"error while searching", (Throwable)((Exception)evt.getNewValue()));
                    }
                }
            };
            ComponentRegistry.getRegistry().getSearchResultsTree().addResultNodeListener(new ResultNodeListener(){

                public void resultNodesChanged() {
                    if (!LagisApp.this.alkisRendererDialog.isVisible()) {
                        StaticSwingTools.showDialog((JDialog)LagisApp.this.alkisRendererDialog);
                    }
                }

                public void resultNodesCleared() {
                }

                public void resultNodesFiltered() {
                }
            });
            RissNodesSearchCreateSearchGeometryListener rissCreateSearchGeomListener = new RissNodesSearchCreateSearchGeometryListener(LagisBroker.getInstance().getMappingComponent(), propChangeListener, ConnectionContext.createDeprecated());
            LagisBroker.getInstance();
            FlurstueckNodesSearchCreateSearchGeometryListener flurstueckCreateSearchGeomListener = new FlurstueckNodesSearchCreateSearchGeometryListener(LagisBroker.getInstance().getMappingComponent(), propChangeListener, ConnectionContext.createDeprecated());
            LagisBroker.getInstance().getMappingComponent().addCustomInputListener("ALKIS_LANDPARCEL_SEARCH_GEOMETRY_LISTENER", (PBasicInputEventHandler)flurstueckCreateSearchGeomListener);
            LagisBroker.getInstance().getMappingComponent().putCursor("ALKIS_LANDPARCEL_SEARCH_GEOMETRY_LISTENER", new Cursor(1));
            flurstueckCreateSearchGeomListener.setMode("POINT");
            LagisBroker.getInstance().getMappingComponent().addCustomInputListener("VERMESSUNG_RISS_SEARCH_GEOMETRY_LISTENER", (PBasicInputEventHandler)rissCreateSearchGeomListener);
            LagisBroker.getInstance().getMappingComponent().putCursor("VERMESSUNG_RISS_SEARCH_GEOMETRY_LISTENER", new Cursor(1));
            rissCreateSearchGeomListener.setMode("POINT");
            BaulastblattNodesSearchCreateSearchGeometryListener baulastblattCreateSearchGeomListener = new BaulastblattNodesSearchCreateSearchGeometryListener(LagisBroker.getInstance().getMappingComponent(), propChangeListener, ConnectionContext.createDeprecated());
            LagisBroker.getInstance().getMappingComponent().addCustomInputListener("ALB_BAULAST_SEARCH_GEOMETRY_LISTENER", (PBasicInputEventHandler)baulastblattCreateSearchGeomListener);
            LagisBroker.getInstance().getMappingComponent().putCursor("ALB_BAULAST_SEARCH_GEOMETRY_LISTENER", new Cursor(1));
            baulastblattCreateSearchGeomListener.setMode("POINT");
            this.initTotd();
            this.initStartupHooks();
        }
        catch (Exception exception) {
            ErrorInfo errorInfo = new ErrorInfo("LaGIS kann nicht gestartet werden", "Fehler beim konstruieren des LaGIS Objektes", null, "", (Throwable)exception, null, null);
            JXErrorPane.showDialog((Component)this, (ErrorInfo)errorInfo);
            LOG.fatal((Object)"Fehler beim konstruieren des LaGIS Objektes", (Throwable)exception);
            System.exit(1);
        }
    }

    public String getFortfuehrungLinkFormat() {
        return this.fortfuehrungLinkFormat;
    }

    public void initComponentRegistry(JFrame frame) throws Exception {
        PropertyManager.getManager().setEditable(true);
        this.searchResultsTree = new SearchResultsTree(){

            public void setResultNodes(Node[] nodes, boolean append, PropertyChangeListener listener, boolean simpleSort, boolean sortActive) {
                super.setResultNodes(nodes, append, listener, simpleSort, false);
            }
        };
        this.descriptionPane = new DescriptionPaneFS();
        MutableToolBar toolBar = new MutableToolBar();
        MutableMenuBar menuBar = new MutableMenuBar();
        LayoutedContainer container = new LayoutedContainer(toolBar, menuBar, true);
        AttributeViewer attributeViewer = new AttributeViewer();
        AttributeEditor attributeEditor = new AttributeEditor();
        MutablePopupMenu popupMenu = new MutablePopupMenu();
        RootTreeNode rootTreeNode = new RootTreeNode(new Node[0]);
        MetaCatalogueTree metaCatalogueTree = new MetaCatalogueTree(rootTreeNode, PropertyManager.getManager().isEditable(), true, PropertyManager.getManager().getMaxConnections());
        CatalogueSelectionListener catalogueSelectionListener = new CatalogueSelectionListener(attributeViewer, this.descriptionPane);
        this.searchResultsTree.addTreeSelectionListener((TreeSelectionListener)catalogueSelectionListener);
        ComponentRegistry.registerComponents((JFrame)frame, (GUIContainer)container, (MutableMenuBar)menuBar, (MutableToolBar)toolBar, (MutablePopupMenu)popupMenu, (MetaCatalogueTree)metaCatalogueTree, (SearchResultsTree)this.searchResultsTree, null, (AttributeViewer)attributeViewer, (AttributeEditor)attributeEditor, (DescriptionPane)this.descriptionPane);
    }

    private void configureReportButton() {
        JButton reportButton = new JButton();
        reportButton.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/report.png")));
        reportButton.setToolTipText("Report Flurst\u00fcck-Details");
        reportButton.setBorderPainted(false);
        reportButton.setFocusable(false);
        reportButton.setPreferredSize(new Dimension(23, 23));
        reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportPrintingWidget widget = new ReportPrintingWidget((Frame)LagisApp.this, true);
                StaticSwingTools.showDialog((JDialog)widget);
            }
        });
        this.toolbar.add(reportButton);
    }

    private void configureCopyPasteFlurstueckInfoComponents() {
        JButton copyButton = new JButton();
        copyButton.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/fs_info_copy.png")));
        copyButton.setBorderPainted(false);
        copyButton.setFocusable(false);
        copyButton.setPreferredSize(new Dimension(23, 23));
        JButton pasteButton = new JButton();
        pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/fs_info_paste.png")));
        pasteButton.setBorderPainted(false);
        pasteButton.setFocusable(false);
        pasteButton.setPreferredSize(new Dimension(23, 23));
        JSeparator sep = new JSeparator();
        sep.setOrientation(1);
        sep.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        sep.setMinimumSize(new Dimension(2, 25));
        sep.setPreferredSize(new Dimension(2, 23));
        this.toolbar.add(sep);
        this.toolbar.add(copyButton);
        this.toolbar.add(pasteButton);
        this.fsInfoClipboard = new FlurstueckInfoClipboard(this, copyButton, pasteButton);
    }

    private static void handleLogin() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Intialisiere Loginframe");
        }
        final DefaultUserNameStore usernames = new DefaultUserNameStore();
        Preferences appPrefs = Preferences.userNodeForPackage(LagisApp.class);
        usernames.setPreferences(appPrefs.node("login"));
        WundaAuthentification wa = new WundaAuthentification(LagisBroker.getInstance().getDomain(), LagisBroker.getInstance().getCallserverUrl(), LagisBroker.getInstance().getConnectionClass(), LagisBroker.getInstance().isCompressionEnabled(), LagisBroker.getInstance().getProxyProperties());
        final JXLoginPane login = new JXLoginPane(wa, null, (UserNameStore)usernames){

            protected Image createLoginBanner() {
                return LagisApp.getBannerImage();
            }
        };
        String u = null;
        try {
            u = usernames.getUserNames()[usernames.getUserNames().length - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (u != null) {
            login.setUserName(u);
        }
        Object dummy = null;
        final JXLoginPane.JXLoginFrame d = new JXLoginPane.JXLoginFrame(login);
        d.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                LagisApp.handleLoginStatus(d.getStatus(), usernames, login);
            }
        });
        d.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LagisApp.handleLoginStatus(d.getStatus(), usernames, login);
            }
        });
        d.setIconImage(IMAGE_MAIN);
        login.setPassword("".toCharArray());
        try {
            ((JXPanel)((JXPanel)login.getComponent(1)).getComponent(1)).getComponent(3).requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        d.setIconImage(IMAGE_MAIN);
        d.setAlwaysOnTop(true);
        d.setVisible(true);
    }

    private JMenuItem getScaleMenuItem(String t, final int d) {
        JMenuItem jmi = new JMenuItem(t);
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LagisApp.this.mapComponent.gotoBoundingBoxWithHistory(LagisApp.this.mapComponent.getBoundingBoxFromScale((double)d));
            }
        });
        return jmi;
    }

    private void loadLagisConfiguration() {
        this.mappingModel.setInitalLayerConfigurationFromServer(true);
        this.configManager.addConfigurable((Configurable)this.mappingModel);
        this.configManager.addConfigurable((Configurable)this.mapComponent);
        this.configManager.configure((Configurable)this.mappingModel);
        this.mapComponent.preparationSetMappingModel((MappingModel)this.mappingModel);
        this.configManager.configure((Configurable)this.mapComponent);
        this.mapComponent.setMappingModel((MappingModel)this.mappingModel);
        this.configManager.configure((Configurable)WFSRetrieverFactory.getInstance());
        LagisBroker.getInstance().checkNKFAdminPermissionsOnServer();
    }

    private void initCismetCommonsComponents() {
        this.mapComponent = new MappingComponent();
        this.mapComponent.addHistoryModelListener((HistoryModelListener)this);
        CismapBroker.getInstance().setMappingComponent(this.mapComponent);
        LagisBroker.getInstance().setMappingComponent(this.mapComponent);
        this.wfsFormFactory = WFSFormFactory.getInstance((MappingComponent)this.mapComponent);
    }

    private static void initLog4J() {
        block43: {
            try {
                if (StaticDebuggingTools.checkHomeForFile((String)"cismetCustomLog4JConfigurationInDotLagis")) {
                    try {
                        try (FileInputStream configStream = new FileInputStream(DIRECTORYPATH_LAGIS + FILESEPARATOR + "custom.log4j.xml");){
                            ConfigurationSource source = new ConfigurationSource((InputStream)configStream);
                            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                            context.start((Configuration)new XmlConfiguration(context, source));
                        }
                        LOG.info((Object)"CustomLoggingOn");
                        break block43;
                    }
                    catch (Exception ex) {
                        try (InputStream configStream = ClassLoader.getSystemResourceAsStream("log4j.xml");){
                            ConfigurationSource source = new ConfigurationSource(configStream);
                            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                            context.start((Configuration)new XmlConfiguration(context, source));
                            break block43;
                        }
                    }
                }
                try (InputStream configStream = LagisApp.class.getResourceAsStream("/de/cismet/lagis/configuration/log4j.xml");){
                    ConfigurationSource source = new ConfigurationSource(configStream);
                    LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                    context.start((Configuration)new XmlConfiguration(context, source));
                }
                LOG.info((Object)"Log4J System erfolgreich konfiguriert");
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Fehler bei Log4J-Config", (Throwable)e);
                }
                System.err.println("Fehler bei Log4J Initialisierung");
                e.printStackTrace();
            }
        }
    }

    private void initRessortPanels() {
        try {
            RessortFactory ressortFactory = RessortFactory.getInstance();
            this.configManager.addConfigurable((Configurable)ressortFactory);
            this.configManager.configure((Configurable)ressortFactory);
            HashMap<String, AbstractWidget> ressorts = ressortFactory.getRessorts();
            if (ressorts.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Anzahl Ressort Widget: " + ressorts.size()));
                }
                JMenu ressortMenue = new JMenu("Ressorts");
                Set<String> keySet = ressorts.keySet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ressort Keyset: " + keySet));
                }
                for (String key : keySet) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Aktueller Key " + key));
                        }
                        AbstractWidget ressort = ressorts.get(key);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Aktueller Name des RessortWidgets " + ressort.getWidgetName()));
                        }
                        final View ressortView = new View(ressort.getWidgetName(), Static2DTools.borderIcon((Icon)ressort.getWidgetIcon(), (int)0, (int)3, (int)0, (int)1), (Component)ressort);
                        this.viewMap.addView(ressort.getWidgetName(), ressortView);
                        this.ressortViews.add(ressortView);
                        this.widgets.add(ressort);
                        if (ressort instanceof Copyable) {
                            this.fsInfoClipboard.addCopyListener((Copyable)((Object)ressort));
                        }
                        if (ressort instanceof Pasteable) {
                            this.fsInfoClipboard.addPasteListener((Pasteable)((Object)ressort));
                        }
                        JMenuItem menuItem = new JMenuItem(ressort.getWidgetName());
                        menuItem.setIcon(ressort.getWidgetIcon());
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LagisApp.this.showOrHideView(ressortView);
                            }
                        });
                        ressortMenue.add(menuItem);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("Fehler beim Configurieren eines RessortWidgets: " + ex));
                    }
                }
                this.ressortDockingWindow = new DockingWindow[this.ressortViews.size()];
                int counter = 0;
                for (View view : this.ressortViews) {
                    this.ressortDockingWindow[counter] = view;
                    ++counter;
                }
                this.menues.add(ressortMenue);
                this.menues.add(this.menHelp);
                this.mnuBar.remove(this.menHelp);
                this.mnuBar.add(ressortMenue);
                this.mnuBar.add(this.menHelp);
            } else {
                this.ressortDockingWindow = new DockingWindow[0];
                LOG.info((Object)"Es existieren keine Ressort Widgets");
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Fehler beim Configurieren der RessortWidgets: " + ex));
        }
    }

    private void initDefaultPanels() {
        boolean isJavaFxAvailable;
        LOG.info((Object)"Initialisieren der einzelnen Komponenten");
        this.pFlurstueck = VerwaltungsPanel.getInstance();
        this.pVertraege = new VertraegePanel();
        this.pNKFOverview = NKFOverviewPanel.getInstance();
        this.pMeldungen = MeldungenPanel.getInstance();
        this.pDMS = new DMSPanel();
        this.pKarte = new KartenPanel();
        this.pNKF = NKFPanel.getInstance();
        this.pRechteDetail = new ReBePanel();
        try {
            LagisApp.class.getClassLoader().loadClass("javafx.embed.swing.JFXPanel");
            isJavaFxAvailable = true;
        }
        catch (ClassNotFoundException e) {
            isJavaFxAvailable = false;
        }
        if (isJavaFxAvailable) {
            this.pHistory = new HistoryPanel();
            this.configManager.addConfigurable((Configurable)this.pHistory);
            this.configManager.configure((Configurable)this.pHistory);
        } else {
            LOG.error((Object)"Error. No Histroy Component available");
        }
        this.pBaulasten = new BaulastenPanel();
        this.pKassenzeichen = KassenzeichenPanel.getInstance();
        if (this.pHistory != null) {
            this.widgets.add(this.pHistory);
        }
        this.widgets.add(this.pFlurstueck);
        this.widgets.add(this.pVertraege);
        this.widgets.add(this.pNKFOverview);
        this.widgets.add(this.pMeldungen);
        this.widgets.add(this.pDMS);
        this.widgets.add(this.pKarte);
        this.widgets.add(this.pNKF);
        this.widgets.add(this.pRechteDetail);
        this.widgets.add(this.pBaulasten);
        this.widgets.add(this.pKassenzeichen);
        this.widgets.add(this.pFlurstueckChooser);
        LOG.info((Object)("Referenz auf die mainApplikation: " + this));
        this.widgets.add(this);
        LagisBroker.getInstance().addWidgets(this.widgets);
        LagisBroker.getInstance().resetWidgets();
    }

    private void initInfoNode() {
        this.vFlurstueck = new View("Verwaltungsbereiche", this.icoVerwaltungsbereich, (Component)this.pFlurstueck);
        this.viewMap.addView("Verwaltungsbereiche", this.vFlurstueck);
        this.vVertraege = new View("Vorg\u00e4nge", this.icoDokumente, (Component)this.pVertraege);
        this.viewMap.addView("Vorg\u00e4nge", this.vVertraege);
        this.vNKFOverview = new View("NKF \u00dcbersicht", this.icoNKF, (Component)this.pNKFOverview);
        this.viewMap.addView("NKF \u00dcbersicht", this.vNKFOverview);
        this.vMeldungen = new View("Meldungen", this.icoNKF, (Component)this.pMeldungen);
        this.viewMap.addView("Meldungen", this.vMeldungen);
        this.vDMS = new View("DMS", this.icoDMS, (Component)this.pDMS);
        this.viewMap.addView("DMS", this.vDMS);
        this.vKarte = new View("Karte", this.icoKarte, (Component)this.pKarte);
        this.viewMap.addView("Karte", this.vKarte);
        this.vNKF = new View("Nutzung", this.icoNKF, (Component)this.pNKF);
        this.viewMap.addView("Nutzung", this.vNKF);
        this.vReBe = new View("Rechte und Belastungen", this.icoRechteDetail, (Component)this.pRechteDetail);
        this.viewMap.addView("Rechte und Belastungen", this.vReBe);
        this.vFlurstueck.getCustomTitleBarComponents().addAll(this.pFlurstueck.getCustomButtons());
        if (this.pHistory != null) {
            this.vHistory = new View("Historie", this.icoRessort, (Component)this.pHistory);
            this.viewMap.addView("Historie", this.vHistory);
        } else {
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)new JLabel("... no History for you ..."), "Center");
            this.vHistory = new View("Historie", this.icoRessort, (Component)p);
            this.viewMap.addView("Historie", this.vHistory);
        }
        this.vBaulasten = new View("Baulasten", this.icoBaulasten, (Component)this.pBaulasten);
        this.viewMap.addView("Baulasten", this.vBaulasten);
        this.vKassenzeichen = new View("Kassenzeicheninformation", this.icoKassenzeichen, (Component)this.pKassenzeichen);
        this.viewMap.addView("Kassenzeicheninformation", this.vKassenzeichen);
        this.rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (boolean)true);
        LagisBroker.getInstance().setRootWindow(this.rootWindow);
        this.rootWindow.addTabMouseButtonListener(DockingWindowActionMouseButtonListener.MIDDLE_BUTTON_CLOSE_LISTENER);
        ShapedGradientDockingTheme theme = new ShapedGradientDockingTheme();
        this.rootWindow.getRootWindowProperties().addSuperObject(theme.getRootWindowProperties());
        RootWindowProperties titleBarStyleProperties = PropertiesUtil.createTitleBarStyleRootWindowProperties();
        this.rootWindow.getRootWindowProperties().addSuperObject(titleBarStyleProperties);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setUndockEnabled(true);
        AlphaGradientComponentPainter x = new AlphaGradientComponentPainter((Color)SystemColor.inactiveCaptionText, (Color)SystemColor.activeCaptionText, (Color)SystemColor.activeCaptionText, (Color)SystemColor.inactiveCaptionText);
        this.rootWindow.getRootWindowProperties().getDragRectangleShapedPanelProperties().setComponentPainter((ComponentPainter)x);
        LagisBroker.getInstance().setTitleBarComponentpainter(LagisBroker.DEFAULT_MODE_COLOR);
        this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().setPaintTabAreaShadow(true);
        this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().setShadowSize(10);
        this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().setShadowStrength(0.8f);
    }

    public void doLayoutInfoNode() {
        if (this.wfsViews.length != 0) {
            if (this.ressortDockingWindow.length != 0) {
                this.rootWindow.setWindow((DockingWindow)new SplitWindow(true, 0.22901994f, (DockingWindow)new SplitWindow(false, 0.38277513f, (DockingWindow)this.vFlurstueck, (DockingWindow)new SplitWindow(false, 0.4300518f, (DockingWindow)this.vNKFOverview, (DockingWindow)new TabWindow(new DockingWindow[]{this.vDMS, this.vMeldungen, this.vBaulasten, this.vKassenzeichen}))), (DockingWindow)new SplitWindow(false, 0.21391752f, (DockingWindow)new SplitWindow(false, 0.33f, (DockingWindow)new TabWindow(this.wfsViews), (DockingWindow)new TabWindow(this.ressortDockingWindow)), (DockingWindow)new TabWindow(new DockingWindow[]{this.vKarte, this.vReBe, this.vVertraege, this.vNKF, this.vHistory}))));
            } else {
                this.rootWindow.setWindow((DockingWindow)new SplitWindow(true, 0.22901994f, (DockingWindow)new SplitWindow(false, 0.38277513f, (DockingWindow)this.vFlurstueck, (DockingWindow)new SplitWindow(false, 0.4300518f, (DockingWindow)this.vNKFOverview, (DockingWindow)new TabWindow(new DockingWindow[]{this.vDMS, this.vMeldungen, this.vBaulasten, this.vKassenzeichen}))), (DockingWindow)new TabWindow(new DockingWindow[]{this.vKarte, this.vReBe, this.vVertraege, this.vNKF, this.vHistory})));
            }
        } else if (this.ressortDockingWindow.length != 0) {
            this.rootWindow.setWindow((DockingWindow)new SplitWindow(true, 0.22901994f, (DockingWindow)new SplitWindow(false, 0.38277513f, (DockingWindow)this.vFlurstueck, (DockingWindow)new SplitWindow(false, 0.4300518f, (DockingWindow)this.vNKFOverview, (DockingWindow)new TabWindow(new DockingWindow[]{this.vDMS, this.vMeldungen, this.vBaulasten, this.vKassenzeichen}))), (DockingWindow)new SplitWindow(false, 0.21391752f, (DockingWindow)new TabWindow(this.ressortDockingWindow), (DockingWindow)new TabWindow(new DockingWindow[]{this.vKarte, this.vReBe, this.vVertraege, this.vNKF, this.vHistory}))));
        } else {
            this.rootWindow.setWindow((DockingWindow)new SplitWindow(true, 0.22901994f, (DockingWindow)new SplitWindow(false, 0.38277513f, (DockingWindow)this.vFlurstueck, (DockingWindow)new SplitWindow(false, 0.4300518f, (DockingWindow)this.vNKFOverview, (DockingWindow)new TabWindow(new DockingWindow[]{this.vDMS, this.vMeldungen, this.vBaulasten, this.vKassenzeichen}))), (DockingWindow)new TabWindow(new DockingWindow[]{this.vKarte, this.vReBe, this.vVertraege, this.vNKF, this.vHistory})));
        }
        for (int i = 0; i < this.wfsViews.length; ++i) {
            this.wfsViews[i].close();
        }
        this.vDMS.restoreFocus();
        this.vKarte.restoreFocus();
    }

    public MeldungenPanel getMeldungenPanel() {
        return this.pMeldungen;
    }

    public void doConfigKeystrokes() {
        KeyStroke showLayoutKeyStroke = KeyStroke.getKeyStroke(68, 2);
        AbstractAction showLayoutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeveloperUtil.createWindowLayoutFrame((String)"Momentanes Layout", (DockingWindow)LagisApp.this.rootWindow).setVisible(true);
                    }
                });
            }
        };
        this.getRootPane().getInputMap(2).put(showLayoutKeyStroke, "SHOW_LAYOUT");
        this.getRootPane().getActionMap().put("SHOW_LAYOUT", showLayoutAction);
    }

    private void initKeySearchComponents() {
    }

    private void initTotd() {
        try {
            if (SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csm://totd")) {
                CidsServerMessageNotifier.getInstance().subscribe(new CidsServerMessageNotifierListener(){

                    public void messageRetrieved(CidsServerMessageNotifierListenerEvent event) {
                        try {
                            String totd = (String)event.getMessage().getContent();
                            LagisBroker.getInstance().setTotd(totd);
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)ex, (Throwable)ex);
                        }
                    }
                }, "totd");
            }
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)"Konnte Rechte an csm://totd nicht abfragen. Keine Titleleiste des Tages !", (Throwable)ex);
        }
    }

    private void initStartupHooks() {
        try {
            new MotdStartUpHook().applicationStarted();
            new CidsServerMessageStartUpHook().applicationStarted();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Ausf\u00fchren der StartupHooks: ", (Throwable)ex);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jSeparator5 = new JSeparator();
        this.toolbar = new JToolBar();
        this.pFlurstueckChooser = new FlurstueckChooser(FlurstueckChooser.Mode.SEARCH);
        this.jSeparator1 = new JSeparator();
        this.btnSwitchInEditmode = new JButton();
        this.btnDiscardChanges = new JButton();
        this.btnAcceptChanges = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jButton1 = new JButton();
        this.cmdSearchBaulasten = new JButton();
        this.cmdSearchRisse = new JButton();
        this.jSeparator4 = new JSeparator();
        this.cmdPrint = new JButton();
        this.btnReloadFlurstueck = new JButton();
        this.btnOpenWizard = new JButton();
        this.btnAktenzeichenSuche = new JButton();
        this.btnAktenzeichenSuche1 = new JButton();
        this.btnVerdisCrossover = new JButton();
        this.jSeparator2 = new JSeparator();
        this.cmdFortfuehrung = new JButton();
        this.cmdMeldung = new JButton();
        this.panAll = new JPanel();
        this.panMain = new JPanel();
        this.panStatusbar = new JPanel();
        this.mnuBar = new JMenuBar();
        this.menFile = new JMenu();
        this.mniSaveLayout = new JMenuItem();
        this.mniLoadLayout = new JMenuItem();
        this.mniLockLayout = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.mniClippboard = new JMenuItem();
        this.mniPrint = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.mniClose = new JMenuItem();
        this.menEdit = new JMenu();
        this.mniRefresh = new JMenuItem();
        this.menHistory = new JMenu();
        this.mniBack = new JMenuItem();
        this.mniForward = new JMenuItem();
        this.mniHome = new JMenuItem();
        this.sepBeforePos = new JSeparator();
        this.sepAfterPos = new JSeparator();
        this.mniHistorySidebar = new JMenuItem();
        this.menBookmarks = new JMenu();
        this.mniAddBookmark = new JMenuItem();
        this.mniBookmarkManager = new JMenuItem();
        this.mniBookmarkSidebar = new JMenuItem();
        this.menExtras = new JMenu();
        this.mniOptions = new JMenuItem();
        this.jSeparator12 = new JSeparator();
        this.mniFlurstueckassistent = new JMenuItem();
        this.mniAddNutzung = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.mniGotoPoint = new JMenuItem();
        this.jSeparator13 = new JSeparator();
        this.mniScale = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.menWindow = new JMenu();
        this.mniMap = new JMenuItem();
        this.mniVerwaltungsbereich = new JMenuItem();
        this.mniVorgaenge = new JMenuItem();
        this.mniNKFOverview = new JMenuItem();
        this.mniNutzung = new JMenuItem();
        this.mniReBe = new JMenuItem();
        this.mniReBe1 = new JMenuItem();
        this.mniDMS = new JMenuItem();
        this.mniHistory = new JMenuItem();
        this.mniBaulasten = new JMenuItem();
        this.mniKassenzeichenInformation = new JMenuItem();
        this.jSeparator14 = new JSeparator();
        this.mniResetWindowLayout = new JMenuItem();
        this.menHelp = new JMenu();
        this.mniOnlineHelp = new JMenuItem();
        this.mniNews = new JMenuItem();
        this.mniVersions = new JMenuItem();
        this.mniLisences = new JMenuItem();
        this.mniAbout = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.toolbar.setRollover(true);
        this.toolbar.setMinimumSize(new Dimension(496, 33));
        this.toolbar.add(this.pFlurstueckChooser);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setMaximumSize(new Dimension(5, Short.MAX_VALUE));
        this.jSeparator1.setPreferredSize(new Dimension(2, 23));
        this.toolbar.add(this.jSeparator1);
        this.btnSwitchInEditmode.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/editmode.png")));
        this.btnSwitchInEditmode.setToolTipText("Editormodus");
        this.btnSwitchInEditmode.setBorderPainted(false);
        this.btnSwitchInEditmode.setFocusable(false);
        this.btnSwitchInEditmode.setPreferredSize(new Dimension(23, 23));
        this.btnSwitchInEditmode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.btnSwitchInEditmodeActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnSwitchInEditmode);
        this.btnDiscardChanges.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/cancel.png")));
        this.btnDiscardChanges.setToolTipText("\u00c4nderungen Abbrechen");
        this.btnDiscardChanges.setBorderPainted(false);
        this.btnDiscardChanges.setFocusable(false);
        this.btnDiscardChanges.setPreferredSize(new Dimension(23, 23));
        this.btnDiscardChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.btnDiscardChangesActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnDiscardChanges);
        this.btnAcceptChanges.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/ok.png")));
        this.btnAcceptChanges.setToolTipText("\u00c4nderungen annehmen");
        this.btnAcceptChanges.setBorderPainted(false);
        this.btnAcceptChanges.setFocusable(false);
        this.btnAcceptChanges.setPreferredSize(new Dimension(23, 23));
        this.btnAcceptChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.btnAcceptChangesActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnAcceptChanges);
        this.jSeparator3.setOrientation(1);
        this.jSeparator3.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator3.setMinimumSize(new Dimension(2, 23));
        this.jSeparator3.setPreferredSize(new Dimension(2, 23));
        this.toolbar.add(this.jSeparator3);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/alk.png")));
        this.jButton1.setToolTipText("Alkis Renderer");
        this.jButton1.setEnabled(false);
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.jButton1ActionPerformed(evt);
            }
        });
        this.toolbar.add(this.jButton1);
        this.cmdSearchBaulasten.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/baulastsuche.png")));
        this.cmdSearchBaulasten.setToolTipText("Baulast-Suche");
        this.cmdSearchBaulasten.setFocusPainted(false);
        this.cmdSearchBaulasten.setFocusable(false);
        this.cmdSearchBaulasten.setHorizontalTextPosition(0);
        this.cmdSearchBaulasten.setMaximumSize(new Dimension(28, 28));
        this.cmdSearchBaulasten.setMinimumSize(new Dimension(28, 28));
        this.cmdSearchBaulasten.setPreferredSize(new Dimension(28, 28));
        this.cmdSearchBaulasten.setVerticalTextPosition(3);
        this.cmdSearchBaulasten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.cmdSearchBaulastenActionPerformed(evt);
            }
        });
        this.toolbar.add(this.cmdSearchBaulasten);
        this.cmdSearchBaulasten.setVisible(LagisBroker.getInstance().checkPermissionBaulasten());
        this.cmdSearchRisse.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/vermessungsrisssuche.png")));
        this.cmdSearchRisse.setToolTipText("Vermessungsriss-Suche");
        this.cmdSearchRisse.setFocusPainted(false);
        this.cmdSearchRisse.setFocusable(false);
        this.cmdSearchRisse.setHorizontalTextPosition(0);
        this.cmdSearchRisse.setMaximumSize(new Dimension(28, 28));
        this.cmdSearchRisse.setMinimumSize(new Dimension(28, 28));
        this.cmdSearchRisse.setPreferredSize(new Dimension(28, 28));
        this.cmdSearchRisse.setVerticalTextPosition(3);
        this.cmdSearchRisse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.cmdSearchRisseActionPerformed(evt);
            }
        });
        this.toolbar.add(this.cmdSearchRisse);
        this.cmdSearchRisse.setVisible(LagisBroker.getInstance().checkPermissionRisse());
        this.jSeparator4.setOrientation(1);
        this.jSeparator4.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator4.setMinimumSize(new Dimension(2, 25));
        this.jSeparator4.setPreferredSize(new Dimension(2, 23));
        this.toolbar.add(this.jSeparator4);
        this.cmdPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/frameprint.png")));
        this.cmdPrint.setToolTipText("Drucken");
        this.cmdPrint.setBorderPainted(false);
        this.cmdPrint.setFocusable(false);
        this.cmdPrint.setHorizontalTextPosition(0);
        this.cmdPrint.setPreferredSize(new Dimension(23, 23));
        this.cmdPrint.setVerticalTextPosition(3);
        this.cmdPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.cmdPrintActionPerformed(evt);
            }
        });
        this.toolbar.add(this.cmdPrint);
        this.btnReloadFlurstueck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/reload.gif")));
        this.btnReloadFlurstueck.setToolTipText("Flurst\u00fcck neu laden");
        this.btnReloadFlurstueck.setBorderPainted(false);
        this.btnReloadFlurstueck.setFocusable(false);
        this.btnReloadFlurstueck.setPreferredSize(new Dimension(23, 23));
        this.btnReloadFlurstueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.btnReloadFlurstueckActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnReloadFlurstueck);
        this.btnOpenWizard.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/wizardicon.png")));
        this.btnOpenWizard.setToolTipText("Flurst\u00fccksassistent \u00f6ffnen");
        this.btnOpenWizard.setBorderPainted(false);
        this.btnOpenWizard.setFocusable(false);
        this.btnOpenWizard.setPreferredSize(new Dimension(23, 23));
        this.btnOpenWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.btnOpenWizardActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnOpenWizard);
        this.btnAktenzeichenSuche.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/Aktenzeichensuche3.png")));
        this.btnAktenzeichenSuche.setToolTipText("Suche Flurst\u00fccke nach Aktenzeichen (Vertrag)...");
        this.btnAktenzeichenSuche.setBorderPainted(false);
        this.btnAktenzeichenSuche.setFocusable(false);
        this.btnAktenzeichenSuche.setHorizontalTextPosition(0);
        this.btnAktenzeichenSuche.setPreferredSize(new Dimension(23, 23));
        this.btnAktenzeichenSuche.setVerticalTextPosition(3);
        this.btnAktenzeichenSuche.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.btnAktenzeichenSucheActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnAktenzeichenSuche);
        this.btnAktenzeichenSuche1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/Aktenzeichensuche4.png")));
        this.btnAktenzeichenSuche1.setToolTipText("Suche Flurst\u00fccke nach Aktenzeichen (Vermietung/Verpachtung)...");
        this.btnAktenzeichenSuche1.setBorderPainted(false);
        this.btnAktenzeichenSuche1.setFocusable(false);
        this.btnAktenzeichenSuche1.setHorizontalTextPosition(0);
        this.btnAktenzeichenSuche1.setPreferredSize(new Dimension(23, 23));
        this.btnAktenzeichenSuche1.setVerticalTextPosition(3);
        this.btnAktenzeichenSuche1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.btnAktenzeichenSuche1ActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnAktenzeichenSuche1);
        this.btnVerdisCrossover.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/verdis.png")));
        this.btnVerdisCrossover.setToolTipText("Kassenzeichen in VerdIS \u00f6ffnen.");
        this.btnVerdisCrossover.setBorderPainted(false);
        this.btnVerdisCrossover.setFocusable(false);
        this.btnVerdisCrossover.setHorizontalTextPosition(0);
        this.btnVerdisCrossover.setPreferredSize(new Dimension(23, 23));
        this.btnVerdisCrossover.setVerticalTextPosition(3);
        this.btnVerdisCrossover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.btnVerdisCrossoverActionPerformed(evt);
            }
        });
        this.toolbar.add(this.btnVerdisCrossover);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator2.setMinimumSize(new Dimension(2, 25));
        this.jSeparator2.setPreferredSize(new Dimension(2, 23));
        this.toolbar.add(this.jSeparator2);
        this.cmdFortfuehrung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/fortfuehrung.png")));
        this.cmdFortfuehrung.setToolTipText("Fortf\u00fchrung");
        this.cmdFortfuehrung.setBorderPainted(false);
        this.cmdFortfuehrung.setFocusable(false);
        this.cmdFortfuehrung.setHorizontalTextPosition(0);
        this.cmdFortfuehrung.setPreferredSize(new Dimension(23, 23));
        this.cmdFortfuehrung.setVerticalTextPosition(3);
        this.cmdFortfuehrung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.cmdFortfuehrungActionPerformed(evt);
            }
        });
        try {
            this.cmdFortfuehrung.setVisible(SessionManager.getConnection().getConfigAttr(SessionManager.getSession().getUser(), "lagis.fortfuehrungsanlaesse.dialog") != null);
        }
        catch (Exception ex) {
            LOG.error((Object)"error while checking for grundis.fortfuehrungsanlaesse.dialog", (Throwable)ex);
            this.cmdFortfuehrung.setVisible(false);
        }
        this.toolbar.add(this.cmdFortfuehrung);
        this.cmdMeldung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/res/add.png")));
        this.cmdMeldung.setToolTipText("neue Meldung");
        this.cmdMeldung.setBorderPainted(false);
        this.cmdMeldung.setFocusable(false);
        this.cmdMeldung.setHorizontalTextPosition(0);
        this.cmdMeldung.setPreferredSize(new Dimension(23, 23));
        this.cmdMeldung.setVerticalTextPosition(3);
        this.cmdMeldung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.cmdMeldungActionPerformed(evt);
            }
        });
        this.toolbar.add(this.cmdMeldung);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.panAll.setLayout(new BorderLayout());
        this.panMain.setAutoscrolls(true);
        this.panMain.setLayout(new BorderLayout());
        this.panAll.add((Component)this.panMain, "Center");
        this.panStatusbar.setLayout(new BorderLayout());
        this.panAll.add((Component)this.panStatusbar, "South");
        this.getContentPane().add((Component)this.panAll, "Center");
        this.menFile.setMnemonic('D');
        this.menFile.setText("Datei");
        this.mniSaveLayout.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mniSaveLayout.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/layout.png")));
        this.mniSaveLayout.setText("Aktuelles Layout speichern");
        this.mniSaveLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniSaveLayoutActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniSaveLayout);
        this.mniLoadLayout.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.mniLoadLayout.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/layout.png")));
        this.mniLoadLayout.setText("Layout laden");
        this.mniLoadLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniLoadLayoutActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniLoadLayout);
        this.mniLockLayout.setText("Layout sperren");
        this.mniLockLayout.setEnabled(false);
        this.mniLockLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniLockLayoutActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniLockLayout);
        this.jSeparator8.setEnabled(false);
        this.menFile.add(this.jSeparator8);
        this.mniClippboard.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.mniClippboard.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/clipboard16.png")));
        this.mniClippboard.setText("Bild der Karte in die Zwischenablage kopieren");
        this.mniClippboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniClippboardActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniClippboard);
        this.mniPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.mniPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/frameprint16.png")));
        this.mniPrint.setText("Drucken");
        this.mniPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniPrintActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniPrint);
        this.jSeparator9.setEnabled(false);
        this.menFile.add(this.jSeparator9);
        this.mniClose.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.mniClose.setText("Beenden");
        this.mniClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniCloseActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniClose);
        this.mnuBar.add(this.menFile);
        this.menEdit.setMnemonic('B');
        this.menEdit.setText("Bearbeiten");
        this.mniRefresh.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.mniRefresh.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/reload16.gif")));
        this.mniRefresh.setText("Neu laden");
        this.mniRefresh.setEnabled(false);
        this.mniRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniRefreshActionPerformed(evt);
            }
        });
        this.menEdit.add(this.mniRefresh);
        this.mnuBar.add(this.menEdit);
        this.menHistory.setMnemonic('C');
        this.menHistory.setText("Chronik");
        this.mniBack.setAccelerator(KeyStroke.getKeyStroke(37, 2));
        this.mniBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/back16.png")));
        this.mniBack.setText("Zur\u00fcck");
        this.mniBack.setEnabled(false);
        this.mniBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniBackActionPerformed(evt);
            }
        });
        this.menHistory.add(this.mniBack);
        this.mniForward.setAccelerator(KeyStroke.getKeyStroke(39, 2));
        this.mniForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/forward16.png")));
        this.mniForward.setText("Vor");
        this.mniForward.setEnabled(false);
        this.mniForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniForwardActionPerformed(evt);
            }
        });
        this.menHistory.add(this.mniForward);
        this.mniHome.setAccelerator(KeyStroke.getKeyStroke(36, 0));
        this.mniHome.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/home16.gif")));
        this.mniHome.setText("Home");
        this.mniHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniHomeActionPerformed(evt);
            }
        });
        this.menHistory.add(this.mniHome);
        this.sepBeforePos.setEnabled(false);
        this.menHistory.add(this.sepBeforePos);
        this.sepAfterPos.setEnabled(false);
        this.menHistory.add(this.sepAfterPos);
        this.mniHistorySidebar.setText("In eigenem Fenster anzeigen");
        this.mniHistorySidebar.setEnabled(false);
        this.menHistory.add(this.mniHistorySidebar);
        this.mnuBar.add(this.menHistory);
        this.menBookmarks.setMnemonic('L');
        this.menBookmarks.setText("Lesezeichen");
        this.mniAddBookmark.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/bookmark_add.png")));
        this.mniAddBookmark.setText("Lesezeichen hinzuf\u00fcgen");
        this.mniAddBookmark.setEnabled(false);
        this.menBookmarks.add(this.mniAddBookmark);
        this.mniBookmarkManager.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/bookmark_folder.png")));
        this.mniBookmarkManager.setText("Lesezeichen Manager");
        this.mniBookmarkManager.setEnabled(false);
        this.menBookmarks.add(this.mniBookmarkManager);
        this.mniBookmarkSidebar.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/bookmark.png")));
        this.mniBookmarkSidebar.setText("Lesezeichen in eigenem Fenster \u00f6ffnen");
        this.mniBookmarkSidebar.setEnabled(false);
        this.menBookmarks.add(this.mniBookmarkSidebar);
        this.mnuBar.add(this.menBookmarks);
        this.menExtras.setMnemonic('E');
        this.menExtras.setText("Extras");
        this.mniOptions.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/tooloptions.png")));
        this.mniOptions.setText("Optionen");
        this.mniOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniOptionsActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniOptions);
        this.jSeparator12.setEnabled(false);
        this.menExtras.add(this.jSeparator12);
        this.mniFlurstueckassistent.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        this.mniFlurstueckassistent.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/wizardicon.png")));
        this.mniFlurstueckassistent.setText("Flurst\u00fccksassistent");
        this.mniFlurstueckassistent.setToolTipText("Flurst\u00fccksassistent \u00f6ffnen");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.btnOpenWizard, (Property)ELProperty.create((String)"${enabled}"), (Object)this.mniFlurstueckassistent, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.mniFlurstueckassistent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniFlurstueckassistentActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniFlurstueckassistent);
        this.mniAddNutzung.setAccelerator(KeyStroke.getKeyStroke(78, 3));
        this.mniAddNutzung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/addNutzung.png")));
        this.mniAddNutzung.setText("Nutzung hinzuf\u00fcgen");
        this.mniAddNutzung.setToolTipText("Nutzung hinzuf\u00fcgen");
        this.mniAddNutzung.setEnabled(false);
        this.mniAddNutzung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniAddNutzungActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniAddNutzung);
        this.menExtras.add(this.jSeparator15);
        this.mniGotoPoint.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.mniGotoPoint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/goto.png")));
        this.mniGotoPoint.setText("Gehe zu ...");
        this.mniGotoPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniGotoPointActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniGotoPoint);
        this.jSeparator13.setEnabled(false);
        this.menExtras.add(this.jSeparator13);
        this.mniScale.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/scale.png")));
        this.mniScale.setText("Ma\u00dfstab ver\u00e4ndern");
        this.mniScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniScaleActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniScale);
        this.menExtras.add(this.jSeparator16);
        this.mnuBar.add(this.menExtras);
        this.menWindow.setMnemonic('F');
        this.menWindow.setText("Fenster");
        this.mniMap.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        this.mniMap.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/karte.png")));
        this.mniMap.setText("Karte");
        this.mniMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniMapActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniMap);
        this.mniVerwaltungsbereich.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        this.mniVerwaltungsbereich.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/flurstueck.png")));
        this.mniVerwaltungsbereich.setText("Verwaltungsbereiche");
        this.mniVerwaltungsbereich.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniVerwaltungsbereichActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniVerwaltungsbereich);
        this.mniVorgaenge.setAccelerator(KeyStroke.getKeyStroke(51, 2));
        this.mniVorgaenge.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/documents.png")));
        this.mniVorgaenge.setText("Vorg\u00e4nge");
        this.mniVorgaenge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniVorgaengeActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniVorgaenge);
        this.mniNKFOverview.setAccelerator(KeyStroke.getKeyStroke(52, 2));
        this.mniNKFOverview.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/sum.png")));
        this.mniNKFOverview.setText("NKF \u00dcbersicht");
        this.mniNKFOverview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniNKFOverviewActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniNKFOverview);
        this.mniNutzung.setAccelerator(KeyStroke.getKeyStroke(53, 2));
        this.mniNutzung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/sum.png")));
        this.mniNutzung.setText("Nutzung");
        this.mniNutzung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniNutzungActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniNutzung);
        this.mniReBe.setAccelerator(KeyStroke.getKeyStroke(54, 2));
        this.mniReBe.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/findgreen.png")));
        this.mniReBe.setText("Rechte und Belastungen");
        this.mniReBe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniReBeActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniReBe);
        this.mniReBe1.setAccelerator(KeyStroke.getKeyStroke(55, 2));
        this.mniReBe1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/sum.png")));
        this.mniReBe1.setText("Meldungen");
        this.mniReBe1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniReBe1ActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniReBe1);
        this.mniDMS.setAccelerator(KeyStroke.getKeyStroke(56, 2));
        this.mniDMS.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/docs.png")));
        this.mniDMS.setText("DMS");
        this.mniDMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniDMSActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniDMS);
        this.mniHistory.setAccelerator(KeyStroke.getKeyStroke(57, 2));
        this.mniHistory.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/ressort.png")));
        this.mniHistory.setText("Historie");
        this.mniHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniHistoryActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniHistory);
        this.mniBaulasten.setAccelerator(KeyStroke.getKeyStroke(48, 2));
        this.mniBaulasten.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/Baulast.png")));
        this.mniBaulasten.setText("Baulasten");
        this.mniBaulasten.setToolTipText("Dem Flurst\u00fcck zugeh\u00f6rige Baulasten");
        this.mniBaulasten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniBaulastenActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniBaulasten);
        this.mniKassenzeichenInformation.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/info.png")));
        this.mniKassenzeichenInformation.setText("Kassenzeicheninformation");
        this.mniKassenzeichenInformation.setToolTipText("Informationen zum aktuellen Flurst\u00fcck");
        this.mniKassenzeichenInformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniKassenzeichenInformationActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniKassenzeichenInformation);
        this.jSeparator14.setEnabled(false);
        this.menWindow.add(this.jSeparator14);
        this.mniResetWindowLayout.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.mniResetWindowLayout.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/layout.png")));
        this.mniResetWindowLayout.setText("Fensteranordnung zur\u00fccksetzen");
        this.mniResetWindowLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniResetWindowLayoutActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniResetWindowLayout);
        this.mnuBar.add(this.menWindow);
        this.menHelp.setMnemonic('H');
        this.menHelp.setText("Hilfe");
        this.mniOnlineHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mniOnlineHelp.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/help.png")));
        this.mniOnlineHelp.setText("Online Hilfe");
        this.mniOnlineHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniOnlineHelpActionPerformed(evt);
            }
        });
        this.menHelp.add(this.mniOnlineHelp);
        this.mniNews.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/menue/news.png")));
        this.mniNews.setText("News");
        this.mniNews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LagisApp.this.mniNewsActionPerformed(evt);
            }
        });
        this.menHelp.add(this.mniNews);
        this.mniVersions.setAccelerator(KeyStroke.getKeyStroke(86, 10));
        this.mniVersions.setText("Versionsinformationen");
        this.mniVersions.setEnabled(false);
        this.menHelp.add(this.mniVersions);
        this.mniLisences.setAccelerator(KeyStroke.getKeyStroke(76, 10));
        this.mniLisences.setText("Lizenzinformationen");
        this.mniLisences.setEnabled(false);
        this.menHelp.add(this.mniLisences);
        this.mniAbout.setAccelerator(KeyStroke.getKeyStroke(65, 10));
        this.mniAbout.setText("\u00dcber LaGIS");
        this.mniAbout.setEnabled(false);
        this.menHelp.add(this.mniAbout);
        this.mnuBar.add(this.menHelp);
        this.setJMenuBar(this.mnuBar);
        this.bindingGroup.bind();
        this.pack();
    }

    private void btnOpenWizardActionPerformed(ActionEvent evt) {
        WizardDisplayer.showWizard((Wizard)new ContinuationWizard().createWizard(), (Rectangle)new Rectangle(20, 20, 600, 400));
    }

    private void mniNewsActionPerformed(ActionEvent evt) {
        this.openUrlInExternalBrowser(newsURL);
    }

    private void mniOnlineHelpActionPerformed(ActionEvent evt) {
        this.openUrlInExternalBrowser(onlineHelpURL);
    }

    private void mniHistoryActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vHistory);
    }

    private void mniDMSActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vDMS);
    }

    private void mniReBeActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vReBe);
    }

    private void mniNutzungActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vNKF);
    }

    private void mniNKFOverviewActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vNKFOverview);
    }

    private void mniVorgaengeActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vVertraege);
    }

    private void mniVerwaltungsbereichActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vFlurstueck);
    }

    private void mniMapActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vKarte);
    }

    private void mniGotoPointActionPerformed(ActionEvent evt) {
        BoundingBox c = this.mapComponent.getCurrentBoundingBox();
        double x = (c.getX1() + c.getX2()) / 2.0;
        double y = (c.getY1() + c.getY2()) / 2.0;
        String s = JOptionPane.showInputDialog(this, "Zentriere auf folgendem Punkt: x,y", StaticDecimalTools.round((double)x) + "," + StaticDecimalTools.round((double)y));
        try {
            String[] sa = s.split(",");
            Double gotoX = new Double(sa[0]);
            Double gotoY = new Double(sa[1]);
            BoundingBox bb = new BoundingBox(gotoX.doubleValue(), gotoY.doubleValue(), gotoX.doubleValue(), gotoY.doubleValue());
            this.mapComponent.gotoBoundingBox(bb, true, false, this.mapComponent.getAnimationDuration());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void mniScaleActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this, "Ma\u00dfstab_manuell_ausw\u00e4hlen", (int)this.mapComponent.getScaleDenominator() + "");
        try {
            Integer i = new Integer(s);
            this.mapComponent.gotoBoundingBoxWithHistory(this.mapComponent.getBoundingBoxFromScale((double)i.intValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void mniHomeActionPerformed(ActionEvent evt) {
        if (this.mapComponent != null) {
            this.mapComponent.gotoInitialBoundingBox();
        }
    }

    private void mniForwardActionPerformed(ActionEvent evt) {
        if (this.mapComponent != null && this.mapComponent.isForwardPossible()) {
            this.mapComponent.forward(true);
        }
    }

    private void mniBackActionPerformed(ActionEvent evt) {
        if (this.mapComponent != null && this.mapComponent.isBackPossible()) {
            this.mapComponent.back(true);
        }
    }

    private void mniRefreshActionPerformed(ActionEvent evt) {
        LagisBroker.getInstance().reloadFlurstueck();
    }

    private void mniClippboardActionPerformed(ActionEvent evt) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LagisApp.this.clipboarder.setLocationRelativeTo((Component)LagisApp.this);
                        LagisApp.this.clipboarder.setVisible(true);
                    }
                });
                ImageSelection imgSel = new ImageSelection(LagisApp.this.mapComponent.getImage());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LagisApp.this.clipboarder.dispose();
                    }
                });
            }
        });
        t.start();
    }

    private void mniResetWindowLayoutActionPerformed(ActionEvent evt) {
        this.doLayoutInfoNode();
    }

    private void mniSaveLayoutActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(DIRECTORYPATH_LAGIS);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".layout");
            }

            @Override
            public String getDescription() {
                return "Layout";
            }
        });
        fc.setMultiSelectionEnabled(false);
        int state = fc.showSaveDialog(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("state:" + state));
        }
        if (state == 0) {
            File file = fc.getSelectedFile();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("file:" + file));
            }
            String name = file.getAbsolutePath();
            if ((name = name.toLowerCase()).endsWith(".layout")) {
                this.saveLayout(name);
            } else {
                this.saveLayout(name + ".layout");
            }
        }
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this, message, HEADER_ERR_MSG, 1);
    }

    public void loadLayout(String file) {
        block12: {
            File layoutFile;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Load Layout.. from " + file));
            }
            if ((layoutFile = new File(file)).exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Layout File exists");
                }
                try {
                    FileInputStream layoutInput = new FileInputStream(layoutFile);
                    ObjectInputStream in = new ObjectInputStream(layoutInput);
                    this.rootWindow.read(in);
                    in.close();
                    this.rootWindow.getWindowBar(Direction.LEFT).setEnabled(true);
                    this.rootWindow.getWindowBar(Direction.RIGHT).setEnabled(true);
                    if (this.isInit) {
                        int count = this.viewMap.getViewCount();
                        for (int i = 0; i < count; ++i) {
                            View current = this.viewMap.getViewAtIndex(i);
                            if (!current.isUndocked()) continue;
                            current.dock();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Loading Layout successfull");
                    }
                }
                catch (IOException ex) {
                    LOG.error((Object)"Layout File IO Exception --> loading default Layout", (Throwable)ex);
                    if (this.isInit) {
                        JOptionPane.showMessageDialog(this, "W\u00e4hrend dem Laden des Layouts ist ein Fehler aufgetreten.\n Das Layout wird zur\u00fcckgesetzt.", HEADER_ERR_MSG, 1);
                        this.doLayoutInfoNode();
                        break block12;
                    }
                    JOptionPane.showMessageDialog(this, "W\u00e4hrend dem Laden des Layouts ist ein Fehler aufgetreten.\n Das Layout wird zur\u00fcckgesetzt.", HEADER_ERR_MSG, 1);
                }
            } else if (this.isInit) {
                LOG.warn((Object)"Datei exitstiert nicht --> default layout (init)");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LagisApp.this.doLayoutInfoNode();
                    }
                });
            } else {
                LOG.warn((Object)"Datei exitstiert nicht)");
                JOptionPane.showMessageDialog(this, "Das angegebene Layout konnte nicht gefunden werden.", HEADER_ERR_MSG, 1);
            }
        }
    }

    private void mniCloseActionPerformed(ActionEvent evt) {
        this.cleanUp();
        this.dispose();
    }

    private void mniLoadLayoutActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(DIRECTORYPATH_LAGIS);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".layout");
            }

            @Override
            public String getDescription() {
                return "Layout";
            }
        });
        fc.setMultiSelectionEnabled(false);
        int state = fc.showOpenDialog(this);
        if (state == 0) {
            File file = fc.getSelectedFile();
            String name = file.getAbsolutePath();
            if ((name = name.toLowerCase()).endsWith(".layout")) {
                this.loadLayout(name);
            } else {
                JOptionPane.showMessageDialog(this, "Das gew\u00e4hlte Dateiformat wird nicht unterst\u00fctzt.\nBitte w\u00e4hlen Sie eine Datei mit der Endung .layout", HEADER_ERR_MSG, 1);
            }
        }
    }

    public void saveLayout(String file) {
        LagisBroker.getInstance().setTitleBarComponentpainter(LagisBroker.DEFAULT_MODE_COLOR);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Saving Layout.. to " + file));
        }
        File layoutFile = new File(file);
        try {
            if (!layoutFile.exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Saving Layout.. File '" + file + "' does not exit"));
                }
                layoutFile.createNewFile();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Saving Layout.. File '" + file + "' does exit"));
            }
            FileOutputStream layoutOutput = new FileOutputStream(layoutFile);
            ObjectOutputStream out = new ObjectOutputStream(layoutOutput);
            this.rootWindow.write(out);
            out.flush();
            out.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Saving Layout.. to " + file + " successfull"));
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "W\u00e4hrend dem Speichern des Layouts ist ein Fehler aufgetreten.", HEADER_ERR_MSG, 1);
            LOG.error((Object)("A failure occured during writing the layout file " + file), (Throwable)ex);
        }
    }

    private void btnReloadFlurstueckActionPerformed(ActionEvent evt) {
        LagisBroker.getInstance().reloadFlurstueck();
    }

    private void btnDiscardChangesActionPerformed(ActionEvent evt) {
        if (LagisBroker.getInstance().isInEditMode()) {
            int answer;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Versuche aus Editiermodus heraus zu wechseln: ");
            }
            if ((answer = JOptionPane.showConfirmDialog(this, "Wollen Sie die gemachten \u00c4nderungen verwerfen?", "Lagis \u00c4nderungen", 0)) == 1) {
                return;
            }
            this.btnAcceptChanges.setEnabled(false);
            this.btnDiscardChanges.setEnabled(false);
            this.btnSwitchInEditmode.setEnabled(false);
            if (LagisBroker.getInstance().releaseLocks()) {
                if (LagisBroker.getInstance().getCurrentFlurstueck() != null && LagisBroker.getInstance().getCurrentFlurstueck().getFlurstueckSchluessel().isGesperrt()) {
                    LagisBroker.getInstance().setTitleBarComponentpainter(LagisBroker.LOCK_MODE_COLOR);
                } else {
                    LagisBroker.getInstance().setTitleBarComponentpainter(LagisBroker.DEFAULT_MODE_COLOR);
                }
                LagisBroker.getInstance().getMappingComponent().setReadOnly(true);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Fehler beim l\u00f6sen der Sperre des Flurstuecks");
            }
            if (!LagisBroker.getInstance().isCoreReadOnlyMode()) {
                this.btnOpenWizard.setEnabled(true);
            }
            LagisBroker.getInstance().reloadFlurstueck();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ist im Editiermodus: " + LagisBroker.getInstance().isInEditMode()));
            }
        }
    }

    public void acceptChanges() {
        this.btnAcceptChangesActionPerformed(null);
    }

    private void btnAcceptChangesActionPerformed(ActionEvent evt) {
        block17: {
            try {
                if (LagisBroker.getInstance().isInEditMode()) {
                    boolean isValid;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Versuche aus Editiermodus heraus zu wechseln: ");
                    }
                    if (isValid = LagisBroker.getInstance().validateWidgets()) {
                        int answer;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Alle \u00c4nderungen sind valide: " + isValid));
                        }
                        if ((answer = JOptionPane.showConfirmDialog(this, "Wollen Sie die gemachten \u00c4nderungen speichern?", "Lagis \u00c4nderungen", 0)) != 0) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"info speichern wurde gecanceled --> weiter im Editmodus");
                            }
                            return;
                        }
                        LagisBroker.getInstance().saveCurrentFlurstueck();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"\u00c4nderungen wurden gespeichert");
                        }
                        this.btnAcceptChanges.setEnabled(false);
                        this.btnDiscardChanges.setEnabled(false);
                        this.btnSwitchInEditmode.setEnabled(false);
                        LagisBroker.getInstance().getMappingComponent().setReadOnly(true);
                        if (LagisBroker.getInstance().releaseLocks()) {
                            if (LagisBroker.getInstance().getCurrentFlurstueck() != null && LagisBroker.getInstance().getCurrentFlurstueck().getFlurstueckSchluessel().isGesperrt()) {
                                LagisBroker.getInstance().setTitleBarComponentpainter(LagisBroker.LOCK_MODE_COLOR);
                            } else {
                                LagisBroker.getInstance().setTitleBarComponentpainter(LagisBroker.DEFAULT_MODE_COLOR);
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, "Die Sperre f\u00fcr das Flurstueck konnte nicht aufgehoben werden", HEADER_ERR_MSG, 2);
                        }
                        LagisBroker.getInstance().reloadFlurstueck();
                    } else {
                        String reason = LagisBroker.getInstance().getCurrentValidationErrorMessage();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Flurstueck kann nicht gespeichert werden, da nicht alle Komponenten valide sind. Grund:\n" + reason));
                        }
                        JOptionPane.showMessageDialog(this, "\u00c4nderungen k\u00f6nnen nur gespeichert werden, wenn alle Inhalte korrekt sind:\n\n" + reason + "\n\nBitte berichtigen Sie die Inhalte oder machen Sie die jeweiligen \u00c4nderungen r\u00fcckg\u00e4ngig.", HEADER_ERR_MSG, 2);
                    }
                    if (!LagisBroker.getInstance().isCoreReadOnlyMode()) {
                        this.btnOpenWizard.setEnabled(true);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ist im Editiermodus: " + LagisBroker.getInstance().isInEditMode()));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim akzeptieren von \u00c4nderungen: ", (Throwable)ex);
                if (LagisBroker.getInstance().isCoreReadOnlyMode()) break block17;
                this.btnOpenWizard.setEnabled(true);
            }
        }
    }

    private void btnSwitchInEditmodeActionPerformed(ActionEvent evt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Versuche in Editiermodus zu wechseln: ");
        }
        if (LagisBroker.getInstance().acquireLock()) {
            if (LagisBroker.getInstance().isCurrentFlurstueckLockedByUser()) {
                LagisBroker.getInstance().setTitleBarComponentpainter(LagisBroker.LOCK_MODE_COLOR, LagisBroker.EDIT_MODE_COLOR);
            } else {
                LagisBroker.getInstance().setTitleBarComponentpainter(LagisBroker.EDIT_MODE_COLOR);
            }
            LagisBroker.getInstance().getMappingComponent().setReadOnly(false);
            this.btnSwitchInEditmode.setEnabled(false);
            this.btnAcceptChanges.setEnabled(true);
            this.btnDiscardChanges.setEnabled(true);
            this.btnOpenWizard.setEnabled(false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ist im Editiermodus: " + LagisBroker.getInstance().isInEditMode()));
        }
    }

    private void mniLockLayoutActionPerformed(ActionEvent evt) {
    }

    private void mniOptionsActionPerformed(ActionEvent evt) {
        OptionsDialog od = new OptionsDialog((Frame)this, true);
        od.setLocationRelativeTo((Component)this);
        od.setVisible(true);
    }

    private void btnAktenzeichenSucheActionPerformed(ActionEvent evt) {
        if (this.searchByVertragAktenzeichenDialog == null) {
            FlurstueckeByAktenzeichenSearchPanel searchPanel = new FlurstueckeByAktenzeichenSearchPanel(FlurstueckeByAktenzeichenSearchPanel.By.VERTRAG);
            this.searchByVertragAktenzeichenDialog = new JDialog(this, searchPanel.getTitle(), false);
            this.searchByVertragAktenzeichenDialog.add(searchPanel);
            this.searchByVertragAktenzeichenDialog.pack();
            this.searchByVertragAktenzeichenDialog.setIconImage(((ImageIcon)searchPanel.getIcon()).getImage());
            StaticSwingTools.showDialog((JDialog)this.searchByVertragAktenzeichenDialog);
        } else if (this.searchByVertragAktenzeichenDialog.isVisible()) {
            this.searchByVertragAktenzeichenDialog.setVisible(false);
        } else {
            StaticSwingTools.showDialog((JDialog)this.searchByVertragAktenzeichenDialog);
        }
    }

    private void mniBaulastenActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vBaulasten);
    }

    private void cmdPrintActionPerformed(ActionEvent evt) {
        this.mapComponent.showPrintingSettingsDialog();
    }

    private void mniPrintActionPerformed(ActionEvent evt) {
        this.cmdPrintActionPerformed(evt);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        MetaObject mo = this.getCurrentFlurstueckMO();
        if (mo != null) {
            this.showRenderer(mo);
        } else {
            this.showErrorMessage("<html>Es wurde kein entsprechendes Alkis Flurst\u00fcck gefunden");
        }
    }

    private MetaObject getCurrentFlurstueckMO() {
        FlurstueckCustomBean flurstueckBean = LagisBroker.getInstance().getCurrentFlurstueck();
        if (flurstueckBean == null) {
            LOG.warn((Object)"es wurde versucht den alkisrenderer aufzurufen, obwohl kein flurstueck selektiert ist");
            return null;
        }
        FlurstueckSchluesselCustomBean flurstueckSchluesselBean = flurstueckBean.getFlurstueckSchluessel();
        if (flurstueckSchluesselBean == null) {
            LOG.warn((Object)"es wurde versucht den alkisrenderer von einen flurstueck aufzurufen, der keinen schluessel besitzt");
            return null;
        }
        String wundaDomain = "WUNDA_BLAU";
        MetaClass metaclass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"alkis_landparcel");
        if (metaclass != null) {
            int land = 5;
            try {
                int gemarkung = flurstueckSchluesselBean.getGemarkung().getSchluessel();
                int flur = flurstueckSchluesselBean.getFlur();
                int zaehler = flurstueckSchluesselBean.getFlurstueckZaehler();
                int nenner = flurstueckSchluesselBean.getFlurstueckNenner();
                String alkisCode = nenner > 0 ? AlkisUtils.generateLandparcelCode((int)5, (int)gemarkung, (int)flur, (int)zaehler, (int)nenner) : AlkisUtils.generateLandparcelCode((int)5, (int)gemarkung, (int)flur, (int)zaehler);
                String query = "SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + ".id FROM " + metaclass.getTableName() + " WHERE " + metaclass.getTableName() + ".alkis_id like '" + alkisCode + "';";
                MetaObject[] mos = CidsBroker.getInstance().getMetaObject(query, "WUNDA_BLAU");
                if (mos != null && mos.length > 0) {
                    return mos[0];
                }
                return null;
            }
            catch (Exception ex) {
                LOG.error((Object)"fehler beim suchen des alkis flurst\u00fccks", (Throwable)ex);
                this.showErrorMessage("<html>Es ist ein Fehler beim Suchen des Alkis Flurst\u00fccks aufgetreten.<br/>" + ex.getMessage());
            }
        } else {
            this.showErrorMessage("<html>Die Meta-Klasse 'alkis_landparcel' konnte nicht geladen werden<br/>\u00dcberpr\u00fcfen Sie die Benutzerrechte.");
        }
        return null;
    }

    public void showRenderer(Node[] nodes) {
        try {
            this.alkisRendererDialog.setNodes(nodes);
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading renderer", (Throwable)ex);
        }
    }

    public void showRenderer(MetaObject metaObject) {
        try {
            this.alkisRendererDialog.setNodes((Node[])Arrays.asList(new MetaObjectNode(metaObject.getBean())).toArray(new MetaObjectNode[0]));
            if (!this.alkisRendererDialog.isVisible()) {
                StaticSwingTools.showDialog((JDialog)this.alkisRendererDialog);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading renderer", (Throwable)ex);
        }
    }

    private void mniFlurstueckassistentActionPerformed(ActionEvent evt) {
        this.btnOpenWizardActionPerformed(evt);
    }

    private void mniAddNutzungActionPerformed(ActionEvent evt) {
        ((NKFTable)((Object)NKFPanel.getInstance().getNutzungTable())).getAddAction().actionPerformed(evt);
    }

    private void mniKassenzeichenInformationActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vKassenzeichen);
    }

    private void cmdSearchRisseActionPerformed(ActionEvent evt) {
        StaticSwingTools.showDialog((JDialog)new VermessungsrissSuchDialog((Frame)this, false, ConnectionContext.createDeprecated()));
    }

    private void cmdSearchBaulastenActionPerformed(ActionEvent evt) {
        StaticSwingTools.showDialog((JDialog)new BaulastSuchDialog((Frame)this, false, ConnectionContext.createDeprecated()));
    }

    private void cmdFortfuehrungActionPerformed(ActionEvent evt) {
        StaticSwingTools.showDialog((JDialog)((Object)LagisFortfuehrungsanlaesseDialog.getInstance()));
    }

    private void btnAktenzeichenSuche1ActionPerformed(ActionEvent evt) {
        if (this.searchByMipaAktenzeichenDialog == null) {
            FlurstueckeByAktenzeichenSearchPanel searchPanel = new FlurstueckeByAktenzeichenSearchPanel(FlurstueckeByAktenzeichenSearchPanel.By.MIPA);
            this.searchByMipaAktenzeichenDialog = new JDialog(this, searchPanel.getTitle(), false);
            this.searchByMipaAktenzeichenDialog.add(searchPanel);
            this.searchByMipaAktenzeichenDialog.pack();
            this.searchByMipaAktenzeichenDialog.setIconImage(((ImageIcon)searchPanel.getIcon()).getImage());
            StaticSwingTools.showDialog((JDialog)this.searchByMipaAktenzeichenDialog);
        } else if (this.searchByMipaAktenzeichenDialog.isVisible()) {
            this.searchByMipaAktenzeichenDialog.setVisible(false);
        } else {
            StaticSwingTools.showDialog((JDialog)this.searchByMipaAktenzeichenDialog);
        }
    }

    private void cmdMeldungActionPerformed(ActionEvent evt) {
        StaticSwingTools.showDialog((Component)this, (JDialog)LagisApp.getInstance().getMeldungenPanel().getDlgCreateMeldung(), (boolean)true);
    }

    private void mniReBe1ActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vMeldungen);
    }

    private void btnVerdisCrossoverActionPerformed(ActionEvent evt) {
        try {
            JDialog dialog = new JDialog(this, "", true);
            VerdisCrossoverPanel vcp = new VerdisCrossoverPanel();
            dialog.add(vcp);
            dialog.pack();
            dialog.setIconImage(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/verdis.png")).getImage());
            dialog.setTitle("Kassenzeichen in VerdIS \u00f6ffnen.");
            vcp.startSearch();
            StaticSwingTools.showDialog((JDialog)dialog);
        }
        catch (Exception ex) {
            LOG.error((Object)"Crossover: Fehler im VerdIS Crossover", (Throwable)ex);
        }
    }

    public static void main(final String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultNavigatorExceptionHandler.getInstance());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String cfgProxy;
                    Options options = new Options();
                    options.addOption("f", true, "ConfigFile");
                    options.addOption("p", true, "ProxyFile");
                    options.addOption("u", true, "CallserverUrl");
                    options.addOption("z", true, "CompressionEnabled");
                    options.addOption("c", true, "ConnectionClass");
                    options.addOption("d", true, "Domain");
                    PosixParser parser = new PosixParser();
                    CommandLine cmd = parser.parse(options, args);
                    if (cmd.hasOption("f")) {
                        String cfgFile = cmd.getOptionValue("f");
                        AppProperties appProperties = new AppProperties(StaticNavigatorTools.getInputStreamFromFileOrUrl((String)cfgFile));
                        String cfgFileName = Paths.get(new URI(cfgFile).getPath(), new String[0]).getFileName().toString();
                        String cfgDirname = cfgFile.substring(0, cfgFile.lastIndexOf(cfgFileName));
                        String proxyConfig = appProperties.getProxyConfig();
                        String string = cfgProxy = proxyConfig != null && !proxyConfig.isEmpty() ? cfgDirname + proxyConfig : null;
                        if (appProperties.getCallserverUrl() != null) {
                            LagisBroker.getInstance().setCallserverUrl(appProperties.getCallserverUrl());
                        } else {
                            LOG.warn((Object)"Kein Callserverhost spezifiziert.");
                            System.exit(1);
                        }
                        try {
                            LagisBroker.getInstance().setCompressionEnabled(appProperties.isCompressionEnabled());
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)"Kein CompressionEnabled spezifiziert.");
                            System.exit(1);
                        }
                        if (appProperties.getConnectionClass() != null) {
                            LagisBroker.getInstance().setConnectionClass(appProperties.getConnectionClass());
                        } else {
                            LOG.warn((Object)"Keine ConnectionClass spezifiziert");
                            System.exit(1);
                        }
                        if (appProperties.getDomain() != null) {
                            LagisBroker.getInstance().setDomain(appProperties.getDomain());
                        } else {
                            LOG.error((Object)"Keine Domain spezifiziert, bitte mit -d setzen.");
                            System.exit(1);
                        }
                    } else {
                        String string = cfgProxy = cmd.hasOption("p") ? cmd.getOptionValue("p") : null;
                        if (cmd.hasOption("u")) {
                            LagisBroker.getInstance().setCallserverUrl(cmd.getOptionValue("u"));
                        } else {
                            LOG.warn((Object)"Kein Callserverhost spezifiziert, bitte mit -u setzen.");
                            System.exit(1);
                        }
                        if (cmd.hasOption("z")) {
                            LagisBroker.getInstance().setCompressionEnabled(Boolean.parseBoolean(cmd.getOptionValue("z")));
                        }
                        if (cmd.hasOption("c")) {
                            LagisBroker.getInstance().setConnectionClass(cmd.getOptionValue("c"));
                        } else {
                            LOG.warn((Object)"Keine ConnectionClass spezifiziert, bitte mit -c setzen.");
                            System.exit(1);
                        }
                        if (cmd.hasOption("d")) {
                            LagisBroker.getInstance().setDomain(cmd.getOptionValue("d"));
                        } else {
                            LOG.error((Object)"Keine Domain spezifiziert, bitte mit -d setzen.");
                            System.exit(1);
                        }
                    }
                    if (cfgProxy != null && !cfgProxy.isEmpty()) {
                        ProxyProperties proxyProperties = new ProxyProperties();
                        proxyProperties.load(StaticNavigatorTools.getInputStreamFromFileOrUrl((String)cfgProxy));
                        LagisBroker.getInstance().setProxyProperties(proxyProperties);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim auslesen der Kommandozeilen Parameter", (Throwable)ex);
                    System.exit(1);
                }
                try {
                    PlasticXPLookAndFeel lf = new PlasticXPLookAndFeel();
                    UIManager.setLookAndFeel((LookAndFeel)lf);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim setzen des Look & Feels", (Throwable)ex);
                }
                LagisApp.initLog4J();
                try {
                    SPLASH = StaticStartupTools.showGhostFrame((String)FILEPATH_SCREEN, (String)"lagis [Startup]");
                }
                catch (Exception e) {
                    LOG.warn((Object)"Problem beim Darstellen des Pre-Loading-Frame", (Throwable)e);
                }
                try {
                    LagisApp.handleLogin();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim Loginframe", (Throwable)ex);
                    System.exit(0);
                }
            }
        });
    }

    public void backStatusChanged() {
        this.mniBack.setEnabled(this.mapComponent.isBackPossible());
    }

    public void forwardStatusChanged() {
        this.mniForward.setEnabled(this.mapComponent.isForwardPossible());
    }

    public void historyChanged() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"HistoryChanged");
        }
        try {
            if (this.mapComponent != null && this.mapComponent.getCurrentElement() != null) {
                Vector backPos = this.mapComponent.getBackPossibilities();
                Vector forwPos = this.mapComponent.getForwardPossibilities();
                if (this.menHistory != null) {
                    this.menHistory.removeAll();
                    this.menHistory.add(this.mniBack);
                    this.menHistory.add(this.mniForward);
                    this.menHistory.add(this.mniHome);
                    this.menHistory.add(this.sepBeforePos);
                    int counter = 0;
                    int start = 0;
                    if (backPos.size() - 10 > 0) {
                        start = backPos.size() - 10;
                    }
                    for (int index = start; index < backPos.size(); ++index) {
                        Object elem = backPos.get(index);
                        JMenuItem item = new JMenuItem(elem.toString());
                        item.setIcon(this.miniBack);
                        final int pos = backPos.size() - 1 - index;
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                for (int i = 0; i < pos; ++i) {
                                    LagisApp.this.mapComponent.back(false);
                                }
                                LagisApp.this.mapComponent.back(true);
                            }
                        });
                        this.menHistory.add(item);
                    }
                    JMenuItem currentItem = new JMenuItem(this.mapComponent.getCurrentElement().toString());
                    currentItem.setEnabled(false);
                    currentItem.setIcon(this.current);
                    this.menHistory.add(currentItem);
                    counter = 0;
                    for (int index = forwPos.size() - 1; index >= 0; --index) {
                        Object elem = forwPos.get(index);
                        JMenuItem item = new JMenuItem(elem.toString());
                        item.setIcon(this.miniForward);
                        final int pos = forwPos.size() - 1 - index;
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                for (int i = 0; i < pos; ++i) {
                                    LagisApp.this.mapComponent.forward(false);
                                }
                                LagisApp.this.mapComponent.forward(true);
                            }
                        });
                        this.menHistory.add(item);
                        if (counter++ > 10) break;
                    }
                    this.menHistory.add(this.sepAfterPos);
                    this.menHistory.add(this.mniHistorySidebar);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"CurrentElement == null --> No History change");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler in Historychanged", (Throwable)ex);
        }
    }

    public void historyActionPerformed() {
        LOG.info((Object)"historyActionPerformed");
    }

    private void setWindowSize() {
        if (this.windowSize != null && this.windowLocation != null) {
            this.setSize(this.windowSize);
            this.setLocation(this.windowLocation);
        } else {
            this.pack();
        }
    }

    public void configure(Element parent) {
        Element prefs = parent.getChild("cismapPluginUIPreferences");
        if (prefs == null) {
            LOG.warn((Object)"there is no local configuration 'cismapPluginUIPreferences'");
        } else {
            try {
                Element window;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"setting windowsize of application");
                }
                if ((window = prefs.getChild("window")) == null) {
                    LOG.warn((Object)"there is no 'window' configuration in 'cismapPluginUIPreferences'");
                } else {
                    int windowHeight = window.getAttribute("height").getIntValue();
                    int windowWidth = window.getAttribute("width").getIntValue();
                    int windowX = window.getAttribute("x").getIntValue();
                    int windowY = window.getAttribute("y").getIntValue();
                    boolean windowMaximised = window.getAttribute("max").getBooleanValue();
                    this.windowSize = new Dimension(windowWidth, windowHeight);
                    this.windowLocation = new Point(windowX, windowY);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("windowSize: width " + windowWidth + " heigth " + windowHeight));
                    }
                    if (windowMaximised) {
                        this.setExtendedState(6);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"setting of window successful");
                    }
                }
            }
            catch (Exception t) {
                LOG.error((Object)"Error while setting windowsize", (Throwable)t);
            }
        }
    }

    public void masterConfigure(Element parent) {
        try {
            Element urls = parent.getChild("urls");
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("OnlineHilfeUrl: " + urls.getChildText("onlineHelp")));
                }
                onlineHelpURL = urls.getChildText("onlineHelp");
            }
            catch (Exception ex) {
                LOG.warn((Object)"Fehler beim lesen der OnlineHilfe URL", (Throwable)ex);
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("News Url: " + urls.getChildText("onlineHelp")));
                }
                newsURL = urls.getChildText("news");
            }
            catch (Exception ex) {
                LOG.warn((Object)"Fehler beim lesen der News Url", (Throwable)ex);
            }
            try {
                Element crossoverPrefs = parent.getChild("CrossoverConfiguration");
                LagisBroker broker = LagisBroker.getInstance();
                try {
                    String crossoverServerPort = crossoverPrefs.getChildText("ServerPort");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Crossover: Crossover port: " + crossoverServerPort));
                    }
                    this.initCrossoverServer(Integer.parseInt(crossoverServerPort));
                }
                catch (Throwable ex) {
                    LOG.error((Object)"Crossover: Error while starting Server", ex);
                }
                try {
                    broker.setVerdisCrossoverPort(Integer.parseInt(crossoverPrefs.getChildText("VerdisCrossoverPort")));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Crossover: verdisCrossoverPort: " + broker.getVerdisCrossoverPort()));
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Crossover: Error beim setzen des verdis servers", (Throwable)ex);
                }
                try {
                    double kassenzeichenBuffer = Double.parseDouble(crossoverPrefs.getChildText("KassenzeichenBuffer"));
                    broker.setKassenzeichenBuffer(kassenzeichenBuffer);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim setzen den buffers f\u00fcr die Kassenzeichenabfrage", (Throwable)ex);
                }
                try {
                    double kassenzeichenBuffer100 = Double.parseDouble(crossoverPrefs.getChildText("KassenzeichenBuffer100"));
                    broker.setKassenzeichenBuffer100(kassenzeichenBuffer100);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim setzen den buffers f\u00fcr die Kassenzeichenabfrage bei flurst\u00fccken gr\u00f6\u00dfer 100m", (Throwable)ex);
                }
                try {
                    double rebeBuffer = Double.parseDouble(crossoverPrefs.getChildText("RebeBuffer"));
                    broker.setRebeBuffer(rebeBuffer);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim setzen den buffers f\u00fcr die Abfrage der Rechte und Blastungen", (Throwable)ex);
                }
                try {
                    double mipaBuffer = Double.parseDouble(crossoverPrefs.getChildText("MipaBuffer"));
                    broker.setMipaBuffer(mipaBuffer);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim setzen den buffers f\u00fcr die Abfrage der Vermietungen und Verpachtungen", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Crossover: Fehler beim Konfigurieren.", (Throwable)ex);
            }
            Element conf = parent.getChild("fortfuehrung");
            if (conf != null) {
                Element child = conf.getChild("linkFormat");
                this.fortfuehrungLinkFormat = child != null ? conf.getChild("linkFormat").getText() : null;
            }
            this.wfsFormFactory.masterConfigure(parent);
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim konfigurieren der Lagis Applikation: ", (Throwable)ex);
        }
    }

    public Element getConfiguration() {
        boolean windowMaximised;
        Element ret = new Element("cismapPluginUIPreferences");
        Element window = new Element("window");
        int windowHeight = this.getHeight();
        int windowWidth = this.getWidth();
        int windowX = (int)this.getLocation().getX();
        int windowY = (int)this.getLocation().getY();
        boolean bl = windowMaximised = this.getExtendedState() == 6;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Windowsize: width " + windowWidth + " height " + windowHeight));
        }
        window.setAttribute("height", "" + windowHeight);
        window.setAttribute("width", "" + windowWidth);
        window.setAttribute("x", "" + windowX);
        window.setAttribute("y", "" + windowY);
        window.setAttribute("max", "" + windowMaximised);
        ret.addContent((Content)window);
        return ret;
    }

    @Override
    public void dispose() {
        try {
            StaticStartupTools.saveScreenshotOfFrame((JFrame)this, (String)FILEPATH_SCREEN);
        }
        catch (Exception ex) {
            LOG.fatal((Object)"Fehler beim Capturen des App-Inhaltes", (Throwable)ex);
        }
        this.setVisible(false);
        LOG.info((Object)"Dispose(): Lagis wird heruntergefahren");
        this.configManager.writeConfiguration();
        this.saveLayout(FILEPATH_DEFAULT_LAYOUT);
        super.dispose();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flurstueckChanged(FlurstueckCustomBean currentFlurstueck) {
        LOG.info((Object)"Flurstueck Changed");
        try {
            this.clearComponent();
            try {
                FlurstueckSchluesselCustomBean flurstueckSchluesselBean = currentFlurstueck.getFlurstueckSchluessel();
                FlurstueckChooser.Status status = FlurstueckChooser.identifyStatus(flurstueckSchluesselBean);
                if (status != null) {
                    this.pFlurstueckChooser.setStatus(status);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim bestimmen der Flurst\u00fccksart", (Throwable)ex);
            }
            if (currentFlurstueck.getFlurstueckSchluessel().isGesperrt() && currentFlurstueck.getFlurstueckSchluessel().getGueltigBis() == null) {
                LOG.info((Object)"Flurst\u00fcck ist gesperrt");
                this.rootWindow.getRootWindowProperties().getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new GradientComponentPainter(LagisBroker.LOCK_MODE_COLOR, new Color(236, 233, 216), LagisBroker.LOCK_MODE_COLOR, new Color(236, 233, 216)));
                if (!LagisBroker.getInstance().isFullReadOnlyMode()) {
                    this.btnSwitchInEditmode.setEnabled(true);
                    if (!LagisBroker.getInstance().isCoreReadOnlyMode()) {
                        this.btnOpenWizard.setEnabled(true);
                    }
                }
            } else if (currentFlurstueck.getFlurstueckSchluessel().getGueltigBis() != null) {
                LOG.info((Object)"Flurst\u00fcck ist historisch");
                this.rootWindow.getRootWindowProperties().getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new GradientComponentPainter(LagisBroker.HISTORY_MODE_COLOR, new Color(236, 233, 216), LagisBroker.HISTORY_MODE_COLOR, new Color(236, 233, 216)));
                this.btnSwitchInEditmode.setEnabled(LagisBroker.getInstance().isNkfAdminPermission());
                if (!LagisBroker.getInstance().isCoreReadOnlyMode()) {
                    this.btnOpenWizard.setEnabled(true);
                }
            } else {
                LOG.info((Object)"Flurst\u00fcck ist normal");
                this.rootWindow.getRootWindowProperties().getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new GradientComponentPainter(LagisBroker.DEFAULT_MODE_COLOR, new Color(236, 233, 216), LagisBroker.DEFAULT_MODE_COLOR, new Color(236, 233, 216)));
                if (!LagisBroker.getInstance().isFullReadOnlyMode()) {
                    this.btnSwitchInEditmode.setEnabled(true);
                    if (!LagisBroker.getInstance().isCoreReadOnlyMode()) {
                        this.btnOpenWizard.setEnabled(true);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler im refresh thread: ", (Throwable)ex);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
        this.jButton1.setEnabled(currentFlurstueck != null);
        this.fsInfoClipboard.flurstueckChanged(currentFlurstueck);
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        this.btnReloadFlurstueck.setEnabled(!isEditable);
        this.mniRefresh.setEnabled(!isEditable);
        if (this.fsInfoClipboard != null) {
            this.fsInfoClipboard.setActive(isEditable);
        }
    }

    @Override
    public synchronized void clearComponent() {
        if (LagisBroker.getInstance().isUnkownFlurstueck()) {
            this.btnSwitchInEditmode.setEnabled(false);
        }
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    private void initCrossoverServer(int crossoverServerPort) {
        block8: {
            int defaultServerPort = 19000;
            boolean defaultServerPortUsed = false;
            try {
                if (crossoverServerPort < 0 || crossoverServerPort > 65535) {
                    LOG.warn((Object)("Crossover: Invalid Crossover serverport: " + crossoverServerPort + ". Going to use default port: " + 19000));
                    defaultServerPortUsed = true;
                    RESTRemoteControlStarter.initRestRemoteControlMethods((int)19000);
                } else {
                    RESTRemoteControlStarter.initRestRemoteControlMethods((int)crossoverServerPort);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Crossover: Error while creating crossover server on port: " + crossoverServerPort), (Throwable)ex);
                if (defaultServerPortUsed) break block8;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Crossover: Trying to create server with defaultPort: 19000");
                }
                defaultServerPortUsed = true;
                try {
                    RESTRemoteControlStarter.initRestRemoteControlMethods((int)19000);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Crossover: Server started at port: 19000");
                    }
                }
                catch (Exception ex1) {
                    LOG.error((Object)"Crossover: Failed to initialize Crossover server on defaultport: 19000. No Server is started");
                    this.btnVerdisCrossover.setEnabled(false);
                }
            }
        }
    }

    private void showOrHideView(View v) {
        if (v.isClosable()) {
            if (v.isShowing()) {
                v.close();
            } else {
                v.restoreFocus();
            }
        } else {
            v.restore();
        }
    }

    private void openUrlInExternalBrowser(String url) {
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (Exception e) {
            LOG.warn((Object)("Fehler beim \u00d6ffnen von:" + url + "\\nNeuer Versuch"), (Throwable)e);
            try {
                BrowserLauncher.openURL((String)url);
            }
            catch (Exception e2) {
                LOG.warn((Object)"Auch das 2te Mal ging schief.Fehler beim \u00d6ffnen von:\\nLetzter Versuch", (Throwable)e2);
                try {
                    BrowserLauncher.openURL((String)("file://" + url));
                }
                catch (Exception e3) {
                    LOG.error((Object)("Auch das 3te Mal ging schief.Fehler beim \u00d6ffnen von:" + url), (Throwable)e3);
                }
            }
        }
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"windowClosing():");
            LOG.debug((Object)"windowClosing(): Checke ob noch eine Sperre vorhanden ist.");
        }
        this.cleanUp();
        this.dispose();
    }

    private void cleanUp() {
        block8: {
            int answer;
            if (!LagisBroker.getInstance().isInEditMode()) break block8;
            try {
                boolean isValid;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Versuche aus Editiermodus heraus zu wechseln: ");
                }
                if ((answer = JOptionPane.showConfirmDialog(this, "Wollen Sie die gemachten \u00c4nderungen speichern", "Lagis \u00c4nderungen", 0)) == 0 && (isValid = LagisBroker.getInstance().validateWidgets())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Alle \u00c4nderungen sind valide: " + isValid));
                    }
                    LagisBroker.getInstance().saveCurrentFlurstueck();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"\u00c4nderungen wurden gespeichert");
                    }
                }
            }
            catch (Exception ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Es ist ein Fehler w\u00e4rend dem abspeichern des Flurstuecks aufgetreten", (Throwable)ex);
                }
                JOptionPane.showMessageDialog(this, "Es traten Fehler beim abspeichern des Flurstuecks auf", HEADER_ERR_MSG, 0);
            }
            while (!LagisBroker.getInstance().releaseLocks() && (answer = JOptionPane.showConfirmDialog(this, "Sperre konnte nicht entfernt werden. M\u00f6chten Sie es erneut probieren?", "Lagis \u00c4nderungen", 0)) != 1) {
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    public static Image getBannerImage() {
        return BANNER;
    }

    private static void handleLoginStatus(JXLoginPane.Status status, DefaultUserNameStore usernames, JXLoginPane login) {
        if (status == JXLoginPane.Status.SUCCEEDED) {
            usernames.removeUserName(login.getUserName());
            usernames.saveUserNames();
            usernames.addUserName(login.getUserName());
            usernames.saveUserNames();
            LagisBroker.getInstance().setLoggedIn(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Login erfolgreich");
            }
            LagisApp app = LagisApp.getInstance();
            app.init();
            app.setVisible(true);
            app.getMapComponent().unlock();
        } else {
            LOG.warn((Object)"Login fehlgeschlagen");
            System.exit(0);
        }
    }

    public void shown() {
    }

    public void resized() {
    }

    public void moved() {
    }

    public void hidden() {
    }

    public Collection getMenus() {
        return this.menues;
    }

    public String getId() {
        return "lagis";
    }

    public JComponent getComponent() {
        return this.panAll;
    }

    public Collection getButtons() {
        return Arrays.asList(this.toolbar.getComponents());
    }

    public void floatingStopped() {
    }

    public void floatingStarted() {
    }

    @Override
    public String getValidationMessage() {
        return "Die Komponente ist valide";
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public void fireValidationStateChanged(Object validatedObject) {
        for (ValidationStateChangedListener listener : this.validationListeners) {
            listener.validationStateChanged(null);
        }
    }

    @Override
    public void removeValidationStateChangedListener(ValidationStateChangedListener l) {
        this.validationListeners.remove(l);
    }

    @Override
    public void addValidationStateChangedListener(ValidationStateChangedListener l) {
        this.validationListeners.add(l);
    }

    @Override
    public void showAssistent(Component parent) {
    }

    public void setFlurstueckUnkown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Art des Flurst\u00fccks ist unbekannt (privat)");
        }
        this.pFlurstueckChooser.setStatus(FlurstueckChooser.Status.UNKNOWN_FLURSTUECK);
    }

    @Override
    public boolean isWidgetReadOnly() {
        return false;
    }

    @Override
    public void featureSelectionChanged(Collection<Feature> features) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private MappingComponent getMapComponent() {
        return this.mapComponent;
    }

    @Override
    public boolean isFeatureSelectionChangedEnabled() {
        return this.listenerEnabled;
    }

    @Override
    public void setFeatureSelectionChangedEnabled(boolean listenerEnabled) {
        this.listenerEnabled = listenerEnabled;
    }

    public static LagisApp getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    static {
        BANNER = new ImageIcon(LagisApp.class.getResource("/de/cismet/lagis/ressource/image/login.png")).getImage();
    }

    private static class AppProperties
    extends PropertyResourceBundle {
        public AppProperties(InputStream is) throws Exception {
            super(is);
        }

        public String getCallserverUrl() {
            return this.getString("callserverUrl");
        }

        public boolean isCompressionEnabled() {
            return Boolean.parseBoolean(this.getString("compressionEnabled"));
        }

        public String getProxyConfig() {
            return this.getString("proxy.config");
        }

        public String getConnectionClass() {
            return this.getString("connectionClass");
        }

        public String getDomain() {
            return this.getString("domain");
        }
    }

    private static final class LazyInitialiser {
        private static final LagisApp INSTANCE = new LagisApp();

        private LazyInitialiser() {
        }
    }

    public static class WundaAuthentification
    extends LoginService {
        public static final String CONNECTION_PROXY_CLASS = "Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler";
        private final Logger log = Logger.getLogger(WundaAuthentification.class);
        private final String standaloneDomain;
        private final String callserverUrl;
        private final String connectionClass;
        private final boolean compressionEnabled;
        private final ProxyProperties proxyProperties;
        private String userString;

        public WundaAuthentification(String standaloneDomain, String callserverUrl, String connectionClass, boolean compressionEnabled, ProxyProperties proxyProperties) {
            this.standaloneDomain = standaloneDomain;
            this.callserverUrl = callserverUrl;
            this.connectionClass = connectionClass;
            this.compressionEnabled = compressionEnabled;
            this.proxyProperties = proxyProperties;
        }

        public boolean authenticate(String name, char[] password, String server) throws Exception {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Authentication:");
            }
            String username = name.split("@")[0];
            String usergroup = name.split("@")[1];
            LagisBroker.getInstance().setAccountName(name);
            String domain = this.standaloneDomain;
            this.userString = name;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("full qualified username: " + this.userString + "@" + this.standaloneDomain));
            }
            try {
                Proxy proxy = ProxyHandler.getInstance().init(this.proxyProperties);
                Connection connection = ConnectionFactory.getFactory().createConnection(this.connectionClass, this.callserverUrl, proxy, this.compressionEnabled);
                ConnectionInfo connectionInfo = new ConnectionInfo();
                connectionInfo.setCallserverURL(this.callserverUrl);
                connectionInfo.setPassword(new String(password));
                connectionInfo.setUserDomain(domain);
                connectionInfo.setUsergroup(usergroup);
                connectionInfo.setUsergroupDomain(domain);
                connectionInfo.setUsername(username);
                ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
                ConnectionProxy connectionProxy = ConnectionFactory.getFactory().createProxy(CONNECTION_PROXY_CLASS, session);
                SessionManager.init((ConnectionProxy)connectionProxy);
                ProxyCredentials.initFromConfAttr((String)"proxy.credentials", (ConnectionContext)ConnectionContext.createDeprecated());
                LagisBroker.getInstance().setSession(session);
                User user = session.getUser();
                LagisBroker.getInstance().setSession(session);
                String userString = user.getName() + "@" + user.getUserGroup().getName();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("userstring: " + userString));
                }
                LagisBroker.getInstance().setAccountName(userString);
                if (SessionManager.getProxy().hasConfigAttr(user, "lagis.permission.readwrite")) {
                    LagisBroker.getInstance().setCoreReadOnlyMode(false);
                    LagisBroker.getInstance().setFullReadOnlyMode(false);
                    return true;
                }
                if (SessionManager.getProxy().hasConfigAttr(user, "lagis.permission.read")) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Authentication successfull user has granted readonly access");
                    }
                    return true;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"authentication else false: no permission available");
                }
                return false;
            }
            catch (Throwable t) {
                this.log.error((Object)("call server url: " + this.callserverUrl));
                this.log.error((Object)"Fehler beim Anmelden ", t);
                return false;
            }
        }
    }

    class ImageSelection
    implements Transferable {
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

