/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.cids.custom.beans.lagis.BaumCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.BaumModel;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.models.DefaultUniqueListModel;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import de.cismet.lagisEE.entity.core.Flurstueck;
import de.cismet.lagisEE.entity.extension.baum.Baum;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class AddExistingBaumPanel
extends JPanel
implements ValidationStateChangedListener,
ListSelectionListener {
    private final Logger log = Logger.getLogger(this.getClass());
    private BaumModel baumModel = new BaumModel();
    private BaumModel currentBaumTabelModel;
    private Flurstueck currentFlurstueck;
    private DefaultUniqueListModel currentListModel;
    private JButton Cancel;
    private JButton btnOK;
    private FlurstueckChooser flurstueckChooser1;
    private JLabel jLabel;
    private JLabel jLabel2;
    private JScrollPane jScrollPane;
    private JSeparator jSeparator;
    private JTable tblBaum;

    public AddExistingBaumPanel(Flurstueck currentFlurstueck, BaumModel currentBaumTabelModel, ListModel currentListModel) {
        this.currentFlurstueck = currentFlurstueck;
        this.currentListModel = (DefaultUniqueListModel)currentListModel;
        this.currentBaumTabelModel = currentBaumTabelModel;
        this.initComponents();
        this.btnOK.setEnabled(false);
        this.tblBaum.setModel(this.baumModel);
        this.tblBaum.getSelectionModel().addListSelectionListener(this);
        FlurstueckCustomBean selectedFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        if (selectedFlurstueck != null && selectedFlurstueck.getFlurstueckSchluessel() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Vorauswahl kann getroffen werden");
            }
            this.flurstueckChooser1.doAutomaticRequest(3, selectedFlurstueck.getFlurstueckSchluessel());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Vorauswahl kann nicht getroffen werden");
        }
        ((JXTable)this.tblBaum).packAll();
        this.flurstueckChooser1.addValidationStateChangedListener(this);
        this.flurstueckChooser1.addRemoveFilter(currentFlurstueck.getFlurstueckSchluessel());
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Validation Status: " + this.flurstueckChooser1.getStatus()));
        }
        if (this.flurstueckChooser1.getStatus() == 0) {
            FlurstueckSchluesselCustomBean currentKey = this.flurstueckChooser1.getCurrentFlurstueckSchluessel();
            Collection<BaumCustomBean> baeume = LagisBroker.getInstance().getBaumForKey(currentKey);
            if (baeume != null) {
                for (Baum baum : this.currentBaumTabelModel.getCidsBeans()) {
                    if (!baeume.contains(baum)) continue;
                    baeume.remove(baum);
                }
                this.baumModel.refreshTableModel(baeume);
            } else {
                this.log.info((Object)"Es sind keine Baeume f\u00fcr das gew\u00e4hlte Flurstueck vorhanden");
            }
        } else {
            this.baumModel.refreshTableModel(null);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.tblBaum.getSelectionModel())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Benutzer selektion changed");
                this.log.debug((Object)("Anzahl selektierter Spalten: " + this.tblBaum.getSelectedRowCount()));
            }
            if (this.tblBaum.getSelectedRowCount() > 0) {
                this.btnOK.setEnabled(true);
            } else {
                this.btnOK.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel = new JLabel();
        this.jSeparator = new JSeparator();
        this.jScrollPane = new JScrollPane();
        this.tblBaum = new JXTable();
        this.btnOK = new JButton();
        this.Cancel = new JButton();
        this.flurstueckChooser1 = new FlurstueckChooser();
        this.jLabel2.setText("jLabel2");
        this.jLabel.setText("Flurst\u00fcck");
        this.tblBaum.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane.setViewportView(this.tblBaum);
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddExistingBaumPanel.this.btnOKActionPerformed(evt);
            }
        });
        this.Cancel.setText("Abbrechen");
        this.Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddExistingBaumPanel.this.CancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator, -1, 482, Short.MAX_VALUE).addComponent(this.jLabel).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Cancel)).addComponent(this.jScrollPane, -1, 477, Short.MAX_VALUE)).addGap(5, 5, 5)).addComponent(this.flurstueckChooser1, -2, 474, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel).addGap(1, 1, 1).addComponent(this.flurstueckChooser1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane, -1, 264, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Cancel).addComponent(this.btnOK)).addContainerGap()));
    }

    private void closeDialog() {
        ((JDialog)this.getParent().getParent().getParent().getParent()).dispose();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.tblBaum.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            BaumCustomBean curBaum = (BaumCustomBean)this.baumModel.getCidsBeanAtRow(((JXTable)this.tblBaum).convertRowIndexToModel(selectedRows[i]));
            this.currentBaumTabelModel.addCidsBean(curBaum);
            this.currentBaumTabelModel.fireTableDataChanged();
            Collection<FlurstueckSchluesselCustomBean> crossRefs = LagisBroker.getInstance().getCrossReferencesForBaum(curBaum);
            if (crossRefs == null) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Es sind Querverweise auf die Baeume vorhanden");
            }
            Iterator<FlurstueckSchluesselCustomBean> it = crossRefs.iterator();
            while (it.hasNext()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Ein Querverweis hinzugef\u00fcgt");
                }
                this.currentListModel.addElement(it.next());
            }
            this.currentListModel.removeElement(this.currentFlurstueck.getFlurstueckSchluessel());
        }
        this.closeDialog();
    }

    private void CancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }
}

