/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.models.DefaultUniqueListModel;
import de.cismet.lagis.models.VertraegeTableModel;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class AddExistingVorgangPanel
extends JPanel
implements ValidationStateChangedListener,
ListSelectionListener {
    private final Logger log = Logger.getLogger(this.getClass());
    private VertraegeTableModel tblModel = new VertraegeTableModel();
    private VertraegeTableModel currentVertraegeTabelModel;
    private FlurstueckCustomBean currentFlurstueck;
    private DefaultUniqueListModel currentListModel;
    private JButton Cancel;
    private JButton btnOK;
    private FlurstueckChooser flurstueckChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable tblVorgang;

    public AddExistingVorgangPanel(FlurstueckCustomBean currentFlurstueck, VertraegeTableModel currentVertraegeTabelModel, ListModel currentListModel) {
        this.currentFlurstueck = currentFlurstueck;
        this.currentListModel = (DefaultUniqueListModel)currentListModel;
        this.currentVertraegeTabelModel = currentVertraegeTabelModel;
        this.initComponents();
        this.btnOK.setEnabled(false);
        this.tblVorgang.setModel(this.tblModel);
        this.tblVorgang.getSelectionModel().addListSelectionListener(this);
        FlurstueckCustomBean selectedFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        if (selectedFlurstueck != null && selectedFlurstueck.getFlurstueckSchluessel() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Vorauswahl kann getroffen werden");
            }
            this.flurstueckChooser1.doAutomaticRequest(3, selectedFlurstueck.getFlurstueckSchluessel());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Vorauswahl kann nicht getroffen werden");
        }
        ((JXTable)this.tblVorgang).packAll();
        this.flurstueckChooser1.addValidationStateChangedListener(this);
        this.flurstueckChooser1.addRemoveFilter(currentFlurstueck.getFlurstueckSchluessel());
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Validation Status: " + this.flurstueckChooser1.getStatus()));
        }
        if (this.flurstueckChooser1.getStatus() == 0) {
            FlurstueckSchluesselCustomBean currentKey = this.flurstueckChooser1.getCurrentFlurstueckSchluessel();
            Collection<VertragCustomBean> vertraege = LagisBroker.getInstance().getVertraegeForKey(currentKey);
            if (vertraege != null) {
                for (VertragCustomBean vertragCustomBean : this.currentVertraegeTabelModel.getCidsBeans()) {
                    if (!vertraege.contains(vertragCustomBean)) continue;
                    vertraege.remove(vertragCustomBean);
                }
                this.tblModel.refreshTableModel(vertraege);
            } else {
                this.log.info((Object)"Es sind keine Vertr\u00e4ge f\u00fcr das gew\u00e4hlte Flurstueck vorhanden");
            }
        } else {
            this.tblModel.refreshTableModel(null);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.tblVorgang.getSelectionModel())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Benutzer selektion changed");
                this.log.debug((Object)("Anzahl selektierter Spalten: " + this.tblVorgang.getSelectedRowCount()));
            }
            if (this.tblVorgang.getSelectedRowCount() > 0) {
                this.btnOK.setEnabled(true);
            } else {
                this.btnOK.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.tblVorgang = new JXTable();
        this.btnOK = new JButton();
        this.Cancel = new JButton();
        this.flurstueckChooser1 = new FlurstueckChooser();
        this.jLabel2.setText("jLabel2");
        this.jLabel1.setText("Flurst\u00fcck");
        this.tblVorgang.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tblVorgang);
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddExistingVorgangPanel.this.btnOKActionPerformed(evt);
            }
        });
        this.Cancel.setText("Abbrechen");
        this.Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddExistingVorgangPanel.this.CancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 474, Short.MAX_VALUE).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Cancel)).addComponent(this.jScrollPane1, -1, 469, Short.MAX_VALUE)).addGap(5, 5, 5)).addComponent(this.flurstueckChooser1, -2, 474, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(1, 1, 1).addComponent(this.flurstueckChooser1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 103, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Cancel).addComponent(this.btnOK)).addContainerGap()));
    }

    private void CancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        ((JDialog)this.getParent().getParent().getParent().getParent()).dispose();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.tblVorgang.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            VertragCustomBean curVertrag = (VertragCustomBean)this.tblModel.getCidsBeanAtRow(((JXTable)this.tblVorgang).convertRowIndexToModel(selectedRows[i]));
            this.currentVertraegeTabelModel.addCidsBean(curVertrag);
            Collection<FlurstueckSchluesselCustomBean> crossRefs = LagisBroker.getInstance().getCrossReferencesForVertrag(curVertrag);
            if (crossRefs == null) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Es sind Querverweise auf diesen Vertrag vorhanden");
            }
            Iterator<FlurstueckSchluesselCustomBean> it = crossRefs.iterator();
            while (it.hasNext()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Ein Querverweis hinzugef\u00fcgt");
                }
                this.currentListModel.addElement(it.next());
            }
            this.currentListModel.removeElement(this.currentFlurstueck.getFlurstueckSchluessel());
        }
        this.closeDialog();
    }
}

