/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.BaumCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumKategorieAuspraegungCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumKategorieCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumMerkmalCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumNutzungCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.editor.DateEditor;
import de.cismet.lagis.gui.checkbox.JCheckBoxList;
import de.cismet.lagis.gui.copypaste.Copyable;
import de.cismet.lagis.gui.copypaste.Pasteable;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.gui.panels.AddExistingBaumPanel;
import de.cismet.lagis.gui.panels.BaumMerkmalCheckBox;
import de.cismet.lagis.gui.panels.BaumModel;
import de.cismet.lagis.gui.panels.BaumTable;
import de.cismet.lagis.gui.tables.RemoveActionHelper;
import de.cismet.lagis.interfaces.FeatureSelectionChangedListener;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.interfaces.GeometrySlotProvider;
import de.cismet.lagis.models.DefaultUniqueListModel;
import de.cismet.lagis.renderer.DateRenderer;
import de.cismet.lagis.renderer.FlurstueckSchluesselRenderer;
import de.cismet.lagis.util.TableSelectionUtils;
import de.cismet.lagis.utillity.GeometrySlotInformation;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.lagisEE.entity.basic.BasicEntity;
import de.cismet.lagisEE.entity.core.CustomSelectionStyledFeatureGroupWrapper;
import de.cismet.lagisEE.entity.core.FlurstueckSchluessel;
import de.cismet.lagisEE.entity.extension.baum.Baum;
import de.cismet.lagisEE.entity.extension.baum.BaumKategorie;
import de.cismet.lagisEE.entity.extension.baum.BaumKategorieAuspraegung;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class BaumPanel
extends AbstractWidget
implements FlurstueckChangeListener,
FlurstueckSaver,
MouseListener,
ListSelectionListener,
ItemListener,
GeometrySlotProvider,
FeatureSelectionChangedListener,
FeatureCollectionListener,
TableModelListener,
Copyable,
Pasteable,
RemoveActionHelper {
    private static final String PROVIDER_NAME = "Baum";
    private static final String WIDGET_ICON = "/de/cismet/lagis/ressource/icons/baum.png";
    private static final Logger LOG = Logger.getLogger(BaumPanel.class);
    private boolean isFlurstueckEditable = true;
    private boolean isInEditMode = false;
    private final BaumModel baumModel = new BaumModel();
    private final ImageIcon icoExistingContract = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/contract.png"));
    private final JComboBox cbxAuspraegung = new JComboBox();
    private final Icon copyDisplayIcon;
    private boolean listenerEnabled = true;
    private JButton btnAddBaum;
    private JButton btnAddExitingBaum;
    private JButton btnRemoveBaum;
    private JButton btnUndo;
    private JScrollPane cpBaum;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane2;
    private JList lstCrossRefs;
    private JList lstMerkmale;
    private JPanel panBemerkung;
    private JPanel panBemerkungTitled;
    private JPanel panMerkmale;
    private JPanel panMerkmaleTitled;
    private JPanel panQuerverweise;
    private JPanel panQuerverweiseTitled;
    private JScrollPane spBemerkung;
    private JScrollPane spMerkmale;
    private JTextArea taBemerkung;
    private JTable tblBaum;
    private JToggleButton tbtnSort;
    private BindingGroup bindingGroup;

    public BaumPanel(String widgetName) {
        this(widgetName, WIDGET_ICON);
    }

    public BaumPanel(String widgetName, String iconPath) {
        this.initComponents();
        this.setWidgetName(widgetName);
        this.setWidgetIcon(iconPath);
        this.configureComponents();
        this.setOpaqueRecursive(this.jPanel1.getComponents());
        this.copyDisplayIcon = new ImageIcon(this.getClass().getResource(WIDGET_ICON));
    }

    @Override
    public List<BasicEntity> getCopyData() {
        ArrayList allBaeume = (ArrayList)this.baumModel.getCidsBeans();
        ArrayList<BasicEntity> result = new ArrayList<BasicEntity>(allBaeume.size());
        for (BaumCustomBean baum : allBaeume) {
            BaumCustomBean tmp = BaumCustomBean.createNew();
            tmp.setAlteNutzung(baum.getAlteNutzung());
            tmp.setAuftragnehmer(baum.getAuftragnehmer());
            tmp.setBaumMerkmal(baum.getBaumMerkmal());
            tmp.setBaumNutzung(baum.getBaumNutzung());
            tmp.setBemerkung(baum.getBemerkung());
            tmp.setCanBeSelected(baum.canBeSelected());
            tmp.setEditable(baum.isEditable());
            tmp.setErfassungsdatum(baum.getErfassungsdatum());
            tmp.setFaelldatum(baum.getFaelldatum());
            tmp.setFillingPaint(baum.getFillingPaint());
            tmp.setFlaeche(baum.getFlaeche());
            Geometry geom = baum.getGeometry();
            if (geom != null) {
                tmp.setGeometry((Geometry)geom.clone());
            }
            tmp.setHighlightingEnabled(baum.isHighlightingEnabled());
            tmp.setLage(baum.getLage());
            tmp.setLinePaint(baum.getLinePaint());
            tmp.setLineWidth(baum.getLineWidth());
            tmp.setModifiable(baum.isModifiable());
            tmp.setPointAnnotationSymbol(baum.getPointAnnotationSymbol());
            tmp.setTransparency(baum.getTransparency());
            tmp.hide(baum.isHidden());
            result.add(tmp);
        }
        return result;
    }

    @Override
    public void paste(BasicEntity item) {
        if (item == null) {
            throw new NullPointerException("Given data item must not be null");
        }
        if (item instanceof Baum) {
            ArrayList residentBaeume = (ArrayList)this.baumModel.getCidsBeans();
            if (residentBaeume.contains(item)) {
                LOG.warn((Object)("Baum " + item + " does already exist in Flurst\u00fcck " + LagisBroker.getInstance().getCurrentFlurstueck()));
            } else {
                this.baumModel.addCidsBean((BaumCustomBean)item);
                MappingComponent mc = LagisBroker.getInstance().getMappingComponent();
                CustomSelectionStyledFeatureGroupWrapper f = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)item, PROVIDER_NAME, PROVIDER_NAME);
                mc.getFeatureCollection().addFeature((Feature)f);
                mc.setGroupLayerVisibility(PROVIDER_NAME, true);
            }
        }
    }

    @Override
    public void pasteAll(List<BasicEntity> dataList) {
        if (dataList == null) {
            throw new NullPointerException("Given list of Baum items must not be null");
        }
        if (dataList.isEmpty()) {
            return;
        }
        ArrayList residentBaeume = (ArrayList)this.baumModel.getCidsBeans();
        int rowCountBefore = this.baumModel.getRowCount();
        MappingComponent mc = LagisBroker.getInstance().getMappingComponent();
        FeatureCollection fc = mc.getFeatureCollection();
        for (BasicEntity entity : dataList) {
            if (!(entity instanceof Baum)) continue;
            if (residentBaeume.contains(entity)) {
                LOG.warn((Object)("Verwaltungsbereich " + entity + " does already exist in Flurst\u00fcck " + LagisBroker.getInstance().getCurrentFlurstueck()));
                continue;
            }
            this.baumModel.addCidsBean((BaumCustomBean)entity);
            CustomSelectionStyledFeatureGroupWrapper wrapper = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)entity, PROVIDER_NAME, PROVIDER_NAME);
            fc.addFeature((Feature)wrapper);
        }
        if (rowCountBefore == this.baumModel.getRowCount()) {
            LOG.warn((Object)("No Baum items were added from input list " + dataList));
        } else {
            this.baumModel.fireTableDataChanged();
            mc.setGroupLayerVisibility(PROVIDER_NAME, true);
        }
    }

    private void setOpaqueRecursive(Component[] components) {
        for (Component currentComp : components) {
            if (currentComp instanceof Container) {
                this.setOpaqueRecursive(((Container)currentComp).getComponents());
            }
            if (!(currentComp instanceof JComponent)) continue;
            ((JComponent)currentComp).setOpaque(false);
        }
    }

    private void configureComponents() {
        TableSelectionUtils.crossReferenceModelAndTable(this.baumModel, (BaumTable)((Object)this.tblBaum));
        this.tblBaum.setDefaultEditor(Date.class, new DateEditor());
        this.tblBaum.setDefaultRenderer(Date.class, new DateRenderer());
        this.tblBaum.addMouseListener(this);
        HighlightPredicate noGeometryPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                int displayedIndex = componentAdapter.row;
                int modelIndex = ((JXTable)BaumPanel.this.tblBaum).convertRowIndexToModel(displayedIndex);
                Baum mp = (Baum)BaumPanel.this.baumModel.getCidsBeanAtRow(modelIndex);
                return mp != null && mp.getGeometry() == null;
            }
        };
        ColorHighlighter noGeometryHighlighter = new ColorHighlighter(noGeometryPredicate, LagisBroker.GREY, null);
        HighlightPredicate contractExpiredPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                int displayedIndex = componentAdapter.row;
                int modelIndex = ((JXTable)BaumPanel.this.tblBaum).convertRowIndexToModel(displayedIndex);
                Baum mp = (Baum)BaumPanel.this.baumModel.getCidsBeanAtRow(modelIndex);
                return mp != null && mp.getFaelldatum() != null && mp.getErfassungsdatum() != null && mp.getFaelldatum().getTime() < System.currentTimeMillis();
            }
        };
        ColorHighlighter contractExpiredHighlighter = new ColorHighlighter(contractExpiredPredicate, LagisBroker.SUCCESSFUL_COLOR, null);
        ((JXTable)this.tblBaum).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER, contractExpiredHighlighter, noGeometryHighlighter});
        Comparator dateComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -1 * ((Date)o1).compareTo((Date)o2);
            }
        };
        ((JXTable)this.tblBaum).getColumnExt(8).setComparator(dateComparator);
        ((JXTable)this.tblBaum).setSortOrder(8, SortOrder.ASCENDING);
        this.tblBaum.getSelectionModel().addListSelectionListener(this);
        ((JXTable)this.tblBaum).setColumnControlVisible(true);
        ((JXTable)this.tblBaum).setHorizontalScrollEnabled(true);
        TableColumn tc = this.tblBaum.getColumnModel().getColumn(4);
        JComboBox<Object> combo = new JComboBox<Object>();
        combo.setBorder(new EmptyBorder(0, 0, 0, 0));
        combo.setEditable(true);
        Collection<BaumKategorieCustomBean> alleKategorien = LagisBroker.getInstance().getAllBaumKategorien();
        for (BaumKategorie baumKategorie : alleKategorien) {
            combo.addItem(baumKategorie);
        }
        combo.addItem("");
        AutoCompleteDecorator.decorate(combo);
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        tc.setCellEditor((TableCellEditor)new ComboBoxCellEditor(combo));
        tc = this.tblBaum.getColumnModel().getColumn(5);
        this.cbxAuspraegung.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.cbxAuspraegung.setEditable(true);
        AutoCompleteDecorator.decorate((JComboBox)this.cbxAuspraegung);
        tc.setCellEditor((TableCellEditor)new ComboBoxCellEditor(this.cbxAuspraegung));
        ((JXTable)this.tblBaum).packAll();
        this.taBemerkung.setDocument(this.baumModel.getBemerkungDocumentModel());
        this.enableSlaveComponents(false);
        Collection<BaumMerkmalCustomBean> baumMerkmal = LagisBroker.getInstance().getAllBaumMerkmale();
        Vector<BaumMerkmalCheckBox> vector = new Vector<BaumMerkmalCheckBox>();
        if (baumMerkmal != null && baumMerkmal.size() > 0) {
            for (BaumMerkmalCustomBean currentMerkmal : baumMerkmal) {
                if (currentMerkmal == null || currentMerkmal.getBezeichnung() == null) continue;
                BaumMerkmalCheckBox newMerkmalCheckBox = new BaumMerkmalCheckBox(currentMerkmal);
                this.setOpaqueRecursive(newMerkmalCheckBox.getComponents());
                newMerkmalCheckBox.setOpaque(false);
                newMerkmalCheckBox.addItemListener(this);
                vector.add(newMerkmalCheckBox);
            }
        }
        this.lstMerkmale.setListData(vector);
        this.lstCrossRefs.setCellRenderer(new FlurstueckSchluesselRenderer());
        this.lstCrossRefs.setModel(new DefaultUniqueListModel());
        this.lstCrossRefs.setSelectionMode(0);
        this.lstCrossRefs.addMouseListener(this);
        this.lstCrossRefs.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String s = value instanceof FlurstueckSchluessel ? ((FlurstueckSchluessel)value).getKeyString() : value.toString();
                this.setText(s);
                this.setOpaque(false);
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                return this;
            }
        });
        PCanvas pc = LagisBroker.getInstance().getMappingComponent().getSelectedObjectPresenter();
        pc.setBackground(this.getBackground());
        LagisBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this);
        this.baumModel.addTableModelListener(this);
    }

    private void updateCbxAuspraegung(Baum mp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Update der Auspr\u00e4gungen");
        }
        this.cbxAuspraegung.removeAllItems();
        if (mp != null && mp.getBaumNutzung() != null && mp.getBaumNutzung().getBaumKategorie() != null && mp.getBaumNutzung().getBaumKategorie().getKategorieAuspraegungen() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Auspr\u00e4gungen sind vorhanden");
            }
            Collection<BaumKategorieAuspraegungCustomBean> auspraegungen = mp.getBaumNutzung().getBaumKategorie().getKategorieAuspraegungen();
            for (BaumKategorieAuspraegung baumKategorieAuspraegung : auspraegungen) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("currentAuspr\u00e4gung: " + baumKategorieAuspraegung));
                }
                this.cbxAuspraegung.addItem(baumKategorieAuspraegung);
            }
            this.cbxAuspraegung.addItem("");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Keine Auspr\u00e4gungen vorhanden");
        }
        this.cbxAuspraegung.validate();
        this.cbxAuspraegung.repaint();
        this.cbxAuspraegung.updateUI();
    }

    @Override
    public void clearComponent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"clearComponent", (Throwable)new CurrentStackTrace());
        }
        this.baumModel.clearSlaveComponents();
        this.deselectAllListEntries();
        this.baumModel.refreshTableModel(new HashSet());
        this.lstCrossRefs.setModel(new DefaultUniqueListModel());
        if (EventQueue.isDispatchThread()) {
            this.lstCrossRefs.updateUI();
            this.lstCrossRefs.repaint();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaumPanel.this.lstCrossRefs.updateUI();
                    BaumPanel.this.lstCrossRefs.repaint();
                }
            });
        }
    }

    public void deselectAllListEntries() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"deselect all entries", (Throwable)new CurrentStackTrace());
        }
        for (int i = 0; i < this.lstMerkmale.getModel().getSize(); ++i) {
            BaumMerkmalCheckBox currentCheckBox = (BaumMerkmalCheckBox)this.lstMerkmale.getModel().getElementAt(i);
            currentCheckBox.removeItemListener(this);
            currentCheckBox.setSelected(false);
            currentCheckBox.addItemListener(this);
        }
        this.lstMerkmale.repaint();
    }

    @Override
    public void refresh(Object arg0) {
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        if (this.isFlurstueckEditable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"BaumRessortWidget --> setComponentEditable");
            }
            this.isInEditMode = isEditable;
            this.baumModel.setInEditMode(isEditable);
            TableCellEditor currentEditor = this.tblBaum.getCellEditor();
            if (currentEditor != null) {
                currentEditor.cancelCellEditing();
            }
            if (isEditable && this.tblBaum.getSelectedRow() != -1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Editable und TabellenEintrag ist gew\u00e4hlt");
                }
                this.btnRemoveBaum.setEnabled(true);
                this.enableSlaveComponents(isEditable);
            } else if (!isEditable) {
                this.deselectAllListEntries();
                this.enableSlaveComponents(isEditable);
                this.btnRemoveBaum.setEnabled(isEditable);
            }
            this.btnAddExitingBaum.setEnabled(isEditable);
            this.btnAddBaum.setEnabled(isEditable);
            this.btnUndo.setEnabled(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"BaumRessortWidget --> setComponentEditable finished");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch B\u00e4ume k\u00f6nnen nicht editiert werden");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            LOG.info((Object)"FlurstueckChanged");
            this.clearComponent();
            FlurstueckArtCustomBean flurstueckArt = newFlurstueck.getFlurstueckSchluessel().getFlurstueckArt();
            if (flurstueckArt != null && flurstueckArt.getBezeichnung().equals("st\u00e4dtisch")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist st\u00e4dtisch und kann editiert werden");
                }
                this.isFlurstueckEditable = true;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch und kann nicht editiert werden");
                }
                this.isFlurstueckEditable = false;
            }
            this.baumModel.refreshTableModel(newFlurstueck.getBaeume());
            Collection<FlurstueckSchluesselCustomBean> crossRefs = newFlurstueck.getBaeumeQuerverweise();
            if (crossRefs != null && crossRefs.size() > 0) {
                this.lstCrossRefs.setModel(new DefaultUniqueListModel(crossRefs));
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayList<Feature> features = BaumPanel.this.baumModel.getAllBaumFeatures();
                    MappingComponent mappingComp = LagisBroker.getInstance().getMappingComponent();
                    FeatureCollection featureCollection = mappingComp.getFeatureCollection();
                    if (features != null) {
                        for (Object currentFeature : features) {
                            if (currentFeature == null) continue;
                            if (BaumPanel.this.isWidgetReadOnly()) {
                                ((Baum)currentFeature).setModifiable(false);
                            }
                            currentFeature = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)currentFeature, BaumPanel.PROVIDER_NAME, BaumPanel.PROVIDER_NAME);
                            featureCollection.addFeature(currentFeature);
                        }
                    }
                    ((JXTable)BaumPanel.this.tblBaum).packAll();
                }
            });
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler im refresh thread: ", (Throwable)ex);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public void updateFlurstueckForSaving(FlurstueckCustomBean flurstueck) {
        Collection<BaumCustomBean> baeume = flurstueck.getBaeume();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Anzahl baeume aktuell gespeichert im Flurst\u00fcck");
            LOG.debug((Object)("Anzahl Baueme im tablemodel: " + this.baumModel.getRowCount()));
        }
        if (baeume != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"warens schon baueme vorhanden");
            }
            baeume.clear();
            baeume.addAll((ArrayList)this.baumModel.getCidsBeans());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("baueme im Flurstueck Set: " + baeume.size()));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Waren noch keine Baueme vorhanden");
            }
            HashSet<BaumCustomBean> newSet = new HashSet<BaumCustomBean>();
            newSet.addAll(this.baumModel.getCidsBeans());
            flurstueck.setBaeume(newSet);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        FlurstueckSchluesselCustomBean key;
        Object source = e.getSource();
        if (source instanceof JXTable) {
            int selecetdRow;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Mit maus auf BaumTaeble geklickt");
            }
            if ((selecetdRow = this.tblBaum.getSelectedRow()) != -1) {
                if (this.isInEditMode) {
                    this.enableSlaveComponents(true);
                    this.btnRemoveBaum.setEnabled(true);
                } else {
                    this.enableSlaveComponents(false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Liste ausgeschaltet");
                    }
                    if (selecetdRow == -1) {
                        this.deselectAllListEntries();
                    }
                }
            } else {
                this.btnRemoveBaum.setEnabled(false);
            }
        } else if (source instanceof JList && e.getClickCount() > 1 && (key = (FlurstueckSchluesselCustomBean)this.lstCrossRefs.getSelectedValue()) != null) {
            LagisBroker.getInstance().loadFlurstueck(key);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseClicked(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void enableSlaveComponents(boolean isEnabled) {
        this.taBemerkung.setEditable(isEnabled);
        this.lstMerkmale.setEnabled(isEnabled);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewIndex;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"SelectionChanged Baum");
        }
        if ((viewIndex = this.tblBaum.getSelectedRow()) != -1) {
            if (this.isInEditMode) {
                this.btnRemoveBaum.setEnabled(true);
            } else {
                this.btnRemoveBaum.setEnabled(false);
            }
            int index = ((JXTable)this.tblBaum).convertRowIndexToModel(viewIndex);
            if (index != -1 && this.tblBaum.getSelectedRowCount() <= 1) {
                Collection<BaumMerkmalCustomBean> merkmale;
                Baum selectedBaum = (Baum)this.baumModel.getCidsBeanAtRow(index);
                this.baumModel.setCurrentSelectedBaum(selectedBaum);
                if (selectedBaum != null) {
                    this.updateCbxAuspraegung(selectedBaum);
                    if (selectedBaum.getGeometry() == null && LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SetBackgroundEnabled abgeschaltet: ", (Throwable)new CurrentStackTrace());
                    }
                }
                if ((merkmale = selectedBaum.getBaumMerkmal()) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Merkmale vorhanden");
                    }
                    for (int i = 0; i < this.lstMerkmale.getModel().getSize(); ++i) {
                        BaumMerkmalCheckBox currentCheckBox = (BaumMerkmalCheckBox)this.lstMerkmale.getModel().getElementAt(i);
                        if (currentCheckBox != null && currentCheckBox.getBaumMerkmal() != null && merkmale.contains(currentCheckBox.getBaumMerkmal())) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Merkmal ist in Baum vorhanden");
                            }
                            currentCheckBox.removeItemListener(this);
                            currentCheckBox.setSelected(true);
                            currentCheckBox.addItemListener(this);
                            this.lstMerkmale.repaint();
                            continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Merkmal ist nicht in Baum vorhanden");
                        }
                        currentCheckBox.removeItemListener(this);
                        currentCheckBox.setSelected(false);
                        currentCheckBox.addItemListener(this);
                        this.lstMerkmale.repaint();
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Keine Merkmale vorhanden");
                    }
                    this.deselectAllListEntries();
                }
                if (this.isInEditMode) {
                    this.enableSlaveComponents(this.isInEditMode);
                } else {
                    this.enableSlaveComponents(this.isInEditMode);
                }
            }
        } else {
            this.btnRemoveBaum.setEnabled(false);
            this.deselectAllListEntries();
            this.baumModel.clearSlaveComponents();
            this.enableSlaveComponents(false);
            return;
        }
        ((BaumTable)((Object)this.tblBaum)).valueChanged_updateFeatures(this, e);
        ((JXTable)this.tblBaum).packAll();
    }

    @Override
    public int getStatus() {
        if (this.tblBaum.getCellEditor() != null) {
            this.validationMessage = "Bitte vollenden Sie alle \u00c4nderungen bei den Baumeintr\u00e4gen.";
            return 2;
        }
        ArrayList baeume = (ArrayList)this.baumModel.getCidsBeans();
        if (baeume != null || baeume.size() > 0) {
            for (Baum currentBaum : baeume) {
                if (currentBaum != null && (currentBaum.getBaumNutzung() == null || currentBaum.getBaumNutzung().getBaumKategorie() == null)) {
                    this.validationMessage = "Alle Baueme m\u00fcssen einen Baumbestand (Kategorie) enthalten";
                    return 2;
                }
                if (currentBaum != null && (currentBaum.getAuftragnehmer() == null || currentBaum.getAuftragnehmer().equals(""))) {
                    this.validationMessage = "Alle Baueme m\u00fcssen einen Auftragnehmer besitzen.";
                    return 2;
                }
                if (currentBaum != null && currentBaum.getLage() == null) {
                    this.validationMessage = "Alle Baueme m\u00fcssen eine Lage besitzen.";
                    return 2;
                }
                if (currentBaum != null && currentBaum.getBaumnummer() == null) {
                    this.validationMessage = "Alle Baueme m\u00fcssen ein Baumnummer besitzen.";
                    return 2;
                }
                if (currentBaum == null || currentBaum.getErfassungsdatum() == null || currentBaum.getFaelldatum() == null || currentBaum.getErfassungsdatum().compareTo(currentBaum.getFaelldatum()) <= 0) continue;
                this.validationMessage = "Das Datum der Erfassung muss vor dem Datum des F\u00e4llens liegen.";
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Item State of BaumMerkmal Changed " + e));
        }
        BaumMerkmalCheckBox checkBox = (BaumMerkmalCheckBox)e.getSource();
        if (this.tblBaum.getSelectedRow() != -1) {
            BaumCustomBean baum = (BaumCustomBean)this.baumModel.getCidsBeanAtRow(((JXTable)this.tblBaum).convertRowIndexToModel(this.tblBaum.getSelectedRow()));
            if (baum != null) {
                Collection<BaumMerkmalCustomBean> merkmale = baum.getBaumMerkmal();
                if (merkmale == null) {
                    LOG.info((Object)"neues Hibernateset f\u00fcr Merkmale angelegt");
                    merkmale = new HashSet<BaumMerkmalCustomBean>();
                    baum.setBaumMerkmal(merkmale);
                }
                if (e.getStateChange() == 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Checkbox wurde selektiert --> f\u00fcge es zum Set hinzu");
                    }
                    merkmale.add(checkBox.getBaumMerkmal());
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Checkbox wurde deselektiert --> l\u00f6sche es aus Set");
                    }
                    merkmale.remove(checkBox.getBaumMerkmal());
                }
            } else {
                LOG.warn((Object)"Kann merkmals\u00e4nderung nicht speichern da kein Eintrag unter diesem Index im Modell vorhanden ist");
            }
        } else {
            LOG.warn((Object)"Kann merkmals\u00e4nderung nicht speichern da kein Eintrag selektiert ist");
        }
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public Vector<GeometrySlotInformation> getSlotInformation() {
        Vector<GeometrySlotInformation> result = new Vector<GeometrySlotInformation>();
        if (this.isWidgetReadOnly()) {
            return result;
        }
        int rowCount = this.baumModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Baum currentBaum = (Baum)this.baumModel.getCidsBeanAtRow(i);
            if (currentBaum.getGeometry() != null) continue;
            result.add(new GeometrySlotInformation(this.getProviderName(), this.getIdentifierString(currentBaum), currentBaum, this));
        }
        return result;
    }

    @Override
    public void featureSelectionChanged(Collection<Feature> features) {
        ((BaumTable)((Object)this.tblBaum)).featureSelectionChanged(this, features, BaumCustomBean.class);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel2 = new JPanel();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.cpBaum = new JScrollPane();
        this.tblBaum = new BaumTable();
        this.jPanel3 = new JPanel();
        this.btnAddBaum = new JButton();
        this.btnRemoveBaum = new JButton();
        this.btnAddExitingBaum = new JButton();
        this.btnUndo = new JButton();
        this.tbtnSort = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.panQuerverweise = new JPanel();
        this.panQuerverweiseTitled = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstCrossRefs = new JList();
        this.jLabel2 = new JLabel();
        this.panMerkmale = new JPanel();
        this.panMerkmaleTitled = new JPanel();
        this.spMerkmale = new JScrollPane();
        this.lstMerkmale = new JCheckBoxList();
        this.jLabel1 = new JLabel();
        this.panBemerkung = new JPanel();
        this.panBemerkungTitled = new JPanel();
        this.spBemerkung = new JScrollPane();
        this.taBemerkung = new JTextArea();
        this.jLabel3 = new JLabel();
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane2, -1, 148, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane2, -1, 126, Short.MAX_VALUE).addContainerGap()));
        this.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.cpBaum.setBorder(null);
        this.tblBaum.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}}, new String[]{"Nummer", "Lage", "Fl\u00e4che m\u00b2", "Nutzung", "Nutzer", "Vertragsbeginn", "Vertragsende"}));
        ((BaumTable)((Object)this.tblBaum)).setSortButton(this.tbtnSort);
        ((BaumTable)((Object)this.tblBaum)).setUndoButton(this.btnUndo);
        this.cpBaum.setViewportView(this.tblBaum);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.cpBaum, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnAddBaum.setAction(((BaumTable)((Object)this.tblBaum)).getAddAction());
        this.btnAddBaum.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddBaum.setBorder(null);
        this.btnAddBaum.setBorderPainted(false);
        this.btnAddBaum.setFocusPainted(false);
        this.btnAddBaum.setMaximumSize(new Dimension(25, 25));
        this.btnAddBaum.setMinimumSize(new Dimension(25, 25));
        this.btnAddBaum.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.btnAddBaum, gridBagConstraints);
        this.btnRemoveBaum.setAction(((BaumTable)((Object)this.tblBaum)).getRemoveAction());
        this.btnRemoveBaum.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveBaum.setBorder(null);
        this.btnRemoveBaum.setBorderPainted(false);
        this.btnRemoveBaum.setFocusPainted(false);
        this.btnRemoveBaum.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveBaum.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveBaum.setPreferredSize(new Dimension(25, 25));
        this.btnRemoveBaum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaumPanel.this.btnRemoveBaumActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel3.add((Component)this.btnRemoveBaum, gridBagConstraints);
        this.btnAddExitingBaum.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/contract.png")));
        this.btnAddExitingBaum.setBorder(null);
        this.btnAddExitingBaum.setBorderPainted(false);
        this.btnAddExitingBaum.setFocusPainted(false);
        this.btnAddExitingBaum.setMaximumSize(new Dimension(25, 25));
        this.btnAddExitingBaum.setMinimumSize(new Dimension(25, 25));
        this.btnAddExitingBaum.setPreferredSize(new Dimension(25, 25));
        this.btnAddExitingBaum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaumPanel.this.btnAddExitingBaumActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.btnAddExitingBaum, gridBagConstraints);
        this.btnUndo.setAction(((BaumTable)((Object)this.tblBaum)).getUndoAction());
        this.btnUndo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/undo.png")));
        this.btnUndo.setToolTipText("R\u00fcckg\u00e4ngig machen");
        this.btnUndo.setBorder(null);
        this.btnUndo.setBorderPainted(false);
        this.btnUndo.setFocusPainted(false);
        this.btnUndo.setMaximumSize(new Dimension(25, 25));
        this.btnUndo.setMinimumSize(new Dimension(25, 25));
        this.btnUndo.setPreferredSize(new Dimension(25, 25));
        this.btnUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaumPanel.this.btnUndoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.btnUndo, gridBagConstraints);
        this.tbtnSort.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.tbtnSort.setToolTipText("Sortierung An / Aus");
        this.tbtnSort.setBorderPainted(false);
        this.tbtnSort.setContentAreaFilled(false);
        this.tbtnSort.setMaximumSize(new Dimension(25, 25));
        this.tbtnSort.setMinimumSize(new Dimension(25, 25));
        this.tbtnSort.setPreferredSize(new Dimension(25, 25));
        this.tbtnSort.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel3.add((Component)this.tbtnSort, gridBagConstraints);
        this.tbtnSort.addItemListener(((BaumTable)((Object)this.tblBaum)).getSortItemListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.jPanel4.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(24, 100));
        this.jPanel1.setPreferredSize(new Dimension(314, 100));
        this.jPanel1.setLayout(new GridBagLayout());
        this.panQuerverweise.setBorder(BorderFactory.createEtchedBorder());
        this.panQuerverweise.setOpaque(false);
        this.panQuerverweise.setLayout(new GridBagLayout());
        this.panQuerverweiseTitled.setOpaque(false);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setOpaque(false);
        this.lstCrossRefs.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.lstCrossRefs.setOpaque(false);
        this.jScrollPane1.setViewportView(this.lstCrossRefs);
        GroupLayout panQuerverweiseTitledLayout = new GroupLayout(this.panQuerverweiseTitled);
        this.panQuerverweiseTitled.setLayout(panQuerverweiseTitledLayout);
        panQuerverweiseTitledLayout.setHorizontalGroup(panQuerverweiseTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE));
        panQuerverweiseTitledLayout.setVerticalGroup(panQuerverweiseTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 61, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panQuerverweise.add((Component)this.panQuerverweiseTitled, gridBagConstraints);
        this.jLabel2.setText("Querverweise:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panQuerverweise.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel1.add((Component)this.panQuerverweise, gridBagConstraints);
        this.panMerkmale.setBorder(BorderFactory.createEtchedBorder());
        this.panMerkmale.setOpaque(false);
        this.panMerkmale.setLayout(new GridBagLayout());
        this.panMerkmaleTitled.setOpaque(false);
        this.spMerkmale.setBorder(null);
        this.spMerkmale.setOpaque(false);
        this.lstMerkmale.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.lstMerkmale.setOpaque(false);
        this.spMerkmale.setViewportView(this.lstMerkmale);
        GroupLayout panMerkmaleTitledLayout = new GroupLayout(this.panMerkmaleTitled);
        this.panMerkmaleTitled.setLayout(panMerkmaleTitledLayout);
        panMerkmaleTitledLayout.setHorizontalGroup(panMerkmaleTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spMerkmale, -2, 0, Short.MAX_VALUE));
        panMerkmaleTitledLayout.setVerticalGroup(panMerkmaleTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spMerkmale, -1, 61, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panMerkmale.add((Component)this.panMerkmaleTitled, gridBagConstraints);
        this.jLabel1.setText("Merkmale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panMerkmale.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel1.add((Component)this.panMerkmale, gridBagConstraints);
        this.panBemerkung.setBorder(BorderFactory.createEtchedBorder());
        this.panBemerkung.setOpaque(false);
        this.panBemerkung.setLayout(new GridBagLayout());
        this.panBemerkungTitled.setOpaque(false);
        this.spBemerkung.setOpaque(false);
        this.taBemerkung.setColumns(20);
        this.taBemerkung.setLineWrap(true);
        this.taBemerkung.setRows(3);
        this.taBemerkung.setWrapStyleWord(true);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.taBemerkung, (Property)ELProperty.create((String)"${editable}"), (Object)this.taBemerkung, (Property)BeanProperty.create((String)"opaque"));
        this.bindingGroup.addBinding((Binding)binding);
        this.spBemerkung.setViewportView(this.taBemerkung);
        GroupLayout panBemerkungTitledLayout = new GroupLayout(this.panBemerkungTitled);
        this.panBemerkungTitled.setLayout(panBemerkungTitledLayout);
        panBemerkungTitledLayout.setHorizontalGroup(panBemerkungTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spBemerkung, -2, 0, Short.MAX_VALUE));
        panBemerkungTitledLayout.setVerticalGroup(panBemerkungTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spBemerkung, -1, 61, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panBemerkung.add((Component)this.panBemerkungTitled, gridBagConstraints);
        this.jLabel3.setText("Bemerkung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panBemerkung.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.panBemerkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void btnUndoActionPerformed(ActionEvent evt) {
    }

    private void btnAddExitingBaumActionPerformed(ActionEvent evt) {
        JDialog dialog = new JDialog(LagisApp.getInstance(), "", true);
        dialog.add(new AddExistingBaumPanel(LagisBroker.getInstance().getCurrentFlurstueck(), this.baumModel, this.lstCrossRefs.getModel()));
        dialog.pack();
        dialog.setIconImage(this.icoExistingContract.getImage());
        dialog.setTitle("Vorhandener Vertrag hinzuf\u00fcgen...");
        StaticSwingTools.showDialog((JDialog)dialog);
    }

    private void btnRemoveBaumActionPerformed(ActionEvent evt) {
        int currentRow = this.tblBaum.getSelectedRow();
        if (currentRow != -1) {
            this.baumModel.removeCidsBean(((JXTable)this.tblBaum).convertRowIndexToModel(currentRow));
            this.baumModel.fireTableDataChanged();
            this.updateCrossRefs();
            this.enableSlaveComponents(false);
            this.deselectAllListEntries();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"liste ausgeschaltet");
            }
        }
    }

    private void updateCrossRefs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Update der Querverweise");
        }
        Collection<FlurstueckSchluesselCustomBean> crossRefs = LagisBroker.getInstance().getCrossreferencesForBaeume(new HashSet<CidsBean>(this.baumModel.getCidsBeans()));
        DefaultUniqueListModel newModel = new DefaultUniqueListModel();
        if (crossRefs != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Es sind Querverweise auf Baeume vorhanden");
            }
            LagisBroker.getInstance().getCurrentFlurstueck().setVertraegeQuerverweise(crossRefs);
            Iterator<FlurstueckSchluesselCustomBean> it = crossRefs.iterator();
            while (it.hasNext()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Ein Querverweis hinzugef\u00fcgt");
                }
                newModel.addElement(it.next());
            }
            newModel.removeElement(LagisBroker.getInstance().getCurrentFlurstueck().getFlurstueckSchluessel());
        }
        this.lstCrossRefs.setModel(newModel);
    }

    private void updateWidgetUi() {
        this.tblBaum.repaint();
        this.lstCrossRefs.repaint();
        this.lstMerkmale.repaint();
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featureCollectionChanged() {
        this.updateWidgetUi();
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        ((JXTable)this.tblBaum).packAll();
    }

    @Override
    public String getDisplayName(BasicEntity entity) {
        if (entity instanceof Baum) {
            Baum baum = (Baum)((Object)entity);
            return this.getProviderName() + " - " + this.getIdentifierString(baum);
        }
        return "unbekannt";
    }

    private String getIdentifierString(Baum baum) {
        String idValue1 = baum.getLage();
        BaumNutzungCustomBean idValue2 = baum.getBaumNutzung();
        StringBuffer identifier = new StringBuffer();
        if (idValue1 != null) {
            identifier.append(idValue1);
        } else {
            identifier.append("keine Lage");
        }
        if (idValue2 != null && idValue2.getBaumKategorie() != null) {
            identifier.append(" - " + idValue2.getBaumKategorie());
        } else {
            identifier.append(" - keine Nutzung");
        }
        if (idValue2 != null && idValue2.getAusgewaehlteAuspraegung() != null) {
            identifier.append(" - " + idValue2.getAusgewaehlteAuspraegung());
        } else {
            identifier.append(" - keine Auspr\u00e4gung");
        }
        return identifier.toString();
    }

    @Override
    public Icon getDisplayIcon() {
        return this.copyDisplayIcon;
    }

    @Override
    public boolean knowsDisplayName(BasicEntity entity) {
        return entity instanceof Baum;
    }

    @Override
    public void duringRemoveAction(Object source) {
        this.updateCrossRefs();
        this.enableSlaveComponents(false);
        this.deselectAllListEntries();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"liste ausgeschaltet");
        }
    }

    @Override
    public void afterRemoveAction(Object source) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isFeatureSelectionChangedEnabled() {
        return this.listenerEnabled;
    }

    @Override
    public void setFeatureSelectionChangedEnabled(boolean listenerEnabled) {
        this.listenerEnabled = listenerEnabled;
    }
}

