/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.GemarkungCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.models.KeyComboboxModel;
import de.cismet.lagisEE.interfaces.Key;
import de.cismet.lagisEE.util.FlurKey;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

public class CreateFlurstueckPanel
extends JPanel
implements DocumentListener,
ActionListener {
    FlurstueckSchluesselCustomBean schluessel;
    private final Logger log = Logger.getLogger(this.getClass());
    private FlurstueckCustomBean currentFlurstueck = null;
    private FlurstueckSchluesselCustomBean currentFlurstueckSchluessel = FlurstueckSchluesselCustomBean.createNew();
    private boolean isIncomplete = false;
    private GemarkungCustomBean currentGemarkung = null;
    private JButton btnCreateNewFlurstueck;
    private final JComboBox cboFlur = new JComboBox();
    private final JComboBox cboGemarkung = new JComboBox();
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblGemarkung;
    private JPanel panAll;
    private JTextField txtFlurstueck;

    public CreateFlurstueckPanel() {
        this.initComponents();
        this.cboFlur.setToolTipText("Flur");
        this.txtFlurstueck.setToolTipText("Flurstueck");
        this.txtFlurstueck.setEnabled(false);
        this.cboGemarkung.setEditable(false);
        this.cboFlur.setEditable(false);
        this.cboGemarkung.setToolTipText("Gemarkung");
        this.btnCreateNewFlurstueck.setEnabled(false);
        this.txtFlurstueck.getDocument().addDocumentListener(this);
        this.txtFlurstueck.addActionListener(this);
        try {
            Thread keyRetrieverThread = new Thread(){

                @Override
                public void run() {
                    Collection<GemarkungCustomBean> gemKeys;
                    if (CreateFlurstueckPanel.this.log.isDebugEnabled()) {
                        CreateFlurstueckPanel.this.log.debug((Object)"Abrufen der Gemarkungen vom Server");
                    }
                    if ((gemKeys = LagisBroker.getInstance().getGemarkungsKeys()) != null) {
                        Vector<Key> gemKeyList = new Vector<Key>(gemKeys);
                        Collections.sort(gemKeyList);
                        CreateFlurstueckPanel.this.cboGemarkung.setModel(new KeyComboboxModel(gemKeyList));
                        CreateFlurstueckPanel.this.cboGemarkung.setEnabled(true);
                    } else {
                        CreateFlurstueckPanel.this.cboGemarkung.setModel(new KeyComboboxModel());
                    }
                }
            };
            keyRetrieverThread.setPriority(5);
            keyRetrieverThread.start();
        }
        catch (Exception ex) {
            this.log.error((Object)"Fehler beim Abrufen der Gemarkungen");
        }
    }

    public CreateFlurstueckPanel(final FlurstueckSchluesselCustomBean schluessel) {
        this.schluessel = schluessel;
        this.initComponents();
        this.cboFlur.setToolTipText("Flur");
        this.txtFlurstueck.setToolTipText("Flurstueck");
        this.txtFlurstueck.setEnabled(false);
        this.cboGemarkung.setEditable(false);
        this.cboFlur.setEditable(false);
        this.cboGemarkung.setToolTipText("Gemarkung");
        this.btnCreateNewFlurstueck.setEnabled(false);
        this.txtFlurstueck.getDocument().addDocumentListener(this);
        this.txtFlurstueck.addActionListener(this);
        try {
            Thread keyRetrieverThread = new Thread(){

                @Override
                public void run() {
                    Collection<GemarkungCustomBean> gemKeys;
                    if (CreateFlurstueckPanel.this.log.isDebugEnabled()) {
                        CreateFlurstueckPanel.this.log.debug((Object)"Abrufen der Gemarkungen vom Server");
                    }
                    if ((gemKeys = LagisBroker.getInstance().getGemarkungsKeys()) != null) {
                        Vector<Key> gemKeyList = new Vector<Key>(gemKeys);
                        Collections.sort(gemKeyList);
                        CreateFlurstueckPanel.this.cboGemarkung.setModel(new KeyComboboxModel(gemKeyList));
                        CreateFlurstueckPanel.this.cboGemarkung.setEnabled(true);
                    } else {
                        CreateFlurstueckPanel.this.cboGemarkung.setModel(new KeyComboboxModel());
                    }
                    if (schluessel != null) {
                        if (CreateFlurstueckPanel.this.log.isDebugEnabled()) {
                            CreateFlurstueckPanel.this.log.debug((Object)("Current Gemarkung: " + schluessel.getGemarkung()));
                        }
                        CreateFlurstueckPanel.this.cboGemarkung.setSelectedItem(schluessel.getGemarkung());
                        CreateFlurstueckPanel.this.cboGemarkung.getEditor().setItem(schluessel.getGemarkung());
                    }
                }
            };
            keyRetrieverThread.setPriority(5);
            keyRetrieverThread.start();
        }
        catch (Exception ex) {
            this.log.error((Object)"Fehler beim Abrufen der Gemarkungen");
        }
    }

    private void initComponents() {
        this.panAll = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.btnCreateNewFlurstueck = new JButton();
        this.txtFlurstueck = new JTextField();
        this.lblGemarkung = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setPreferredSize(new Dimension(20, 20));
        this.panAll.setLayout(new BorderLayout());
        this.panAll.setBorder(BorderFactory.createTitledBorder(null, "", 0, 5));
        this.panAll.setPreferredSize(new Dimension(50, 100));
        this.jScrollPane1.setBorder(null);
        this.jPanel1.setPreferredSize(new Dimension(20, 20));
        this.btnCreateNewFlurstueck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/ok.png")));
        this.btnCreateNewFlurstueck.setBorder(null);
        this.btnCreateNewFlurstueck.setBorderPainted(false);
        this.btnCreateNewFlurstueck.setContentAreaFilled(false);
        this.btnCreateNewFlurstueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateFlurstueckPanel.this.btnCreateNewFlurstueckActionPerformed(evt);
            }
        });
        this.cboFlur.setEditable(true);
        this.cboFlur.setMaximumSize(new Dimension(90, 23));
        this.cboFlur.setMinimumSize(new Dimension(90, 23));
        this.cboFlur.setPreferredSize(new Dimension(90, 23));
        this.cboFlur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateFlurstueckPanel.this.cboFlurActionPerformed(evt);
            }
        });
        this.cboGemarkung.setEditable(true);
        this.cboGemarkung.setMaximumSize(new Dimension(90, 23));
        this.cboGemarkung.setMinimumSize(new Dimension(90, 23));
        this.cboGemarkung.setPreferredSize(new Dimension(90, 23));
        this.cboGemarkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateFlurstueckPanel.this.cboGemarkungActionPerformed(evt);
            }
        });
        this.lblGemarkung.setText("Gemarkung");
        this.jLabel2.setText("Flur");
        this.jLabel3.setText("Flurstueck");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.cboGemarkung, -2, -1, -2).add((Component)this.lblGemarkung)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.cboFlur, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.txtFlurstueck, -2, 90, -2)).addPreferredGap(0).add((Component)this.btnCreateNewFlurstueck, -2, 32, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.lblGemarkung)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.cboGemarkung, -2, -1, -2).add((Component)this.cboFlur, -2, -1, -2).add((Component)this.txtFlurstueck, -2, 22, -2))).add((Component)this.btnCreateNewFlurstueck, -2, 33, -2)).addContainerGap(28, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.panAll.add((Component)this.jScrollPane1, "Center");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panAll, -2, 348, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panAll, -1, 95, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnCreateNewFlurstueckActionPerformed(ActionEvent evt) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"create flurst\u00fcck performed");
            }
            ((TitledBorder)this.panAll.getBorder()).setTitle("");
            FlurstueckSchluesselCustomBean checkedKey = LagisBroker.getInstance().completeFlurstueckSchluessel(this.currentFlurstueckSchluessel);
            if (checkedKey != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Flurst\u00fcck ist bereits vorhanden");
                }
                ((TitledBorder)this.panAll.getBorder()).setTitle("Flurst\u00fcck ist bereits vorhanden, bitte w\u00e4hlen Sie einen anderen Schl\u00fcssel.");
            } else {
                FlurstueckCustomBean newFlurstueck;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Flurst\u00fcck ist noch nicht vorhanden und kann angelegt werden");
                }
                if ((newFlurstueck = LagisBroker.getInstance().createFlurstueck(this.currentFlurstueckSchluessel)) != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Id des neuen Flurst\u00fccks" + newFlurstueck.getId()));
                    }
                    LagisBroker.getInstance().loadFlurstueck(newFlurstueck.getFlurstueckSchluessel());
                    StaticSwingTools.getParentFrame((Component)this).dispose();
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Neues Flurst\u00fccks ist null");
                    this.log.debug((Object)"Fehler beim Anlegen den Flurstuecks.");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Fehler beim anlegen des Flurstuecks: " + ex));
        }
    }

    private void cboFlurActionPerformed(ActionEvent evt) {
        if (evt != null && evt.getSource() instanceof JComboBox) {
            if (evt.getActionCommand().equals("comboBoxChanged")) {
                Object selectedItem = this.cboFlur.getSelectedItem();
                if (selectedItem != null && selectedItem instanceof FlurKey) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("selected Item: " + selectedItem));
                        this.log.debug((Object)("selected Item: " + ((FlurKey)selectedItem).getFlurId()));
                    }
                    this.currentFlurstueckSchluessel.setFlur(((FlurKey)selectedItem).getFlurId());
                    this.lockFlurstueckCbo(false);
                }
            } else if (evt.getActionCommand().equals("comboBoxEdited")) {
                // empty if block
            }
        }
    }

    private void cboGemarkungActionPerformed(ActionEvent evt) {
        try {
            this.isIncomplete = false;
            this.currentFlurstueckSchluessel = null;
            this.lockFlurCbo(true);
            this.lockFlurstueckCbo(true);
            this.currentFlurstueckSchluessel = FlurstueckSchluesselCustomBean.createNew();
            if (evt != null && evt.getSource() instanceof JComboBox) {
                boolean unknownKey;
                boolean handMade;
                GemarkungCustomBean current;
                if (evt.getActionCommand().equals("comboBoxChanged")) {
                    Object selectedItem;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"GemarkungChanged");
                    }
                    if (!((selectedItem = this.cboGemarkung.getSelectedItem()) instanceof GemarkungCustomBean)) {
                        Object current2 = null;
                        this.currentGemarkung = null;
                        return;
                    }
                    this.currentGemarkung = current = (GemarkungCustomBean)selectedItem;
                    handMade = false;
                    unknownKey = false;
                } else {
                    current = null;
                    this.currentGemarkung = null;
                    handMade = false;
                    unknownKey = false;
                }
                if (current != null) {
                    Thread keyRetrieverThread = new Thread(){

                        @Override
                        public void run() {
                            KeyComboboxModel keyModel;
                            if (CreateFlurstueckPanel.this.log.isDebugEnabled()) {
                                CreateFlurstueckPanel.this.log.debug((Object)"Abrufen der FlurKeys vom Server");
                            }
                            CreateFlurstueckPanel.this.currentGemarkung = LagisBroker.getInstance().completeGemarkung(current);
                            if (CreateFlurstueckPanel.this.currentGemarkung == null) {
                                if (CreateFlurstueckPanel.this.log.isDebugEnabled()) {
                                    CreateFlurstueckPanel.this.log.debug((Object)"liefert keine komplette Germarkung (Thread)");
                                }
                                CreateFlurstueckPanel.this.currentGemarkung = current;
                            }
                            CreateFlurstueckPanel.this.currentFlurstueckSchluessel.setGemarkung(CreateFlurstueckPanel.this.currentGemarkung);
                            Collection<Key> flurKeys = LagisBroker.getInstance().getDependingKeysForKey(CreateFlurstueckPanel.this.currentGemarkung);
                            if (flurKeys != null) {
                                Vector<Key> flurKeyList = new Vector<Key>(flurKeys);
                                Collections.sort(flurKeyList);
                                keyModel = new KeyComboboxModel(flurKeyList);
                            } else {
                                keyModel = new KeyComboboxModel();
                            }
                            CreateFlurstueckPanel.this.cboFlur.setModel(keyModel);
                            CreateFlurstueckPanel.this.lockFlurCbo(false);
                            CreateFlurstueckPanel.this.cboFlur.requestFocus();
                            if (!handMade || keyModel.getSize() != 0 || unknownKey) {
                                // empty if block
                            }
                        }
                    };
                    keyRetrieverThread.setPriority(5);
                    keyRetrieverThread.start();
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Fehler beim setzen der Gemarkung", (Throwable)ex);
        }
    }

    public void lockFlurCbo(boolean flur) {
        if (flur) {
            this.cboFlur.setModel(new KeyComboboxModel());
            this.cboFlur.setEnabled(false);
        } else {
            this.cboFlur.setEnabled(true);
        }
    }

    public void lockFlurstueckCbo(boolean flurstueck) {
        if (flurstueck) {
            this.txtFlurstueck.setEnabled(false);
            this.txtFlurstueck.setText("");
            this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
        } else {
            this.txtFlurstueck.setEnabled(true);
        }
    }

    public void setHighlightColor(Color color) {
        this.cboGemarkung.getEditor().getEditorComponent().setBackground(color);
        this.cboFlur.getEditor().getEditorComponent().setBackground(color);
        this.txtFlurstueck.setBackground(color);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        String text = this.txtFlurstueck.getText();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Flurst\u00fcck String changed: " + text));
        }
        if (text != null) {
            if (text.length() != 0) {
                String[] tokens = text.split("/");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Anzahl teile der Flurst\u00fccksid: " + tokens.length));
                }
                try {
                    switch (tokens.length) {
                        case 1: {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Eine Zahl");
                            }
                            this.currentFlurstueckSchluessel.setFlurstueckZaehler(Integer.parseInt(tokens[0]));
                            this.currentFlurstueckSchluessel.setFlurstueckNenner(0);
                            this.setHighlightColor(LagisBroker.SUCCESSFUL_COLOR);
                            this.btnCreateNewFlurstueck.setEnabled(true);
                            break;
                        }
                        case 2: {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Zwei Zahlen");
                            }
                            this.currentFlurstueckSchluessel.setFlurstueckZaehler(Integer.parseInt(tokens[0]));
                            this.currentFlurstueckSchluessel.setFlurstueckNenner(Integer.parseInt(tokens[1]));
                            this.setHighlightColor(LagisBroker.SUCCESSFUL_COLOR);
                            this.btnCreateNewFlurstueck.setEnabled(true);
                            break;
                        }
                        default: {
                            this.log.warn((Object)"Falsche Eingabe erwarted wird ein Flurstueck ohne oder mit Nenner z.B. 10\n");
                            this.setHighlightColor(LagisBroker.ERROR_COLOR);
                            this.btnCreateNewFlurstueck.setEnabled(false);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    this.log.error((Object)"Fehler beim parsen des Flurst\u00fcck Z\u00e4hler/Nenner", (Throwable)ex);
                    this.setHighlightColor(LagisBroker.ERROR_COLOR);
                    this.btnCreateNewFlurstueck.setEnabled(false);
                }
            } else {
                this.btnCreateNewFlurstueck.setEnabled(false);
            }
        } else {
            this.btnCreateNewFlurstueck.setEnabled(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        String text = this.txtFlurstueck.getText();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Flurst\u00fcck String changed: " + text));
        }
        if (text != null) {
            if (text.length() != 0) {
                String[] tokens = text.split("/");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Anzahl teile der Flurst\u00fccksid: " + tokens.length));
                }
                try {
                    switch (tokens.length) {
                        case 1: {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Eine Zahl");
                            }
                            this.currentFlurstueckSchluessel.setFlurstueckZaehler(Integer.parseInt(tokens[0]));
                            this.currentFlurstueckSchluessel.setFlurstueckNenner(0);
                            this.setHighlightColor(LagisBroker.SUCCESSFUL_COLOR);
                            this.btnCreateNewFlurstueck.setEnabled(true);
                            break;
                        }
                        case 2: {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Zwei Zahlen");
                            }
                            this.currentFlurstueckSchluessel.setFlurstueckZaehler(Integer.parseInt(tokens[0]));
                            this.currentFlurstueckSchluessel.setFlurstueckNenner(Integer.parseInt(tokens[1]));
                            this.setHighlightColor(LagisBroker.SUCCESSFUL_COLOR);
                            this.btnCreateNewFlurstueck.setEnabled(true);
                            break;
                        }
                        default: {
                            this.log.warn((Object)"Falsche Eingabe erwarted wird ein Flurstueck ohne oder mit Nenner z.B. 10\n");
                            this.setHighlightColor(LagisBroker.ERROR_COLOR);
                            this.btnCreateNewFlurstueck.setEnabled(false);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    this.log.error((Object)"Fehler beim parsen des Flurst\u00fcck Z\u00e4hler/Nenner", (Throwable)ex);
                    this.setHighlightColor(LagisBroker.ERROR_COLOR);
                    this.btnCreateNewFlurstueck.setEnabled(false);
                }
            } else {
                this.btnCreateNewFlurstueck.setEnabled(false);
            }
        } else {
            this.btnCreateNewFlurstueck.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JTextField && this.btnCreateNewFlurstueck.isEnabled()) {
            this.btnCreateNewFlurstueckActionPerformed(new ActionEvent(this, 1, "createNewFlurstueck"));
        }
    }
}

