/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.clientutils.DmsUrlsPanel;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.widget.AbstractWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class DMSPanel
extends AbstractWidget
implements FlurstueckChangeListener,
FlurstueckSaver {
    private static final String WIDGET_NAME = "Dokumenten Panel";
    private static final Logger LOG = Logger.getLogger(DMSPanel.class);
    private DmsUrlsPanel dmsUrlsPanel1;

    public DMSPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        this.dmsUrlsPanel1.initWithConnectionContext(ConnectionContext.createDeprecated());
    }

    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            this.clearComponent();
            this.setCursor(Cursor.getDefaultCursor());
            this.dmsUrlsPanel1.setDmsUrls(newFlurstueck.getDokumente());
            this.dmsUrlsPanel1.refresh();
            this.repaint();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Flurstueckswechsel im FlurstueckPanel: ", (Throwable)ex);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        this.dmsUrlsPanel1.setEnabled(isEditable);
    }

    @Override
    public synchronized void clearComponent() {
        this.dmsUrlsPanel1.setDmsUrls(null);
        this.dmsUrlsPanel1.refresh();
    }

    private void initComponents() {
        this.dmsUrlsPanel1 = new DmsUrlsPanel("LAGIS");
        this.setLayout(new BorderLayout());
        this.add((Component)this.dmsUrlsPanel1, "Center");
    }

    public boolean isInEditMode() {
        return this.dmsUrlsPanel1.isEnabled();
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public void updateFlurstueckForSaving(FlurstueckCustomBean flurstueck) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Dokumente werden gespeichert");
        }
        this.clearComponent();
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }
}

