/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.GemarkungCustomBean;
import de.cismet.cids.custom.beans.lagis.RebeCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltungsbereichCustomBean;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.FeatureGroupMember;
import de.cismet.cismap.commons.gui.FeatureLayerTransparencyButton;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.AttachFeatureListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeleteFeatureListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.FeatureMoveListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.JoinPolygonsListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SimpleMoveListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SplitPolygonListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.NoPermissionsWidget;
import de.cismet.lagis.utillity.GeometrySlotInformation;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.lagis.widget.RessortFactory;
import de.cismet.lagisEE.entity.core.CustomSelectionStyledFeatureGroupWrapper;
import de.cismet.lagisEE.interfaces.GeometrySlot;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.historybutton.HistoryModel;
import de.cismet.tools.gui.historybutton.JHistoryButton;
import edu.umd.cs.piccolox.event.PNotification;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdom.Content;
import org.jdom.Element;

public class KartenPanel
extends AbstractWidget
implements FlurstueckChangeListener,
FeatureCollectionListener,
Configurable,
NoPermissionsWidget,
Observer {
    private static final String WIDGET_NAME = "Karten Panel";
    private static final String PROVIDER_BAUM = "Baum";
    private static final String PROVIDER_MIPA = "MiPa";
    private static final String PERM_KEY_BAUM = "Baumdatei";
    private static final String PERM_KEY_MIPA = "Vermietung/Verpachtung";
    private static final Logger LOG = Logger.getLogger(KartenPanel.class);
    private final MappingComponent mappingComponent;
    private boolean isEditable = true;
    private final JButton cmdCopyFlaeche = new JButton();
    private final JButton cmdPasteFlaeche = new JButton();
    private Object clipboard = null;
    private final ArrayList<Feature> copiedFeatures = new ArrayList();
    private final Map<String, FeatureGroupActionListener> featureGroupButtonListenerMap;
    private final JLabel lblInfo;
    private Object lastOverFeature;
    private JButton cmdAdd;
    private JButton cmdAddHandle;
    private JButton cmdAttachPolyToAlphadata;
    private JButton cmdBack;
    private JButton cmdForeground;
    private JButton cmdForward;
    private JButton cmdFullPoly;
    private JButton cmdFullPoly1;
    private JButton cmdJoinPoly;
    private JButton cmdMoveHandle;
    private JButton cmdMovePolygon;
    private JButton cmdNewPoint;
    private JButton cmdNewPolygon;
    private JButton cmdPan;
    private JButton cmdRaisePolygon;
    private JButton cmdRedo;
    private JButton cmdRemoveHandle;
    private JButton cmdRemovePolygon;
    private JToggleButton cmdSearchAlkisLandparcel;
    private JToggleButton cmdSearchBaulasten;
    private JToggleButton cmdSearchVermessungRiss;
    private JButton cmdSelect;
    private JButton cmdSnap;
    private JButton cmdSplitPoly;
    private JButton cmdUndo;
    private JButton cmdWmsBackground;
    private JButton cmdZoom;
    private JButton jButton2;
    private JPanel jPanel1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JToolBar jToolBar1;

    public KartenPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
        this.mappingComponent.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this);
        this.mappingComponent.setBackgroundEnabled(true);
        PNotificationCenter.defaultCenter().addListener((Object)this, "attachFeatureRequested", "ATTACH_FEATURE_NOTIFICATION", (Object)this.mappingComponent.getInputListener("ATTACH_POLYGON_TO_ALPHADATA"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "selectionChanged", "SELECTION_CHANGED", (Object)this.mappingComponent.getInputListener("SPLIT_POLYGON"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "splitPolygon", "SPLIT_FINISHED", (Object)this.mappingComponent.getInputListener("SPLIT_POLYGON"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "featureDeleteRequested", "FEATURE_DELETE_REQUEST_NOTIFICATION", (Object)this.mappingComponent.getInputListener("REMOVE_POLYGON"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "joinPolygons", "FEATURE_JOIN_REQUEST_NOTIFICATION", (Object)this.mappingComponent.getInputListener("JOIN_POLYGONS"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "selectionChanged", "SELECTION_CHANGED_NOTIFICATION", (Object)this.mappingComponent.getInputListener("SELECT"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "selectionChanged", "SELECTION_CHANGED_NOTIFICATION_FEATUREMOVE", (Object)this.mappingComponent.getInputListener("MOVE_POLYGON"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "coordinatesChanged", "COORDINATES_CHANGED", (Object)this.mappingComponent.getInputListener("MOTION"));
        ((JHistoryButton)this.cmdForward).setDirection(1);
        ((JHistoryButton)this.cmdBack).setDirection(2);
        ((JHistoryButton)this.cmdForward).setHistoryModel((HistoryModel)this.mappingComponent);
        ((JHistoryButton)this.cmdBack).setHistoryModel((HistoryModel)this.mappingComponent);
        this.mappingComponent.setBackground(this.getBackground());
        this.mappingComponent.setBackgroundEnabled(true);
        this.add("Center", (Component)this.mappingComponent);
        this.configureCopyPaste();
        this.featureGroupButtonListenerMap = new HashMap<String, FeatureGroupActionListener>();
        this.addFeatureGroupButton("Flurst\u00fcck", "Flurst\u00fcck", "/de/cismet/lagis/ressource/icons/layer_flurstueck.png", "/de/cismet/lagis/ressource/icons/layer_flurstueck_sw.png");
        this.addFeatureGroupButton("Verwaltende Dienstelle", "Verwaltungsbereiche", "/de/cismet/lagis/ressource/icons/layer_vb.png", "/de/cismet/lagis/ressource/icons/layer_vb_sw.png");
        this.addFeatureGroupButton("ReBe", "ReBe", "/de/cismet/lagis/ressource/icons/layer_rebe.png", "/de/cismet/lagis/ressource/icons/layer_rebe_sw.png");
        RessortFactory ressortFactory = RessortFactory.getInstance();
        HashMap<String, AbstractWidget> ressorts = ressortFactory.getRessorts();
        if (ressorts.containsKey(PERM_KEY_BAUM)) {
            this.addFeatureGroupButton(PROVIDER_BAUM, PERM_KEY_BAUM, "/de/cismet/lagis/ressource/icons/layer_baum.png", "/de/cismet/lagis/ressource/icons/layer_baum_sw.png");
        }
        if (ressorts.containsKey(PERM_KEY_MIPA)) {
            this.addFeatureGroupButton(PROVIDER_MIPA, PERM_KEY_MIPA, "/de/cismet/lagis/ressource/icons/layer_mipa.png", "/de/cismet/lagis/ressource/icons/layer_mipa_sw.png");
        }
        this.addSeparator();
        this.lblInfo = new JLabel();
        this.remove(this.jPanel1);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.lblInfo, "West");
        panel.add((Component)this.jPanel1, "East");
        super.add((Component)panel, "South");
        ((Observable)this.mappingComponent.getMemUndo()).addObserver(this);
        ((Observable)this.mappingComponent.getMemRedo()).addObserver(this);
        this.mappingComponent.getFeatureLayer().setTransparency(0.5882353f);
        ((SimpleMoveListener)this.mappingComponent.getInputListener("MOTION")).setDeepSeekEnabled(true);
    }

    private void addSeparator() {
        JSeparator sep = new JSeparator(1);
        sep.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        sep.setMinimumSize(new Dimension(2, 10));
        sep.setPreferredSize(new Dimension(2, 10));
        this.jToolBar1.add(sep);
    }

    private void addFeatureGroupButton(String featureGroup, String tooltipText, String icon, String invisIcon) {
        JToggleButton button = new JToggleButton();
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setSelectedIcon(new ImageIcon(this.getClass().getResource(icon)));
        button.setIcon(new ImageIcon(this.getClass().getResource(invisIcon)));
        FeatureGroupActionListener listener = new FeatureGroupActionListener(button, this.mappingComponent, featureGroup, tooltipText);
        button.addActionListener(listener);
        button.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        button.setIconTextGap(8);
        button.setMargin(new Insets(10, 14, 10, 14));
        this.jToolBar1.add(button);
        this.featureGroupButtonListenerMap.put(featureGroup, listener);
    }

    private void configureCopyPaste() {
        this.cmdCopyFlaeche.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/copyFl16.png")));
        this.cmdCopyFlaeche.setToolTipText("Fl\u00e4che kopieren");
        this.cmdCopyFlaeche.setBorderPainted(false);
        this.cmdCopyFlaeche.setEnabled(false);
        this.cmdCopyFlaeche.setFocusPainted(false);
        this.cmdCopyFlaeche.setFocusable(false);
        this.cmdCopyFlaeche.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdCopyFlaeche.setIconTextGap(8);
        this.cmdCopyFlaeche.setHorizontalTextPosition(0);
        this.cmdCopyFlaeche.setPreferredSize(new Dimension(23, 23));
        this.cmdCopyFlaeche.setVerticalTextPosition(3);
        this.cmdCopyFlaeche.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdCopyFlaecheActionPerformed(evt);
            }
        });
        this.cmdPasteFlaeche.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/pasteFl16.png")));
        this.cmdPasteFlaeche.setToolTipText("Fl\u00e4che einf\u00fcgen");
        this.cmdPasteFlaeche.setBorderPainted(false);
        this.cmdPasteFlaeche.setEnabled(false);
        this.cmdPasteFlaeche.setFocusPainted(false);
        this.cmdPasteFlaeche.setFocusable(false);
        this.cmdPasteFlaeche.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdPasteFlaeche.setIconTextGap(8);
        this.cmdPasteFlaeche.setHorizontalTextPosition(0);
        this.cmdPasteFlaeche.setPreferredSize(new Dimension(23, 23));
        this.cmdPasteFlaeche.setVerticalTextPosition(3);
        this.cmdPasteFlaeche.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdPasteFlaecheActionPerformed(evt);
            }
        });
        this.jToolBar1.add((Component)this.cmdCopyFlaeche, 21);
        this.jToolBar1.add((Component)this.cmdPasteFlaeche, 22);
        this.cmdCopyFlaeche.setVisible(false);
        this.cmdPasteFlaeche.setVisible(false);
    }

    private void cmdCopyFlaecheActionPerformed(ActionEvent evt) {
        boolean answer = false;
        this.copiedFeatures.clear();
        this.clipboard = LagisBroker.getInstance().getMappingComponent().getFeatureCollection().getSelectedFeatures();
        if (this.clipboard != null) {
            for (Feature clipboardFlaeche : (Collection)this.clipboard) {
                PureNewFeature newFeature = new PureNewFeature((Geometry)clipboardFlaeche.getGeometry().clone());
                newFeature.setCanBeSelected(true);
                newFeature.setEditable(true);
                this.copiedFeatures.add((Feature)newFeature);
            }
        }
        if (this.copiedFeatures.size() > 0) {
            this.cmdPasteFlaeche.setEnabled(true);
        } else {
            this.cmdPasteFlaeche.setEnabled(false);
        }
    }

    private void cmdPasteFlaecheActionPerformed(ActionEvent evt) {
        if (this.copiedFeatures.size() > 0) {
            LagisBroker.getInstance().getMappingComponent().getFeatureCollection().unselectAll();
            for (Feature clipboardFlaeche : this.copiedFeatures) {
                PureNewFeature newFeature = new PureNewFeature((Geometry)clipboardFlaeche.getGeometry().clone());
                newFeature.setCanBeSelected(true);
                newFeature.setEditable(true);
                LagisBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature((Feature)newFeature);
            }
        }
    }

    public void setInteractionMode() {
        String currentInteractionMode = this.mappingComponent.getInteractionMode();
        if (currentInteractionMode != null) {
            if (currentInteractionMode.equals("SELECT")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"InteractionMode set to SELECT");
                }
                this.cmdSelectActionPerformed(null);
            } else if (currentInteractionMode.equals("PAN")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"InteractionMode set to PAN");
                }
                this.cmdPanActionPerformed(null);
            } else if (currentInteractionMode.equals("NEW_POLYGON")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"InteractionMode set to NEW_POLYGON");
                }
                this.cmdNewPolygonActionPerformed(null);
            } else if (currentInteractionMode.equals("ZOOM")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"InteractionMode set to ZOOM");
                }
                this.cmdZoomActionPerformed(null);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unknown Interactionmode: " + currentInteractionMode));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"InteractionMode == null");
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.cmdFullPoly = new JButton();
        this.cmdFullPoly1 = new JButton();
        this.cmdBack = new JHistoryButton();
        this.cmdForward = new JHistoryButton();
        this.jSeparator4 = new JSeparator();
        this.cmdWmsBackground = new JButton();
        this.cmdForeground = new JButton();
        this.cmdSnap = new JButton();
        this.jSeparator5 = new JSeparator();
        this.cmdZoom = new JButton();
        this.cmdPan = new JButton();
        this.cmdSelect = new JButton();
        this.jSeparator10 = new JSeparator();
        this.cmdSearchAlkisLandparcel = new JToggleButton();
        this.cmdSearchBaulasten = new JToggleButton();
        this.cmdSearchVermessungRiss = new JToggleButton();
        this.jSeparator9 = new JSeparator();
        this.cmdMovePolygon = new JButton();
        this.cmdNewPolygon = new JButton();
        this.cmdNewPoint = new JButton();
        this.cmdRaisePolygon = new JButton();
        this.cmdRemovePolygon = new JButton();
        this.cmdAttachPolyToAlphadata = new JButton();
        this.cmdJoinPoly = new JButton();
        this.cmdSplitPoly = new JButton();
        this.jSeparator6 = new JSeparator();
        this.cmdMoveHandle = new JButton();
        this.cmdAddHandle = new JButton();
        this.cmdRemoveHandle = new JButton();
        this.jSeparator7 = new JSeparator();
        this.cmdUndo = new JButton();
        this.cmdRedo = new JButton();
        this.jSeparator8 = new JSeparator();
        this.jButton2 = new FeatureLayerTransparencyButton();
        this.jPanel1 = new JPanel();
        this.cmdAdd = new JButton();
        this.setLayout(new BorderLayout());
        this.jToolBar1.setMaximumSize(new Dimension(32769, 32769));
        this.jToolBar1.setMinimumSize(new Dimension(300, 25));
        this.jToolBar1.setPreferredSize(new Dimension(300, 28));
        this.cmdFullPoly.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/fullPoly.png")));
        this.cmdFullPoly.setToolTipText("Zeige alle Fl\u00e4chen");
        this.cmdFullPoly.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdFullPoly.setIconTextGap(8);
        this.cmdFullPoly.setMargin(new Insets(10, 14, 10, 14));
        this.cmdFullPoly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdFullPolyActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdFullPoly);
        this.cmdFullPoly1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/fullSelPoly.png")));
        this.cmdFullPoly1.setToolTipText("Zoom zur ausgew\u00e4hlten Fl\u00e4che");
        this.cmdFullPoly1.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdFullPoly1.setIconTextGap(8);
        this.cmdFullPoly1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdFullPoly1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdFullPoly1);
        this.cmdBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/back2.png")));
        this.cmdBack.setToolTipText("Zur\u00fcck");
        this.cmdBack.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdBackActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdBack);
        this.cmdForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/fwd.png")));
        this.cmdForward.setToolTipText("Vor");
        this.cmdForward.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdForwardActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdForward);
        this.jSeparator4.setOrientation(1);
        this.jSeparator4.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator4.setMinimumSize(new Dimension(2, 10));
        this.jSeparator4.setPreferredSize(new Dimension(2, 10));
        this.jToolBar1.add(this.jSeparator4);
        this.cmdWmsBackground.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/map.png")));
        this.cmdWmsBackground.setToolTipText("Hintergrund an/aus");
        this.cmdWmsBackground.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdWmsBackground.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/map_on.png")));
        this.cmdWmsBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdWmsBackgroundActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdWmsBackground);
        this.cmdForeground.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/foreground.png")));
        this.cmdForeground.setToolTipText("Vordergrund an/aus");
        this.cmdForeground.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdForeground.setFocusable(false);
        this.cmdForeground.setHorizontalTextPosition(0);
        this.cmdForeground.setSelected(true);
        this.cmdForeground.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/foreground_on.png")));
        this.cmdForeground.setVerticalTextPosition(3);
        this.cmdForeground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdForegroundActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdForeground);
        this.cmdSnap.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/snap.png")));
        this.cmdSnap.setToolTipText("Snapping an/aus");
        this.cmdSnap.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdSnap.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/snap_selected.png")));
        this.cmdSnap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdSnapActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdSnap);
        this.jSeparator5.setOrientation(1);
        this.jSeparator5.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator5.setMinimumSize(new Dimension(2, 10));
        this.jSeparator5.setPreferredSize(new Dimension(2, 10));
        this.jToolBar1.add(this.jSeparator5);
        this.cmdZoom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/zoom.png")));
        this.cmdZoom.setToolTipText("Zoomen");
        this.cmdZoom.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdZoom.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/zoom_selected.png")));
        this.cmdZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdZoomActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdZoom);
        this.cmdPan.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/move2.png")));
        this.cmdPan.setToolTipText("Verschieben");
        this.cmdPan.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdPan.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/move2_selected.png")));
        this.cmdPan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdPanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdPan);
        this.cmdSelect.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/select.png")));
        this.cmdSelect.setToolTipText("Ausw\u00e4hlen");
        this.cmdSelect.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdSelect.setSelected(true);
        this.cmdSelect.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/select_selected.png")));
        this.cmdSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdSelectActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdSelect);
        this.jSeparator10.setOrientation(1);
        this.jSeparator10.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator10.setMinimumSize(new Dimension(2, 10));
        this.jSeparator10.setPreferredSize(new Dimension(2, 10));
        this.jToolBar1.add(this.jSeparator10);
        this.cmdSearchAlkisLandparcel.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/alk.png")));
        this.cmdSearchAlkisLandparcel.setToolTipText("Flurst\u00fccke suchen");
        this.cmdSearchAlkisLandparcel.setBorderPainted(false);
        this.cmdSearchAlkisLandparcel.setContentAreaFilled(false);
        this.cmdSearchAlkisLandparcel.setFocusPainted(false);
        this.cmdSearchAlkisLandparcel.setFocusable(false);
        this.cmdSearchAlkisLandparcel.setHorizontalTextPosition(0);
        this.cmdSearchAlkisLandparcel.setMaximumSize(new Dimension(22, 18));
        this.cmdSearchAlkisLandparcel.setMinimumSize(new Dimension(22, 18));
        this.cmdSearchAlkisLandparcel.setPreferredSize(new Dimension(22, 18));
        this.cmdSearchAlkisLandparcel.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/alk_selected.png")));
        this.cmdSearchAlkisLandparcel.setVerticalTextPosition(3);
        this.cmdSearchAlkisLandparcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdSearchAlkisLandparcelActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdSearchAlkisLandparcel);
        this.cmdSearchBaulasten.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/Baulast.png")));
        this.cmdSearchBaulasten.setToolTipText("Baulasten suchen");
        this.cmdSearchBaulasten.setBorderPainted(false);
        this.cmdSearchBaulasten.setContentAreaFilled(false);
        this.cmdSearchBaulasten.setFocusPainted(false);
        this.cmdSearchBaulasten.setFocusable(false);
        this.cmdSearchBaulasten.setHorizontalTextPosition(0);
        this.cmdSearchBaulasten.setMaximumSize(new Dimension(22, 18));
        this.cmdSearchBaulasten.setMinimumSize(new Dimension(22, 18));
        this.cmdSearchBaulasten.setPreferredSize(new Dimension(22, 18));
        this.cmdSearchBaulasten.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/Baulast_selected.png")));
        this.cmdSearchBaulasten.setVerticalTextPosition(3);
        this.cmdSearchBaulasten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdSearchBaulastenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdSearchBaulasten);
        this.cmdSearchBaulasten.setVisible(LagisBroker.getInstance().checkPermissionBaulasten());
        this.cmdSearchVermessungRiss.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/vermessungsriss.png")));
        this.cmdSearchVermessungRiss.setToolTipText("Vermessungsrisse suchen");
        this.cmdSearchVermessungRiss.setBorderPainted(false);
        this.cmdSearchVermessungRiss.setContentAreaFilled(false);
        this.cmdSearchVermessungRiss.setFocusPainted(false);
        this.cmdSearchVermessungRiss.setFocusable(false);
        this.cmdSearchVermessungRiss.setHorizontalTextPosition(0);
        this.cmdSearchVermessungRiss.setMaximumSize(new Dimension(22, 18));
        this.cmdSearchVermessungRiss.setMinimumSize(new Dimension(22, 18));
        this.cmdSearchVermessungRiss.setPreferredSize(new Dimension(22, 18));
        this.cmdSearchVermessungRiss.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/commons/gui/vermessungsriss_selected.png")));
        this.cmdSearchVermessungRiss.setVerticalTextPosition(3);
        this.cmdSearchVermessungRiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdSearchVermessungRissActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdSearchVermessungRiss);
        this.cmdSearchVermessungRiss.setVisible(LagisBroker.getInstance().checkPermissionRisse());
        this.jSeparator9.setOrientation(1);
        this.jSeparator9.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator9.setMinimumSize(new Dimension(2, 10));
        this.jSeparator9.setPreferredSize(new Dimension(2, 10));
        this.jToolBar1.add(this.jSeparator9);
        this.cmdMovePolygon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/movePoly.png")));
        this.cmdMovePolygon.setToolTipText("Polygon verschieben");
        this.cmdMovePolygon.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdMovePolygon.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/movePoly_selected.png")));
        this.cmdMovePolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdMovePolygonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdMovePolygon);
        this.cmdNewPolygon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/newPoly.png")));
        this.cmdNewPolygon.setToolTipText("neues Polygon");
        this.cmdNewPolygon.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdNewPolygon.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/newPoly_selected.png")));
        this.cmdNewPolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdNewPolygonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdNewPolygon);
        this.cmdNewPoint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/newPoint.png")));
        this.cmdNewPoint.setToolTipText("neuer Punkt");
        this.cmdNewPoint.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdNewPoint.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/newPoint_selected.png")));
        this.cmdNewPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdNewPointActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdNewPoint);
        this.cmdRaisePolygon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/raisePoly.png")));
        this.cmdRaisePolygon.setToolTipText("Polygon hochholen");
        this.cmdRaisePolygon.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdRaisePolygon.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/raisePoly_selected.png")));
        this.cmdRaisePolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdRaisePolygonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRaisePolygon);
        this.cmdRemovePolygon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/removePoly.png")));
        this.cmdRemovePolygon.setToolTipText("Polygon entfernen");
        this.cmdRemovePolygon.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdRemovePolygon.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/removePoly_selected.png")));
        this.cmdRemovePolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdRemovePolygonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRemovePolygon);
        this.cmdAttachPolyToAlphadata.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/polygonAttachment.png")));
        this.cmdAttachPolyToAlphadata.setToolTipText("Polygon zuordnen");
        this.cmdAttachPolyToAlphadata.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdAttachPolyToAlphadata.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/polygonAttachment_selected.png")));
        this.cmdAttachPolyToAlphadata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdAttachPolyToAlphadataActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdAttachPolyToAlphadata);
        this.cmdJoinPoly.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/joinPoly.png")));
        this.cmdJoinPoly.setToolTipText("Polygone zusammenfassen");
        this.cmdJoinPoly.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdJoinPoly.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/joinPoly_selected.png")));
        this.cmdJoinPoly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdJoinPolyActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdJoinPoly);
        this.cmdSplitPoly.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/splitPoly.png")));
        this.cmdSplitPoly.setToolTipText("Polygon splitten");
        this.cmdSplitPoly.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdSplitPoly.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/splitPoly_selected.png")));
        this.cmdSplitPoly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdSplitPolyActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdSplitPoly);
        this.jSeparator6.setOrientation(1);
        this.jSeparator6.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator6.setMinimumSize(new Dimension(2, 10));
        this.jSeparator6.setPreferredSize(new Dimension(2, 10));
        this.jToolBar1.add(this.jSeparator6);
        this.cmdMoveHandle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/moveHandle.png")));
        this.cmdMoveHandle.setToolTipText("Handle verschieben");
        this.cmdMoveHandle.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdMoveHandle.setSelected(true);
        this.cmdMoveHandle.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/moveHandle_selected.png")));
        this.cmdMoveHandle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdMoveHandleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdMoveHandle);
        this.cmdAddHandle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/addHandle.png")));
        this.cmdAddHandle.setToolTipText("Handle hinzuf\u00fcgen");
        this.cmdAddHandle.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdAddHandle.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/addHandle_selected.png")));
        this.cmdAddHandle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdAddHandleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdAddHandle);
        this.cmdRemoveHandle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/removeHandle.png")));
        this.cmdRemoveHandle.setToolTipText("Handle entfernen");
        this.cmdRemoveHandle.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdRemoveHandle.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/removeHandle_selected.png")));
        this.cmdRemoveHandle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdRemoveHandleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRemoveHandle);
        this.jSeparator7.setOrientation(1);
        this.jSeparator7.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator7.setMinimumSize(new Dimension(2, 10));
        this.jSeparator7.setPreferredSize(new Dimension(2, 10));
        this.jToolBar1.add(this.jSeparator7);
        this.cmdUndo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/undo.png")));
        this.cmdUndo.setToolTipText("Undo");
        this.cmdUndo.setBorderPainted(false);
        this.cmdUndo.setContentAreaFilled(false);
        this.cmdUndo.setEnabled(false);
        this.cmdUndo.setFocusPainted(false);
        this.cmdUndo.setFocusable(false);
        this.cmdUndo.setHorizontalTextPosition(0);
        this.cmdUndo.setVerticalTextPosition(3);
        this.cmdUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdUndoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdUndo);
        this.cmdRedo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/redo.png")));
        this.cmdRedo.setBorderPainted(false);
        this.cmdRedo.setContentAreaFilled(false);
        this.cmdRedo.setEnabled(false);
        this.cmdRedo.setFocusPainted(false);
        this.cmdRedo.setFocusable(false);
        this.cmdRedo.setHorizontalTextPosition(0);
        this.cmdRedo.setVerticalTextPosition(3);
        this.cmdRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdRedoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRedo);
        this.jSeparator8.setOrientation(1);
        this.jSeparator8.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator8.setMinimumSize(new Dimension(2, 10));
        this.jSeparator8.setPreferredSize(new Dimension(2, 10));
        this.jToolBar1.add(this.jSeparator8);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/flurstueck_transp.png")));
        this.jButton2.setToolTipText("Featurelayer-Transparenz einstellen");
        this.jButton2.setBorderPainted(false);
        this.jButton2.setContentAreaFilled(false);
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setMaximumSize(new Dimension(22, 18));
        this.jButton2.setMinimumSize(new Dimension(22, 18));
        this.jButton2.setPreferredSize(new Dimension(22, 18));
        this.jButton2.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButton2);
        this.add((Component)this.jToolBar1, "North");
        this.jPanel1.setMinimumSize(new Dimension(50, 100));
        this.jPanel1.setPreferredSize(new Dimension(50, 30));
        this.cmdAdd.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/layersman.png")));
        this.cmdAdd.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.cmdAdd.setBorderPainted(false);
        this.cmdAdd.setFocusPainted(false);
        this.cmdAdd.setMinimumSize(new Dimension(25, 25));
        this.cmdAdd.setPreferredSize(new Dimension(25, 25));
        this.cmdAdd.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/layersman.png")));
        this.cmdAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KartenPanel.this.cmdAddActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(872, Short.MAX_VALUE).add((Component)this.cmdAdd, -2, -1, -2)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.cmdAdd, -2, -1, -2).addContainerGap(75, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "South");
    }

    private void cmdMovePolygonActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdMovePolygon.setSelected(true);
        this.mappingComponent.setInteractionMode("MOVE_POLYGON");
    }

    private void cmdAddActionPerformed(ActionEvent evt) {
        this.mappingComponent.showInternalLayerWidget(!this.mappingComponent.isInternalLayerWidgetVisible(), 500);
    }

    private void cmdRemoveHandleActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.cmdRemoveHandle.setSelected(true);
        this.mappingComponent.setHandleInteractionMode("REMOVE_HANDLE");
    }

    private void cmdAddHandleActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.cmdAddHandle.setSelected(true);
        this.mappingComponent.setHandleInteractionMode("ADD_HANDLE");
    }

    private void cmdMoveHandleActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.cmdMoveHandle.setSelected(true);
        this.mappingComponent.setHandleInteractionMode("MOVE_HANDLE");
    }

    private void cmdSplitPolyActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdSplitPoly.setSelected(true);
        this.mappingComponent.setInteractionMode("SPLIT_POLYGON");
    }

    private void cmdJoinPolyActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdJoinPoly.setSelected(true);
        this.mappingComponent.setInteractionMode("JOIN_POLYGONS");
    }

    private void cmdAttachPolyToAlphadataActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdAttachPolyToAlphadata.setSelected(true);
        this.mappingComponent.setInteractionMode("ATTACH_POLYGON_TO_ALPHADATA");
    }

    private void cmdRemovePolygonActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdRemovePolygon.setSelected(true);
        this.mappingComponent.setInteractionMode("REMOVE_POLYGON");
    }

    private void cmdRaisePolygonActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdRaisePolygon.setSelected(true);
        this.mappingComponent.setInteractionMode("RAISE_POLYGON");
    }

    private void cmdNewPointActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        boolean snapEnab = true;
        boolean snapVizEnab = true;
        this.mappingComponent.setSnappingEnabled(true);
        this.cmdSnap.setSelected(true);
        this.mappingComponent.setVisualizeSnappingEnabled(true);
        this.cmdNewPoint.setSelected(true);
        this.mappingComponent.setInteractionMode("NEW_POLYGON");
        ((CreateGeometryListener)this.mappingComponent.getInputListener("NEW_POLYGON")).setMode("POINT");
    }

    private void cmdNewPolygonActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        boolean snapEnab = true;
        boolean snapVizEnab = true;
        this.mappingComponent.setSnappingEnabled(true);
        this.cmdSnap.setSelected(true);
        this.mappingComponent.setVisualizeSnappingEnabled(true);
        this.cmdNewPolygon.setSelected(true);
        this.mappingComponent.setInteractionMode("NEW_POLYGON");
        ((CreateGeometryListener)this.mappingComponent.getInputListener("NEW_POLYGON")).setMode("POLYGON");
    }

    private void cmdSelectActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdSelect.setSelected(true);
        this.mappingComponent.setInteractionMode("SELECT");
        this.cmdMoveHandleActionPerformed(null);
    }

    private void removeHandleGroupSelection() {
        this.cmdRemoveHandle.setSelected(false);
        this.cmdAddHandle.setSelected(false);
        this.cmdMoveHandle.setSelected(false);
    }

    private void cmdPanActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdPan.setSelected(true);
        this.mappingComponent.setInteractionMode("PAN");
    }

    private void removeMainGroupSelection() {
        this.cmdSelect.setSelected(false);
        this.cmdPan.setSelected(false);
        this.cmdZoom.setSelected(false);
        this.cmdMovePolygon.setSelected(false);
        this.cmdNewPolygon.setSelected(false);
        this.cmdNewPoint.setSelected(false);
        this.cmdRemovePolygon.setSelected(false);
        this.cmdAttachPolyToAlphadata.setSelected(false);
        this.cmdSplitPoly.setSelected(false);
        this.cmdJoinPoly.setSelected(false);
        this.cmdRaisePolygon.setSelected(false);
        this.cmdSearchAlkisLandparcel.setSelected(false);
        this.cmdSearchBaulasten.setSelected(false);
        this.cmdSearchVermessungRiss.setSelected(false);
    }

    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        LagisBroker.getInstance().flurstueckChangeFinished(this);
    }

    @Override
    public synchronized void setComponentEditable(final boolean isEditable) {
        if (this.isEditable == isEditable) {
            return;
        }
        this.isEditable = isEditable;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MapPanel --> setComponentEditable");
        }
        if (EventQueue.isDispatchThread()) {
            this.mappingComponent.setReadOnly(!isEditable);
            if (!isEditable) {
                this.removeMainGroupSelection();
                this.cmdSelect.setSelected(true);
                this.mappingComponent.setInteractionMode("SELECT");
                this.cmdMoveHandleActionPerformed(null);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Anzahl Features in FeatureCollection:" + this.mappingComponent.getFeatureCollection().getFeatureCount()));
            }
            LagisBroker.getInstance().getMappingComponent().setReadOnly(!isEditable);
            this.cmdMovePolygon.setVisible(isEditable);
            this.cmdRemovePolygon.setVisible(isEditable);
            this.cmdAttachPolyToAlphadata.setVisible(isEditable);
            this.cmdJoinPoly.setVisible(isEditable);
            this.jSeparator6.setVisible(isEditable);
            this.cmdMoveHandle.setVisible(isEditable);
            this.cmdAddHandle.setVisible(isEditable);
            this.cmdRemoveHandle.setVisible(isEditable);
            this.cmdSplitPoly.setVisible(isEditable);
            this.cmdRaisePolygon.setVisible(isEditable);
            this.jSeparator6.setVisible(isEditable);
            this.cmdCopyFlaeche.setVisible(isEditable);
            this.cmdPasteFlaeche.setVisible(isEditable);
            this.cmdUndo.setVisible(isEditable);
            this.cmdRedo.setVisible(isEditable);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KartenPanel.this.mappingComponent.setReadOnly(!isEditable);
                    if (!isEditable) {
                        KartenPanel.this.removeMainGroupSelection();
                        KartenPanel.this.cmdSelect.setSelected(true);
                        KartenPanel.this.mappingComponent.setInteractionMode("SELECT");
                        KartenPanel.this.cmdMoveHandleActionPerformed(null);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Anzahl Features in FeatureCollection:" + KartenPanel.this.mappingComponent.getFeatureCollection().getFeatureCount()));
                    }
                    LagisBroker.getInstance().getMappingComponent().setReadOnly(!isEditable);
                    KartenPanel.this.cmdMovePolygon.setVisible(isEditable);
                    KartenPanel.this.cmdRemovePolygon.setVisible(isEditable);
                    KartenPanel.this.cmdAttachPolyToAlphadata.setVisible(isEditable);
                    KartenPanel.this.cmdJoinPoly.setVisible(isEditable);
                    KartenPanel.this.jSeparator6.setVisible(isEditable);
                    KartenPanel.this.cmdMoveHandle.setVisible(isEditable);
                    KartenPanel.this.cmdAddHandle.setVisible(isEditable);
                    KartenPanel.this.cmdRemoveHandle.setVisible(isEditable);
                    KartenPanel.this.cmdSplitPoly.setVisible(isEditable);
                    KartenPanel.this.cmdRaisePolygon.setVisible(isEditable);
                    KartenPanel.this.jSeparator6.setVisible(isEditable);
                    KartenPanel.this.cmdCopyFlaeche.setVisible(isEditable);
                    KartenPanel.this.cmdPasteFlaeche.setVisible(isEditable);
                    KartenPanel.this.jSeparator8.setVisible(isEditable);
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MapPanel --> setComponentEditable finished");
        }
        this.mappingComponent.getMemUndo().clear();
        this.mappingComponent.getMemRedo().clear();
    }

    @Override
    public synchronized void clearComponent() {
    }

    private void cmdZoomActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdZoom.setSelected(true);
        this.mappingComponent.setInteractionMode("ZOOM");
    }

    private void cmdSnapActionPerformed(ActionEvent evt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set snapping Enabled: " + this.cmdSnap.isSelected()));
        }
        this.cmdSnap.setSelected(!this.cmdSnap.isSelected());
        this.mappingComponent.setSnappingEnabled(this.cmdSnap.isSelected());
        this.mappingComponent.setVisualizeSnappingEnabled(this.cmdSnap.isSelected());
        this.mappingComponent.setInGlueIdenticalPointsMode(this.cmdSnap.isSelected());
    }

    private void cmdWmsBackgroundActionPerformed(ActionEvent evt) {
        if (this.mappingComponent.isBackgroundEnabled()) {
            this.mappingComponent.setBackgroundEnabled(false);
            this.cmdWmsBackground.setSelected(false);
        } else {
            this.mappingComponent.setBackgroundEnabled(true);
            this.cmdWmsBackground.setSelected(true);
            this.mappingComponent.queryServices();
        }
    }

    private void cmdForwardActionPerformed(ActionEvent evt) {
    }

    private void cmdBackActionPerformed(ActionEvent evt) {
    }

    private void cmdFullPoly1ActionPerformed(ActionEvent evt) {
        this.mappingComponent.zoomToSelectedNode();
    }

    private void cmdFullPolyActionPerformed(ActionEvent evt) {
        this.mappingComponent.zoomToFullFeatureCollectionBounds();
    }

    private void cmdForegroundActionPerformed(ActionEvent evt) {
        if (this.mappingComponent.isFeatureCollectionVisible()) {
            this.mappingComponent.setFeatureCollectionVisibility(false);
            this.cmdForeground.setSelected(false);
        } else {
            this.mappingComponent.setFeatureCollectionVisibility(true);
            this.cmdForeground.setSelected(true);
        }
    }

    private void cmdUndoActionPerformed(ActionEvent evt) {
        LOG.info((Object)"UNDO");
        CustomAction a = this.mappingComponent.getMemUndo().getLastAction();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... Aktion ausf\u00fchren: " + a.info()));
        }
        try {
            a.doAction();
        }
        catch (Exception e) {
            LOG.error((Object)"Error beim Ausf\u00fchren der Aktion", (Throwable)e);
        }
        CustomAction inverse = a.getInverse();
        this.mappingComponent.getMemRedo().addAction(inverse);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... neue Aktion auf REDO-Stack: " + inverse));
            LOG.debug((Object)"... fertig");
        }
    }

    private void cmdRedoActionPerformed(ActionEvent evt) {
        LOG.info((Object)"REDO");
        CustomAction a = this.mappingComponent.getMemRedo().getLastAction();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... Aktion ausf\u00fchren: " + a.info()));
        }
        try {
            a.doAction();
        }
        catch (Exception e) {
            LOG.error((Object)"Error beim Ausf\u00fchren der Aktion", (Throwable)e);
        }
        CustomAction inverse = a.getInverse();
        this.mappingComponent.getMemUndo().addAction(inverse);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... neue Aktion auf UNDO-Stack: " + inverse));
            LOG.debug((Object)"... fertig");
        }
    }

    private void cmdSearchAlkisLandparcelActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdSearchAlkisLandparcel.setSelected(true);
        this.mappingComponent.setInteractionMode("ALKIS_LANDPARCEL_SEARCH_GEOMETRY_LISTENER");
    }

    private void cmdSearchVermessungRissActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdSearchVermessungRiss.setSelected(true);
        this.mappingComponent.setInteractionMode("VERMESSUNG_RISS_SEARCH_GEOMETRY_LISTENER");
    }

    private void cmdSearchBaulastenActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdSearchBaulasten.setSelected(true);
        this.mappingComponent.setInteractionMode("ALB_BAULAST_SEARCH_GEOMETRY_LISTENER");
    }

    public void featureDeleteRequested(PNotification notfication) {
        try {
            Object o = notfication.getObject();
            if (o instanceof DeleteFeatureListener) {
                DeleteFeatureListener dfl = (DeleteFeatureListener)o;
                PFeature pf = dfl.getFeatureRequestedForDeletion();
                pf.getFeature().setGeometry(null);
                if (pf.getFeature() instanceof VerwaltungsbereichCustomBean && LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Verwaltungsbereichsgeometrie wurde gel\u00f6scht setze Fl\u00e4chee = 0");
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim featuredeleteRequest", (Throwable)ex);
        }
    }

    public void joinPolygons(PNotification notification) {
        JoinPolygonsListener listener;
        PFeature joinCandidate;
        Object o;
        PFeature one = this.mappingComponent.getSelectedNode();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"");
        }
        if ((o = notification.getObject()) instanceof JoinPolygonsListener && ((joinCandidate = (listener = (JoinPolygonsListener)o).getFeatureRequestedForJoin()).getFeature() instanceof StyledFeature || joinCandidate.getFeature() instanceof PureNewFeature)) {
            int CTRL_MASK = 2;
            if ((listener.getModifier() & 2) != 0) {
                if (one != null && joinCandidate != one) {
                    PFeature two;
                    if (one.getFeature() instanceof PureNewFeature && joinCandidate.getFeature() instanceof StyledFeature) {
                        two = one;
                        one = joinCandidate;
                        one.setSelected(true);
                        two.setSelected(false);
                        this.mappingComponent.getFeatureCollection().select(one.getFeature());
                    } else {
                        two = joinCandidate;
                    }
                    try {
                        Geometry backup = one.getFeature().getGeometry();
                        Geometry newGeom = one.getFeature().getGeometry().union(two.getFeature().getGeometry());
                        if (newGeom.getGeometryType().equalsIgnoreCase("Multipolygon")) {
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Es k\u00f6nnen nur Polygone zusammengefasst werden, die aneinander angrenzen oder sich \u00fcberlappen.", "Zusammenfassung nicht m\u00f6glich", 2, null);
                            return;
                        }
                        if (newGeom.getGeometryType().equalsIgnoreCase("Polygon") && ((Polygon)newGeom).getNumInteriorRing() > 0) {
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Polygone k\u00f6nnen nur dann zusammengefasst werden, wenn dadurch kein Loch entsteht.", "Zusammenfassung nicht m\u00f6glich", 2, null);
                            return;
                        }
                        if (one.getFeature() instanceof StyledFeature && two.getFeature() instanceof StyledFeature) {
                            StyledFeature fOne = (StyledFeature)one.getFeature();
                            StyledFeature fTwo = (StyledFeature)two.getFeature();
                            if (fOne instanceof VerwaltungsbereichCustomBean && !(fTwo instanceof VerwaltungsbereichCustomBean) || fTwo instanceof VerwaltungsbereichCustomBean && !(fOne instanceof VerwaltungsbereichCustomBean)) {
                                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Fl\u00e4cheen k\u00f6nnen nur zusammengefasst werden, wenn die Fl\u00e4cheenart gleich ist.", "Zusammenfassung nicht m\u00f6glich", 2, null);
                                return;
                            }
                            if (fOne instanceof RebeCustomBean && !(fTwo instanceof RebeCustomBean) || fTwo instanceof RebeCustomBean && !(fOne instanceof RebeCustomBean)) {
                                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Fl\u00e4cheen k\u00f6nnen nur zusammengefasst werden, wenn die Fl\u00e4cheenart gleich ist.", "Zusammenfassung nicht m\u00f6glich", 2, null);
                                return;
                            }
                            two.getFeature().setGeometry(null);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("newGeom ist vom Typ:" + newGeom.getGeometryType()));
                        }
                        one.getFeature().setGeometry(newGeom);
                        if (!one.getFeature().getGeometry().equals(backup)) {
                            two.removeFromParent();
                            two = null;
                        }
                        one.visualize();
                    }
                    catch (Exception e) {
                        LOG.error((Object)("one: " + one + "\n two: " + two), (Throwable)e);
                    }
                    return;
                }
            } else {
                PFeature pf = joinCandidate;
                if (one != null) {
                    one.setSelected(false);
                }
                one = pf;
                this.mappingComponent.selectPFeatureManually(one);
                if (one.getFeature() instanceof StyledFeature) {
                    StyledFeature f = (StyledFeature)one.getFeature();
                    this.mappingComponent.getFeatureCollection().select((Feature)f);
                } else {
                    this.mappingComponent.getFeatureCollection().unselectAll();
                }
            }
        }
    }

    public void attachFeatureRequested(PNotification notification) {
        Object o = notification.getObject();
        LOG.info((Object)"Try to attach Geometry");
        AttachFeatureListener afl = (AttachFeatureListener)o;
        PFeature pf = afl.getFeatureToAttach();
        if (pf.getFeature() instanceof PureNewFeature) {
            Geometry g = pf.getFeature().getGeometry();
            GeometrySlotInformation slotInfo = LagisBroker.getInstance().assignGeometry(g);
            if (slotInfo != null) {
                slotInfo.getRefreshable().refresh(null);
                this.mappingComponent.getFeatureCollection().removeFeature(pf.getFeature());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Geometrie: " + slotInfo.getOpenSlot().getGeometry() + " wird hinzugef\u00fcgt"));
                }
                String providerName = slotInfo.getProviderName();
                GeometrySlot openSlot = slotInfo.getOpenSlot();
                CustomSelectionStyledFeatureGroupWrapper featureWrapper = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)openSlot, providerName, providerName);
                featureWrapper.setEditable(true);
                this.mappingComponent.getFeatureCollection().addFeature((Feature)featureWrapper);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Geometrie wurde an element: " + slotInfo.getSlotIdentifier() + " attached"));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Geometrie wurde nicht attached");
            }
        }
    }

    public void splitPolygon(PNotification notification) {
        SplitPolygonListener l;
        PFeature pf;
        Object o = notification.getObject();
        if (o instanceof SplitPolygonListener && (pf = (l = (SplitPolygonListener)o).getFeatureClickedOn()).isSplittable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Split");
            }
            Feature[] f_arr = pf.split();
            ((StyledFeature)pf.getFeature()).setGeometry(null);
            this.mappingComponent.getFeatureCollection().removeFeature(pf.getFeature());
            f_arr[0].setEditable(true);
            f_arr[1].setEditable(true);
            this.mappingComponent.getFeatureCollection().addFeature(f_arr[0]);
            this.mappingComponent.getFeatureCollection().addFeature(f_arr[1]);
            this.cmdAttachPolyToAlphadataActionPerformed(null);
        }
    }

    public void coordinatesChanged(PNotification notification) {
        Object o = notification.getObject();
        PFeature pf = ((SimpleMoveListener)o).getUnderlyingPFeature();
        if (pf != this.lastOverFeature) {
            this.lastOverFeature = pf;
            if (pf != null && pf.getFeature() instanceof CidsLayerFeature && pf.getVisible() && pf.getParent() != null && pf.getParent().getVisible()) {
                CidsLayerFeature feature = (CidsLayerFeature)pf.getFeature();
                String alkisId = (String)feature.getBean().getProperty("alkis_id");
                String[] parts = alkisId.split("-");
                String[] znParts = parts[2].split("/");
                String gemarkung = parts[0].substring(2);
                String flur = Integer.toString(Integer.parseInt(parts[1]));
                String flurstz = Integer.toString(Integer.parseInt(znParts[0]));
                String flurstn = znParts.length > 1 ? Integer.toString(Integer.parseInt(znParts[1])) : "0";
                GemarkungCustomBean gem = LagisBroker.getInstance().getGemarkungForKey(Integer.parseInt(gemarkung));
                this.lblInfo.setText(gem.getBezeichnung() + ' ' + flur + ' ' + flurstz + '/' + flurstn);
            } else {
                this.lblInfo.setText("");
            }
        }
    }

    public void selectionChanged(PNotification notfication) {
        Object o = notfication.getObject();
        if ((o instanceof SelectionListener || o instanceof FeatureMoveListener || o instanceof SplitPolygonListener) && o instanceof SelectionListener) {
            PFeature pf = ((SelectionListener)o).getAffectedPFeature();
            if (this.cmdSelect.isSelected() && ((SelectionListener)o).getClickCount() > 1 && pf.getFeature() instanceof CidsLayerFeature) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"CidsLayerFeature selected");
                }
                CidsLayerFeature clf = (CidsLayerFeature)pf.getFeature();
                if (LagisBroker.getInstance().isInEditMode()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Flurst\u00fcck kann nicht gewechselt werden --> Editmode");
                    }
                    JOptionPane.showMessageDialog(LagisApp.getInstance(), "Das Flurst\u00fcck kann nur gewechselt werden, wenn alle \u00c4nderungen gespeichert oder verworfen worden sind.", "Wechseln nicht m\u00f6glich", 2);
                    return;
                }
                String alkisId = (String)clf.getBean().getProperty("alkis_id");
                String[] parts = alkisId.split("-");
                String[] znParts = parts[2].split("/");
                try {
                    String flurstn;
                    String gem = parts[0].substring(2);
                    String flur = Integer.toString(Integer.parseInt(parts[1]));
                    String flurstz = Integer.toString(Integer.parseInt(znParts[0]));
                    String string = flurstn = znParts.length > 1 ? Integer.toString(Integer.parseInt(znParts[1])) : "0";
                    if (gem != null && flur != null && flurstz != null) {
                        GemarkungCustomBean resolvedGemarkung = LagisBroker.getInstance().getGemarkungForKey(Integer.parseInt(gem));
                        if (resolvedGemarkung == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Gemarkung konnte nicht entschl\u00fcsselt werden");
                            }
                            resolvedGemarkung = GemarkungCustomBean.createNew();
                            resolvedGemarkung.setSchluessel(Integer.parseInt(gem));
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Gemarkung konnte entschl\u00fcsselt werden");
                        }
                        FlurstueckSchluesselCustomBean key = FlurstueckSchluesselCustomBean.createNew();
                        key.setGemarkung(resolvedGemarkung);
                        key.setFlur(Integer.parseInt(flur));
                        key.setFlurstueckZaehler(Integer.parseInt(flurstz));
                        if (flurstn != null) {
                            key.setFlurstueckNenner(Integer.parseInt(flurstn));
                        } else {
                            key.setFlurstueckNenner(0);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Schl\u00fcssel konnte konstruiert werden");
                        }
                        LagisBroker.getInstance().loadFlurstueck(key);
                    } else {
                        LOG.error((Object)"Properties == null Flurstueck oder Identifier im Konfigfile nicht richtig gesetzt --> kann nicht ausgew\u00e4hlt werden");
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim laden des ausgew\u00e4hlten Flurst\u00fccks", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    public void masterConfigure(Element parent) {
    }

    public Element getConfiguration() {
        Element mapPanelElement = new Element("mapPanel");
        Element featureLlayerTransparencyElement = new Element("featureLayerTransparency");
        featureLlayerTransparencyElement.setText(Float.toString(CismapBroker.getInstance().getMappingComponent().getFeatureLayer().getTransparency()));
        mapPanelElement.addContent((Content)featureLlayerTransparencyElement);
        Element selectedFeatureGroupButtonsElement = new Element("featureGroupButtons");
        for (String featureGroupName : this.featureGroupButtonListenerMap.keySet()) {
            JToggleButton button = this.featureGroupButtonListenerMap.get(featureGroupName).button;
            if (button == null) continue;
            Element selectedFeatureGroupButtonElement = new Element("featureGroupButton");
            selectedFeatureGroupButtonElement.setAttribute("name", featureGroupName);
            selectedFeatureGroupButtonElement.setAttribute("selected", Boolean.toString(button.isSelected()));
            selectedFeatureGroupButtonsElement.addContent((Content)selectedFeatureGroupButtonElement);
        }
        mapPanelElement.addContent((Content)selectedFeatureGroupButtonsElement);
        return mapPanelElement;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o.equals(this.mappingComponent.getMemUndo())) {
            if (arg.equals("ACTIVATE") && !this.cmdUndo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"UNDO-Button aktivieren");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KartenPanel.this.cmdUndo.setEnabled(true);
                    }
                });
            } else if (arg.equals("DEACTIVATE") && this.cmdUndo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"UNDO-Button deaktivieren");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KartenPanel.this.cmdUndo.setEnabled(false);
                    }
                });
            }
        } else if (o.equals(this.mappingComponent.getMemRedo())) {
            if (arg.equals("ACTIVATE") && !this.cmdRedo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"REDO-Button aktivieren");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KartenPanel.this.cmdRedo.setEnabled(true);
                    }
                });
            } else if (arg.equals("DEACTIVATE") && this.cmdRedo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"REDO-Button deaktivieren");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KartenPanel.this.cmdRedo.setEnabled(false);
                    }
                });
            }
        }
    }

    public void configure(Element parent) {
        block8: {
            try {
                Element selectedFeatureGroupButtonsElements;
                Element mapPanelElement;
                if (parent == null || (mapPanelElement = parent.getChild("mapPanel")) == null) break block8;
                Element featureLayerTransparencyElement = mapPanelElement.getChild("featureLayerTransparency");
                if (featureLayerTransparencyElement != null) {
                    try {
                        CismapBroker.getInstance().getMappingComponent().getFeatureLayer().setTransparency(Float.parseFloat(featureLayerTransparencyElement.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((selectedFeatureGroupButtonsElements = mapPanelElement.getChild("featureGroupButtons")) == null) break block8;
                for (Element selectedFeatureGroupButtonElement : selectedFeatureGroupButtonsElements.getChildren("featureGroupButton")) {
                    FeatureGroupActionListener listener;
                    String featureGroupName = selectedFeatureGroupButtonElement.getAttributeValue("name");
                    boolean selected = true;
                    try {
                        selected = Boolean.parseBoolean(selectedFeatureGroupButtonElement.getAttributeValue("selected"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ((listener = this.featureGroupButtonListenerMap.get(featureGroupName)) == null) continue;
                    JToggleButton button = listener.button;
                    button.setSelected(selected);
                    listener.actionPerformed(null);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Fehler beim masterConfigure von: " + this.getClass()), (Throwable)ex);
            }
        }
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Features Added");
        }
        Collection features = fce.getEventFeatures();
        HashSet<String> groups = new HashSet<String>();
        for (Feature f : features) {
            if (!(f instanceof FeatureGroupMember)) continue;
            FeatureGroupMember fgm = (FeatureGroupMember)f;
            groups.add(fgm.getGroupId());
        }
        for (String group : groups) {
            FeatureGroupActionListener listener = this.featureGroupButtonListenerMap.get(group);
            if (listener == null) continue;
            listener.actionPerformed(null);
        }
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"FeatureSelection Changed");
        }
        Collection features = fce.getEventFeatures();
        if (LagisBroker.getInstance().isInEditMode() && features != null && features.size() > 0) {
            Iterator it = features.iterator();
            this.cmdCopyFlaeche.setEnabled(false);
            while (it.hasNext()) {
                Feature curFeature = (Feature)it.next();
                if (!curFeature.canBeSelected() || !LagisBroker.getInstance().getMappingComponent().getFeatureCollection().isSelected(curFeature)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("In edit modus, mindestens ein feature selectiert: " + curFeature));
                }
                this.cmdCopyFlaeche.setEnabled(true);
                break;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"disable copy nicht alle vorraussetzungen erf\u00fcllt");
            }
            this.cmdCopyFlaeche.setEnabled(false);
        }
        LagisBroker.getInstance().fireChangeEvent(features);
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }

    public void featureCollectionChanged() {
    }

    private final class FeatureGroupActionListener
    implements ActionListener {
        private final JToggleButton button;
        private final MappingComponent mapComp;
        private final String featureGroup;
        private final String visibleText;
        private final String invisibText;

        public FeatureGroupActionListener(JToggleButton button, MappingComponent mapComp, String featureGroup, String tooltipText) {
            this.button = button;
            this.mapComp = mapComp;
            this.featureGroup = featureGroup;
            this.visibleText = tooltipText + " ausblenden";
            this.invisibText = tooltipText + " einblenden";
            this.button.setToolTipText(this.visibleText);
        }

        private void setVisible(boolean isVisible) {
            this.button.setToolTipText(isVisible ? this.visibleText : this.invisibText);
            this.mapComp.setGroupLayerVisibility(this.featureGroup, isVisible);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.setVisible(this.button.isSelected());
        }
    }
}

