/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.gui.panels.KassenzeichenAddDialogListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KassenzeichenAddDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(KassenzeichenAddDialog.class);
    private final KassenzeichenAddDialogListener listener;
    private JButton jButton6;
    private JButton jButton7;
    private JFormattedTextField jFormattedTextField1;
    private JLabel jLabel3;
    private JPanel jPanel8;
    private JProgressBar jProgressBar3;

    public KassenzeichenAddDialog(KassenzeichenAddDialogListener listener) {
        this.initComponents();
        this.getRootPane().setDefaultButton(this.jButton6);
        this.jFormattedTextField1.requestFocus();
        this.listener = listener;
    }

    private void initComponents() {
        this.jPanel8 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jFormattedTextField1 = new JFormattedTextField();
        this.jProgressBar3 = new JProgressBar();
        this.jButton7 = new JButton();
        this.jButton6 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Kassenzeichen hinzuf\u00fcgen");
        this.setMinimumSize(new Dimension(260, 130));
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel8.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(KassenzeichenAddDialog.class, (String)"KassenzeichenAddDialog.jLabel3.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel8.add((Component)this.jLabel3, gridBagConstraints);
        try {
            this.jFormattedTextField1.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter("########")));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.jFormattedTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KassenzeichenAddDialog.this.jFormattedTextField1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel8.add((Component)this.jFormattedTextField1, gridBagConstraints);
        this.jProgressBar3.setString(NbBundle.getMessage(KassenzeichenAddDialog.class, (String)"KassenzeichenAddDialog.jProgressBar3.string"));
        this.jProgressBar3.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel8.add((Component)this.jProgressBar3, gridBagConstraints);
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton7, (String)NbBundle.getMessage(KassenzeichenAddDialog.class, (String)"KassenzeichenAddDialog.jButton7.text"));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KassenzeichenAddDialog.this.jButton7ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel8.add((Component)this.jButton7, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(KassenzeichenAddDialog.class, (String)"KassenzeichenAddDialog.jButton6.text"));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KassenzeichenAddDialog.this.jButton6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel8.add((Component)this.jButton6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel8, gridBagConstraints);
        this.pack();
    }

    private void jFormattedTextField1ActionPerformed(ActionEvent evt) {
        this.jButton7ActionPerformed(evt);
    }

    public CidsBean loadKassenzeichenByNummer(int kassenzeichen) throws Exception {
        MetaClass mcKassenzeichen = CidsBroker.getInstance().getMetaClass("kassenzeichen", "VERDIS_GRUNDIS");
        String query = "SELECT " + mcKassenzeichen.getId() + ", id, kassenzeichennummer8 FROM kassenzeichen WHERE kassenzeichennummer8 = " + kassenzeichen + ";";
        MetaObject[] mos = CidsBroker.getInstance().getMetaObject(query, "VERDIS_GRUNDIS");
        if (mos == null || mos.length < 1) {
            return null;
        }
        MetaObject mo = mos[0];
        return mo.getBean();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.jProgressBar3.setIndeterminate(true);
        new SwingWorker<CidsBean, Void>(){

            @Override
            protected CidsBean doInBackground() throws Exception {
                int kznr = Integer.parseInt((String)KassenzeichenAddDialog.this.jFormattedTextField1.getValue());
                CidsBean cidsBean = KassenzeichenAddDialog.this.loadKassenzeichenByNummer(kznr);
                return cidsBean;
            }

            @Override
            protected void done() {
                try {
                    CidsBean kassenzeichenBean = (CidsBean)this.get();
                    if (kassenzeichenBean != null) {
                        KassenzeichenAddDialog.this.listener.kassenzeichennummerAdded((Integer)kassenzeichenBean.getProperty("kassenzeichennummer8"));
                        KassenzeichenAddDialog.this.jFormattedTextField1.setValue(null);
                    } else {
                        KassenzeichenAddDialog.this.flashSearchField(Color.red);
                    }
                }
                catch (Exception ex) {
                    LOG.info((Object)ex, (Throwable)ex);
                    KassenzeichenAddDialog.this.flashSearchField(Color.red);
                }
                KassenzeichenAddDialog.this.jProgressBar3.setIndeterminate(false);
            }
        }.execute();
    }

    public void flashSearchField(Color c) {
        this.jFormattedTextField1.setBackground(c);
        ActionListener timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                KassenzeichenAddDialog.this.jFormattedTextField1.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            }
        };
        Timer timer = new Timer(250, timerAction);
        timer.setRepeats(false);
        timer.start();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

