/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.lagis.action.CreateMeldungServerAction;
import de.cismet.lagis.action.FinishMeldungServerAction;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.BoldHighlighter;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.models.MeldungenTableModel;
import de.cismet.lagis.server.search.MeldungenSearch;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class MeldungenPanel
extends AbstractWidget
implements FlurstueckChangeListener {
    private static final String WIDGET_NAME = "Meldungen";
    private static final MeldungenPanel INSTANCE = new MeldungenPanel();
    private static final Logger LOG = Logger.getLogger(MeldungenPanel.class);
    private static final DateFormat DF = new SimpleDateFormat("dd.MM.YYYY");
    private final MeldungenTableModel tableModel = new MeldungenTableModel();
    private CidsBean shownMeldung;
    private JButton btnCloseMeldungDialog;
    private JToggleButton btnFinishMeldung;
    private JDialog dlgCreateMeldung;
    private JDialog dlgShowMeldung;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private Box.Filler filler5;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextField jTextField1;
    private JToggleButton jToggleButton2;
    private JToggleButton jToggleButton3;
    private JXHyperlink jXHyperlink1;
    private JLabel lblCreator;
    private JLabel lblErledigtAm;
    private JLabel lblErledigtVon;
    private JLabel lblName;
    private JLabel lblTimestamp;
    private JPanel panErledigt;
    private JXTable tMeldungen;

    private MeldungenPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        this.dlgCreateMeldung.pack();
        this.dlgShowMeldung.pack();
        this.tMeldungen.setModel((TableModel)this.tableModel);
        this.tMeldungen.setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER});
        this.tMeldungen.setSortOrder(0, SortOrder.DESCENDING);
        this.tMeldungen.packAll();
        this.tMeldungen.setHighlighters(new Highlighter[]{new BoldHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
                FlurstueckCustomBean flurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
                if (flurstueck == null || MeldungenPanel.this.jToggleButton2.isSelected()) {
                    return false;
                }
                return flurstueck.equals(MeldungenPanel.this.tableModel.getCidsBeanAtRow(MeldungenPanel.this.tMeldungen.convertRowIndexToModel(componentAdapter.row)).getProperty("fk_flurstueck"));
            }
        })});
        this.tMeldungen.setRowFilter((RowFilter)new MeldungenRowFilter());
    }

    public JTable getMeldungenTable() {
        return this.tMeldungen;
    }

    public static MeldungenPanel getInstance() {
        return INSTANCE;
    }

    private void reloadMeldungen() {
        this.jButton4.setEnabled(false);
        this.jPanel4.setVisible(true);
        new SwingWorker<CidsBean[], Object>(){

            @Override
            protected CidsBean[] doInBackground() throws Exception {
                Collection mons = CidsBroker.getInstance().executeSearch((CidsServerSearch)new MeldungenSearch());
                ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                for (MetaObjectNode mon : mons) {
                    MetaObject mo = CidsBroker.getInstance().getMetaObject(mon.getObjectId(), mon.getClassId(), mon.getDomain());
                    beans.add(mo.getBean());
                }
                return beans.toArray(new CidsBean[0]);
            }

            @Override
            protected void done() {
                try {
                    CidsBean[] beans = (CidsBean[])this.get();
                    MeldungenPanel.this.tableModel.setCidsBeans(new ArrayList<CidsBean>(Arrays.asList(beans)));
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    MeldungenPanel.this.tableModel.setCidsBeans(new ArrayList<CidsBean>());
                }
                finally {
                    MeldungenPanel.this.jButton4.setEnabled(true);
                    MeldungenPanel.this.jPanel4.setVisible(false);
                }
            }
        }.execute();
    }

    @Override
    public synchronized void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            this.reloadMeldungen();
        }
        catch (Exception e) {
            LOG.error((Object)"Error during flurstueckChanged in MeldungenPanel", (Throwable)e);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public synchronized void clearComponent() {
    }

    private void initComponents() {
        this.dlgCreateMeldung = new JDialog();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.dlgShowMeldung = new JDialog();
        this.jPanel8 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jPanel11 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jXHyperlink1 = new JXHyperlink();
        this.jSeparator1 = new JSeparator();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.jLabel10 = new JLabel();
        this.lblCreator = new JLabel();
        this.jLabel7 = new JLabel();
        this.lblTimestamp = new JLabel();
        this.jLabel5 = new JLabel();
        this.lblName = new JLabel();
        this.jLabel6 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jPanel12 = new JPanel();
        this.btnFinishMeldung = new JToggleButton();
        this.filler5 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.panErledigt = new JPanel();
        this.lblErledigtAm = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.lblErledigtVon = new JLabel();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.jPanel10 = new JPanel();
        this.btnCloseMeldungDialog = new JButton();
        this.jPanel3 = new JPanel();
        this.jButton4 = new JButton();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tMeldungen = new MeldungTable();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.dlgCreateMeldung.setTitle("neue Meldung");
        this.dlgCreateMeldung.setModal(true);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel7.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel7.add((Component)this.jTextField1, gridBagConstraints);
        this.jTextArea1.setColumns(40);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(8);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel2.setText("Betreff:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel7.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Nachricht:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel7.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Meldung wird abgesetzt...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel7.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.dlgCreateMeldung.getContentPane().add((Component)this.jPanel6, "Center");
        this.jPanel5.setLayout(new FlowLayout(2, 10, 10));
        this.jButton1.setText("Abbrechen");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeldungenPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton1);
        this.jButton3.setText("Meldung absetzen");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeldungenPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton3);
        this.dlgCreateMeldung.getContentPane().add((Component)this.jPanel5, "Last");
        this.dlgShowMeldung.setTitle("Meldung");
        this.dlgShowMeldung.setModal(true);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel9.setLayout(new GridBagLayout());
        this.jPanel11.setLayout(new GridBagLayout());
        this.jLabel11.setText("Flurst\u00fcck:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel11.add((Component)this.jLabel11, gridBagConstraints);
        this.jXHyperlink1.setText("...");
        this.jXHyperlink1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeldungenPanel.this.jXHyperlink1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel11.add((Component)this.jXHyperlink1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.jPanel11.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel11.add((Component)this.filler1, gridBagConstraints);
        this.jLabel10.setText("Von:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel11.add((Component)this.jLabel10, gridBagConstraints);
        this.lblCreator.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel11.add((Component)this.lblCreator, gridBagConstraints);
        this.jLabel7.setText("Am:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel11.add((Component)this.jLabel7, gridBagConstraints);
        this.lblTimestamp.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel11.add((Component)this.lblTimestamp, gridBagConstraints);
        this.jLabel5.setText("Betreff:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel11.add((Component)this.jLabel5, gridBagConstraints);
        this.lblName.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel11.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel9.add((Component)this.jPanel11, gridBagConstraints);
        this.jLabel6.setText("Nachricht:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel9.add((Component)this.jLabel6, gridBagConstraints);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setColumns(40);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setRows(8);
        this.jScrollPane3.setViewportView(this.jTextArea2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel9.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanel12.setLayout(new GridBagLayout());
        this.btnFinishMeldung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/res/ok.png")));
        this.btnFinishMeldung.setText("erledigt");
        this.btnFinishMeldung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeldungenPanel.this.btnFinishMeldungActionPerformed(evt);
            }
        });
        this.jPanel12.add((Component)this.btnFinishMeldung, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel12.add((Component)this.filler5, gridBagConstraints);
        this.panErledigt.setLayout(new GridBagLayout());
        this.lblErledigtAm.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panErledigt.add((Component)this.lblErledigtAm, gridBagConstraints);
        this.jLabel15.setText("Am:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panErledigt.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setText("Von:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panErledigt.add((Component)this.jLabel16, gridBagConstraints);
        this.lblErledigtVon.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panErledigt.add((Component)this.lblErledigtVon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panErledigt.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel12.add((Component)this.panErledigt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.jPanel9.add((Component)this.jPanel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.jPanel8.add((Component)this.jPanel9, gridBagConstraints);
        this.dlgShowMeldung.getContentPane().add((Component)this.jPanel8, "Center");
        this.jPanel10.setLayout(new FlowLayout(2, 10, 10));
        this.btnCloseMeldungDialog.setText("Dialog schlie\u00dfen");
        this.btnCloseMeldungDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeldungenPanel.this.btnCloseMeldungDialogActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.btnCloseMeldungDialog);
        this.dlgShowMeldung.getContentPane().add((Component)this.jPanel10, "Last");
        this.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/res/reload.png")));
        this.jButton4.setBorderPainted(false);
        this.jButton4.setContentAreaFilled(false);
        this.jButton4.setEnabled(false);
        this.jButton4.setFocusPainted(false);
        this.jButton4.setMaximumSize(new Dimension(24, 24));
        this.jButton4.setMinimumSize(new Dimension(24, 24));
        this.jButton4.setPreferredSize(new Dimension(24, 24));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeldungenPanel.this.jButton4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel3.add((Component)this.jButton4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.filler3, gridBagConstraints);
        this.jToggleButton2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/res/filter_flurstueck_disabled.png")));
        this.jToggleButton2.setToolTipText("nur Meldungen f\u00fcr angezeigtes Flurst\u00fcck");
        this.jToggleButton2.setBorderPainted(false);
        this.jToggleButton2.setContentAreaFilled(false);
        this.jToggleButton2.setFocusPainted(false);
        this.jToggleButton2.setMaximumSize(new Dimension(24, 24));
        this.jToggleButton2.setMinimumSize(new Dimension(24, 24));
        this.jToggleButton2.setPreferredSize(new Dimension(24, 24));
        this.jToggleButton2.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/res/filter_flurstueck_enabled.png")));
        this.jToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeldungenPanel.this.jToggleButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.jToggleButton2, gridBagConstraints);
        this.jToggleButton3.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/res/filter_erledigt_disabled.png")));
        this.jToggleButton3.setToolTipText("erledigte Meldungen anzeigen");
        this.jToggleButton3.setBorderPainted(false);
        this.jToggleButton3.setContentAreaFilled(false);
        this.jToggleButton3.setFocusPainted(false);
        this.jToggleButton3.setMaximumSize(new Dimension(24, 24));
        this.jToggleButton3.setMinimumSize(new Dimension(24, 24));
        this.jToggleButton3.setPreferredSize(new Dimension(24, 24));
        this.jToggleButton3.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/res/filter_erledigt_enabled.png")));
        this.jToggleButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeldungenPanel.this.jToggleButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.jToggleButton3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.filler4, gridBagConstraints);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/res/add.png")));
        this.jButton2.setBorderPainted(false);
        this.jButton2.setFocusPainted(false);
        this.jButton2.setMaximumSize(new Dimension(24, 24));
        this.jButton2.setMinimumSize(new Dimension(24, 24));
        this.jButton2.setPreferredSize(new Dimension(24, 24));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeldungenPanel.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.tMeldungen.setModel((TableModel)new MeldungenTableModel());
        this.tMeldungen.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MeldungenPanel.this.tMeldungenMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)this.tMeldungen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel1.setText("Meldungen werden geladen ...");
        this.jPanel4.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel4.setVisible(false);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.reloadMeldungen();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        StaticSwingTools.showDialog((Component)this, (JDialog)this.dlgCreateMeldung, (boolean)true);
    }

    private void jToggleButton2ActionPerformed(ActionEvent evt) {
        this.tableModel.fireTableDataChanged();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dlgCreateMeldung.setVisible(false);
        this.clearNewMeldungDialog();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        final ActionEvent evtFinal = evt;
        this.jLabel4.setVisible(true);
        this.jButton1.setEnabled(false);
        this.jButton3.setEnabled(false);
        final String name = this.jTextField1.getText();
        final String text = this.jTextArea1.getText();
        new SwingWorker<CidsBean, Void>(){

            @Override
            protected CidsBean doInBackground() throws Exception {
                MetaObjectNode meldungMon = (MetaObjectNode)CidsBroker.getInstance().executeTask("createMeldung", new MetaObjectNode((CidsBean)LagisBroker.getInstance().getCurrentFlurstueck()), new ServerActionParameter(CreateMeldungServerAction.Parameter.NAME.toString(), (Object)name), new ServerActionParameter(CreateMeldungServerAction.Parameter.TEXT.toString(), (Object)text));
                MetaObject meldungMo = CidsBroker.getInstance().getMetaObject(meldungMon.getObjectId(), meldungMon.getClassId(), meldungMon.getDomain());
                return meldungMo.getBean();
            }

            @Override
            protected void done() {
                try {
                    MeldungenPanel.this.tableModel.addCidsBean((CidsBean)this.get());
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                finally {
                    MeldungenPanel.this.jButton1ActionPerformed(evtFinal);
                    MeldungenPanel.this.jLabel4.setVisible(false);
                    MeldungenPanel.this.jButton1.setEnabled(true);
                    MeldungenPanel.this.jButton3.setEnabled(true);
                }
            }
        }.execute();
    }

    private void jToggleButton3ActionPerformed(ActionEvent evt) {
        this.tableModel.fireTableDataChanged();
    }

    private void btnCloseMeldungDialogActionPerformed(ActionEvent evt) {
        this.showMeldung(null);
    }

    private void btnFinishMeldungActionPerformed(ActionEvent evt) {
        this.btnFinishMeldung.setEnabled(false);
        final boolean remove = !this.btnFinishMeldung.isSelected();
        new SwingWorker<CidsBean, Object>(){

            @Override
            protected CidsBean doInBackground() throws Exception {
                MetaObjectNode meldungMon = (MetaObjectNode)CidsBroker.getInstance().executeTask("finishMeldung", new MetaObjectNode(MeldungenPanel.this.shownMeldung), new ServerActionParameter(FinishMeldungServerAction.Parameter.REMOVE.toString(), (Object)remove));
                MetaObject meldungMo = CidsBroker.getInstance().getMetaObject(meldungMon.getObjectId(), meldungMon.getClassId(), meldungMon.getDomain());
                return meldungMo.getBean();
            }

            @Override
            protected void done() {
                try {
                    CidsBean meldungBean = (CidsBean)this.get();
                    MeldungenPanel.this.tableModel.removeCidsBean(MeldungenPanel.this.shownMeldung);
                    MeldungenPanel.this.tableModel.addCidsBean(meldungBean);
                    MeldungenPanel.this.showMeldung(meldungBean);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                finally {
                    MeldungenPanel.this.btnFinishMeldung.setEnabled(true);
                }
            }
        }.execute();
    }

    private void tMeldungenMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int row = this.tMeldungen.rowAtPoint(evt.getPoint());
            CidsBean meldungBean = this.tableModel.getCidsBeanAtRow(this.tMeldungen.convertRowIndexToModel(row));
            this.showMeldung(meldungBean);
        }
    }

    private void jXHyperlink1ActionPerformed(ActionEvent evt) {
        CidsBean flurstueckSchluesselBean = (CidsBean)this.shownMeldung.getProperty("fk_flurstueck.fk_flurstueck_schluessel");
        LagisBroker.getInstance().loadFlurstueck((FlurstueckSchluesselCustomBean)flurstueckSchluesselBean.getMetaObject().getBean());
    }

    public JDialog getDlgCreateMeldung() {
        return this.dlgCreateMeldung;
    }

    public void showMeldung(CidsBean meldungBean) {
        this.shownMeldung = meldungBean;
        String flurstueck = meldungBean != null ? ((CidsBean)meldungBean.getProperty("fk_flurstueck")).toString() : null;
        String creator = meldungBean != null ? (String)meldungBean.getProperty("creator") : null;
        String timestamp = meldungBean != null && meldungBean.getProperty("timestamp") != null ? DF.format((Timestamp)meldungBean.getProperty("timestamp")) : null;
        String name = meldungBean != null ? (String)meldungBean.getProperty("name") : null;
        String text = meldungBean != null ? (String)meldungBean.getProperty("text") : null;
        String erledigtVon = meldungBean != null ? (String)meldungBean.getProperty("erledigt_von") : null;
        String erledigtAm = meldungBean != null && meldungBean.getProperty("erledigt_am") != null ? DF.format((Timestamp)meldungBean.getProperty("erledigt_am")) : null;
        this.jXHyperlink1.setText(flurstueck);
        this.jXHyperlink1.setEnabled(flurstueck != null);
        this.lblCreator.setText(creator);
        this.lblTimestamp.setText(timestamp);
        this.lblName.setText(name);
        this.jTextArea2.setText(text);
        this.lblErledigtVon.setText(erledigtVon);
        this.lblErledigtAm.setText(erledigtAm);
        this.btnFinishMeldung.setEnabled(meldungBean != null);
        this.btnFinishMeldung.setSelected(erledigtVon != null);
        this.panErledigt.setVisible(erledigtVon != null);
        if (meldungBean != null) {
            StaticSwingTools.showDialog((Component)this, (JDialog)this.dlgShowMeldung, (boolean)true);
        } else {
            this.dlgShowMeldung.setVisible(false);
        }
    }

    private void clearNewMeldungDialog() {
        this.jTextField1.setText("");
        this.jTextArea1.setText("");
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
    }

    class MeldungTable
    extends JXTable {
        MeldungTable() {
        }

        public String getToolTipText(MouseEvent event) {
            int row = this.rowAtPoint(event.getPoint());
            if (row > -1) {
                CidsBean meldungBean = MeldungenPanel.this.tableModel.getCidsBeanAtRow(MeldungenPanel.this.tMeldungen.convertRowIndexToModel(row));
                if (meldungBean == null) {
                    return null;
                }
                String name = (String)meldungBean.getProperty("name");
                String text = (String)meldungBean.getProperty("text");
                String creator = (String)meldungBean.getProperty("creator");
                Timestamp timestamp = (Timestamp)meldungBean.getProperty("timestamp");
                String tooltip = String.format("<html><body><u><b>von:</b></u> %s<br/><u><b>am:</b></u> %s<br/><u><b>Betreff:</b></u> %s<br/><u><b>Nachricht:</b></u><div>%s</div></body></html>", creator != null ? creator : "unbekannt", timestamp != null ? DF.format(timestamp) : "unbekannt", name != null ? name : "", text != null ? text.replaceAll("\n", "<br/>\n") : "");
                return tooltip;
            }
            return "";
        }
    }

    private class MeldungenRowFilter
    extends RowFilter<TableModel, Integer> {
        private MeldungenRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            boolean show;
            CidsBean meldungBean = MeldungenPanel.this.tableModel.getCidsBeanByIndex(entry.getIdentifier());
            if (meldungBean == null) {
                return false;
            }
            boolean bl = show = MeldungenPanel.this.jToggleButton3.isSelected() || meldungBean.getProperty("erledigt_am") == null;
            if (MeldungenPanel.this.jToggleButton2.isSelected()) {
                FlurstueckCustomBean flurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
                show &= flurstueck.equals(meldungBean.getProperty("fk_flurstueck"));
            }
            return show;
        }
    }
}

