/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.gui.tables.NKFOverviewTable;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.models.NKFOverviewTableModel;
import de.cismet.lagis.util.NutzungsContainer;
import de.cismet.lagis.widget.AbstractWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;

public class NKFOverviewPanel
extends AbstractWidget
implements FlurstueckChangeListener {
    private static final String WIDGET_NAME = "NKF \u00dcbersicht";
    private static final NKFOverviewPanel instance = new NKFOverviewPanel();
    private static final Logger LOG = Logger.getLogger(NKFOverviewPanel.class);
    private FlurstueckCustomBean currentFlurstueck;
    private NKFOverviewTableModel tableModel = new NKFOverviewTableModel();
    private final Icon icoHistoricIcon = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/history.png"));
    private final Icon icoHistoricIconDummy = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/emptyDummy22.png"));
    private JButton btnBuchen;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lblHistoricIcon;
    private JLabel lblStilleReserven;
    private JLabel lblStilleReservenBetrag;
    private JTable tSummeNutzungen;
    private JToggleButton tbtnSort;

    private NKFOverviewPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        this.tSummeNutzungen.setModel(this.tableModel);
        ((JXTable)this.tSummeNutzungen).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER});
        ((JXTable)this.tSummeNutzungen).setSortOrder(0, SortOrder.ASCENDING);
        ((JXTable)this.tSummeNutzungen).packAll();
        ((NKFOverviewTable)((Object)this.tSummeNutzungen)).setSortButton(this.tbtnSort);
        this.btnBuchen.setEnabled(false);
    }

    public JTable getSummeNutzungenTable() {
        return this.tSummeNutzungen;
    }

    public static NKFOverviewPanel getInstance() {
        return instance;
    }

    @Override
    public synchronized void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            LOG.info((Object)"FlurstueckChanged");
            this.currentFlurstueck = newFlurstueck;
            try {
                this.clearComponent();
                this.tableModel.setCurrentDate(null);
                this.tableModel.refreshModel(this.currentFlurstueck.getNutzungen());
                this.updateStilleReservenBetrag();
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler im refresh thread: ", (Throwable)ex);
            }
            finally {
                LagisBroker.getInstance().flurstueckChangeFinished(this);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Flurst\u00fcckswechsel: ", (Throwable)ex);
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        if (isEditable) {
            String stilleReserven = this.lblStilleReservenBetrag.getText();
            if (stilleReserven != null) {
                try {
                    Number number = LagisBroker.getCurrencyFormatter().parse(stilleReserven);
                }
                catch (Exception exception) {}
            } else {
                this.btnBuchen.setEnabled(isEditable);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"NKFOverview --> setComponentEditable finished");
        }
    }

    @Override
    public synchronized void clearComponent() {
        this.tableModel.setCurrentDate(null);
        this.tableModel.refreshModel(new ArrayList<NutzungCustomBean>());
        this.updateStilleReservenBetrag();
        this.btnBuchen.setEnabled(false);
    }

    @Override
    public synchronized void refresh(Object refreshObject) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Refresh NKFPanel");
        }
        if (refreshObject != null && refreshObject instanceof NutzungsContainer) {
            NutzungsContainer container = (NutzungsContainer)refreshObject;
            this.tableModel.setCurrentDate(container.getCurrentDate());
            this.tableModel.refreshModel(container.getNutzungen());
            this.updateStilleReservenBetrag();
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tSummeNutzungen = new NKFOverviewTable();
        this.jPanel1 = new JPanel();
        this.lblStilleReserven = new JLabel();
        this.lblStilleReservenBetrag = new JLabel();
        this.btnBuchen = new JButton();
        this.lblHistoricIcon = new JLabel();
        this.tbtnSort = new JToggleButton();
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tSummeNutzungen.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tSummeNutzungen.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}));
        this.jScrollPane1.setViewportView(this.tSummeNutzungen);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 50;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblStilleReserven.setText("Stille Reserven:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.lblStilleReserven, gridBagConstraints);
        this.lblStilleReservenBetrag.setText("0,0 \u20ac");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel1.add((Component)this.lblStilleReservenBetrag, gridBagConstraints);
        this.btnBuchen.setText("Buchen");
        this.btnBuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NKFOverviewPanel.this.btnBuchenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.btnBuchen, gridBagConstraints);
        this.lblHistoricIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/emptyDummy22.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.jPanel1.add((Component)this.lblHistoricIcon, gridBagConstraints);
        this.tbtnSort.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.tbtnSort.setToolTipText("Sortierung An / Aus");
        this.tbtnSort.setBorderPainted(false);
        this.tbtnSort.setContentAreaFilled(false);
        this.tbtnSort.setMaximumSize(new Dimension(25, 25));
        this.tbtnSort.setMinimumSize(new Dimension(25, 25));
        this.tbtnSort.setPreferredSize(new Dimension(25, 25));
        this.tbtnSort.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel1.add((Component)this.tbtnSort, gridBagConstraints);
        this.tbtnSort.addItemListener(((NKFOverviewTable)((Object)this.tSummeNutzungen)).getSortItemListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void btnBuchenActionPerformed(ActionEvent evt) {
        int answer = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "Wollen Sie alle Stillen Reserven des Flurst\u00fccks buchen?", "Stille Reserven buchen", 0);
        if (answer == 0) {
            try {
                LagisApp.getInstance().acceptChanges();
                if (LagisBroker.getInstance().isInEditMode()) {
                    LOG.warn((Object)"Stille Reserven konnten nicht gebucht werden, immernoch im Editmodus");
                    JOptionPane.showMessageDialog(LagisApp.getInstance(), "Es war nicht m\u00f6glich aus dem Editiermodus herauszuwechseln.", "Stille Reserven", 0);
                } else {
                    LagisBroker.getInstance().bookNutzungenForFlurstueck(this.currentFlurstueck.getFlurstueckSchluessel(), LagisBroker.getInstance().getAccountName());
                }
            }
            catch (Exception ex) {
                StringBuffer resultString = new StringBuffer("Es war nicht m\u00f6glich die Stillen Reserven des Flurst\u00fccks zu buchen. Fehler: \n");
                if (ex instanceof ActionNotSuccessfulException) {
                    ActionNotSuccessfulException reason = (ActionNotSuccessfulException)ex;
                    if (reason.hasNestedExceptions()) {
                        LOG.error((Object)"Nested Rename Exceptions: ", (Throwable)reason.getNestedExceptions());
                    }
                    resultString.append(reason.getMessage());
                } else {
                    LOG.error((Object)"Unbekannter Fehler: ", (Throwable)ex);
                    resultString.append("Unbekannter Fehler bitte wenden Sie sich an Ihren Systemadministrator");
                }
                JOptionPane.showMessageDialog(LagisApp.getInstance(), resultString.toString(), "Stille Reserven", 0);
            }
        }
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }

    private void updateStilleReservenBetrag() {
        double stilleReserve = this.tableModel.getStilleReserve();
        this.lblStilleReservenBetrag.setText(LagisBroker.getCurrencyFormatter().format(stilleReserve));
        if (!(stilleReserve > 0.0) || LagisBroker.getInstance().isInEditMode()) {
            // empty if block
        }
        if (this.tableModel.getCurrentDate() != null) {
            this.lblHistoricIcon.setIcon(this.icoHistoricIcon);
        } else {
            this.lblHistoricIcon.setIcon(this.icoHistoricIconDummy);
        }
    }
}

