/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.cids.custom.beans.lagis.AnlageklasseCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungBuchungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungsartCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.Exception.BuchungNotInNutzungException;
import de.cismet.lagis.Exception.IllegalNutzungStateException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.editor.EuroEditor;
import de.cismet.lagis.editor.FlaecheEditor;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.gui.panels.NKFBandMember;
import de.cismet.lagis.gui.panels.NKFOverviewPanel;
import de.cismet.lagis.gui.tables.NKFTable;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.interfaces.Refreshable;
import de.cismet.lagis.models.NKFTableModel;
import de.cismet.lagis.renderer.EuroRenderer;
import de.cismet.lagis.renderer.FlaecheRenderer;
import de.cismet.lagis.util.LagISUtils;
import de.cismet.lagis.util.NutzungsContainer;
import de.cismet.lagis.util.TableSelectionUtils;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.gui.jbands.JBand;
import de.cismet.tools.gui.jbands.PlainBand;
import de.cismet.tools.gui.jbands.SimpleBandModel;
import de.cismet.tools.gui.jbands.SimpleTextSection;
import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import de.cismet.tools.gui.jbands.interfaces.BandModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdom.Element;

public class NKFPanel
extends AbstractWidget
implements MouseListener,
FlurstueckChangeListener,
FlurstueckSaver,
TableModelListener,
ListSelectionListener,
Configurable {
    private static final String WIDGET_NAME = "NKF Datenpanel";
    private static final String FIND_PREDECESSOR_MENU_NAME = "Vorg\u00e4nger finden";
    private static final NKFPanel INSTANCE = new NKFPanel();
    private static final Logger LOG = Logger.getLogger(NKFPanel.class);
    boolean isOnlyHistoric = false;
    private boolean isInEditMode = false;
    private boolean isFlurstueckEditable = true;
    private final Icon icoHistoricIcon = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/history64.png"));
    private final Icon icoHistoricIconDummy = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/emptyDummy64.png"));
    private final Icon icoBooked = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/booked.png"));
    private final Icon icoNotBooked = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/notBooked.png"));
    private final ArrayList<NutzungCustomBean> copyPasteList = new ArrayList();
    private JPopupMenu predecessorPopup;
    private NutzungBuchungCustomBean currentPopupNutzung = null;
    private final PlainBand bandNutzungen;
    private final PlainBand bandMonth;
    private JButton btnAddNutzung;
    private JButton btnCopyNutzung;
    private JButton btnFlipBuchung;
    private JButton btnPasteNutzung;
    private JButton btnRemoveNutzung;
    private JBand jBand1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lblCurrentHistoryPostion;
    private JLabel lblHistoricIcon;
    private JTable tNutzung;
    private JToggleButton tbtnSort;

    private NKFPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        SimpleBandModel bandModel = new SimpleBandModel();
        this.bandNutzungen = new PlainBand();
        this.bandMonth = new PlainBand();
        bandModel.addBand((Band)this.bandMonth);
        bandModel.addBand((Band)this.bandNutzungen);
        this.jBand1.setModel((BandModel)bandModel);
        this.btnRemoveNutzung.setEnabled(false);
        ((NKFTable)((Object)this.tNutzung)).getAddAction().setEnabled(false);
        this.btnFlipBuchung.setEnabled(false);
        this.configureTable();
        this.configurePopupMenue();
        this.jBand1.setSelectionMode(JBand.SelectionMode.SINGLE_SELECTION);
        this.jBand1.setHideEmptyPrePostfix(true);
    }

    private NKFTableModel getTableModel() {
        return (NKFTableModel)this.tNutzung.getModel();
    }

    public JTable getNutzungTable() {
        return this.tNutzung;
    }

    public static NKFPanel getInstance() {
        return INSTANCE;
    }

    private void configurePopupMenue() {
        this.predecessorPopup = new JPopupMenu();
        JMenuItem findPredecessor = new JMenuItem(FIND_PREDECESSOR_MENU_NAME);
        findPredecessor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NKFPanel.this.findPredecessorForNutzung(e);
            }
        });
        this.predecessorPopup.add(findPredecessor);
    }

    private void findPredecessorForNutzung(ActionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ActionEvent: " + e.getActionCommand()));
        }
        if (this.currentPopupNutzung != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"currentPopupNutzung vorhanden");
            }
            this.jumpToPredecessorNutzung(this.currentPopupNutzung);
        }
    }

    private void configureTable() {
        TableSelectionUtils.crossReferenceModelAndTable(this.getTableModel(), (NKFTable)((Object)this.tNutzung));
        this.tNutzung.getSelectionModel().addListSelectionListener(this);
        JComboBox<Object> cboAK = new JComboBox<Object>(LagisBroker.getInstance().getAllAnlageklassen().toArray());
        cboAK.addItem("");
        this.tNutzung.setDefaultEditor(AnlageklasseCustomBean.class, new DefaultCellEditor(cboAK));
        this.tNutzung.setDefaultRenderer(Integer.class, new FlaecheRenderer());
        this.tNutzung.setDefaultEditor(Integer.class, new FlaecheEditor());
        ArrayList<NutzungsartCustomBean> nutzungsarten = new ArrayList<NutzungsartCustomBean>(LagisBroker.getInstance().getAllNutzungsarten());
        Collections.sort(nutzungsarten);
        JComboBox<Object> cboNA = new JComboBox<Object>(nutzungsarten.toArray());
        cboNA.addItem("");
        cboNA.setEditable(true);
        cboNA.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (component != null) {
                    if (value instanceof NutzungsartCustomBean) {
                        ((JLabel)component).setText(((NutzungsartCustomBean)value).getBezeichnung());
                    } else if (value instanceof AnlageklasseCustomBean) {
                        JLabel lab = new JLabel();
                        lab.setText(((JLabel)component).getText());
                        lab.setBackground(((JLabel)component).getBackground());
                        lab.setForeground(((JLabel)component).getForeground());
                        lab.setToolTipText(((AnlageklasseCustomBean)value).getSchluessel());
                        return lab;
                    }
                }
                return component;
            }
        });
        AutoCompleteDecorator.decorate(cboNA, (ObjectToStringConverter)new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object object) {
                if (object == null) {
                    return null;
                }
                if (object instanceof CidsBean) {
                    return (String)((CidsBean)object).getProperty("bezeichnung");
                }
                return object.toString();
            }
        });
        ComboBoxCellEditor cce = new ComboBoxCellEditor(cboNA){};
        this.tNutzung.setDefaultEditor(NutzungsartCustomBean.class, (TableCellEditor)cce);
        this.tNutzung.setDefaultRenderer(NutzungsartCustomBean.class, new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                this.setText(value instanceof NutzungsartCustomBean ? ((NutzungsartCustomBean)value).getBezeichnung() : "");
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (component != null && value instanceof NutzungsartCustomBean) {
                    ((JLabel)component).setText(((NutzungsartCustomBean)value).getBezeichnung());
                }
                return component;
            }
        });
        this.tNutzung.setDefaultRenderer(AnlageklasseCustomBean.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (component != null && value instanceof AnlageklasseCustomBean) {
                    JLabel lab = new JLabel();
                    lab.setText(((JLabel)component).getText());
                    lab.setBackground(((JLabel)component).getBackground());
                    lab.setForeground(((JLabel)component).getForeground());
                    lab.setOpaque(((JLabel)component).isOpaque());
                    lab.setFont(((JLabel)component).getFont());
                    lab.setToolTipText(((AnlageklasseCustomBean)value).getSchluessel());
                    return lab;
                }
                return component;
            }
        });
        this.tNutzung.setDefaultEditor(Double.class, new EuroEditor());
        this.tNutzung.setDefaultRenderer(Double.class, new EuroRenderer());
        this.tNutzung.addMouseListener(this);
        this.tNutzung.addMouseListener(new PopupListener());
        this.getTableModel().addTableModelListener(this);
        HighlightPredicate buchungsStatusPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                try {
                    if (componentAdapter.getRowCount() > 0) {
                        int displayedIndex = componentAdapter.row;
                        int modelIndex = ((JXTable)NKFPanel.this.tNutzung).convertRowIndexToModel(displayedIndex);
                        NutzungBuchungCustomBean n = (NutzungBuchungCustomBean)NKFPanel.this.getTableModel().getCidsBeanAtRow(modelIndex);
                        return n != null && !n.getIstBuchwert();
                    }
                    return false;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim Highlighting des Buchwerts vorhanden", (Throwable)ex);
                    return false;
                }
            }
        };
        ColorHighlighter buchungsStatusHighlighter = new ColorHighlighter(buchungsStatusPredicate, LagisBroker.UNKOWN_COLOR, null);
        HighlightPredicate geloeschtPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                try {
                    if (componentAdapter.getRowCount() > 0) {
                        int displayedIndex = componentAdapter.row;
                        int modelIndex = ((JXTable)NKFPanel.this.tNutzung).convertRowIndexToModel(displayedIndex);
                        NutzungBuchungCustomBean n = (NutzungBuchungCustomBean)NKFPanel.this.getTableModel().getCidsBeanAtRow(modelIndex);
                        return n != null && n.getSollGeloeschtWerden();
                    }
                    return false;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim Highlighting test wurde gel\u00f6scht vorhanden", (Throwable)ex);
                    return false;
                }
            }
        };
        ColorHighlighter geloeschtHighlighter = new ColorHighlighter(geloeschtPredicate, LagisBroker.GREY, null);
        ((JXTable)this.tNutzung).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER, buchungsStatusHighlighter, geloeschtHighlighter});
        ((JXTable)this.tNutzung).setSortOrder(0, SortOrder.ASCENDING);
        ((JXTable)this.tNutzung).setColumnControlVisible(true);
        ((JXTable)this.tNutzung).setHorizontalScrollEnabled(true);
        ((JXTable)this.tNutzung).packAll();
        ((NKFTable)((Object)this.tNutzung)).setSortButton(this.tbtnSort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            LOG.info((Object)"FlurstueckChanged");
            this.clearComponent();
            FlurstueckArtCustomBean flurstueckArt = newFlurstueck.getFlurstueckSchluessel().getFlurstueckArt();
            if (flurstueckArt != null && flurstueckArt.getBezeichnung().equals("st\u00e4dtisch")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist st\u00e4dtisch und kann editiert werden");
                }
                this.isFlurstueckEditable = true;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch und kann nicht editiert werden");
                }
                this.isFlurstueckEditable = false;
            }
            Collection<NutzungCustomBean> newNutzungen = newFlurstueck.getNutzungen();
            this.getTableModel().refreshTableModel(newNutzungen);
            if (newNutzungen != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Es sind Nutzungen vorhanden: " + newNutzungen.size()));
            }
            this.updateBands();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Flurst\u00fcckswechsel: ", (Throwable)ex);
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        if (this.isFlurstueckEditable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"NKFPanel --> setComponentEditable");
            }
            this.isInEditMode = isEditable;
            this.getTableModel().setInEditMode(isEditable);
            if (isEditable) {
                this.memberUnselect();
                ((NKFTable)((Object)this.tNutzung)).getAddAction().setEnabled(true);
                if (this.tNutzung.getSelectedRow() != -1) {
                    this.btnCopyNutzung.setEnabled(true);
                    int index = ((JXTable)this.tNutzung).convertRowIndexToModel(this.tNutzung.getSelectedRow());
                    NutzungBuchungCustomBean selectedBuchung = (NutzungBuchungCustomBean)this.getTableModel().getCidsBeanAtRow(index);
                    if (selectedBuchung.isBuchwertFlippable() && LagisBroker.getInstance().isNkfAdminPermission()) {
                        this.btnFlipBuchung.setEnabled(true);
                    }
                    if (index != -1 && selectedBuchung.getGueltigbis() == null) {
                        this.btnRemoveNutzung.setEnabled(true);
                    }
                }
                if (this.copyPasteList.size() > 0) {
                    this.btnPasteNutzung.setEnabled(isEditable);
                }
            } else {
                this.btnFlipBuchung.setEnabled(false);
                this.btnPasteNutzung.setEnabled(isEditable);
                this.btnCopyNutzung.setEnabled(false);
                ((NKFTable)((Object)this.tNutzung)).getAddAction().setEnabled(false);
                TableCellEditor currentEditor = this.tNutzung.getCellEditor();
                if (currentEditor != null) {
                    currentEditor.cancelCellEditing();
                }
                this.btnRemoveNutzung.setEnabled(false);
                this.btnCopyNutzung.setEnabled(false);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"NKFPanel --> setComponentEditable finished");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch Verwaltungen k\u00f6nnen nicht editiert werden");
        }
    }

    @Override
    public synchronized void clearComponent() {
        this.getTableModel().refreshTableModel(null);
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tNutzung = new NKFTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblCurrentHistoryPostion = new JLabel();
        this.lblHistoricIcon = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnAddNutzung = new JButton();
        this.btnRemoveNutzung = new JButton();
        this.btnPasteNutzung = new JButton();
        this.btnCopyNutzung = new JButton();
        this.btnFlipBuchung = new JButton();
        this.tbtnSort = new JToggleButton();
        this.jBand1 = new JBand(true);
        this.jComboBox1 = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.tNutzung.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tNutzung.setModel(new NKFTableModel());
        this.jScrollPane1.setViewportView(this.tNutzung);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText("Nutzungen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("NKF Historie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.lblCurrentHistoryPostion.setText("Keine Historie vorhanden");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 6, 0, 0);
        this.jPanel2.add((Component)this.lblCurrentHistoryPostion, gridBagConstraints);
        this.lblHistoricIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/emptyDummy64.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        this.jPanel2.add((Component)this.lblHistoricIcon, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnAddNutzung.setAction(((NKFTable)((Object)this.tNutzung)).getAddAction());
        this.btnAddNutzung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddNutzung.setBorder(null);
        this.btnAddNutzung.setBorderPainted(false);
        this.btnAddNutzung.setMaximumSize(new Dimension(25, 25));
        this.btnAddNutzung.setMinimumSize(new Dimension(25, 25));
        this.btnAddNutzung.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel1.add((Component)this.btnAddNutzung, gridBagConstraints);
        this.btnRemoveNutzung.setAction(((NKFTable)((Object)this.tNutzung)).getRemoveAction());
        this.btnRemoveNutzung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveNutzung.setBorder(null);
        this.btnRemoveNutzung.setBorderPainted(false);
        this.btnRemoveNutzung.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveNutzung.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveNutzung.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel1.add((Component)this.btnRemoveNutzung, gridBagConstraints);
        this.btnPasteNutzung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/pasteNu.png")));
        this.btnPasteNutzung.setToolTipText("Buchung einf\u00fcgen");
        this.btnPasteNutzung.setBorderPainted(false);
        this.btnPasteNutzung.setMaximumSize(new Dimension(25, 25));
        this.btnPasteNutzung.setMinimumSize(new Dimension(25, 25));
        this.btnPasteNutzung.setPreferredSize(new Dimension(25, 25));
        this.btnPasteNutzung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NKFPanel.this.btnPasteNutzungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel1.add((Component)this.btnPasteNutzung, gridBagConstraints);
        this.btnCopyNutzung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/copyNu.png")));
        this.btnCopyNutzung.setToolTipText("Buchung kopieren");
        this.btnCopyNutzung.setBorderPainted(false);
        this.btnCopyNutzung.setMaximumSize(new Dimension(25, 25));
        this.btnCopyNutzung.setMinimumSize(new Dimension(25, 25));
        this.btnCopyNutzung.setPreferredSize(new Dimension(25, 25));
        this.btnCopyNutzung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NKFPanel.this.btnCopyNutzungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel1.add((Component)this.btnCopyNutzung, gridBagConstraints);
        this.btnFlipBuchung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/booked.png")));
        this.btnFlipBuchung.setToolTipText("Buchwert / kein Buchwert");
        this.btnFlipBuchung.setBorderPainted(false);
        this.btnFlipBuchung.setMaximumSize(new Dimension(25, 25));
        this.btnFlipBuchung.setMinimumSize(new Dimension(25, 25));
        this.btnFlipBuchung.setPreferredSize(new Dimension(25, 25));
        this.btnFlipBuchung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NKFPanel.this.btnFlipBuchungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel1.add((Component)this.btnFlipBuchung, gridBagConstraints);
        this.tbtnSort.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.tbtnSort.setToolTipText("Sortierung An / Aus");
        this.tbtnSort.setBorderPainted(false);
        this.tbtnSort.setContentAreaFilled(false);
        this.tbtnSort.setMaximumSize(new Dimension(25, 25));
        this.tbtnSort.setMinimumSize(new Dimension(25, 25));
        this.tbtnSort.setPreferredSize(new Dimension(25, 25));
        this.tbtnSort.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel1.add((Component)this.tbtnSort, gridBagConstraints);
        this.tbtnSort.addItemListener(((NKFTable)((Object)this.tNutzung)).getSortItemListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jBand1.setMinimumSize(new Dimension(23, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jBand1, gridBagConstraints);
        this.jComboBox1.setRenderer(new DateComboBoxRenderer());
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NKFPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.jPanel2.add((Component)this.jComboBox1, gridBagConstraints);
        this.jComboBox1.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void btnCopyNutzungActionPerformed(ActionEvent evt) {
        this.copyPasteList.clear();
        if (this.tNutzung.getSelectedRow() != -1) {
            int[] selectedRows = this.tNutzung.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                this.tNutzung.getSelectedRow();
                int index = ((JXTable)this.tNutzung).convertRowIndexToModel(selectedRows[i]);
                NutzungBuchungCustomBean curNutzungToCopy = (NutzungBuchungCustomBean)this.getTableModel().getCidsBeanAtRow(index);
                if (curNutzungToCopy == null) continue;
                try {
                    this.copyPasteList.add(NutzungCustomBean.createNew(curNutzungToCopy.cloneBuchung()));
                    continue;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim kopieren einer Buchung: ", (Throwable)ex);
                    JOptionPane.showMessageDialog(LagisApp.getInstance(), "Die Buchung konnte nicht kopiert werden, da die zu \nkopierende Buchung Fehler enth\u00e4lt", "Fehler beim kopieren einer Buchung", 0);
                    return;
                }
            }
        }
        if (this.isInEditMode) {
            this.btnPasteNutzung.setEnabled(true);
        }
    }

    private void btnPasteNutzungActionPerformed(ActionEvent evt) {
        if (this.copyPasteList.size() > 0) {
            NutzungCustomBean lastNutzung = null;
            for (NutzungCustomBean curNutzung : this.copyPasteList) {
                this.getTableModel().addNutzung(curNutzung);
                lastNutzung = curNutzung;
            }
            this.selectNutzungInHistory(lastNutzung.getNutzungsBuchungen().get(0));
        }
    }

    private void btnFlipBuchungActionPerformed(ActionEvent evt) {
        int index;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Flippe Buchung");
        }
        if ((index = ((JXTable)this.tNutzung).convertRowIndexToModel(this.tNutzung.getSelectedRow())) != -1) {
            NutzungBuchungCustomBean selectedBuchung = (NutzungBuchungCustomBean)this.getTableModel().getCidsBeanAtRow(index);
            if (selectedBuchung.isBuchwertFlippable()) {
                try {
                    selectedBuchung.flipBuchungsBuchwert();
                    this.getTableModel().fireTableDataChanged();
                    this.tNutzung.repaint();
                }
                catch (IllegalNutzungStateException ex) {
                    LOG.error((Object)"Buchwert kann nicht geflipped werden, Nutzung in illegalem Zustand: ", (Throwable)ex);
                }
                catch (BuchungNotInNutzungException ex) {
                    LOG.error((Object)"Buchwert kann nicht geflipped werden, Die Buchung ist nicht in der Nutzung vorhanden: ", (Throwable)ex);
                }
            }
        } else {
            LOG.warn((Object)"Keine Buchung selektiert, sollte nicht m\u00f6glich sein");
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        Date date = (Date)this.jComboBox1.getSelectedItem();
        this.getTableModel().setModelToHistoryDate(date);
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MouseClicked");
        }
        if (source instanceof JXTable) {
            NutzungBuchungCustomBean nutzung;
            int selecetdRow;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Mit maus auf NKFTabelle geklickt");
            }
            if (!((selecetdRow = this.tNutzung.getSelectedRow()) == -1 || (nutzung = (NutzungBuchungCustomBean)this.getTableModel().getCidsBeanAtRow(((JXTable)this.tNutzung).convertRowIndexToModel(selecetdRow))) == null || e.getClickCount() != 2 || this.isInEditMode && this.tNutzung.getSelectedColumn() != 1 && this.tNutzung.getSelectedColumn() != 9 && this.tNutzung.getSelectedColumn() != 3 && this.tNutzung.getSelectedColumn() != 10 && this.tNutzung.getSelectedColumn() != 0 && this.tNutzung.getSelectedColumn() != 4 && this.tNutzung.getSelectedColumn() != 11)) {
                this.jumpToPredecessorNutzung(nutzung);
            }
        }
    }

    private void jumpToPredecessorNutzung(NutzungBuchungCustomBean buchung) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Versuche zu Vorg\u00e4ngernutzung zu springen: ");
        }
        if (this.tNutzung.getCellEditor() != null) {
            this.tNutzung.getCellEditor().cancelCellEditing();
        }
        NutzungBuchungCustomBean vorgaenger = null;
        if (buchung != null && buchung.getNutzung() != null && (vorgaenger = buchung.getNutzung().getPredecessorBuchung(buchung)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Vorg\u00e4nger Nutzung gefunden");
            }
            this.selectNutzungInHistory(vorgaenger);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Es gibt keinen Vorg\u00e4nger f\u00fcr die Nutzung: " + buchung.getId()));
        }
    }

    private void selectNutzungInHistory(NutzungBuchungCustomBean nutzung) {
        this.jBand1.setSelectedMember((BandMemberSelectable)null);
        int index = this.getTableModel().getIndexOfCidsBean(nutzung);
        int displayedIndex = ((JXTable)this.tNutzung).convertRowIndexToView(index);
        if (index != -1) {
            this.tNutzung.getSelectionModel().clearSelection();
            this.tNutzung.getSelectionModel().addSelectionInterval(displayedIndex, displayedIndex);
            Rectangle tmp = this.tNutzung.getCellRect(displayedIndex, 0, true);
            if (tmp != null) {
                this.tNutzung.scrollRectToVisible(tmp);
            }
        }
    }

    @Override
    public void updateFlurstueckForSaving(FlurstueckCustomBean flurstueck) {
        Collection<NutzungCustomBean> vNutzungen = flurstueck.getNutzungen();
        if (vNutzungen != null) {
            LagISUtils.makeCollectionContainSameAsOtherCollection(vNutzungen, this.getTableModel().getAllNutzungen());
        } else {
            HashSet<NutzungCustomBean> newSet = new HashSet<NutzungCustomBean>();
            newSet.addAll(this.getTableModel().getAllNutzungen());
            flurstueck.setNutzungen(newSet);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int index;
        Refreshable refresh;
        if (this.tNutzung.getSelectedRow() != -1) {
            int index2 = ((JXTable)this.tNutzung).convertRowIndexToModel(this.tNutzung.getSelectedRow());
            NutzungBuchungCustomBean selectedBuchung = (NutzungBuchungCustomBean)this.getTableModel().getCidsBeanAtRow(index2);
            if (selectedBuchung == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"selectedBuchung nicht l\u00e4nger verf\u00fcgbar l\u00f6sche selektierung");
                }
                this.tNutzung.clearSelection();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"tableChanged");
        }
        if ((refresh = LagisBroker.getInstance().getRefreshableByClass(NKFOverviewPanel.class)) != null) {
            refresh.refresh(new NutzungsContainer(this.getTableModel().getAllNutzungen(), this.getTableModel().getCurrentDate()));
        }
        if (this.tNutzung.getSelectedRow() != -1 && (index = ((JXTable)this.tNutzung).convertRowIndexToModel(this.tNutzung.getSelectedRow())) != -1) {
            NutzungBuchungCustomBean selectedBuchung = (NutzungBuchungCustomBean)this.getTableModel().getCidsBeanAtRow(index);
            if (selectedBuchung.getIstBuchwert()) {
                this.btnFlipBuchung.setIcon(this.icoNotBooked);
            } else {
                this.btnFlipBuchung.setIcon(this.icoBooked);
            }
        }
    }

    public void memberUnselect() {
        int i;
        boolean isSelected = false;
        for (i = 0; i < this.bandNutzungen.getNumberOfMembers(); ++i) {
            NKFBandMember bm = (NKFBandMember)this.bandNutzungen.getMember(i);
            if (!bm.isSelected()) continue;
            isSelected = true;
            break;
        }
        if (!isSelected && this.bandNutzungen.getNumberOfMembers() > 0) {
            this.jBand1.setSelectedMember((BandMemberSelectable)((NKFBandMember)this.bandNutzungen.getMember(i - 1)));
        }
    }

    public void memberSelect(NKFBandMember bandMember) {
        try {
            this.jBand1.scrollToBandMember((BandMember)bandMember);
            Date date = bandMember.getDate();
            this.jComboBox1.removeAllItems();
            if (date != null) {
                this.lblCurrentHistoryPostion.setText(LagisBroker.getDateFormatter().format(date));
                HashSet<Date> dates = new HashSet<Date>();
                for (NutzungCustomBean nutzung_ : LagisBroker.getInstance().getCurrentFlurstueck().getNutzungen()) {
                    dates.addAll(nutzung_.getDatesForDay(bandMember.getDate()));
                }
                for (Date date_ : dates) {
                    this.jComboBox1.addItem(date_);
                }
                this.lblHistoricIcon.setIcon(this.icoHistoricIcon);
                if (this.isInEditMode) {
                    ((NKFTable)((Object)this.tNutzung)).getAddAction().setEnabled(false);
                    this.btnRemoveNutzung.setEnabled(false);
                }
            } else {
                this.lblCurrentHistoryPostion.setText("Aktuelle Nutzungen");
                this.lblHistoricIcon.setIcon(this.icoHistoricIconDummy);
                this.jComboBox1.addItem(null);
                if (this.isInEditMode) {
                    ((NKFTable)((Object)this.tNutzung)).getAddAction().setEnabled(true);
                    this.btnRemoveNutzung.setEnabled(false);
                }
            }
            this.jComboBox1.setSelectedIndex(0);
            this.jComboBox1.setVisible(this.jComboBox1.getItemCount() > 1);
            this.lblCurrentHistoryPostion.setVisible(this.jComboBox1.getItemCount() <= 1);
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim updaten des Slider labels: ", (Throwable)ex);
        }
    }

    private int diffInDays(Date from, Date to) {
        return (int)((from.getTime() - to.getTime()) / 86400000L);
    }

    private List<NutzungBuchungCustomBean> getSortedHistoricsortedNutzungen(List<NutzungBuchungCustomBean> sortedNutzungen) {
        ArrayList<NutzungBuchungCustomBean> sortedHistoricNutzungen = new ArrayList<NutzungBuchungCustomBean>();
        for (NutzungBuchungCustomBean curBuchung : sortedNutzungen) {
            if (curBuchung.getGueltigbis() == null) break;
            sortedHistoricNutzungen.add(curBuchung);
        }
        return sortedHistoricNutzungen;
    }

    public synchronized void updateBands() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"update Slider", (Throwable)new CurrentStackTrace());
        }
        ArrayList<NutzungBuchungCustomBean> sortedNutzungen = this.getTableModel().getAllBuchungen();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"nach \u00c4nderungen");
        }
        try {
            this.bandNutzungen.removeAllMember();
            this.bandMonth.removeAllMember();
            for (int i = 0; i < this.bandNutzungen.getNumberOfMembers(); ++i) {
                NKFBandMember nkfMember = (NKFBandMember)this.bandNutzungen.getMember(i);
                nkfMember.removeAllListeners();
            }
            List<NutzungBuchungCustomBean> sortedHistoricNutzungen = this.getSortedHistoricsortedNutzungen(sortedNutzungen);
            if (!sortedHistoricNutzungen.isEmpty()) {
                Iterator<NutzungBuchungCustomBean> it = sortedHistoricNutzungen.iterator();
                Calendar c = Calendar.getInstance();
                NutzungBuchungCustomBean firstNutzung = it.next();
                int minPreDays = 5;
                int minPostDays = 5;
                c.setTime(firstNutzung.getGueltigbis());
                c.set(5, 1);
                int preOffset = this.diffInDays(firstNutzung.getGueltigbis(), c.getTime());
                if (preOffset < 5) {
                    c.add(2, -1);
                    preOffset = this.diffInDays(firstNutzung.getGueltigbis(), c.getTime());
                }
                c.setTime(firstNutzung.getGueltigbis());
                c.add(5, -preOffset);
                Date firstDate = c.getTime();
                int previousDayDiff = preOffset;
                final NKFBandMember firstNkfBandMember = new NKFBandMember(0.0, previousDayDiff, firstNutzung.getGueltigbis());
                this.bandNutzungen.addMember((BandMember)firstNkfBandMember);
                firstNkfBandMember.addListener(new NKFBandMember.Listener(){

                    @Override
                    public void memberSelected(boolean selected) {
                        if (selected) {
                            NKFPanel.this.memberSelect(firstNkfBandMember);
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    NKFPanel.this.memberUnselect();
                                }
                            });
                        }
                    }
                });
                NutzungBuchungCustomBean previousNutzung = firstNutzung;
                while (it.hasNext()) {
                    Date preGueltigBis;
                    NutzungBuchungCustomBean curNutzung = it.next();
                    Date curGueltigBis = LagisBroker.getDateWithoutTime(curNutzung.getGueltigbis());
                    if (curGueltigBis.equals(preGueltigBis = LagisBroker.getDateWithoutTime(previousNutzung.getGueltigbis()))) continue;
                    int curDayDiff = previousDayDiff + this.diffInDays(curGueltigBis, preGueltigBis);
                    final NKFBandMember nkfBandMember = new NKFBandMember(previousDayDiff, curDayDiff, curGueltigBis);
                    nkfBandMember.addListener(new NKFBandMember.Listener(){

                        @Override
                        public void memberSelected(boolean selected) {
                            if (selected) {
                                NKFPanel.this.memberSelect(nkfBandMember);
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        NKFPanel.this.memberUnselect();
                                    }
                                });
                            }
                        }
                    });
                    this.bandNutzungen.addMember((BandMember)nkfBandMember);
                    previousNutzung = curNutzung;
                    previousDayDiff = curDayDiff;
                }
                NutzungBuchungCustomBean lastNutzung = previousNutzung;
                c.setTime(lastNutzung.getGueltigbis());
                c.set(5, 1);
                c.add(2, 1);
                int postOffset = this.diffInDays(c.getTime(), lastNutzung.getGueltigbis());
                if (postOffset < 5) {
                    c.add(2, 1);
                    postOffset = this.diffInDays(c.getTime(), lastNutzung.getGueltigbis());
                }
                int endDayDiff = previousDayDiff + postOffset;
                final NKFBandMember bandMember = new NKFBandMember(previousDayDiff, endDayDiff, null);
                bandMember.addListener(new NKFBandMember.Listener(){

                    @Override
                    public void memberSelected(boolean selected) {
                        if (selected) {
                            NKFPanel.this.memberSelect(bandMember);
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    NKFPanel.this.memberUnselect();
                                }
                            });
                        }
                    }
                });
                this.bandNutzungen.addMember((BandMember)bandMember);
                Date previousDate = firstDate;
                previousDayDiff = 0;
                while (previousDayDiff < endDayDiff) {
                    c.setTime(previousDate);
                    String prevDateMonth = c.getDisplayName(2, 2, Locale.getDefault());
                    String prevDateYear = Integer.toString(c.get(1));
                    c.set(5, 1);
                    c.add(2, 1);
                    Date curDate = c.getTime();
                    int curDayDiff = previousDayDiff + this.diffInDays(curDate, previousDate);
                    this.bandMonth.addMember((BandMember)new SimpleTextSection(prevDateMonth + " " + prevDateYear, (double)previousDayDiff, (double)curDayDiff, false, false));
                    previousDate = curDate;
                    previousDayDiff = curDayDiff;
                }
                if (endDayDiff > 75) {
                    this.jBand1.setZoomFactor((double)endDayDiff / 75.0);
                } else {
                    this.jBand1.setZoomFactor(1.0);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NKFPanel.this.memberUnselect();
                    }
                });
                this.jBand1.setVisible(true);
            } else {
                this.lblCurrentHistoryPostion.setText("Keine Historie vorhanden");
                this.lblCurrentHistoryPostion.setVisible(true);
                this.jComboBox1.setVisible(false);
                this.jBand1.setVisible(false);
            }
            this.jBand1.setModel(this.jBand1.getModel());
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim updaten des NKF History Sliders (Change Filter)", (Throwable)ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("tablemodel rowcount: " + this.getTableModel().getRowCount()));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tNutzung.getSelectedRow() != -1) {
            int index = ((JXTable)this.tNutzung).convertRowIndexToModel(this.tNutzung.getSelectedRow());
            if (index != -1) {
                NutzungBuchungCustomBean selectedBuchung = (NutzungBuchungCustomBean)this.getTableModel().getCidsBeanAtRow(index);
                this.btnCopyNutzung.setEnabled(true);
                if (selectedBuchung.getIstBuchwert()) {
                    this.btnFlipBuchung.setIcon(this.icoNotBooked);
                } else {
                    this.btnFlipBuchung.setIcon(this.icoBooked);
                }
                if (this.isInEditMode) {
                    if (selectedBuchung.isBuchwertFlippable() && LagisBroker.getInstance().isNkfAdminPermission()) {
                        this.btnFlipBuchung.setEnabled(true);
                    } else {
                        this.btnFlipBuchung.setEnabled(false);
                    }
                    if (LagisBroker.getInstance().isNkfAdminPermission()) {
                        if (selectedBuchung == selectedBuchung.getNutzung().getLastBuchung()) {
                            this.btnRemoveNutzung.setEnabled(true);
                        } else {
                            this.btnRemoveNutzung.setEnabled(false);
                        }
                    } else if (selectedBuchung.getGueltigbis() == null) {
                        this.btnRemoveNutzung.setEnabled(true);
                    } else {
                        this.btnRemoveNutzung.setEnabled(false);
                    }
                } else {
                    this.btnRemoveNutzung.setEnabled(false);
                    this.btnFlipBuchung.setEnabled(false);
                }
            } else {
                this.btnCopyNutzung.setEnabled(false);
                this.btnRemoveNutzung.setEnabled(false);
                this.btnFlipBuchung.setEnabled(false);
            }
        } else {
            this.btnRemoveNutzung.setEnabled(false);
            this.btnCopyNutzung.setEnabled(false);
            this.btnFlipBuchung.setEnabled(false);
        }
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }

    @Override
    public int getStatus() {
        if (this.isFlurstueckEditable) {
            if (this.tNutzung.getCellEditor() != null) {
                this.validationMessage = "Bitte vollenden Sie alle \u00c4nderungen bei den Nutzungen.";
                return 2;
            }
            boolean existingUnvalidCurrentNutzung = false;
            boolean existsAtLeastOneValidCurrentNutzung = false;
            ArrayList<NutzungCustomBean> currentNutzungen = this.getTableModel().getAllNutzungen();
            ArrayList<NutzungBuchungCustomBean> currentBuchungen = this.getTableModel().getOpenBuchungen();
            if (currentNutzungen != null || currentNutzungen.size() > 0) {
                for (NutzungBuchungCustomBean currentBuchung : currentBuchungen) {
                    if (currentBuchung != null && currentBuchung.getNutzungsart() == null) {
                        existingUnvalidCurrentNutzung = true;
                    }
                    if (currentBuchung != null && currentBuchung.getNutzungsart() != null) {
                        existsAtLeastOneValidCurrentNutzung = true;
                    }
                    if (currentBuchung.getFlaeche() != null && currentBuchung.getQuadratmeterpreis() != null) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Neuer Preis: " + (double)currentBuchung.getFlaeche().intValue() * currentBuchung.getQuadratmeterpreis()));
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Neuer Preis kann nicht berechnet werden");
                }
            }
            if (existingUnvalidCurrentNutzung) {
                this.validationMessage = "Alle Nutzungen m\u00fcssen eine Nutzungsart haben.";
                return 2;
            }
            if (!existsAtLeastOneValidCurrentNutzung && !LagisBroker.getInstance().isNkfAdminPermission()) {
                this.validationMessage = "Es muss mindestens eine aktuelle Nutzung mit Nutzungsart angelegt sein,\num das Flurst\u00fcck speichern zu k\u00f6nnen.";
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public void configure(Element parent) {
    }

    public Element getConfiguration() {
        return null;
    }

    public void masterConfigure(Element parent) {
    }

    public class DateComboBoxRenderer
    extends DefaultListCellRenderer {
        private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy - HH:mm:ss");

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                ((JLabel)comp).setText(this.sdf.format((Date)value));
            } else {
                ((JLabel)comp).setText("Aktuelle Nutzungen");
            }
            return comp;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"showPopup");
            }
            if (e.isPopupTrigger()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"popup triggered");
                }
                int rowAtPoint = NKFPanel.this.tNutzung.rowAtPoint(new Point(e.getX(), e.getY()));
                NutzungBuchungCustomBean selectedNutzung = null;
                if (rowAtPoint != -1 && (selectedNutzung = (NutzungBuchungCustomBean)NKFPanel.this.getTableModel().getCidsBeanAtRow(((JXTable)NKFPanel.this.tNutzung).convertRowIndexToModel(rowAtPoint))) != null && selectedNutzung.getNutzung() != null && selectedNutzung.getNutzung().getPredecessorBuchung(selectedNutzung) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"nutzung found");
                    }
                    NKFPanel.this.currentPopupNutzung = selectedNutzung;
                    NKFPanel.this.predecessorPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

