/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.RebeArtCustomBean;
import de.cismet.cids.custom.beans.lagis.RebeCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.editor.DateEditor;
import de.cismet.lagis.gui.copypaste.Copyable;
import de.cismet.lagis.gui.copypaste.Pasteable;
import de.cismet.lagis.gui.tables.ReBeTable;
import de.cismet.lagis.interfaces.FeatureSelectionChangedListener;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.interfaces.GeometrySlotProvider;
import de.cismet.lagis.interfaces.LagisBrokerPropertyChangeListener;
import de.cismet.lagis.models.ReBeTableModel;
import de.cismet.lagis.renderer.DateRenderer;
import de.cismet.lagis.util.TableSelectionUtils;
import de.cismet.lagis.utillity.GeometrySlotInformation;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.lagisEE.entity.basic.BasicEntity;
import de.cismet.lagisEE.entity.core.CustomSelectionStyledFeatureGroupWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class ReBePanel
extends AbstractWidget
implements MouseListener,
FlurstueckChangeListener,
LagisBrokerPropertyChangeListener,
GeometrySlotProvider,
FlurstueckSaver,
FeatureSelectionChangedListener,
ListSelectionListener,
Copyable,
Pasteable {
    private static final String WIDGET_NAME = "Rechte & Belastungen Panel";
    public static final String PROVIDER_NAME = "ReBe";
    private static final String DEF_REBE_TRIGGER_ART = "Dienstbarkeit";
    private static final String DEF_TARGET_COL = "Nummer";
    private static final String DEF_COL_VALUE = "Abt. II, lfd. Nr. ";
    private static final String COPY_DISPLAY_ICON = "/de/cismet/lagis/ressource/icons/rebe.png";
    private final Logger log = Logger.getLogger(this.getClass());
    private final ReBeTableModel tableModel = new ReBeTableModel();
    private boolean isInEditMode = false;
    private final Icon copyDisplayIcon = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/rebe.png"));
    private boolean listenerEnabled = true;
    private JButton btnAddReBe;
    private JButton btnRemoveReBe;
    private JButton btnUndo;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable tReBe;
    private JToggleButton tbtnSort;

    public ReBePanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        this.btnRemoveReBe.setEnabled(false);
        this.configureTable();
        LagisBroker.getInstance().addWfsFlurstueckGeometryChangeListener(this);
    }

    private void configureTable() {
        TableSelectionUtils.crossReferenceModelAndTable(this.tableModel, (ReBeTable)((Object)this.tReBe));
        Collection<RebeArtCustomBean> reBeArten = LagisBroker.getInstance().getAllRebeArten();
        if (reBeArten != null) {
            JComboBox<RebeArtCustomBean> cboRebeArt = new JComboBox<RebeArtCustomBean>(new Vector<RebeArtCustomBean>(reBeArten));
            this.tReBe.setDefaultEditor(RebeArtCustomBean.class, new DefaultCellEditor(cboRebeArt));
            cboRebeArt.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ReBePanel.this.handleCboRebeArtItemStateChanged(e);
                }
            });
        }
        JCheckBox cboReBe = new JCheckBox();
        ((JCheckBox)((JXTable.BooleanEditor)this.tReBe.getDefaultEditor(Boolean.class)).getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReBePanel.this.cboBooleanEditorActionPerformed();
            }
        });
        cboReBe.setIcon(new ImageIcon());
        cboReBe.setSelectedIcon(new ImageIcon());
        cboReBe.setRolloverIcon(new ImageIcon());
        cboReBe.setPressedIcon(new ImageIcon());
        cboReBe.setDisabledIcon(new ImageIcon());
        cboReBe.setDisabledSelectedIcon(new ImageIcon());
        cboReBe.setHorizontalAlignment(0);
        this.tReBe.setDefaultEditor(Date.class, new DateEditor());
        this.tReBe.setDefaultRenderer(Date.class, new DateRenderer());
        this.tReBe.addMouseListener(this);
        HighlightPredicate noGeometryPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                int displayedIndex = componentAdapter.row;
                int modelIndex = ((JXTable)ReBePanel.this.tReBe).convertRowIndexToModel(displayedIndex);
                RebeCustomBean r = (RebeCustomBean)ReBePanel.this.tableModel.getCidsBeanAtRow(modelIndex);
                return r != null && r.getGeometry() == null;
            }
        };
        ColorHighlighter noGeometryHighlighter = new ColorHighlighter(noGeometryPredicate, LagisBroker.GREY, null);
        ((JXTable)this.tReBe).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER, noGeometryHighlighter});
        ((JXTable)this.tReBe).setSortOrder(0, SortOrder.ASCENDING);
        this.tReBe.getSelectionModel().addListSelectionListener(this);
        ((JXTable)this.tReBe).packAll();
        ((ReBeTable)((Object)this.tReBe)).setSortButton(this.tbtnSort);
        ((ReBeTable)((Object)this.tReBe)).setUndoButton(this.btnUndo);
    }

    private void handleCboRebeArtItemStateChanged(ItemEvent e) {
        String rebeArt;
        if (e.getStateChange() == 1 && DEF_REBE_TRIGGER_ART.equals(rebeArt = e.getItem().toString())) {
            String currentValueObj;
            JXTable rebeJXTable = (JXTable)this.tReBe;
            int colIndex = this.tableModel.findColumn(DEF_TARGET_COL);
            int rowIndex = this.tReBe.getSelectedRow();
            TableCellEditor currentEditor = this.tReBe.getCellEditor();
            if (currentEditor != null) {
                currentEditor.stopCellEditing();
            }
            if ((currentValueObj = rebeJXTable.getStringAt(rowIndex, colIndex)) == null || currentValueObj.trim().isEmpty()) {
                rebeJXTable.setValueAt((Object)DEF_COL_VALUE, rowIndex, colIndex);
                TableCellEditor cellEditor = this.tReBe.getCellEditor(rowIndex, colIndex);
                Component c = cellEditor.getTableCellEditorComponent(this.tReBe, null, true, rowIndex, colIndex);
                rebeJXTable.editCellAt(rowIndex, colIndex);
                final JTextField txtField = (JTextField)c;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        txtField.requestFocus();
                    }
                });
            }
        }
    }

    @Override
    public List<BasicEntity> getCopyData() {
        List<? extends CidsBean> allReBe = this.tableModel.getCidsBeans();
        ArrayList<BasicEntity> result = new ArrayList<BasicEntity>(allReBe.size());
        for (RebeCustomBean rebeCustomBean : allReBe) {
            try {
                RebeCustomBean tmp = RebeCustomBean.createNew();
                Date dateEintragung = rebeCustomBean.getDatumEintragung();
                Date dateLoeschung = rebeCustomBean.getDatumLoeschung();
                tmp.setDatumEintragung(dateEintragung == null ? null : (Date)dateEintragung.clone());
                tmp.setDatumLoeschung(dateLoeschung == null ? null : (Date)dateLoeschung.clone());
                tmp.setBemerkung(rebeCustomBean.getBemerkung());
                Geometry geom = rebeCustomBean.getGeometry();
                if (geom != null) {
                    tmp.setGeometry((Geometry)geom.clone());
                }
                tmp.setEditable(rebeCustomBean.isEditable());
                tmp.hide(rebeCustomBean.isHidden());
                tmp.setModifiable(rebeCustomBean.isModifiable());
                tmp.setNummer(rebeCustomBean.getNummer());
                tmp.setIstRecht(rebeCustomBean.getIstRecht());
                tmp.setBeschreibung(rebeCustomBean.getBeschreibung());
                result.add(tmp);
            }
            catch (Exception ex) {
                this.log.error((Object)"error creating rebe bean");
            }
        }
        return result;
    }

    @Override
    public void paste(BasicEntity entity) {
        if (entity == null) {
            throw new NullPointerException("Entity must not be null");
        }
        if (entity instanceof RebeCustomBean) {
            List<? extends CidsBean> residentReBe = this.tableModel.getCidsBeans();
            if (residentReBe.contains(entity)) {
                this.log.warn((Object)("ReBe " + entity + " does already exist -> ignored"));
            } else {
                this.tableModel.addCidsBean((RebeCustomBean)entity);
                CustomSelectionStyledFeatureGroupWrapper wrapper = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)entity, PROVIDER_NAME, PROVIDER_NAME);
                MappingComponent mc = LagisBroker.getInstance().getMappingComponent();
                FeatureCollection fc = mc.getFeatureCollection();
                fc.addFeature((Feature)wrapper);
                this.tableModel.fireTableDataChanged();
                mc.setGroupLayerVisibility(PROVIDER_NAME, true);
            }
        }
    }

    @Override
    public void pasteAll(List<BasicEntity> dataList) {
        if (dataList == null) {
            throw new NullPointerException("Given list of data items must not be null");
        }
        if (dataList.isEmpty()) {
            return;
        }
        List<? extends CidsBean> residentReBe = this.tableModel.getCidsBeans();
        int rowCountBefore = this.tableModel.getRowCount();
        MappingComponent mc = LagisBroker.getInstance().getMappingComponent();
        FeatureCollection fc = mc.getFeatureCollection();
        for (BasicEntity entity : dataList) {
            if (!(entity instanceof RebeCustomBean)) continue;
            if (residentReBe.contains(entity)) {
                this.log.warn((Object)("ReBe " + entity + " does already exist -> ignored"));
                continue;
            }
            this.tableModel.addCidsBean((RebeCustomBean)entity);
            CustomSelectionStyledFeatureGroupWrapper wrapper = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)entity, PROVIDER_NAME, PROVIDER_NAME);
            fc.addFeature((Feature)wrapper);
        }
        if (rowCountBefore == this.tableModel.getRowCount()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No ReBe items were added from input list " + dataList));
            }
        } else {
            this.tableModel.fireTableDataChanged();
            mc.setGroupLayerVisibility(PROVIDER_NAME, true);
        }
    }

    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        this.log.info((Object)"FlurstueckChanged");
        try {
            this.clearComponent();
            FlurstueckArtCustomBean flurstueckArt = newFlurstueck.getFlurstueckSchluessel().getFlurstueckArt();
            if (flurstueckArt != null && flurstueckArt.getBezeichnung().equals("st\u00e4dtisch")) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Flurst\u00fcck ist nicht Abteilung IX");
                }
                this.tableModel.setIsReBeKindSwitchAllowed(true);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Flurst\u00fcck ist Abteilung IX");
                }
                this.tableModel.setIsReBeKindSwitchAllowed(false);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Fehler beim Flurst\u00fcckswechsel: ", (Throwable)ex);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ReBe --> setComponentEditable");
        }
        this.isInEditMode = isEditable;
        TableCellEditor currentEditor = this.tReBe.getCellEditor();
        if (currentEditor != null) {
            currentEditor.cancelCellEditing();
        }
        if (isEditable && this.tReBe.getSelectedRow() != -1) {
            this.btnRemoveReBe.setEnabled(true);
        } else if (!isEditable) {
            this.btnRemoveReBe.setEnabled(isEditable);
        }
        this.btnAddReBe.setEnabled(isEditable);
        this.tableModel.setInEditMode(isEditable);
        this.btnUndo.setEnabled(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ReBe --> setComponentEditable finished");
        }
    }

    @Override
    public synchronized void clearComponent() {
        this.tableModel.refreshTableModel(new HashSet());
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tReBe = new ReBeTable();
        this.jPanel1 = new JPanel();
        this.btnRemoveReBe = new JButton();
        this.btnAddReBe = new JButton();
        this.tbtnSort = new JToggleButton();
        this.btnUndo = new JButton();
        this.setLayout(new GridBagLayout());
        this.tReBe.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tReBe.setModel(new DefaultTableModel(new Object[][]{{"Recht", "Baulast", "1", "Wegerecht", "12AZ7095", "28.12.03", "", null}, {"Belastung", "Pers\u00f6nliche Dienstbarkeit", "1", "Leitungsrecht", "12HU9994", "09.05.03", "", null}}, new String[]{"Recht/Belastung", "Art", DEF_TARGET_COL, "Beschreibung", "Eintragung AZ", "Eintragung Datum", "L\u00f6schung AZ", "L\u00f6schung Datum"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.tReBe);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnRemoveReBe.setAction(((ReBeTable)((Object)this.tReBe)).getRemoveAction());
        this.btnRemoveReBe.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveReBe.setBorder(null);
        this.btnRemoveReBe.setBorderPainted(false);
        this.btnRemoveReBe.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveReBe.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveReBe.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 3, 4, 3);
        this.jPanel1.add((Component)this.btnRemoveReBe, gridBagConstraints);
        this.btnAddReBe.setAction(((ReBeTable)((Object)this.tReBe)).getAddAction());
        this.btnAddReBe.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddReBe.setBorder(null);
        this.btnAddReBe.setBorderPainted(false);
        this.btnAddReBe.setMaximumSize(new Dimension(25, 25));
        this.btnAddReBe.setMinimumSize(new Dimension(25, 25));
        this.btnAddReBe.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 3, 4, 3);
        this.jPanel1.add((Component)this.btnAddReBe, gridBagConstraints);
        this.tbtnSort.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.tbtnSort.setToolTipText("Sortierung An / Aus");
        this.tbtnSort.setBorderPainted(false);
        this.tbtnSort.setContentAreaFilled(false);
        this.tbtnSort.setMaximumSize(new Dimension(25, 25));
        this.tbtnSort.setMinimumSize(new Dimension(25, 25));
        this.tbtnSort.setPreferredSize(new Dimension(25, 25));
        this.tbtnSort.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 3, 4, 3);
        this.jPanel1.add((Component)this.tbtnSort, gridBagConstraints);
        this.tbtnSort.addItemListener(((ReBeTable)((Object)this.tReBe)).getSortItemListener());
        this.btnUndo.setAction(((ReBeTable)((Object)this.tReBe)).getUndoAction());
        this.btnUndo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/undo.png")));
        this.btnUndo.setBorderPainted(false);
        this.btnUndo.setMaximumSize(new Dimension(25, 25));
        this.btnUndo.setMinimumSize(new Dimension(25, 25));
        this.btnUndo.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 3, 4, 3);
        this.jPanel1.add((Component)this.btnUndo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof JXTable) {
            int selecetdRow;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Mit maus auf ReBeTabelle geklickt");
            }
            if ((selecetdRow = this.tReBe.getSelectedRow()) != -1) {
                if (this.isInEditMode) {
                    this.btnRemoveReBe.setEnabled(true);
                }
            } else {
                this.btnRemoveReBe.setEnabled(false);
            }
        }
    }

    @Override
    public Vector<GeometrySlotInformation> getSlotInformation() {
        Vector<GeometrySlotInformation> result = new Vector<GeometrySlotInformation>();
        if (this.isWidgetReadOnly()) {
            return result;
        }
        int rowCount = this.tableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            RebeCustomBean currentReBe = (RebeCustomBean)this.tableModel.getCidsBeanAtRow(i);
            if (currentReBe.getGeometry() != null) continue;
            Object idValue1 = this.tableModel.getValueAt(i, 0);
            Object idValue2 = this.tableModel.getValueAt(i, 3);
            String identifer = idValue1 != null && idValue2 != null ? (((Boolean)idValue1).booleanValue() ? "Recht" + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + idValue2.toString() : "Belastung" + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + idValue2.toString()) : (idValue1 != null ? (((Boolean)idValue1).booleanValue() ? "Recht" + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + "Keine Nummer" : "Belastung" + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + "Keine Nummer") : (idValue2 != null ? "Belastung" + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + idValue2.toString() : "Belastung" + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + "Kein Nummer"));
            result.add(new GeometrySlotInformation(this.getProviderName(), identifer, currentReBe, this));
        }
        return result;
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public void updateFlurstueckForSaving(FlurstueckCustomBean flurstueck) {
        List<RebeCustomBean> rebes = LagisBroker.getInstance().getCurrentRebes();
        for (RebeCustomBean rebeCustomBean : this.tableModel.getCidsBeans()) {
            if (rebes.contains(rebeCustomBean)) continue;
            rebes.add(rebeCustomBean);
        }
    }

    @Override
    public synchronized void featureSelectionChanged(Collection<Feature> features) {
        ((ReBeTable)((Object)this.tReBe)).featureSelectionChanged(this, features, RebeCustomBean.class);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        if (this.tReBe.getSelectedRow() != -1) {
            if (this.isInEditMode) {
                this.btnRemoveReBe.setEnabled(true);
            } else {
                this.btnRemoveReBe.setEnabled(false);
            }
            ((ReBeTable)((Object)this.tReBe)).valueChanged_updateFeatures(this, e);
        } else {
            this.btnRemoveReBe.setEnabled(false);
        }
        this.setFeatureSelectionChangedEnabled(true);
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }

    @Override
    public int getStatus() {
        if (this.tReBe.getCellEditor() != null) {
            this.validationMessage = "Bitte vollenden Sie alle \u00c4nderungen bei den Rechten und Belastungen.";
            return 2;
        }
        return 0;
    }

    private void cboBooleanEditorActionPerformed() {
        TableCellEditor currentEditor;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"rechtCheckboxAction");
        }
        if ((currentEditor = this.tReBe.getCellEditor()) != null) {
            currentEditor.stopCellEditing();
        }
        for (Feature feature : LagisBroker.getInstance().getMappingComponent().getFeatureCollection().getSelectedFeatures()) {
            LagisBroker.getInstance().getMappingComponent().getFeatureCollection().reconsiderFeature(feature);
        }
    }

    @Override
    public String getDisplayName(BasicEntity entity) {
        if (entity instanceof RebeCustomBean) {
            RebeCustomBean rebe = (RebeCustomBean)entity;
            return "ReBe - " + (rebe.isRecht() ? "Recht" : "Belastung") + " - " + rebe.getNummer();
        }
        return "unbekannt";
    }

    @Override
    public Icon getDisplayIcon() {
        return this.copyDisplayIcon;
    }

    @Override
    public boolean knowsDisplayName(BasicEntity entity) {
        return entity instanceof RebeCustomBean;
    }

    @Override
    public boolean isFeatureSelectionChangedEnabled() {
        return this.listenerEnabled;
    }

    @Override
    public void setFeatureSelectionChangedEnabled(boolean listenerEnabled) {
        this.listenerEnabled = listenerEnabled;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentRebes".equals(evt.getPropertyName())) {
            this.tableModel.refreshTableModel((Collection)evt.getNewValue());
            ArrayList<Feature> features = this.tableModel.getAllReBeFeatures();
            if (features != null) {
                for (Feature currentFeature : features) {
                    if (currentFeature == null) continue;
                    if (this.isWidgetReadOnly()) {
                        ((RebeCustomBean)currentFeature).setModifiable(false);
                    }
                    CustomSelectionStyledFeatureGroupWrapper sf = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)currentFeature, PROVIDER_NAME, PROVIDER_NAME);
                    LagisBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature((Feature)sf);
                }
            }
        }
    }
}

