/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.KassenzeichenPanel;
import de.cismet.lagis.gui.tables.KassenzeichenTable;
import de.cismet.layout.FadingCardLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbBundle;

public class VerdisCrossoverPanel
extends JPanel
implements MouseListener,
ListSelectionListener {
    private static final Logger log = Logger.getLogger(VerdisCrossoverPanel.class);
    private static final String server = "http://localhost:";
    private static final String request = "/gotoKassenzeichen?";
    public static final NameValuePair PARAMETER_KASSENZEICHEN = new NameValuePair("kassenzeichen", "");
    private static final String PROGRESS_CARD_NAME = "progress";
    private static final String CONTENT_CARD_NAME = "content";
    private static final String MESSAGE_CARD_NAME = "message";
    private static final String SWITCH_TO_MENU_NAME = "Zu Kassenzeichen wechseln";
    private final KassenzeichenTableModel tableModel = new KassenzeichenTableModel();
    private FadingCardLayout layout = new FadingCardLayout();
    private JPopupMenu switchToKassenzeichenPopup;
    private JButton btnClose;
    private JButton btnLoadSelectedKassenzeichen;
    private JButton btnLoadSelectedKassenzeichen1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lblMessage;
    private JPanel panAll;
    private JPanel panContent;
    private JPanel panContentMessage;
    private JPanel panContentProgress;
    private JPanel panControl;
    private JProgressBar pgbProgress;
    private JTable tblKassenzeichen;

    public VerdisCrossoverPanel() {
        this.initComponents();
        this.configurePopupMenue();
        this.panAll.setLayout((LayoutManager)this.layout);
        this.panAll.removeAll();
        this.panAll.add((Component)this.panContentProgress, PROGRESS_CARD_NAME);
        this.panAll.add((Component)this.panContent, CONTENT_CARD_NAME);
        this.panAll.add((Component)this.panContentMessage, MESSAGE_CARD_NAME);
        this.tblKassenzeichen.setModel(this.tableModel);
        this.tblKassenzeichen.addMouseListener(this);
        this.tblKassenzeichen.addMouseListener(new PopupListener());
        this.tblKassenzeichen.getSelectionModel().addListSelectionListener(this);
        this.pgbProgress.setIndeterminate(true);
        this.layout.show((Container)this.panAll, PROGRESS_CARD_NAME);
    }

    public void startSearch() {
        try {
            LagisBroker.getInstance().execute(new KassenzeichenRetriever());
        }
        catch (Exception ex) {
            log.error((Object)"Fehler w\u00e4hrend dem suchen der Kassenzeichen: ", (Throwable)ex);
        }
    }

    private void initComponents() {
        this.panControl = new JPanel();
        this.jPanel1 = new JPanel();
        this.btnClose = new JButton();
        this.btnLoadSelectedKassenzeichen = new JButton();
        this.btnLoadSelectedKassenzeichen1 = new JButton();
        this.jPanel2 = new JPanel();
        this.panAll = new JPanel();
        this.panContentProgress = new JPanel();
        this.pgbProgress = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.panContentMessage = new JPanel();
        this.lblMessage = new JLabel();
        this.jLabel3 = new JLabel();
        this.panContent = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblKassenzeichen = new JXTable();
        this.setPreferredSize(new Dimension(500, 200));
        this.setLayout(new GridBagLayout());
        this.panControl.setMinimumSize(new Dimension(50, 50));
        this.panControl.setPreferredSize(new Dimension(300, 50));
        this.panControl.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnClose.setText(NbBundle.getMessage(VerdisCrossoverPanel.class, (String)"VerdisCrossoverPanel.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerdisCrossoverPanel.this.btnCloseActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 2, 6);
        this.jPanel1.add((Component)this.btnClose, gridBagConstraints);
        this.btnLoadSelectedKassenzeichen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/postion.png")));
        this.btnLoadSelectedKassenzeichen.setText(NbBundle.getMessage(VerdisCrossoverPanel.class, (String)"VerdisCrossoverPanel.btnLoadSelectedKassenzeichen.text"));
        this.btnLoadSelectedKassenzeichen.setToolTipText(NbBundle.getMessage(VerdisCrossoverPanel.class, (String)"VerdisCrossoverPanel.btnLoadSelectedKassenzeichen.toolTipText"));
        this.btnLoadSelectedKassenzeichen.setEnabled(false);
        this.btnLoadSelectedKassenzeichen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerdisCrossoverPanel.this.btnLoadSelectedKassenzeichenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 2, 6);
        this.jPanel1.add((Component)this.btnLoadSelectedKassenzeichen, gridBagConstraints);
        this.btnLoadSelectedKassenzeichen1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/kassenzeicheninfo_add.png")));
        this.btnLoadSelectedKassenzeichen1.setText(NbBundle.getMessage(VerdisCrossoverPanel.class, (String)"VerdisCrossoverPanel.btnLoadSelectedKassenzeichen1.text"));
        this.btnLoadSelectedKassenzeichen1.setToolTipText(NbBundle.getMessage(VerdisCrossoverPanel.class, (String)"VerdisCrossoverPanel.btnLoadSelectedKassenzeichen1.toolTipText"));
        this.btnLoadSelectedKassenzeichen1.setEnabled(false);
        this.btnLoadSelectedKassenzeichen1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerdisCrossoverPanel.this.btnLoadSelectedKassenzeichen1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 2, 6);
        this.jPanel1.add((Component)this.btnLoadSelectedKassenzeichen1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panControl.add((Component)this.jPanel1, gridBagConstraints);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panControl.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.panControl, gridBagConstraints);
        this.panAll.setPreferredSize(new Dimension(400, 251));
        this.panAll.setLayout(new CardLayout());
        this.panContentProgress.setPreferredSize(new Dimension(250, 140));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/searching.png")));
        this.jLabel2.setText(NbBundle.getMessage(VerdisCrossoverPanel.class, (String)"VerdisCrossoverPanel.jLabel2.text"));
        GroupLayout panContentProgressLayout = new GroupLayout(this.panContentProgress);
        this.panContentProgress.setLayout(panContentProgressLayout);
        panContentProgressLayout.setHorizontalGroup(panContentProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panContentProgressLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panContentProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pgbProgress, -1, 384, Short.MAX_VALUE).addComponent(this.jLabel2)).addContainerGap()));
        panContentProgressLayout.setVerticalGroup(panContentProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panContentProgressLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(panContentProgressLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(panContentProgressLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pgbProgress, -2, -1, -2).addGap(12, 12, 12)).addComponent(this.jLabel1, -2, 67, -2)).addContainerGap()));
        this.panAll.add((Component)this.panContentProgress, "card3");
        this.panContentMessage.setPreferredSize(new Dimension(250, 140));
        this.lblMessage.setText(NbBundle.getMessage(VerdisCrossoverPanel.class, (String)"VerdisCrossoverPanel.lblMessage.text"));
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/warn.png")));
        this.jLabel3.setText(NbBundle.getMessage(VerdisCrossoverPanel.class, (String)"VerdisCrossoverPanel.jLabel3.text"));
        GroupLayout panContentMessageLayout = new GroupLayout(this.panContentMessage);
        this.panContentMessage.setLayout(panContentMessageLayout);
        panContentMessageLayout.setHorizontalGroup(panContentMessageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panContentMessageLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel3, -2, 54, -2).addGap(18, 18, 18).addComponent(this.lblMessage, -2, 388, -2).addContainerGap()));
        panContentMessageLayout.setVerticalGroup(panContentMessageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panContentMessageLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(panContentMessageLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, -2, 67, -2).addComponent(this.lblMessage, -2, 59, -2)).addContainerGap()));
        this.panAll.add((Component)this.panContentMessage, "card2");
        this.tblKassenzeichen.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tblKassenzeichen);
        GroupLayout panContentLayout = new GroupLayout(this.panContent);
        this.panContent.setLayout(panContentLayout);
        panContentLayout.setHorizontalGroup(panContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panContentLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 460, Short.MAX_VALUE).addContainerGap()));
        panContentLayout.setVerticalGroup(panContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panContentLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 120, Short.MAX_VALUE).addContainerGap()));
        this.panAll.add((Component)this.panContent, "card4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panAll, gridBagConstraints);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void btnLoadSelectedKassenzeichenActionPerformed(ActionEvent evt) {
        this.loadSelectedKassenzeichen();
    }

    private void btnLoadSelectedKassenzeichen1ActionPerformed(ActionEvent evt) {
        this.addSelectedKassenzeichenToList();
    }

    private void closeDialog() {
        ((JDialog)this.getParent().getParent().getParent().getParent()).dispose();
    }

    private void configurePopupMenue() {
        this.switchToKassenzeichenPopup = new JPopupMenu();
        JMenuItem switchToKassenZeichenItem = new JMenuItem(SWITCH_TO_MENU_NAME);
        switchToKassenZeichenItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"action performed");
                }
                VerdisCrossoverPanel.this.loadSelectedKassenzeichen();
            }
        });
        this.switchToKassenzeichenPopup.add(switchToKassenZeichenItem);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Crossover: mouse clicked");
            log.debug((Object)("tableModelsize: " + this.tableModel.getRowCount()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("tableModel content: " + this.tableModel.getAllKassenzeichen()));
        }
        if ((source = e.getSource()) instanceof JXTable) {
            if (e.getClickCount() > 1) {
                this.loadSelectedKassenzeichen();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Crossover: Kein Multiclick");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Crossover:Mouselistner nicht f\u00fcr JXTable");
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void loadSelectedKassenzeichen() {
        try {
            int selectedRow = this.tblKassenzeichen.getSelectedRow();
            if (selectedRow != -1) {
                int modelIndex = ((JXTable)this.tblKassenzeichen).convertRowIndexToModel(selectedRow);
                if (modelIndex != -1) {
                    CidsBean selectedKassenzeichen = this.tableModel.getKassenzeichenAtIndex(modelIndex);
                    if (selectedKassenzeichen != null) {
                        LagisBroker.getInstance().openKassenzeichenInVerdis(selectedKassenzeichen);
                    } else {
                        log.warn((Object)"Crossover: Kein Kassenzeichen zu angebenen Index.");
                    }
                } else {
                    log.warn((Object)"Crossover: Kein ModelIndex zu angebenen ViewIndex.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Crossover: Keine Tabellenzeile selektiert.");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Fehler beim laden des selektierten Kasssenzeichens", (Throwable)ex);
        }
    }

    private void addSelectedKassenzeichenToList() {
        try {
            CidsBean selectedKassenzeichen;
            int modelIndex;
            int selectedRow = this.tblKassenzeichen.getSelectedRow();
            if (selectedRow != -1 && (modelIndex = ((JXTable)this.tblKassenzeichen).convertRowIndexToModel(selectedRow)) != -1 && (selectedKassenzeichen = this.tableModel.getKassenzeichenAtIndex(modelIndex)) != null) {
                ((KassenzeichenTable)((Object)KassenzeichenPanel.getInstance().getTable())).addNewKassenzeichen((Integer)selectedKassenzeichen.getProperty("kassenzeichennummer8"));
            }
        }
        catch (Exception ex) {
            log.error((Object)"Fehler beim hinzuf\u00fcgen des selektierten Kasssenzeichens", (Throwable)ex);
        }
    }

    public static URL createQuery(int port, CidsBean bean) {
        if (port < 0 || port > 65535) {
            log.warn((Object)("Crossover: verdisCrossoverPort ist ung\u00fcltig: " + port));
        } else {
            try {
                PARAMETER_KASSENZEICHEN.setValue(String.valueOf(bean.getProperty("kassenzeichennummer8")));
                GetMethod tmp = new GetMethod(server + port + request);
                tmp.setQueryString(new NameValuePair[]{PARAMETER_KASSENZEICHEN});
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Crossover: verdisCrossOverQuery: " + tmp.getURI().toString()));
                }
                return new URL(tmp.getURI().toString());
            }
            catch (Exception ex) {
                log.error((Object)"Crossover: Fehler beim fernsteuern von VerdIS.", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tblKassenzeichen.getSelectedRowCount() > 0) {
            this.btnLoadSelectedKassenzeichen.setEnabled(true);
            this.btnLoadSelectedKassenzeichen1.setEnabled(LagisBroker.getInstance().isInEditMode());
        } else {
            this.btnLoadSelectedKassenzeichen.setEnabled(false);
            this.btnLoadSelectedKassenzeichen1.setEnabled(false);
        }
    }

    class KassenzeichenRetriever
    extends SwingWorker<Set<CidsBean>, Void> {
        KassenzeichenRetriever() {
        }

        @Override
        protected Set<CidsBean> doInBackground() throws Exception {
            FlurstueckSchluesselCustomBean currentKey = LagisBroker.getInstance().getCurrentFlurstueckSchluessel();
            if (currentKey != null) {
                LagisBroker.getInstance();
                Geometry flurstueckGeom = LagisBroker.getInstance().getCurrentWFSGeometry();
                if (flurstueckGeom != null) {
                    double buffer = flurstueckGeom.getArea() > 100.0 ? LagisBroker.getInstance().getKassenzeichenBuffer100() : LagisBroker.getInstance().getKassenzeichenBuffer();
                    String query = "SELECT 11, k.id FROM kassenzeichen k, kassenzeichen_geometrien kgarr, kassenzeichen_geometrie kg, geom WHERE k.id = kgarr.kassenzeichen_reference AND kg.id = kgarr.kassenzeichen_geometrie AND kg.geometrie = geom.id AND not st_isEmpty(geom.geo_field) AND st_intersects(geom.geo_field,st_buffer(st_buffer(st_geometryfromtext('" + flurstueckGeom.toString() + "',25832), " + buffer + "), 0))";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)query);
                    }
                    if (this.isCancelled()) {
                        return null;
                    }
                    MetaObject[] result = CidsBroker.getInstance().getMetaObject(query, "VERDIS_GRUNDIS");
                    HashSet<CidsBean> kassenzeichen = new HashSet<CidsBean>(result == null ? 0 : result.length);
                    if (result != null) {
                        for (int i = 0; i < result.length; ++i) {
                            kassenzeichen.add(result[i].getBean());
                        }
                    }
                    if (kassenzeichen != null && kassenzeichen.size() > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Crossover: Anzahl Kassenzeichen: " + kassenzeichen.size()));
                        }
                    } else {
                        log.info((Object)"Crossover:Keine geschnittenen Kassenzeichen gefunden.");
                    }
                    return kassenzeichen;
                }
                VerdisCrossoverPanel.this.lblMessage.setText("<html>Keine Flurst\u00fccksgeometrie vorhanden,<br/>bestimmen der Kasssenzeichen nicht m\u00f6glich.</html>");
                log.warn((Object)"Crossover: Keine Geometrie vorhanden zum bestimmen der Kassenzeichen");
            } else {
                VerdisCrossoverPanel.this.lblMessage.setText("<html>Bitte w\u00e4hlen Sie ein Flurst\u00fcck aus,<br/>damit Kassenzeichen bestimmt werden k\u00f6nnen.</html > ");
                log.warn((Object)"Crossover: Kein  Flurst\u00fcck ausgew\u00e4hlt kann Lagis Kassenzeichen nicht bestimmen");
            }
            return null;
        }

        @Override
        protected void done() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"KassenzeichenRetriever done.");
            }
            super.done();
            if (this.isCancelled() && log.isDebugEnabled()) {
                log.debug((Object)"Kassenzeichen retriever canceled.Nothing to do {}");
            }
            try {
                HashSet results = (HashSet)this.get();
                if (results == null) {
                    results = new HashSet();
                    VerdisCrossoverPanel.this.tableModel.updateTableModel(results);
                    VerdisCrossoverPanel.this.layout.show((Container)VerdisCrossoverPanel.this.panAll, VerdisCrossoverPanel.MESSAGE_CARD_NAME);
                } else {
                    VerdisCrossoverPanel.this.tableModel.updateTableModel(results);
                    VerdisCrossoverPanel.this.layout.show((Container)VerdisCrossoverPanel.this.panAll, VerdisCrossoverPanel.CONTENT_CARD_NAME);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Fehler beim verarbeiten der Ergebnisse: ", (Throwable)ex);
                VerdisCrossoverPanel.this.tableModel.updateTableModel(new HashSet());
                VerdisCrossoverPanel.this.lblMessage.setText("<html>Fehler beim abfragen<br/>der Kassenzeichen.< /html >");
                VerdisCrossoverPanel.this.layout.show((Container)VerdisCrossoverPanel.this.panAll, VerdisCrossoverPanel.MESSAGE_CARD_NAME);
            }
            VerdisCrossoverPanel.this.revalidate();
            VerdisCrossoverPanel.this.repaint();
            ((JDialog)VerdisCrossoverPanel.this.getParent().getParent().getParent().getParent()).repaint();
        }
    }

    public class KassenzeichenTableModel
    extends AbstractTableModel {
        private final String[] COLUMN_HEADER = new String[]{"Kassenzeichen"};
        private final ArrayList<CidsBean> data = new ArrayList();

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CidsBean value = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return value.getProperty("kassenzeichennummer8");
                }
            }
            return "Spalte ist nicht definiert";
        }

        public void updateTableModel(Set newData) {
            this.data.clear();
            if (newData != null) {
                this.data.addAll(newData);
            }
            this.fireTableDataChanged();
        }

        public CidsBean getKassenzeichenAtIndex(int index) {
            return this.data.get(index);
        }

        public ArrayList getAllKassenzeichen() {
            return this.data;
        }

        @Override
        public String getColumnName(int column) {
            return this.COLUMN_HEADER[column];
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"showPopup");
            }
            if (e.isPopupTrigger()) {
                int rowAtPoint;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"popup triggered");
                }
                if ((rowAtPoint = VerdisCrossoverPanel.this.tblKassenzeichen.rowAtPoint(new Point(e.getX(), e.getY()))) != -1 && VerdisCrossoverPanel.this.tableModel.getKassenzeichenAtIndex(((JXTable)VerdisCrossoverPanel.this.tblKassenzeichen).convertRowIndexToModel(rowAtPoint)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"KassenzeichenEntity found");
                    }
                    VerdisCrossoverPanel.this.switchToKassenzeichenPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

