/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.cids.custom.beans.lagis.BeschlussCustomBean;
import de.cismet.cids.custom.beans.lagis.BeschlussartCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.KostenCustomBean;
import de.cismet.cids.custom.beans.lagis.KostenartCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragsartCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.editor.DateEditor;
import de.cismet.lagis.editor.EuroEditor;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.gui.panels.AddExistingVorgangPanel;
import de.cismet.lagis.gui.tables.BeschluesseTable;
import de.cismet.lagis.gui.tables.KostenTable;
import de.cismet.lagis.gui.tables.RemoveActionHelper;
import de.cismet.lagis.gui.tables.VertraegeTable;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.models.DefaultUniqueListModel;
import de.cismet.lagis.models.VertraegeTableModel;
import de.cismet.lagis.models.documents.VertragDocumentModelContainer;
import de.cismet.lagis.renderer.DateRenderer;
import de.cismet.lagis.renderer.EuroRenderer;
import de.cismet.lagis.renderer.FlurstueckSchluesselRenderer;
import de.cismet.lagis.util.LagISUtils;
import de.cismet.lagis.util.TableSelectionUtils;
import de.cismet.lagis.validation.Validator;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;

public class VertraegePanel
extends AbstractWidget
implements FlurstueckChangeListener,
FlurstueckSaver,
ListSelectionListener,
MouseListener,
RemoveActionHelper {
    private static final String WIDGET_NAME = "Vertr\u00e4ge Panel";
    private static final Logger LOG = Logger.getLogger(VertraegePanel.class);
    private final VertraegeTableModel vTableModel = new VertraegeTableModel();
    private final VertragDocumentModelContainer documentContainer;
    private final Validator valTxtVoreigentuemer;
    private final Validator valTxtAuflassung;
    private final Validator valTxtKaufpreis;
    private final Validator valTxtQuadPreis;
    private final Validator valTxtAktenzeichen;
    private final Validator valTxtBemerkung;
    private final Validator valTxtEintragung;
    private final Vector<Validator> validators = new Vector();
    private final ImageIcon icoExistingContract = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/contract.png"));
    private boolean isInEditMode = false;
    private boolean isFlurstueckEditable = true;
    private JButton btnAddBeschluss;
    private JButton btnAddExitingContract;
    private JButton btnAddKosten;
    private JButton btnAddVertrag;
    private JButton btnRemoveBeschluss;
    private JButton btnRemoveKosten;
    private JButton btnRemoveVertrag;
    private JComboBox cboVertragsart;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JLabel lblAktenzeichen;
    private JLabel lblAuflassung;
    private JLabel lblBemerkung;
    private JLabel lblEintragung;
    private JLabel lblKaufpreis;
    private JLabel lblQuadPreis;
    private JLabel lblVertragsart;
    private JLabel lblVoreigentuemer;
    private JList lstCrossRefs;
    private JPanel panBemerkung;
    private JPanel panBeschluss;
    private JPanel panData;
    private JPanel panKosten;
    private JPanel panQuerverweise;
    private JPanel panTab;
    private JPanel panVertraege;
    private JPanel pnlBeschluesseControls;
    private JPanel pnlDetail;
    private JPanel pnlKostenControls;
    private JPanel pnlKostenControls1;
    private JTabbedPane tabKB;
    private JTable tblBeschluesse;
    private JTable tblKosten;
    private JTable tblVertraege;
    private JToggleButton tbtnSortBeschluss;
    private JToggleButton tbtnSortKosten;
    private JToggleButton tbtnSortVertrag;
    private JTextField txtAktenzeichen;
    private JTextField txtAuflassung;
    private JTextArea txtBemerkung;
    private JTextField txtEintragung;
    private JTextField txtKaufpreis;
    private JTextField txtQuadPreis;
    private JTextField txtVoreigentuemer;

    public VertraegePanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        TableSelectionUtils.crossReferenceModelAndTable(this.vTableModel, (VertraegeTable)((Object)this.tblVertraege));
        this.documentContainer = new VertragDocumentModelContainer(this.vTableModel);
        ((VertraegeTable)((Object)this.tblVertraege)).setDocumentContainer(this.documentContainer);
        this.tblVertraege.addMouseListener(this.documentContainer);
        ((VertraegeTable)((Object)this.tblVertraege)).setRemoveActionHelper(this);
        this.txtKaufpreis.setDocument(this.documentContainer.getKaufpreisDocumentModel());
        this.valTxtKaufpreis = new Validator(this.txtKaufpreis);
        this.valTxtKaufpreis.reSetValidator(this.documentContainer.getKaufpreisDocumentModel());
        this.txtAuflassung.setDocument(this.documentContainer.getAuflassungDocumentModel());
        this.valTxtAuflassung = new Validator(this.txtAuflassung);
        this.valTxtAuflassung.reSetValidator(this.documentContainer.getAuflassungDocumentModel());
        this.txtVoreigentuemer.setDocument(this.documentContainer.getVoreigentuemerDocumentModel());
        this.valTxtVoreigentuemer = new Validator(this.txtVoreigentuemer);
        this.valTxtVoreigentuemer.reSetValidator(this.documentContainer.getVoreigentuemerDocumentModel());
        this.txtQuadPreis.setDocument(this.documentContainer.getQuadPreisDocumentModel());
        this.valTxtQuadPreis = new Validator(this.txtQuadPreis);
        this.valTxtQuadPreis.reSetValidator(this.documentContainer.getQuadPreisDocumentModel());
        this.txtAktenzeichen.setDocument(this.documentContainer.getAktenzeichenDocumentModel());
        this.valTxtAktenzeichen = new Validator(this.txtAktenzeichen);
        this.valTxtAktenzeichen.reSetValidator(this.documentContainer.getAktenzeichenDocumentModel());
        this.txtBemerkung.setDocument(this.documentContainer.getBemerkungDocumentModel());
        this.valTxtBemerkung = new Validator(this.txtBemerkung);
        this.valTxtBemerkung.reSetValidator(this.documentContainer.getBemerkungDocumentModel());
        this.txtEintragung.setDocument(this.documentContainer.getEintragungDocumentModel());
        this.valTxtEintragung = new Validator(this.txtEintragung);
        this.valTxtEintragung.reSetValidator(this.documentContainer.getEintragungDocumentModel());
        this.cboVertragsart.setModel(this.documentContainer.getVertragsartComboBoxModel());
        this.cboVertragsart.addActionListener(this.documentContainer);
        ((KostenTable)((Object)this.tblKosten)).setDocumentContainer(this.documentContainer);
        TableSelectionUtils.crossReferenceModelAndTable(this.documentContainer.getKostenTableModel(), (KostenTable)((Object)this.tblKosten));
        ((BeschluesseTable)((Object)this.tblBeschluesse)).setDocumentContainer(this.documentContainer);
        TableSelectionUtils.crossReferenceModelAndTable(this.documentContainer.getBeschluesseTableModel(), (BeschluesseTable)((Object)this.tblBeschluesse));
        this.validators.add(this.valTxtAktenzeichen);
        this.validators.add(this.valTxtAuflassung);
        this.validators.add(this.valTxtBemerkung);
        this.validators.add(this.valTxtEintragung);
        this.validators.add(this.valTxtKaufpreis);
        this.validators.add(this.valTxtQuadPreis);
        this.validators.add(this.valTxtVoreigentuemer);
        JComboBox<BeschlussartCustomBean> cboBA = new JComboBox<BeschlussartCustomBean>(new Vector<BeschlussartCustomBean>(LagisBroker.getInstance().getAllBeschlussarten()));
        JComboBox<KostenartCustomBean> cboKA = new JComboBox<KostenartCustomBean>(new Vector<KostenartCustomBean>(LagisBroker.getInstance().getAllKostenarten()));
        this.tblBeschluesse.setDefaultEditor(BeschlussartCustomBean.class, new DefaultCellEditor(cboBA));
        this.tblKosten.setDefaultEditor(KostenartCustomBean.class, new DefaultCellEditor(cboKA));
        this.tblKosten.setDefaultEditor(Double.class, new EuroEditor());
        this.tblKosten.setDefaultRenderer(Double.class, new EuroRenderer());
        this.tblKosten.getSelectionModel().addListSelectionListener(this);
        this.tblVertraege.getSelectionModel().addListSelectionListener(this);
        this.tblBeschluesse.getSelectionModel().addListSelectionListener(this);
        this.tblKosten.setDefaultEditor(Date.class, new DateEditor());
        this.tblKosten.setDefaultRenderer(Date.class, new DateRenderer());
        this.tblBeschluesse.setDefaultEditor(Date.class, new DateEditor());
        this.tblBeschluesse.setDefaultRenderer(Date.class, new DateRenderer());
        ((JXTable)this.tblVertraege).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER});
        ((JXTable)this.tblBeschluesse).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER});
        ((JXTable)this.tblKosten).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER});
        ((JXTable)this.tblVertraege).setSortOrder(0, SortOrder.ASCENDING);
        ((JXTable)this.tblBeschluesse).setSortOrder(1, SortOrder.ASCENDING);
        ((JXTable)this.tblKosten).setSortOrder(2, SortOrder.ASCENDING);
        this.enableSlaveFlieds(false);
        this.btnRemoveBeschluss.setEnabled(false);
        this.btnRemoveKosten.setEnabled(false);
        this.tblVertraege.addMouseListener(this);
        this.lstCrossRefs.setCellRenderer(new FlurstueckSchluesselRenderer());
        this.lstCrossRefs.setModel(new DefaultUniqueListModel());
        this.lstCrossRefs.setSelectionMode(0);
        this.lstCrossRefs.addMouseListener(this);
        ((JXTable)this.tblBeschluesse).packAll();
        ((JXTable)this.tblKosten).packAll();
        ((JXTable)this.tblVertraege).packAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            LOG.info((Object)"FlurstueckChanged");
            this.clearComponent();
            FlurstueckArtCustomBean flurstueckArt = newFlurstueck.getFlurstueckSchluessel().getFlurstueckArt();
            if (flurstueckArt != null && flurstueckArt.getBezeichnung().equals("st\u00e4dtisch")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist st\u00e4dtisch und kann editiert werden");
                }
                this.isFlurstueckEditable = true;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch und kann nicht editiert werden");
                }
                this.isFlurstueckEditable = false;
            }
            this.vTableModel.refreshTableModel(newFlurstueck.getVertraege());
            this.documentContainer.updateTableModel(this.vTableModel);
            Collection<FlurstueckSchluesselCustomBean> crossRefs = newFlurstueck.getVertraegeQuerverweise();
            if (crossRefs != null && crossRefs.size() > 0) {
                this.lstCrossRefs.setModel(new DefaultUniqueListModel(crossRefs));
                this.tabKB.setForegroundAt(0, Color.RED);
            } else {
                this.tabKB.setForegroundAt(0, null);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Flurst\u00fcckswechsel: ", (Throwable)ex);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        if (this.isFlurstueckEditable) {
            TableCellEditor currentBeschlussEditor;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Vertrag --> setComponentEditable");
            }
            this.isInEditMode = isEditable;
            this.lstCrossRefs.setEnabled(!isEditable);
            if (isEditable && this.tblVertraege.getSelectedRow() != -1) {
                this.btnRemoveVertrag.setEnabled(true);
            } else if (!isEditable) {
                this.btnRemoveVertrag.setEnabled(false);
            }
            if (this.tblVertraege.getSelectedRow() != -1) {
                this.enableSlaveFlieds(isEditable);
            } else if (!isEditable) {
                this.enableSlaveFlieds(isEditable);
                this.btnRemoveBeschluss.setEnabled(false);
                this.btnRemoveKosten.setEnabled(false);
            }
            TableCellEditor currentKostenEditor = this.tblKosten.getCellEditor();
            if (currentKostenEditor != null) {
                currentKostenEditor.cancelCellEditing();
            }
            if ((currentBeschlussEditor = this.tblVertraege.getCellEditor()) != null) {
                currentBeschlussEditor.cancelCellEditing();
            }
            this.btnAddExitingContract.setEnabled(isEditable);
            this.btnAddVertrag.setEnabled(isEditable);
            this.tbtnSortBeschluss.setEnabled(isEditable);
            this.tbtnSortKosten.setEnabled(isEditable);
            this.tbtnSortVertrag.setEnabled(isEditable);
            this.documentContainer.getBeschluesseTableModel().setInEditMode(isEditable);
            this.documentContainer.getKostenTableModel().setInEditMode(isEditable);
            this.tblKosten.setEnabled(isEditable);
            this.tblBeschluesse.setEnabled(isEditable);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Vertrag --> setComponentEditable finished");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch Verwaltungen k\u00f6nnen nicht editiert werden");
        }
    }

    @Override
    public synchronized void clearComponent() {
        this.vTableModel.refreshTableModel(null);
        this.documentContainer.clearComponents();
        this.cboVertragsart.setSelectedItem(null);
        this.lstCrossRefs.setModel(new DefaultUniqueListModel());
    }

    @Override
    public int getStatus() {
        if (this.tblBeschluesse.getCellEditor() != null || this.tblKosten.getCellEditor() != null) {
            this.validationMessage = "Bitte vollenden Sie alle \u00c4nderungen bei den Kosten/Beschl\u00fcssen.";
            return 2;
        }
        for (Validator current : this.validators) {
            if (current.getValidationState() == 0) continue;
            this.validationMessage = current.getValidationMessage();
            return 2;
        }
        ArrayList alleVertraege = (ArrayList)this.vTableModel.getCidsBeans();
        if (alleVertraege != null) {
            for (VertragCustomBean currentVertrag : alleVertraege) {
                if (currentVertrag != null && currentVertrag.getVertragsart() == null) {
                    this.validationMessage = "Bei allen Vertr\u00e4gen muss eine Vertragsart ausgew\u00e4hlt werden";
                    return 2;
                }
                if (currentVertrag != null && currentVertrag.getBeschluesse() != null) {
                    for (BeschlussCustomBean currentBeschluss : currentVertrag.getBeschluesse()) {
                        if (currentBeschluss.getBeschlussart() != null) continue;
                        this.validationMessage = "Bei allen Beschl\u00fcssen muss eine Beschlussart ausgew\u00e4hlt werden";
                        return 2;
                    }
                }
                if (currentVertrag == null || currentVertrag.getKosten() == null) continue;
                for (KostenCustomBean currentKosten : currentVertrag.getKosten()) {
                    if (currentKosten.getKostenart() != null) continue;
                    this.validationMessage = "Bei allen Kosten muss eine Kostenart ausgew\u00e4hlt werden";
                    return 2;
                }
            }
        }
        return 0;
    }

    public void validationStateChanged(Object validatedObject) {
        this.fireValidationStateChanged(validatedObject);
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    private void initComponents() {
        this.pnlDetail = new JPanel();
        this.panVertraege = new JPanel();
        this.pnlKostenControls1 = new JPanel();
        this.btnAddVertrag = new JButton();
        this.btnRemoveVertrag = new JButton();
        this.tbtnSortVertrag = new JToggleButton();
        this.btnAddExitingContract = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblVertraege = new VertraegeTable();
        this.jScrollPane3 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.panBemerkung = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.txtBemerkung = new JTextArea();
        this.lblBemerkung = new JLabel();
        this.panData = new JPanel();
        this.lblEintragung = new JLabel();
        this.txtEintragung = new JTextField();
        this.lblAktenzeichen = new JLabel();
        this.txtAktenzeichen = new JTextField();
        this.lblVertragsart = new JLabel();
        this.cboVertragsart = new JComboBox();
        this.lblQuadPreis = new JLabel();
        this.txtQuadPreis = new JTextField();
        this.lblKaufpreis = new JLabel();
        this.txtKaufpreis = new JTextField();
        this.lblAuflassung = new JLabel();
        this.txtAuflassung = new JTextField();
        this.txtVoreigentuemer = new JTextField();
        this.lblVoreigentuemer = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.panTab = new JPanel();
        this.tabKB = new JTabbedPane();
        this.panQuerverweise = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.lstCrossRefs = new JList();
        this.panKosten = new JPanel();
        this.pnlKostenControls = new JPanel();
        this.btnAddKosten = new JButton();
        this.btnRemoveKosten = new JButton();
        this.tbtnSortKosten = new JToggleButton();
        this.jScrollPane5 = new JScrollPane();
        this.tblKosten = new KostenTable();
        this.panBeschluss = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.tblBeschluesse = new BeschluesseTable();
        this.pnlBeschluesseControls = new JPanel();
        this.btnAddBeschluss = new JButton();
        this.btnRemoveBeschluss = new JButton();
        this.tbtnSortBeschluss = new JToggleButton();
        this.setLayout(new BorderLayout());
        this.pnlDetail.setLayout(new GridBagLayout());
        this.panVertraege.setMinimumSize(new Dimension(10, 120));
        this.panVertraege.setPreferredSize(new Dimension(10, 140));
        this.panVertraege.setLayout(new GridBagLayout());
        this.pnlKostenControls1.setLayout(new GridBagLayout());
        this.btnAddVertrag.setAction(((VertraegeTable)((Object)this.tblVertraege)).getAddAction());
        this.btnAddVertrag.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddVertrag.setBorder(null);
        this.btnAddVertrag.setBorderPainted(false);
        this.btnAddVertrag.setMaximumSize(new Dimension(25, 25));
        this.btnAddVertrag.setMinimumSize(new Dimension(25, 25));
        this.btnAddVertrag.setPreferredSize(new Dimension(25, 25));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlKostenControls1.add((Component)this.btnAddVertrag, gridBagConstraints);
        this.btnRemoveVertrag.setAction(((VertraegeTable)((Object)this.tblVertraege)).getRemoveAction());
        this.btnRemoveVertrag.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveVertrag.setBorder(null);
        this.btnRemoveVertrag.setBorderPainted(false);
        this.btnRemoveVertrag.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveVertrag.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveVertrag.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.pnlKostenControls1.add((Component)this.btnRemoveVertrag, gridBagConstraints);
        this.tbtnSortVertrag.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.tbtnSortVertrag.setToolTipText("Sortierung An / Aus");
        this.tbtnSortVertrag.setBorder(null);
        this.tbtnSortVertrag.setBorderPainted(false);
        this.tbtnSortVertrag.setContentAreaFilled(false);
        this.tbtnSortVertrag.setMaximumSize(new Dimension(25, 25));
        this.tbtnSortVertrag.setMinimumSize(new Dimension(25, 25));
        this.tbtnSortVertrag.setPreferredSize(new Dimension(25, 25));
        this.tbtnSortVertrag.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.pnlKostenControls1.add((Component)this.tbtnSortVertrag, gridBagConstraints);
        this.tbtnSortVertrag.addItemListener(((VertraegeTable)((Object)this.tblVertraege)).getSortItemListener());
        this.btnAddExitingContract.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/contract.png")));
        this.btnAddExitingContract.setBorder(null);
        this.btnAddExitingContract.setBorderPainted(false);
        this.btnAddExitingContract.setMaximumSize(new Dimension(25, 25));
        this.btnAddExitingContract.setMinimumSize(new Dimension(25, 25));
        this.btnAddExitingContract.setPreferredSize(new Dimension(25, 25));
        this.btnAddExitingContract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VertraegePanel.this.btnAddExitingContractActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlKostenControls1.add((Component)this.btnAddExitingContract, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panVertraege.add((Component)this.pnlKostenControls1, gridBagConstraints);
        this.jLabel1.setText("Vertr\u00e4ge:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.panVertraege.add((Component)this.jLabel1, gridBagConstraints);
        this.tblVertraege.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tblVertraege.setModel(new DefaultTableModel(new Object[][]{{"Verkauf", "105.12-147545", "14\u20ac", "8.946\u20ac"}}, new String[]{"Vertragsart", "Aktenzeichen", "Quadratmeterpreis", "Kaufpreis (i. NK)"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblVertraege.setPreferredSize(new Dimension(150, 18));
        ((VertraegeTable)((Object)this.tblVertraege)).setSortButton(this.tbtnSortVertrag);
        this.jScrollPane1.setViewportView(this.tblVertraege);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panVertraege.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.pnlDetail.add((Component)this.panVertraege, gridBagConstraints);
        this.jScrollPane3.setBorder(null);
        this.jScrollPane3.setViewportBorder(null);
        this.jPanel1.setLayout(new GridBagLayout());
        this.panBemerkung.setLayout(new GridBagLayout());
        this.txtBemerkung.setColumns(20);
        this.txtBemerkung.setLineWrap(true);
        this.txtBemerkung.setRows(5);
        this.jScrollPane4.setViewportView(this.txtBemerkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panBemerkung.add((Component)this.jScrollPane4, gridBagConstraints);
        this.lblBemerkung.setText("Bemerkung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panBemerkung.add((Component)this.lblBemerkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.panBemerkung, gridBagConstraints);
        this.panData.setLayout(new GridBagLayout());
        this.lblEintragung.setText("Eintragung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 12, 0, 0);
        this.panData.add((Component)this.lblEintragung, gridBagConstraints);
        this.txtEintragung.setText("16.03.05");
        this.txtEintragung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VertraegePanel.this.txtEintragungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panData.add((Component)this.txtEintragung, gridBagConstraints);
        this.lblAktenzeichen.setText("Aktenzeichen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panData.add((Component)this.lblAktenzeichen, gridBagConstraints);
        this.txtAktenzeichen.setText("21.06.04");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panData.add((Component)this.txtAktenzeichen, gridBagConstraints);
        this.lblVertragsart.setText("Vertragsart");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.panData.add((Component)this.lblVertragsart, gridBagConstraints);
        this.cboVertragsart.setModel(new DefaultComboBoxModel<String>(new String[]{"Kauf"}));
        this.cboVertragsart.setMinimumSize(new Dimension(6, 20));
        this.cboVertragsart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VertraegePanel.this.cboVertragsartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.panData.add((Component)this.cboVertragsart, gridBagConstraints);
        this.lblQuadPreis.setText("Quadradmeterpreis");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panData.add((Component)this.lblQuadPreis, gridBagConstraints);
        this.txtQuadPreis.setText("14,00\u20ac");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panData.add((Component)this.txtQuadPreis, gridBagConstraints);
        this.lblKaufpreis.setText("Kaufpreis (inkl. Nebenkosten)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panData.add((Component)this.lblKaufpreis, gridBagConstraints);
        this.txtKaufpreis.setText("8.946\u20ac");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panData.add((Component)this.txtKaufpreis, gridBagConstraints);
        this.lblAuflassung.setText("Auflassung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panData.add((Component)this.lblAuflassung, gridBagConstraints);
        this.txtAuflassung.setText("04.03.05");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.panData.add((Component)this.txtAuflassung, gridBagConstraints);
        this.txtVoreigentuemer.setText("Stadgemeinde Wuppertal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panData.add((Component)this.txtVoreigentuemer, gridBagConstraints);
        this.lblVoreigentuemer.setText("Voreigent\u00fcmer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.panData.add((Component)this.lblVoreigentuemer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.panData.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel1.add((Component)this.panData, gridBagConstraints);
        this.panTab.setLayout(new GridBagLayout());
        this.tabKB.setToolTipText("Sortierung An / Aus");
        this.panQuerverweise.setLayout(new GridBagLayout());
        this.jScrollPane2.setViewportView(this.lstCrossRefs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.panQuerverweise.add((Component)this.jScrollPane2, gridBagConstraints);
        this.tabKB.addTab("Querverweise", this.panQuerverweise);
        this.panKosten.setLayout(new GridBagLayout());
        this.pnlKostenControls.setLayout(new GridBagLayout());
        this.btnAddKosten.setAction(((KostenTable)((Object)this.tblKosten)).getAddAction());
        this.btnAddKosten.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddKosten.setBorder(null);
        this.btnAddKosten.setBorderPainted(false);
        this.btnAddKosten.setMaximumSize(new Dimension(25, 25));
        this.btnAddKosten.setMinimumSize(new Dimension(25, 25));
        this.btnAddKosten.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlKostenControls.add((Component)this.btnAddKosten, gridBagConstraints);
        this.btnRemoveKosten.setAction(((KostenTable)((Object)this.tblKosten)).getRemoveAction());
        this.btnRemoveKosten.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveKosten.setBorder(null);
        this.btnRemoveKosten.setBorderPainted(false);
        this.btnRemoveKosten.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveKosten.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveKosten.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.pnlKostenControls.add((Component)this.btnRemoveKosten, gridBagConstraints);
        this.tbtnSortKosten.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.tbtnSortKosten.setToolTipText("Sortierung An / Aus");
        this.tbtnSortKosten.setBorder(null);
        this.tbtnSortKosten.setBorderPainted(false);
        this.tbtnSortKosten.setContentAreaFilled(false);
        this.tbtnSortKosten.setMaximumSize(new Dimension(25, 25));
        this.tbtnSortKosten.setMinimumSize(new Dimension(25, 25));
        this.tbtnSortKosten.setPreferredSize(new Dimension(25, 25));
        this.tbtnSortKosten.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.pnlKostenControls.add((Component)this.tbtnSortKosten, gridBagConstraints);
        this.tbtnSortKosten.addItemListener(((KostenTable)((Object)this.tblKosten)).getSortItemListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.panKosten.add((Component)this.pnlKostenControls, gridBagConstraints);
        this.jScrollPane5.setPreferredSize(new Dimension(0, 0));
        this.tblKosten.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tblKosten.setModel(new DefaultTableModel(new Object[][]{{"Notar", "     120\u20ac", "27.10.03"}, {"Wiederbeschaffungskosten", "20.000\u20ac", "30.05.04"}}, new String[]{"Kostenart", "Betrag", "Datum"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        ((KostenTable)((Object)this.tblKosten)).setSortButton(this.tbtnSortKosten);
        this.jScrollPane5.setViewportView(this.tblKosten);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.panKosten.add((Component)this.jScrollPane5, gridBagConstraints);
        this.tabKB.addTab("Kosten", this.panKosten);
        this.panBeschluss.setLayout(new GridBagLayout());
        this.jScrollPane6.setPreferredSize(new Dimension(0, 0));
        this.tblBeschluesse.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tblBeschluesse.setModel(new DefaultTableModel(new Object[][]{{"Rat der Stadt", "04.03.05"}}, new String[]{"Beschlussart", "Datum"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        ((BeschluesseTable)((Object)this.tblBeschluesse)).setSortButton(this.tbtnSortBeschluss);
        this.jScrollPane6.setViewportView(this.tblBeschluesse);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.panBeschluss.add((Component)this.jScrollPane6, gridBagConstraints);
        this.pnlBeschluesseControls.setLayout(new GridBagLayout());
        this.btnAddBeschluss.setAction(((BeschluesseTable)((Object)this.tblBeschluesse)).getAddAction());
        this.btnAddBeschluss.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddBeschluss.setBorder(null);
        this.btnAddBeschluss.setBorderPainted(false);
        this.btnAddBeschluss.setMaximumSize(new Dimension(25, 25));
        this.btnAddBeschluss.setMinimumSize(new Dimension(25, 25));
        this.btnAddBeschluss.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlBeschluesseControls.add((Component)this.btnAddBeschluss, gridBagConstraints);
        this.btnRemoveBeschluss.setAction(((BeschluesseTable)((Object)this.tblBeschluesse)).getRemoveAction());
        this.btnRemoveBeschluss.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveBeschluss.setBorder(null);
        this.btnRemoveBeschluss.setBorderPainted(false);
        this.btnRemoveBeschluss.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveBeschluss.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveBeschluss.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.pnlBeschluesseControls.add((Component)this.btnRemoveBeschluss, gridBagConstraints);
        this.tbtnSortBeschluss.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.tbtnSortBeschluss.setBorder(null);
        this.tbtnSortBeschluss.setBorderPainted(false);
        this.tbtnSortBeschluss.setContentAreaFilled(false);
        this.tbtnSortBeschluss.setMaximumSize(new Dimension(25, 25));
        this.tbtnSortBeschluss.setMinimumSize(new Dimension(25, 25));
        this.tbtnSortBeschluss.setPreferredSize(new Dimension(25, 25));
        this.tbtnSortBeschluss.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.pnlBeschluesseControls.add((Component)this.tbtnSortBeschluss, gridBagConstraints);
        this.tbtnSortBeschluss.addItemListener(((BeschluesseTable)((Object)this.tblBeschluesse)).getSortItemListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.panBeschluss.add((Component)this.pnlBeschluesseControls, gridBagConstraints);
        this.tabKB.addTab("Beschl\u00fcsse", this.panBeschluss);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panTab.add((Component)this.tabKB, gridBagConstraints);
        this.tabKB.getAccessibleContext().setAccessibleName("Beschluesse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.panTab, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.pnlDetail.add((Component)this.jScrollPane3, gridBagConstraints);
        this.add((Component)this.pnlDetail, "Center");
    }

    private void txtEintragungActionPerformed(ActionEvent evt) {
    }

    private void cboVertragsartActionPerformed(ActionEvent evt) {
        Object selectedItem = this.cboVertragsart.getSelectedItem();
        if (selectedItem != null && selectedItem instanceof VertragsartCustomBean) {
            VertragsartCustomBean art = (VertragsartCustomBean)selectedItem;
            switch (art.getId()) {
                case 1: {
                    this.lblVoreigentuemer.setText("Voreigent\u00fcmer");
                    break;
                }
                case 2: {
                    this.lblVoreigentuemer.setText("Erwerber");
                    break;
                }
                default: {
                    this.lblVoreigentuemer.setText("Vertragspartner (Vertragsart nicht definiert)");
                }
            }
        }
    }

    private void btnAddExitingContractActionPerformed(ActionEvent evt) {
        JDialog dialog = new JDialog(LagisApp.getInstance(), "", true);
        dialog.add(new AddExistingVorgangPanel(LagisBroker.getInstance().getCurrentFlurstueck(), this.vTableModel, this.lstCrossRefs.getModel()));
        dialog.pack();
        dialog.setIconImage(this.icoExistingContract.getImage());
        dialog.setTitle("Vorhandener Vertrag hinzuf\u00fcgen...");
        StaticSwingTools.showDialog((JDialog)dialog);
    }

    private void updateCrossRefs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Update der Querverweise");
        }
        Collection<FlurstueckSchluesselCustomBean> crossRefs = LagisBroker.getInstance().getCrossreferencesForVertraege(new HashSet<CidsBean>(this.vTableModel.getCidsBeans()));
        DefaultUniqueListModel newModel = new DefaultUniqueListModel();
        if (crossRefs != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Es sind Querverweise auf Vertr\u00e4g vorhanden");
            }
            if (crossRefs.size() > 0) {
                this.tabKB.setForegroundAt(0, Color.RED);
            } else {
                this.tabKB.setForegroundAt(0, null);
            }
            LagisBroker.getInstance().getCurrentFlurstueck().setVertraegeQuerverweise(crossRefs);
            Iterator<FlurstueckSchluesselCustomBean> it = crossRefs.iterator();
            while (it.hasNext()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Ein Querverweis hinzugef\u00fcgt");
                }
                newModel.addElement(it.next());
            }
            newModel.removeElement(LagisBroker.getInstance().getCurrentFlurstueck().getFlurstueckSchluessel());
        }
        this.lstCrossRefs.setModel(newModel);
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public void updateFlurstueckForSaving(FlurstueckCustomBean flurstueck) {
        Collection<VertragCustomBean> vertraege = flurstueck.getVertraege();
        if (vertraege != null) {
            LagISUtils.makeCollectionContainSameAsOtherCollection(vertraege, this.vTableModel.getCidsBeans());
        } else {
            HashSet<VertragCustomBean> newSet = new HashSet<VertragCustomBean>();
            newSet.addAll(this.vTableModel.getCidsBeans());
            flurstueck.setVertraege(newSet);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        DefaultListSelectionModel source;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("geht generell: " + e.getSource()));
        }
        if ((source = (DefaultListSelectionModel)e.getSource()).equals(this.tblVertraege.getSelectionModel())) {
            int selecetdRow;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Vertr\u00e4ge Tabelle");
                LOG.debug((Object)"Mit maus auf Vertr\u00e4getabelle geklickt");
            }
            if ((selecetdRow = this.tblVertraege.getSelectedRow()) != -1 && this.isInEditMode) {
                this.btnRemoveVertrag.setEnabled(true);
            } else {
                this.btnRemoveVertrag.setEnabled(false);
            }
        } else if (source.equals(this.tblKosten.getSelectionModel())) {
            int selecetdRow;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Kosten Tabelle");
            }
            if ((selecetdRow = this.tblKosten.getSelectedRow()) != -1 && this.isInEditMode) {
                this.btnRemoveKosten.setEnabled(true);
            } else {
                this.btnRemoveKosten.setEnabled(false);
            }
        } else if (source.equals(this.tblBeschluesse.getSelectionModel())) {
            int selecetdRow;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Beschl\u00fcsse Tabelle");
            }
            if ((selecetdRow = this.tblBeschluesse.getSelectedRow()) != -1 && this.isInEditMode) {
                this.btnRemoveBeschluss.setEnabled(true);
            } else {
                this.btnRemoveBeschluss.setEnabled(false);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        FlurstueckSchluesselCustomBean key;
        Object source = e.getSource();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("source: " + source));
        }
        if (source instanceof JXTable) {
            JXTable table = (JXTable)source;
            int currentRow = table.getSelectedRow();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Row: " + currentRow));
            }
            if (currentRow != -1 && this.isInEditMode) {
                this.enableSlaveFlieds(true);
            } else {
                this.enableSlaveFlieds(false);
            }
        } else if (source instanceof JList && e.getClickCount() > 1 && (key = (FlurstueckSchluesselCustomBean)this.lstCrossRefs.getSelectedValue()) != null) {
            LagisBroker.getInstance().loadFlurstueck(key);
        }
    }

    private void enableSlaveFlieds(boolean isEnabled) {
        this.txtAktenzeichen.setEditable(isEnabled);
        this.txtAuflassung.setEditable(isEnabled);
        this.txtBemerkung.setEditable(isEnabled);
        this.txtEintragung.setEditable(isEnabled);
        this.txtKaufpreis.setEditable(isEnabled);
        this.txtQuadPreis.setEditable(isEnabled);
        this.cboVertragsart.setEnabled(isEnabled);
        this.txtVoreigentuemer.setEditable(isEnabled);
        this.cboVertragsart.setEnabled(isEnabled);
        this.btnAddKosten.setEnabled(isEnabled);
        this.btnAddBeschluss.setEnabled(isEnabled);
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }

    @Override
    public void duringRemoveAction(Object source) {
        this.updateCrossRefs();
    }

    @Override
    public void afterRemoveAction(Object source) {
        this.documentContainer.clearComponents();
        this.enableSlaveFlieds(false);
    }
}

