/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.tables;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.beans.lagis.KassenzeichenCustomBean;
import de.cismet.lagis.gui.panels.KassenzeichenAddDialog;
import de.cismet.lagis.gui.panels.KassenzeichenAddDialogListener;
import de.cismet.lagis.gui.tables.AbstractCidsBeanTable_Lagis;
import de.cismet.lagis.models.KassenzeichenTableModel;
import de.cismet.tools.gui.StaticSwingTools;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class KassenzeichenTable
extends AbstractCidsBeanTable_Lagis {
    private static final Logger LOG = Logger.getLogger(KassenzeichenTable.class);

    @Override
    protected void addNewItem() {
        try {
            StaticSwingTools.showDialog((JDialog)new KassenzeichenAddDialog(new KassenzeichenAddDialogListener(){

                @Override
                public void kassenzeichennummerAdded(Integer kassenzeichennummer) {
                    KassenzeichenTable.this.addNewKassenzeichen(kassenzeichennummer);
                }
            }));
        }
        catch (Exception ex) {
            LOG.error((Object)"error creating bean for Kassenzeichen", (Throwable)ex);
        }
    }

    public boolean addNewKassenzeichen(Integer kassenzeichennummer) {
        if (kassenzeichennummer != null) {
            for (KassenzeichenCustomBean kassenzeichenCustomBean : ((KassenzeichenTableModel)this.getModel()).getCidsBeans()) {
                if (kassenzeichenCustomBean == null || !kassenzeichennummer.equals(kassenzeichenCustomBean.getKassenzeichennummer())) continue;
                return false;
            }
            KassenzeichenCustomBean tmp = KassenzeichenCustomBean.createNew();
            tmp.setKassenzeichennummer(kassenzeichennummer);
            tmp.setZugeordnet_am(new Timestamp(new Date().getTime()));
            tmp.setZugeordnet_von(SessionManager.getSession().getUser().getName());
            ((KassenzeichenTableModel)this.getModel()).addCidsBean(tmp);
            this.fireItemAdded();
            return true;
        }
        return false;
    }

    @Override
    protected void removeItem(int modelRow) {
        ((KassenzeichenTableModel)this.getModel()).removeCidsBean(modelRow);
    }
}

