/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.tables;

import de.cismet.cids.custom.beans.lagis.NutzungBuchungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.tables.AbstractCidsBeanTable_Lagis;
import de.cismet.lagis.gui.tables.NKFRemoveNutzungDialog;
import de.cismet.lagis.models.NKFTableModel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class NKFTable
extends AbstractCidsBeanTable_Lagis {
    private static final Logger LOG = Logger.getLogger(NKFTable.class);

    @Override
    protected void addNewItem() {
        ((NKFTableModel)this.getModel()).addNutzung(NutzungCustomBean.createNew());
        LOG.info((Object)"New Nutzung added to Model");
        this.fireItemAdded();
    }

    @Override
    protected void removeItem(int modelRow) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Selektierte Nutzung gefunden in Zeile: " + modelRow + "selectedRow: " + this.getSelectedRow()));
        }
        NKFTableModel model = (NKFTableModel)this.getModel();
        NutzungCustomBean nutzung = ((NutzungBuchungCustomBean)model.getCidsBeanAtRow(modelRow)).getNutzung();
        boolean completeRemoval = false;
        boolean performRemove = true;
        if (LagisBroker.getInstance().isNkfAdminPermission()) {
            int result = this.showRemoveHistoricalNutzungDialog(nutzung.isTerminated());
            if (result == 0) {
                completeRemoval = true;
            } else if (result != 1 && result == 2) {
                performRemove = false;
            }
        }
        if (performRemove) {
            model.removeNutzungBuchung(modelRow, completeRemoval);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NKFTable.this.clearSelection();
            }
        });
    }

    private int showRemoveHistoricalNutzungDialog(boolean isNutzungTerminated) {
        NKFRemoveNutzungDialog d = new NKFRemoveNutzungDialog(isNutzungTerminated);
        StaticSwingTools.showDialog((Component)((Object)this), (JDialog)d, (boolean)true);
        return d.getSelectedValue();
    }
}

