/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.tables;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.VerwaltendeDienststelleCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltungsbereichCustomBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.tables.AbstractCidsBeanTable_Lagis;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;

public class VerwaltungsTable
extends AbstractCidsBeanTable_Lagis {
    private static final Logger LOG = Logger.getLogger(VerwaltungsTable.class);
    private static final String[] COLUMN_NAMES = new String[]{"Dienststelle", "Fl\u00e4che m\u00b2"};
    private static final Class[] COLUMN_CLASSES = new Class[]{VerwaltendeDienststelleCustomBean.class, Integer.class};

    @Override
    protected void addNewItem() {
        try {
            VerwaltungsbereichCustomBean tmp = VerwaltungsbereichCustomBean.createNew();
            ((Model)this.getModel()).addCidsBean(tmp);
            this.fireItemAdded();
        }
        catch (Exception ex) {
            LOG.error((Object)"error creating bean for verwaltungsbereiche", (Throwable)ex);
        }
    }

    @Override
    protected void removeItem(int modelRow) {
        ((Model)this.getModel()).removeCidsBean(modelRow);
    }

    public static class Model
    extends CidsBeanTableModel_Lagis {
        private double currentWFSSize = 0.0;
        private boolean history = false;

        public Model() {
            super(COLUMN_NAMES, COLUMN_CLASSES, VerwaltungsbereichCustomBean.class);
        }

        public Model(Set<VerwaltungsbereichCustomBean> verwaltungsbereiche) {
            super(COLUMN_NAMES, COLUMN_CLASSES, verwaltungsbereiche);
        }

        public void setHistory(boolean history) {
            this.history = history;
        }

        public boolean isHistory() {
            return this.history;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ausgew\u00e4hlte zeile/spalte" + rowIndex + "/" + columnIndex));
                }
                VerwaltungsbereichCustomBean vBereich = (VerwaltungsbereichCustomBean)this.getCidsBeanAtRow(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return vBereich.getDienststelle();
                    }
                    case 1: {
                        Integer flaeche = this.isHistory() ? vBereich.getFlaeche() : Integer.valueOf(this.determineFlaeche(vBereich));
                        return flaeche;
                    }
                }
                return "Spalte ist nicht definiert";
            }
            catch (Exception ex) {
                LOG.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
                return null;
            }
        }

        public int determineFlaeche(VerwaltungsbereichCustomBean vBereich) {
            if (this.getRowCount() == 1) {
                return (int)Math.round(this.currentWFSSize);
            }
            Geometry tmp = vBereich.getGeometry();
            if (tmp != null) {
                return (int)Math.round(tmp.getArea());
            }
            return 0;
        }

        public void fillFlaechen() {
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                VerwaltungsbereichCustomBean vBereich = (VerwaltungsbereichCustomBean)this.getCidsBeanAtRow(rowIndex);
                vBereich.setFlaeche(this.determineFlaeche(vBereich));
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return COLUMN_NAMES.length - 1 > columnIndex && this.getRowCount() > rowIndex && this.isInEditMode();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            try {
                VerwaltungsbereichCustomBean vBereich = (VerwaltungsbereichCustomBean)this.getCidsBeanAtRow(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        vBereich.setDienststelle((VerwaltendeDienststelleCustomBean)aValue);
                        break;
                    }
                    default: {
                        LOG.warn((Object)("Keine Spalte f\u00fcr angegebenen Index vorhanden: " + columnIndex));
                        return;
                    }
                }
                this.fireTableDataChangedAndKeepSelection();
            }
            catch (Exception ex) {
                LOG.error((Object)("Fehler beim setzen von Daten in dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            }
        }

        public ArrayList<Feature> getAllVerwaltungsFeatures() {
            ArrayList<Feature> tmp = new ArrayList<Feature>();
            ArrayList verwaltungsbereiche = (ArrayList)this.getCidsBeans();
            if (verwaltungsbereiche != null) {
                for (VerwaltungsbereichCustomBean curVB : verwaltungsbereiche) {
                    if (curVB.getGeometry() == null) continue;
                    tmp.add(curVB);
                }
                return tmp;
            }
            return tmp;
        }

        @Override
        public void removeCidsBean(int rowIndex) {
            VerwaltungsbereichCustomBean vBereich = (VerwaltungsbereichCustomBean)this.getCidsBeanAtRow(rowIndex);
            if (vBereich != null && vBereich.getGeometry() != null) {
                LagisBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)vBereich);
            }
            super.removeCidsBean(rowIndex);
        }

        public void setCurrentWFSSize(double currentWFSSize) {
            this.currentWFSSize = currentWFSSize;
            this.fireTableDataChangedAndKeepSelection();
        }
    }
}

