/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagisEE.interfaces.Key;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.apache.log4j.Logger;

public class KeyComboboxModel
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    private static final Logger LOG = Logger.getLogger(KeyComboboxModel.class);
    private List<Key> keys = new ArrayList<Key>();
    private Key selectedKey = null;

    public KeyComboboxModel() {
    }

    public KeyComboboxModel(List<Key> keys) {
        this.keys = keys == null ? new ArrayList<Key>() : keys;
    }

    @Override
    public void setSelectedItem(Object key) {
        if (key != null && key instanceof Key && !key.equals(this.selectedKey)) {
            this.selectedKey = (Key)key;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedKey;
    }

    @Override
    public int getSize() {
        return this.keys.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= 0 && index < this.keys.size()) {
            return this.keys.get(index);
        }
        return null;
    }

    public boolean contains(Object key) {
        if (key != null && key instanceof Key) {
            return this.keys.contains((Key)key);
        }
        return false;
    }

    public int getIndexOf(Object key) {
        if (key != null && key instanceof Key) {
            return this.keys.indexOf((Key)key);
        }
        return -1;
    }

    public void addElement(Object key) {
        LagisBroker.warnIfThreadIsNotEDT();
        if (key != null && key instanceof Key) {
            this.keys.add((Key)key);
            Collections.sort(this.keys);
            this.fireContentsChanged(this, 0, this.keys.size() - 1);
            if (this.keys.size() == 1 && this.selectedKey == null && key != null) {
                this.setSelectedItem(key);
            }
        } else {
            LOG.warn((Object)"Es wurde versucht ein Object != Key zu adden");
        }
    }

    public void insertElementAt(Object key, int index) {
        if (key != null && key instanceof Key) {
            this.keys.add(index, (Key)key);
            this.fireIntervalAdded(this, index, index);
        } else {
            LOG.warn((Object)"Es wurde versucht ein Object != Key zu adden");
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (index >= 0 && index < this.keys.size()) {
            if (this.getElementAt(index) == this.selectedKey) {
                if (index == 0) {
                    this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
                } else {
                    this.setSelectedItem(this.getElementAt(index - 1));
                }
            }
            this.keys.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    @Override
    public void removeElement(Object key) {
        int index = this.keys.indexOf(key);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.keys.size() > 0) {
            boolean firstIndex = false;
            int lastIndex = this.keys.size() - 1;
            this.keys.clear();
            this.selectedKey = null;
            this.fireIntervalRemoved(this, 0, lastIndex);
        } else {
            this.selectedKey = null;
        }
    }
}

