/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.models.AbstractCidsBeanTableModel;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class MeldungenTableModel
extends AbstractCidsBeanTableModel {
    private static final Logger LOG = Logger.getLogger(MeldungenTableModel.class);
    private static final String[] COLUMN_HEADER = new String[]{"Datum", "Meldung", "Flurst\u00fcck"};
    private static final Class[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class};
    private static final DateFormat DF = new SimpleDateFormat("dd.MM.YYYY");

    public MeldungenTableModel() {
        super(COLUMN_HEADER, COLUMN_CLASSES);
    }

    @Override
    public boolean isCellEditable(int i, int i1) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        CidsBean meldungBean = this.getCidsBeanByIndex(row);
        if (meldungBean == null) {
            return null;
        }
        switch (column) {
            case 0: {
                try {
                    Timestamp timestamp = (Timestamp)meldungBean.getProperty("timestamp");
                    return timestamp != null ? DF.format(timestamp) : "-";
                }
                catch (Exception ex) {
                    LOG.warn((Object)"exception in tablemodel", (Throwable)ex);
                    return "<html><b><i>Fehler";
                }
            }
            case 1: {
                try {
                    return (String)meldungBean.getProperty("name");
                }
                catch (Exception ex) {
                    LOG.warn((Object)"exception in tablemodel", (Throwable)ex);
                    return "<html><b><i>Fehler";
                }
            }
            case 2: {
                try {
                    return ((CidsBean)meldungBean.getProperty("fk_flurstueck")).toString();
                }
                catch (Exception ex) {
                    LOG.warn((Object)"exception in tablemodel", (Throwable)ex);
                    return "<html><i>Fehler";
                }
            }
        }
        return null;
    }
}

