/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.custom.beans.lagis.NutzungBuchungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.lagis.Exception.BuchungNotInNutzungException;
import de.cismet.lagis.Exception.IllegalNutzungStateException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.NKFOverviewPanel;
import de.cismet.lagis.util.TableSelectionUtils;
import de.cismet.lagis.utillity.AnlagenklasseSumme;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class NKFOverviewTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_HEADER = new String[]{"Anlageklasse", "Summe"};
    private static final Logger LOG = Logger.getLogger(NKFOverviewTableModel.class);
    private ArrayList<NutzungCustomBean> nutzungen = new ArrayList();
    private ArrayList<AnlagenklasseSumme> data = new ArrayList();
    private DecimalFormat df = LagisBroker.getCurrencyFormatter();
    private Date currentDate = null;
    private double stilleReserve = 0.0;

    public NKFOverviewTableModel() {
        this.nutzungen = new ArrayList();
    }

    public NKFOverviewTableModel(ArrayList<NutzungCustomBean> nutzungen) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Konstruktor Nutzungen");
            }
            this.nutzungen = new ArrayList<NutzungCustomBean>(nutzungen);
            this.calculateSum();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim anlegen des Models", (Throwable)ex);
            this.nutzungen = new ArrayList();
        }
    }

    public synchronized void refreshModel(Collection<NutzungCustomBean> nutzungen) {
        if (nutzungen != null) {
            this.refreshModel(new ArrayList<NutzungCustomBean>(nutzungen));
        } else {
            this.refreshModel(new ArrayList<NutzungCustomBean>());
        }
    }

    public synchronized void refreshModel(ArrayList<NutzungCustomBean> nutzungen) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Refresh Nutzungen");
            }
            this.nutzungen = new ArrayList<NutzungCustomBean>(nutzungen);
            this.calculateSum();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim anlegen des Models", (Throwable)ex);
            this.nutzungen = new ArrayList();
        }
        TableSelectionUtils.fireTableDataChangedAndKeepSelection(this, NKFOverviewPanel.getInstance().getSummeNutzungenTable());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.data.isEmpty()) {
            return null;
        }
        try {
            AnlagenklasseSumme summe = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return summe.getAnlageklasse().getSchluessel();
                }
                case 1: {
                    return this.df.format(summe.getSumme());
                }
            }
            return "Spalte ist nicht definiert";
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            return null;
        }
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEADER.length;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    private synchronized void calculateSum() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calculate Sum");
        }
        this.stilleReserve = 0.0;
        this.data = new ArrayList();
        for (NutzungCustomBean currentNutzung : this.nutzungen) {
            Double curStilleReseve;
            NutzungBuchungCustomBean currentBuchung;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("curNutzung:" + currentNutzung));
                LOG.debug((Object)("tableModelDate:" + this.currentDate));
            }
            if ((currentBuchung = currentNutzung.getBuchungForDate(this.currentDate)) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("currentBuchung: " + currentBuchung));
            }
            if (currentBuchung.getAnlageklasse() == null || currentBuchung.getGesamtpreis() == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Anlageklasse & Gesamtpreis != null");
            }
            boolean index = false;
            Iterator<AnlagenklasseSumme> itAS = this.data.iterator();
            boolean isAlreadyInVector = false;
            while (itAS.hasNext()) {
                AnlagenklasseSumme curSumme;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"vektor nicht leer");
                }
                if ((curSumme = itAS.next()).equals(Double.NaN)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Bei der Berechnung der Summen ist ein Fehler aufgetreten: Keine weitere Berechnung");
                    continue;
                }
                if (!curSumme.equals(currentBuchung.getAnlageklasse())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Element der anlagensumme vorhanden");
                }
                try {
                    curStilleReseve = currentNutzung.getStilleReserveForBuchung(currentBuchung);
                    if (curStilleReseve != null) {
                        this.stilleReserve += curStilleReseve.doubleValue();
                        curSumme.setSumme(curSumme.getSumme() + (currentBuchung.getGesamtpreis() - curStilleReseve));
                    }
                }
                catch (BuchungNotInNutzungException ex) {
                    LOG.error((Object)"Stille Reserve konnte nicht berechnet werden: Fehlerhalfte Buchung");
                    this.stilleReserve = Double.NaN;
                    curSumme.setSumme(Double.NaN);
                }
                catch (IllegalNutzungStateException ex) {
                    LOG.error((Object)"Stille Reserve konnte nicht berechnet werden: Kein Buchwert");
                    this.stilleReserve = Double.NaN;
                    curSumme.setSumme(Double.NaN);
                }
                isAlreadyInVector = true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"nach while");
            }
            if (isAlreadyInVector) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Element der anlagensumme hinzugef\u00fcgt");
            }
            AnlagenklasseSumme tmp = new AnlagenklasseSumme(currentBuchung.getAnlageklasse());
            try {
                curStilleReseve = currentNutzung.getStilleReserveForBuchung(currentBuchung);
                if (curStilleReseve != null) {
                    this.stilleReserve += curStilleReseve.doubleValue();
                    tmp.setSumme(currentBuchung.getGesamtpreis() - curStilleReseve);
                }
            }
            catch (BuchungNotInNutzungException ex) {
                LOG.error((Object)"Stille Reserve konnte nicht berechnet werden: Fehlerhalfte Buchung");
                tmp.setSumme(Double.NaN);
            }
            catch (IllegalNutzungStateException ex) {
                LOG.error((Object)"Stille Reserve konnte nicht berechnet werden: Kein Buchwert");
                tmp.setSumme(Double.NaN);
            }
            this.data.add(tmp);
        }
        Collections.sort(this.data);
    }

    public double getStilleReserve() {
        return this.stilleReserve;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_HEADER[column];
    }

    public ArrayList<NutzungCustomBean> getAllNutzungen() {
        return this.nutzungen;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }
}

