/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.custom.beans.lagis.AnlageklasseCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungBuchungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungsartCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.Exception.TerminateNutzungNotPossibleException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import de.cismet.tools.CurrentStackTrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class NKFTableModel
extends CidsBeanTableModel_Lagis {
    public static final int COLUMN_NUTZUNGS_NUMMER = 0;
    public static final int COLUMN_BUCHUNGS_NUMMER = 1;
    public static final int COLUMN_ANLAGEKLASSE = 2;
    public static final int COLUMN_NUTZUNGSART_SCHLUESSEL = 3;
    public static final int COLUMN_NUTZUNGSART_BEZEICHNUNG = 4;
    public static final int COLUMN_FLAECHE = 5;
    public static final int COLUMN_QUADRATMETER_PREIS = 6;
    public static final int COLUMN_GESAMT_PREIS = 7;
    public static final int COLUMN_STILLE_RESERVE = 8;
    public static final int COLUMN_BUCHWERT = 9;
    public static final int COLUMN_BEMERKUNG = 10;
    public static final int COLUMN_LAST = 11;
    private static final String[] COLUMN_NAMES = new String[]{"Nutzungs-Nr.", "Buchungs-Nr.", "Anlageklasse", "Nutzungsart", "Nutzungsarten-Bezeichnung", "Fl\u00e4che/m\u00b2", "m\u00b2-Preis", "Gesamtpreis", "Stille Reserve", "Buchwert", "Bemerkung"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Integer.class, Integer.class, AnlageklasseCustomBean.class, String.class, NutzungsartCustomBean.class, Integer.class, Double.class, Double.class, Double.class, ImageIcon.class, String.class};
    private static final Logger LOG = Logger.getLogger(NKFTableModel.class);
    private Icon booked = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/booked.png"));
    private Icon notBooked = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/nutzung/notBooked.png"));
    private ArrayList<NutzungCustomBean> allNutzungen;
    private Date currentDate = null;

    public NKFTableModel() {
        super(COLUMN_NAMES, COLUMN_CLASSES, NutzungBuchungCustomBean.class);
        this.allNutzungen = new ArrayList();
    }

    public NKFTableModel(Collection<NutzungBuchungCustomBean> buchungen) {
        super(COLUMN_NAMES, COLUMN_CLASSES, buchungen);
        try {
            this.allNutzungen = new ArrayList();
            for (NutzungBuchungCustomBean buchung : buchungen) {
                this.allNutzungen.add(buchung.getNutzung());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Anzahl aller Nutzungen: " + this.allNutzungen.size()));
            }
            this.currentDate = null;
            this.setModelToHistoryDate(this.currentDate);
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim anlegen des Models", (Throwable)ex);
            this.allNutzungen = new ArrayList();
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (this.getRowCount() == 0) {
                return null;
            }
            NutzungBuchungCustomBean selectedBuchung = (NutzungBuchungCustomBean)this.getCidsBeanAtRow(rowIndex);
            if (selectedBuchung == null) {
                return null;
            }
            NutzungCustomBean nutzung = selectedBuchung.getNutzung();
            Double stilleReserve = nutzung != null ? nutzung.getStilleReserveForBuchung(selectedBuchung) : null;
            switch (columnIndex) {
                case 0: {
                    return nutzung != null && nutzung.getId() != -1 ? nutzung.getId() : null;
                }
                case 1: {
                    return nutzung == null ? null : Integer.valueOf(nutzung.getBuchungsNummerForBuchung(selectedBuchung));
                }
                case 2: {
                    return selectedBuchung.getAnlageklasse();
                }
                case 3: {
                    return selectedBuchung.getNutzungsart() != null ? selectedBuchung.getNutzungsart().getSchluessel() : null;
                }
                case 4: {
                    return selectedBuchung.getNutzungsart();
                }
                case 5: {
                    return selectedBuchung.getFlaeche();
                }
                case 6: {
                    return selectedBuchung.getQuadratmeterpreis();
                }
                case 7: {
                    return selectedBuchung.getGesamtpreis() - (stilleReserve != null ? stilleReserve : 0.0);
                }
                case 8: {
                    return stilleReserve != null ? stilleReserve : 0.0;
                }
                case 9: {
                    return selectedBuchung.getIstBuchwert() ? this.booked : this.notBooked;
                }
                case 10: {
                    return selectedBuchung.getBemerkung();
                }
            }
            return "Spalte ist nicht definiert";
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 || columnIndex == 3 || columnIndex == 1 || columnIndex == 9 || columnIndex == 10 || columnIndex == 11) {
            return false;
        }
        return COLUMN_NAMES.length > columnIndex && this.getRowCount() > rowIndex && this.isInEditMode();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            NutzungBuchungCustomBean selectedBuchung = (NutzungBuchungCustomBean)this.getCidsBeanAtRow(rowIndex);
            NutzungCustomBean selectedNutzung = selectedBuchung.getNutzung();
            NutzungBuchungCustomBean oldBuchung = null;
            if (selectedBuchung.getGueltigbis() == null && !LagisBroker.getInstance().isNkfAdminPermission()) {
                if (selectedBuchung.getId() != null && selectedBuchung.getId() != -1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"neue Buchung wird angelegt");
                    }
                    NutzungBuchungCustomBean newBuchung = selectedBuchung.cloneBuchung();
                    selectedNutzung.addBuchung(newBuchung);
                    oldBuchung = selectedBuchung;
                    selectedBuchung = newBuchung;
                } else {
                    oldBuchung = selectedNutzung.getPreviousBuchung();
                }
            } else if (selectedBuchung.getIstBuchwert() && LOG.isDebugEnabled()) {
                LOG.debug((Object)"historischer Buchwert wurde editiert");
            }
            switch (columnIndex) {
                case 2: {
                    if (aValue != null && aValue instanceof String) {
                        selectedBuchung.setAnlageklasse(null);
                        break;
                    }
                    selectedBuchung.setAnlageklasse((AnlageklasseCustomBean)aValue);
                    break;
                }
                case 4: {
                    if (aValue != null && aValue instanceof String) {
                        selectedBuchung.setNutzungsart(null);
                        break;
                    }
                    selectedBuchung.setNutzungsart((NutzungsartCustomBean)aValue);
                    break;
                }
                case 5: {
                    selectedBuchung.setFlaeche((Integer)aValue);
                    break;
                }
                case 6: {
                    selectedBuchung.setQuadratmeterpreis((Double)aValue);
                    break;
                }
                case 10: {
                    if (aValue != null && aValue instanceof String && ((String)aValue).length() == 0) {
                        selectedBuchung.setBemerkung(null);
                        return;
                    }
                    selectedBuchung.setBemerkung((String)aValue);
                    break;
                }
                default: {
                    LOG.warn((Object)("Keine Spalte f\u00fcr angegebenen Index vorhanden: " + columnIndex));
                    return;
                }
            }
            if (selectedBuchung != null && oldBuchung != null && (selectedBuchung.getId() == null || selectedBuchung.getId() == -1)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Pr\u00fcfe ob die Nutzung sich wirklich ver\u00e4ndert hat");
                }
                if (NutzungBuchungCustomBean.NUTZUNG_HISTORY_EQUALATOR.pedanticEquals(oldBuchung, selectedBuchung)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Nutzungen sind gleich muss keine neue angelegt werden");
                    }
                    selectedNutzung.removeOpenNutzung();
                }
            }
            this.setModelToHistoryDate(this.currentDate);
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim setzen von Daten in dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
        }
    }

    public void addNutzung(NutzungCustomBean nutzung) {
        if (nutzung != null) {
            this.allNutzungen.add(nutzung);
            this.setModelToHistoryDate(this.currentDate);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Nutzung kann nicht hinzugef\u00fcgt werden ist null.");
        }
    }

    public void removeNutzungBuchung(int rowIndex, boolean completeRemoval) {
        try {
            this.removeNutzungBuchung_helper(rowIndex, completeRemoval);
        }
        catch (TerminateNutzungNotPossibleException ex) {
            LOG.error((Object)"Eine Nutzung konnte nicht entfernt werden", (Throwable)ex);
            int n = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "Die Buchung konnte nicht entfernt werden, bitte wenden Sie \nsich an den Systemadministrator", "Fehler beim l\u00f6schen einer Buchung", 0);
        }
    }

    private void removeNutzungBuchung_helper(int rowIndex, boolean completeRemoval) throws TerminateNutzungNotPossibleException {
        NutzungBuchungCustomBean selectedBuchung = (NutzungBuchungCustomBean)this.getCidsBeans().get(rowIndex);
        NutzungCustomBean nutzungToRemove = selectedBuchung.getNutzung();
        if (nutzungToRemove != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Nutzung die entfernt werden soll ist in Modell vorhanden.");
            }
            if (nutzungToRemove.getId() == null || nutzungToRemove.getId() == -1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Nutzung die Entfernt wurde war noch nicht in Datenbank");
                }
                this.allNutzungen.remove(nutzungToRemove);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Nutzung ist in Datenbank vorhanden");
                }
                if (selectedBuchung != null && (selectedBuchung.getId() == null || selectedBuchung.getId() == -1)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Die Betroffene Buchung ist neu und kann gel\u00f6scht werden");
                    }
                    nutzungToRemove.removeOpenNutzung();
                } else if (completeRemoval) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Die Betroffene Buchung ist in der Datenbank gespeichert. Buchung komplett l\u00f6schen");
                    }
                    if (nutzungToRemove.getBuchungsCount() > 1) {
                        nutzungToRemove.removeBuchungWithoutCreatingAHistory(selectedBuchung);
                    } else {
                        this.allNutzungen.remove(nutzungToRemove);
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Die Betroffene Buchung ist in der Datenbank gespeichert. Komplette Nutzung wird historisch gesetzt");
                    }
                    Date terminationDate = new Date();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Termination date: " + terminationDate));
                    }
                    nutzungToRemove.terminateNutzung(terminationDate);
                }
            }
        }
        this.setModelToHistoryDate(this.currentDate);
    }

    public ArrayList<NutzungBuchungCustomBean> getAllBuchungen() {
        ArrayList<NutzungBuchungCustomBean> sortedNutzungen = new ArrayList<NutzungBuchungCustomBean>();
        for (NutzungCustomBean curNutzung : this.allNutzungen) {
            if (curNutzung.getBuchungsCount() <= 0) continue;
            for (NutzungBuchungCustomBean curBuchung : curNutzung.getNutzungsBuchungen()) {
                sortedNutzungen.add(curBuchung);
            }
        }
        if (sortedNutzungen.size() > 0) {
            Collections.sort(sortedNutzungen, NutzungBuchungCustomBean.DATE_COMPARATOR);
        }
        return sortedNutzungen;
    }

    @Override
    public <T extends CidsBean> void refreshTableModel(Collection<T> nutzungen) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Refresh des NKFTableModell");
            }
            if (nutzungen != null) {
                this.allNutzungen = new ArrayList<T>(nutzungen);
            } else {
                this.allNutzungen.clear();
            }
            this.getTable().clearSelection();
            this.setModelToHistoryDate(this.currentDate);
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim refreshen des Models", (Throwable)ex);
            this.setCidsBeans(new ArrayList());
            this.allNutzungen = new ArrayList();
        }
    }

    public ArrayList<NutzungBuchungCustomBean> getOpenBuchungen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Anzahl aller Nutzungen: " + this.allNutzungen.size()));
        }
        ArrayList<NutzungBuchungCustomBean> selectedBuchungen = new ArrayList<NutzungBuchungCustomBean>();
        for (NutzungCustomBean curNutzung : this.allNutzungen) {
            NutzungBuchungCustomBean curBuchung = curNutzung.getOpenBuchung();
            if (curBuchung == null) continue;
            selectedBuchungen.add(curBuchung);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Anzahl offener Nutzungen: " + selectedBuchungen.size()));
        }
        return selectedBuchungen;
    }

    public ArrayList<NutzungCustomBean> getAllNutzungen() {
        return this.allNutzungen;
    }

    public final void setModelToHistoryDate(Date historyDate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setModelToHistoryDate: " + historyDate), (Throwable)new CurrentStackTrace());
            LOG.debug((Object)("anzahl rows: " + this.getRowCount()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("AnzahlNutzungen: " + this.allNutzungen.size()));
        }
        boolean dateChanged = false;
        dateChanged = this.currentDate == null || historyDate == null ? this.currentDate != null || historyDate != null : !this.currentDate.equals(historyDate);
        this.currentDate = historyDate;
        this.clearCidsBeans();
        for (NutzungCustomBean curNutzung : this.allNutzungen) {
            Collection<NutzungBuchungCustomBean> buchungenForDay = curNutzung.getBuchungForDate(historyDate, false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Anzahl buchungen: " + buchungenForDay.size()));
            }
            this.addAllCidsBeans(buchungenForDay);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("anzahl rows: " + this.getRowCount()));
        }
        if (dateChanged) {
            this.getTable().clearSelection();
            this.fireTableDataChanged();
        } else {
            this.fireTableDataChangedAndKeepSelection();
        }
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }
}

