/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.renderer;

import de.cismet.cids.custom.beans.lagis.FarbeCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltendeDienststelleCustomBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class VerwaltendeDienststelleRenderer
extends DefaultTableCellRenderer {
    Element htmlTooltip;
    private XMLOutputter serializer = new XMLOutputter();
    private final Logger log = Logger.getLogger(this.getClass());

    public VerwaltendeDienststelleRenderer() {
        Format format = Format.getPrettyFormat();
        format.setEncoding("ISO-8859-1");
        this.serializer.setFormat(format);
    }

    public void setHTMLTooltip(Element htmlTooltip) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("htmltooltipset:" + htmlTooltip));
        }
        this.htmlTooltip = htmlTooltip;
    }

    @Override
    public void setValue(Object value) {
        try {
            if (value instanceof VerwaltendeDienststelleCustomBean) {
                VerwaltendeDienststelleCustomBean tmp = (VerwaltendeDienststelleCustomBean)value;
                if (tmp != null) {
                    Collection<FarbeCustomBean> farben;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"VerwaltendeDienststelleCustomBean != null");
                    }
                    if ((farben = tmp.getFarben()) != null && !farben.isEmpty()) {
                        FarbeCustomBean farbe = farben.iterator().next();
                        this.setIcon(new ColorIcon(new Color(farbe.getRgbFarbwert())));
                    } else {
                        this.setIcon(new ColorIcon(Color.black));
                    }
                    this.setText(value == null ? "" : value.toString());
                    this.setIconTextGap(5);
                    this.setBorder(new EmptyBorder(0, 5, 0, 0));
                    try {
                        Element html = this.htmlTooltip.getChild("HTML");
                        html.getChild("Abteilung").setText(tmp.getAbkuerzungAbteilung());
                        html.getChild("Ressort").setText(tmp.getRessort().getAbkuerzung());
                        String htmlString = this.serializer.outputString(html);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("setting htmltooltip: " + htmlString));
                        }
                        this.setToolTipText(htmlString);
                    }
                    catch (Exception silent) {
                        this.setToolTipText("Objektnutzung");
                    }
                } else {
                    this.setIcon(new ColorIcon(Color.black));
                    this.setIconTextGap(5);
                    this.setBorder(new EmptyBorder(0, 5, 0, 0));
                    this.setText("");
                    this.setToolTipText("Objektnutzung");
                }
            } else if (value == null) {
                this.setIcon(null);
                this.setText("");
                this.setBorder(null);
                this.setToolTipText("Objektnutzung");
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)"Fehler beim Rendern einer VerwaltendenDienststelle", (Throwable)ex);
            this.setIcon(new ColorIcon(Color.black));
            this.setIconTextGap(5);
            this.setBorder(new EmptyBorder(0, 5, 0, 0));
            this.setText(value == null ? "" : value.toString());
            this.setToolTipText("Objektnutzung");
        }
    }

    class ColorIcon
    implements Icon {
        private static final int ICON_SIZE = 8;
        private Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.setColor(new Color(70, 70, 70));
            g.fillRect(x, y, 8, 8);
            g.setColor(this.color);
            g.fillRect(x + 1, y + 1, 6, 6);
            g.setColor(oldColor);
        }
    }
}

