/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import de.cismet.lagis.report.ReportSwingWorkerDialog;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.log4j.Logger;

public class ReportSwingWorker
extends SwingWorker<Boolean, Object> {
    private static final Logger LOG = Logger.getLogger(ReportSwingWorker.class);
    private final List<String> compiledReportList;
    private final Map<String, JRDataSource> dataSourcesMap;
    private final ReportSwingWorkerDialog dialog;
    private final boolean withDialog;
    private String directory;
    private final Map<String, Object> paramMap;

    public ReportSwingWorker(List<String> compiledReportList, Map<String, JRDataSource> dataSourcesMap, Map<String, Object> paramMap, boolean withDialog, Frame parent, String directory) {
        this.compiledReportList = compiledReportList;
        this.withDialog = withDialog;
        this.directory = directory;
        this.dataSourcesMap = dataSourcesMap;
        this.paramMap = paramMap;
        this.dialog = withDialog ? new ReportSwingWorkerDialog(parent, true) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean doInBackground() throws Exception {
        if (this.withDialog) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StaticSwingTools.showDialog((JDialog)ReportSwingWorker.this.dialog);
                }
            });
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileOutputStream fos = null;
        try {
            ArrayList<InputStream> ins = new ArrayList<InputStream>();
            int numReports = this.compiledReportList.size();
            for (int index = 0; index < numReports; ++index) {
                String report = this.compiledReportList.get(index);
                JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)ReportSwingWorker.class.getResourceAsStream(report));
                JRDataSource dataSource = this.dataSourcesMap.get(report);
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.paramMap, (JRDataSource)dataSource);
                jasperPrint.setOrientation(jasperReport.getOrientationValue());
                ByteArrayOutputStream outTmp = new ByteArrayOutputStream();
                JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outTmp);
                ins.add(new ByteArrayInputStream(outTmp.toByteArray()));
                outTmp.close();
            }
            ReportSwingWorker.concatPDFs(ins, out, true);
            File file = new File(this.directory, "report.pdf");
            file.getParentFile().mkdirs();
            fos = new FileOutputStream(file);
            fos.write(out.toByteArray());
            BrowserLauncher.openURL((String)("file:///" + file));
            Boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            LOG.error((Object)"Export to PDF-Stream failed.", (Throwable)ex);
        }
        catch (JRException ex) {
            LOG.error((Object)"Export to PDF-Stream failed.", (Throwable)ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOG.error((Object)"error while closing streams", (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    protected void done() {
        boolean error = false;
        try {
            error = (Boolean)this.get() == false;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (ExecutionException ex) {
            error = true;
            ex.printStackTrace();
            LOG.error((Object)"error while generating report", (Throwable)ex);
        }
        if (this.withDialog) {
            this.dialog.setVisible(false);
        }
        if (error) {
            JOptionPane.showMessageDialog(this.dialog.getParent(), "Beim Generieren des Reports ist ein Fehler aufgetreten. ", "Fehler!", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void concatPDFs(List<InputStream> streamOfPDFFiles, OutputStream outputStream, boolean paginate) {
        int totalNumOfPages = 0;
        Document document = new Document();
        List<InputStream> inputStreams = streamOfPDFFiles;
        ArrayList<PdfReader> pdfReaders = new ArrayList<PdfReader>();
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            for (InputStream pdf : inputStreams) {
                PdfReader pdfReader = new PdfReader(pdf);
                pdfReaders.add(pdfReader);
                totalNumOfPages += pdfReader.getNumberOfPages();
            }
            document.open();
            BaseFont baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            PdfContentByte contentByte = writer.getDirectContent();
            int currentPageNumber = 0;
            for (PdfReader pdfReader : pdfReaders) {
                int currentNumOfPages = 0;
                while (currentNumOfPages < pdfReader.getNumberOfPages()) {
                    ++currentPageNumber;
                    document.setPageSize(pdfReader.getPageSizeWithRotation(++currentNumOfPages));
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, currentNumOfPages);
                    contentByte.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                    if (!paginate) continue;
                    contentByte.beginText();
                    contentByte.setFontAndSize(baseFont, 9.0f);
                    contentByte.showTextAligned(1, currentPageNumber + " of " + totalNumOfPages, 520.0f, 5.0f, 0.0f);
                    contentByte.endText();
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while merging pdfs", (Throwable)ex);
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                LOG.error((Object)"error whil closing pdfstream", (Throwable)ex);
            }
        }
    }
}

