/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.datasource;

import de.cismet.cids.custom.beans.lagis.AnlageklasseCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungBuchungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.report.datasource.ADataSource;
import de.cismet.lagis.utillity.AnlagenklasseSumme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;

public class NKFUebersichtDataSource
extends ADataSource<AnlagenklasseSumme>
implements JRDataSource {
    private static final String JR_ANLAGE_KL = "anlagenklasse";
    private static final String JR_SUMME = "summe";

    public NKFUebersichtDataSource() {
    }

    public NKFUebersichtDataSource(List<AnlagenklasseSumme> summen) {
        super(summen);
    }

    @Override
    protected List<AnlagenklasseSumme> retrieveData() {
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        Collection<NutzungCustomBean> nutzungen = currentFlurstueck.getNutzungen();
        HashMap<AnlageklasseCustomBean, Double> sumMap = new HashMap<AnlageklasseCustomBean, Double>();
        for (NutzungCustomBean tmpNutzung : nutzungen) {
            if (tmpNutzung.getBuchungsCount() <= 0) continue;
            for (NutzungBuchungCustomBean nutzungBuchungCustomBean : tmpNutzung.getNutzungsBuchungen()) {
                if (nutzungBuchungCustomBean.getGueltigbis() != null) continue;
                Double gesamtPreis = nutzungBuchungCustomBean.getGesamtpreis();
                AnlageklasseCustomBean anlkl = nutzungBuchungCustomBean.getAnlageklasse();
                if (anlkl == null || gesamtPreis == null) continue;
                try {
                    Double stilleReserve = tmpNutzung.getStilleReserveForBuchung(nutzungBuchungCustomBean);
                    if (stilleReserve == null) {
                        stilleReserve = 0.0;
                    }
                    if (sumMap.containsKey(anlkl)) {
                        Double recentSum = (Double)sumMap.get(anlkl);
                        sumMap.put(anlkl, recentSum + (gesamtPreis - stilleReserve));
                        continue;
                    }
                    sumMap.put(anlkl, gesamtPreis - stilleReserve);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        ArrayList<AnlagenklasseSumme> summen = new ArrayList<AnlagenklasseSumme>(sumMap.size());
        for (Map.Entry entry : sumMap.entrySet()) {
            AnlagenklasseSumme sum = new AnlagenklasseSumme((AnlageklasseCustomBean)entry.getKey());
            sum.setSumme((Double)entry.getValue());
            summen.add(sum);
        }
        return summen;
    }

    @Override
    protected Object getFieldValue(String fieldName) throws JRException {
        if (JR_ANLAGE_KL.equals(fieldName)) {
            return ((AnlagenklasseSumme)this.currentItem).getAnlageklasse().getBezeichnung();
        }
        if (JR_SUMME.equals(fieldName)) {
            return super.formatNumber(((AnlagenklasseSumme)this.currentItem).getSumme());
        }
        throw new IllegalArgumentException("Field " + fieldName + " is not supported in this report");
    }
}

