/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.datasource;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungBuchungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.report.datasource.ADataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;

public final class NutzungenDataSource
extends ADataSource<NutzungBuchungCustomBean>
implements JRDataSource {
    private static final String JR_NUTZUNGS_NR = "nutz_nr";
    private static final String JR_BUCHUNGS_NR = "b_nr";
    private static final String JR_ANLAGE_KL = "anlageklasse";
    private static final String JR_NUTZ_ARTEN_KEY = "nutz_arten_schluessel";
    private static final String JR_FLAECHE = "flaeche";
    private static final String JR_QM_PREIS = "qm_preis";
    private static final String JR_WERT = "wert";
    private static final String JR_BUCHUNGS_WERT = "b_wert";
    private static final String JR_BEMERKUNG = "bem";
    private transient NutzungCustomBean currentNutzung;

    public NutzungenDataSource() {
    }

    public NutzungenDataSource(List<NutzungBuchungCustomBean> buchungen) {
        super(buchungen);
    }

    @Override
    protected List<NutzungBuchungCustomBean> retrieveData() {
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        Collection<NutzungCustomBean> nutzungen = currentFlurstueck.getNutzungen();
        ArrayList<NutzungBuchungCustomBean> buchungen = new ArrayList<NutzungBuchungCustomBean>(nutzungen.size());
        for (NutzungCustomBean tmpNutzung : nutzungen) {
            if (tmpNutzung.getBuchungsCount() <= 0) continue;
            for (NutzungBuchungCustomBean buchung : tmpNutzung.getNutzungsBuchungen()) {
                if (buchung.getGueltigbis() != null) continue;
                buchungen.add(buchung);
            }
        }
        return buchungen;
    }

    @Override
    public boolean next() throws JRException {
        if (super.next()) {
            this.currentNutzung = ((NutzungBuchungCustomBean)this.currentItem).getNutzung();
            if (this.currentNutzung == null) {
                throw new JRException("There is no Nutzung associated to Buchung " + this.currentItem);
            }
            return true;
        }
        return false;
    }

    private double calculateGesamtPreis(NutzungBuchungCustomBean buchung) {
        Double gesamtPreis = buchung.getGesamtpreis();
        if (gesamtPreis == null) {
            return 0.0;
        }
        try {
            NutzungCustomBean nutzung = buchung.getNutzung();
            Double stilleReserve = nutzung.getStilleReserveForBuchung(buchung);
            if (stilleReserve == null) {
                stilleReserve = 0.0;
            }
            return gesamtPreis - stilleReserve;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected Object getFieldValue(String fieldName) throws JRException {
        if (JR_NUTZUNGS_NR.equals(fieldName)) {
            return String.valueOf(this.currentNutzung.getId());
        }
        if (JR_BUCHUNGS_NR.equals(fieldName)) {
            return super.formatNumber(this.currentNutzung.getBuchungsNummerForBuchung((NutzungBuchungCustomBean)this.currentItem));
        }
        if (JR_ANLAGE_KL.equals(fieldName)) {
            return ((NutzungBuchungCustomBean)this.currentItem).getAnlageklasse().getSchluessel();
        }
        if (JR_NUTZ_ARTEN_KEY.equals(fieldName)) {
            return ((NutzungBuchungCustomBean)this.currentItem).getNutzungsart().getBezeichnung();
        }
        if (JR_FLAECHE.equals(fieldName)) {
            return super.formatNumber(((NutzungBuchungCustomBean)this.currentItem).getFlaeche());
        }
        if (JR_QM_PREIS.equals(fieldName)) {
            return super.formatNumber(((NutzungBuchungCustomBean)this.currentItem).getQuadratmeterpreis());
        }
        if (JR_WERT.equals(fieldName)) {
            return super.formatNumber(this.calculateGesamtPreis((NutzungBuchungCustomBean)this.currentItem));
        }
        if (JR_BUCHUNGS_WERT.equals(fieldName)) {
            return super.formatBoolean(this.currentNutzung.getOpenBuchung().getIstBuchwert());
        }
        if (JR_BEMERKUNG.equals(fieldName)) {
            return ((NutzungBuchungCustomBean)this.currentItem).getBemerkung();
        }
        throw new IllegalArgumentException("Field " + fieldName + " is not supported in this report");
    }
}

