/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.datasource;

import de.cismet.cids.custom.beans.lagis.RebeCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.report.datasource.ADataSource;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;

public class ReBeDataSource
extends ADataSource<RebeCustomBean>
implements JRDataSource {
    private static final String JR_RECHT = "recht";
    private static final String JR_ART = "art";
    private static final String JR_ART_RECHT = "art_des_rechts";
    private static final String JR_NR = "nr";
    private static final String JR_EINTRAGUNG = "eintragung";
    private static final String JR_LOESCHUNG = "loeschung";
    private static final String JR_BEMERKUNG = "bemerkung";

    public ReBeDataSource() {
    }

    public ReBeDataSource(List<RebeCustomBean> rebeList) {
        super(rebeList);
    }

    @Override
    protected List<RebeCustomBean> retrieveData() {
        return LagisBroker.getInstance().getCurrentRebes();
    }

    @Override
    protected Object getFieldValue(String fieldName) throws JRException {
        if (JR_RECHT.equals(fieldName)) {
            return super.formatBoolean(((RebeCustomBean)this.currentItem).getIstRecht());
        }
        if (JR_ART.equals(fieldName)) {
            return ((RebeCustomBean)this.currentItem).getReBeArt().getBezeichnung();
        }
        if (JR_ART_RECHT.equals(fieldName)) {
            return ((RebeCustomBean)this.currentItem).getBeschreibung();
        }
        if (JR_NR.equals(fieldName)) {
            return ((RebeCustomBean)this.currentItem).getNummer();
        }
        if (JR_EINTRAGUNG.equals(fieldName)) {
            return super.formatDate(((RebeCustomBean)this.currentItem).getDatumEintragung());
        }
        if (JR_LOESCHUNG.equals(fieldName)) {
            return super.formatDate(((RebeCustomBean)this.currentItem).getDatumLoeschung());
        }
        if (JR_BEMERKUNG.equals(fieldName)) {
            return ((RebeCustomBean)this.currentItem).getBemerkung();
        }
        throw new IllegalArgumentException("Field " + fieldName + " is not supported in this report");
    }
}

