/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.datasource;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.RessortCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltendeDienststelleCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltungsbereichCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.report.datasource.ADataSource;
import de.cismet.lagis.wizard.GeometryWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;

public class VerwaltungsBereichDataSource
extends ADataSource<VerwaltungsbereichCustomBean>
implements JRDataSource {
    private static final String JR_DIENSTSTELLE = "dienststelle";
    private static final String JR_FLAECHE = "flaeche";
    private Geometry currentGeom;

    public VerwaltungsBereichDataSource() {
    }

    public VerwaltungsBereichDataSource(List<VerwaltungsbereichCustomBean> vbList) {
        super(vbList);
    }

    @Override
    protected List<VerwaltungsbereichCustomBean> retrieveData() {
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        Collection<VerwaltungsbereichCustomBean> vbSet = currentFlurstueck.getVerwaltungsbereiche();
        FlurstueckSchluesselCustomBean fsKey = currentFlurstueck.getFlurstueckSchluessel();
        ArrayList<FlurstueckSchluesselCustomBean> fsList = new ArrayList<FlurstueckSchluesselCustomBean>(1);
        fsList.add(fsKey);
        GeometryWorker worker = new GeometryWorker(fsList);
        Object result = worker.call();
        this.currentGeom = (Geometry)result.get(fsKey);
        return new ArrayList<VerwaltungsbereichCustomBean>(vbSet);
    }

    @Override
    protected Object getFieldValue(String fieldName) throws JRException {
        if (JR_DIENSTSTELLE.equals(fieldName)) {
            VerwaltendeDienststelleCustomBean dienst = ((VerwaltungsbereichCustomBean)this.currentItem).getDienststelle();
            if (dienst == null) {
                return null;
            }
            RessortCustomBean ressort = dienst.getRessort();
            if (ressort == null) {
                return null;
            }
            return ressort.getAbkuerzung();
        }
        if (JR_FLAECHE.equals(fieldName)) {
            Geometry geom = ((VerwaltungsbereichCustomBean)this.currentItem).getGeometry();
            if (geom == null) {
                if (this.currentGeom == null) {
                    return super.formatNumber(0);
                }
                return super.formatNumber((int)Math.round(this.currentGeom.getArea()));
            }
            return super.formatNumber((int)Math.round(geom.getArea()));
        }
        throw new IllegalArgumentException("Field " + fieldName + " is not supported in this report");
    }
}

