/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.datasource;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.report.datasource.ADataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;

public class VorgaengeDataSource
extends ADataSource<VertragCustomBean>
implements JRDataSource {
    private static final String JR_ART = "art";
    private static final String JR_AKTZ = "aktz";
    private static final String JR_KAUFPREIS = "kaufpreis_nk";
    private static final String JR_QM_PREIS = "qm_preis";
    private static final String JR_AUFLASSUNG = "auflassung";
    private static final String JR_EINTRAGUNG = "eintragung";
    private static final String JR_VPARTNER = "vertragspartner";
    private static final String JR_BEMERKUNG = "bemerkung";

    public VorgaengeDataSource() {
    }

    public VorgaengeDataSource(List<VertragCustomBean> vertraegeList) {
        super(vertraegeList);
    }

    @Override
    protected List<VertragCustomBean> retrieveData() {
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        Collection<VertragCustomBean> vertraegeSet = currentFlurstueck.getVertraege();
        return new ArrayList<VertragCustomBean>(vertraegeSet);
    }

    @Override
    protected Object getFieldValue(String fieldName) throws JRException {
        if (JR_ART.equals(fieldName)) {
            return ((VertragCustomBean)this.currentItem).getVertragsart().getBezeichnung();
        }
        if (JR_AKTZ.equals(fieldName)) {
            return ((VertragCustomBean)this.currentItem).getAktenzeichen();
        }
        if (JR_KAUFPREIS.equals(fieldName)) {
            return super.formatNumber(((VertragCustomBean)this.currentItem).getGesamtpreis());
        }
        if (JR_QM_PREIS.equals(fieldName)) {
            return super.formatNumber(((VertragCustomBean)this.currentItem).getQuadratmeterpreis());
        }
        if (JR_AUFLASSUNG.equals(fieldName)) {
            return super.formatDate(((VertragCustomBean)this.currentItem).getDatumAuflassung());
        }
        if (JR_EINTRAGUNG.equals(fieldName)) {
            return super.formatDate(((VertragCustomBean)this.currentItem).getDatumEintragung());
        }
        if (JR_VPARTNER.equals(fieldName)) {
            return ((VertragCustomBean)this.currentItem).getVertragspartner();
        }
        if (JR_BEMERKUNG.equals(fieldName)) {
            return ((VertragCustomBean)this.currentItem).getBemerkung();
        }
        throw new IllegalArgumentException("Field " + fieldName + " is not supported in this report");
    }
}

