/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.test;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaCustomBean;
import de.cismet.cids.custom.beans.lagis.RebeCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class TestOjectsWithGeomToJson {
    public static void main(String[] args) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            mapper.registerModule((Module)module);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            ConnectionContext context = ConnectionContext.createDummy();
            DevelopmentTools.showSimpleLoginDialog((String)"http://localhost:9986/callserver/binary", (String)"LAGIS", (boolean)true, (ConnectionContext)context);
            LagisBroker.getInstance().setDomain("LAGIS");
            MetaClass mcFlurstueck = CidsBroker.getInstance().getLagisMetaClass("flurstueck");
            MetaClass mcAlkisFlurstueck = CidsBroker.getInstance().getLagisMetaClass("ALKIS_FLURSTUECK");
            List<Integer> multiVerwaltungsBereichFlurstueckIds = Arrays.asList(22726);
            for (Integer flurstueckId : multiVerwaltungsBereichFlurstueckIds) {
                FlurstueckCustomBean flurstueck = (FlurstueckCustomBean)CidsBroker.getInstance().getMetaObject(flurstueckId, mcFlurstueck.getId(), "LAGIS").getBean();
                FlurstueckSchluesselCustomBean flurstueckSchluessel = flurstueck.getFlurstueckSchluessel();
                String alkisFlurstueckQuery = String.format("SELECT %d, id FROM alkis_flurstueck WHERE fk_schluessel = %d LIMIT 1;", mcAlkisFlurstueck.getID(), flurstueckSchluessel.getId());
                MetaObject[] mosAlkisFlurstueck = CidsBroker.getInstance().getLagisMetaObject(alkisFlurstueckQuery);
                CidsBean alkisFlurstueck = mosAlkisFlurstueck != null && mosAlkisFlurstueck.length > 0 ? mosAlkisFlurstueck[0].getBean() : null;
                Geometry flurstueckGeometrie = (Geometry)alkisFlurstueck.getProperty("geometrie");
                List<MipaCustomBean> mipas = LagisBroker.getInstance().getMiPas(flurstueckGeometrie);
                List<RebeCustomBean> rebes = LagisBroker.getInstance().getRechteUndBelastungen(flurstueckGeometrie);
                String historyDot = LagisBroker.getInstance().getHistoryGraph(flurstueck, LagisBroker.HistoryLevel.DIRECT_RELATIONS, 0, LagisBroker.HistorySibblingLevel.NONE, 0, LagisBroker.HistoryType.BOTH, null);
                String flurstueckJson = flurstueck.toJSONString(false);
                String mipasJson = CidsBean.toJSONString((boolean)false, mipas);
                String rebesJson = CidsBean.toJSONString((boolean)false, rebes);
                Map flurstueckMap = (Map)mapper.readValue(flurstueckJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
                List mipasMap = (List)mapper.readValue(mipasJson, (TypeReference)new TypeReference<List<Map>>(){});
                List rebesMap = (List)mapper.readValue(rebesJson, (TypeReference)new TypeReference<List<Map>>(){});
                flurstueckMap.put("historyDot", historyDot);
                flurstueckMap.put("mipas", mipasMap);
                flurstueckMap.put("rebes", rebesMap);
                String prettyJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)flurstueckMap);
                try (FileOutputStream out = new FileOutputStream("/tmp/fs_" + flurstueckId + ".json");){
                    IOUtils.write((String)prettyJson, (OutputStream)out, (String)"UTF-8");
                }
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

