/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.thread;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.interfaces.DoneDelegate;
import de.cismet.lagis.thread.WFSRetrieverFactory;
import de.cismet.lagis.thread.WFSWorkerThread;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.deegree.model.feature.FeatureCollection;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.JTSAdapter;
import org.jdom.Element;

public class WFSByKeyWorkerThread
extends WFSWorkerThread<FlurstueckSchluesselCustomBean, com.vividsolutions.jts.geom.Geometry> {
    private static final Logger LOG = Logger.getLogger(WFSByKeyWorkerThread.class);

    public WFSByKeyWorkerThread(FlurstueckSchluesselCustomBean key, DoneDelegate doneDelegate, HashMap<Integer, Boolean> properties) {
        super(key, doneDelegate, properties);
    }

    public FlurstueckSchluesselCustomBean getFlurstueckKey() {
        return (FlurstueckSchluesselCustomBean)this.getKey();
    }

    @Override
    protected Element getQuery() {
        return WFSRetrieverFactory.getInstance().getWFSQuery(this.getFlurstueckKey());
    }

    @Override
    protected String getHostname() {
        return WFSRetrieverFactory.getInstance().getHostname();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected com.vividsolutions.jts.geom.Geometry doInBackground() throws Exception {
        try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(this.exec()));){
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"doInBackground (WFSRetriever) is canceled");
                }
                com.vividsolutions.jts.geom.Geometry geometry = null;
                return geometry;
            }
            FeatureCollection featuresCollection = this.parse(reader);
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"doInBackground (WFSRetriever) is canceled");
                }
                com.vividsolutions.jts.geom.Geometry geometry = null;
                return geometry;
            }
            if (featuresCollection == null) {
                LOG.info((Object)"WFS Single Request brachte kein Ergebnis");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("FeatureCollection : " + featuresCollection));
                }
                com.vividsolutions.jts.geom.Geometry geometry = null;
                return geometry;
            }
            int featureSize = featuresCollection.size();
            if (featureSize == 0) {
                LOG.info((Object)"Feature Collection ist leer");
                this.hadErrors = true;
                this.errorMessage = "Es wurden keine Geometrien zu dem angegebenen Schl\u00fcssel gefunden";
                com.vividsolutions.jts.geom.Geometry geometry = null;
                return geometry;
            }
            if (featureSize == 1) {
                com.vividsolutions.jts.geom.Geometry geom;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"WFS Request erbrachte genau ein Ergebnis");
                }
                com.vividsolutions.jts.geom.Geometry geometry = geom = JTSAdapter.export((Geometry)featuresCollection.getFeature(0).getDefaultGeometryPropertyValue());
                return geometry;
            }
            LOG.info((Object)("WFS lieferte mehr als ein Ergebnis zur\u00fcck: " + featureSize));
            this.hadErrors = true;
            this.errorMessage = "Der WFS lieferte mehrere Geometrien zur\u00fcck";
            com.vividsolutions.jts.geom.Geometry geometry = null;
            return geometry;
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim abrufen der WFS Geometrie ", (Throwable)ex);
            return null;
        }
    }
}

