/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.thread;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.interfaces.DoneDelegate;
import de.cismet.lagis.thread.WFSByKeyWorkerThread;
import de.cismet.tools.configuration.Configurable;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class WFSRetrieverFactory
implements Configurable {
    private static WFSRetrieverFactory INSTANCE;
    private static final Logger LOG;
    private static final Namespace OGC_NAMESPACE;
    private static final Namespace WFS_NAMESPACE;
    private Element gemarkung;
    private Element flur;
    private Element flurstZaehler;
    private Element flurstNenner;
    private Element wfsQuery;
    private String hostname;

    private WFSRetrieverFactory() {
    }

    public static WFSRetrieverFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WFSRetrieverFactory();
        }
        return INSTANCE;
    }

    public String getHostname() {
        return this.hostname;
    }

    public SwingWorker getWFSRetriever(FlurstueckSchluesselCustomBean key, DoneDelegate doneDelegate, HashMap<Integer, Boolean> properties) {
        return new WFSByKeyWorkerThread(key, doneDelegate, properties);
    }

    public Element getWFSQuery(FlurstueckSchluesselCustomBean key) {
        this.gemarkung.setText(key.getGemarkung().getSchluessel().toString());
        this.flur.setText(key.getFlur().toString());
        this.flurstZaehler.setText(key.getFlurstueckZaehler().toString());
        this.flurstNenner.setText(key.getFlurstueckNenner().toString());
        return (Element)this.wfsQuery.clone();
    }

    public Element getConfiguration() {
        return null;
    }

    public void masterConfigure(Element parent) {
        try {
            this.hostname = parent.getChild("WFSRequest").getChild("Hostname").getText();
            this.wfsQuery = (Element)parent.getChild("WFSRequest").getChild("Query").getChild("GetFeature", WFS_NAMESPACE).clone();
            List byKeyChilds = this.wfsQuery.getChild("Query", WFS_NAMESPACE).getChild("Filter", OGC_NAMESPACE).getChild("And", OGC_NAMESPACE).getChildren("PropertyIsEqualTo", OGC_NAMESPACE);
            if (byKeyChilds != null && byKeyChilds.size() > 0) {
                for (Element currentElement : byKeyChilds) {
                    Element name = currentElement.getChild("PropertyName", OGC_NAMESPACE);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Name: " + name.getText()));
                    }
                    if (name.getText().equals("app:gem")) {
                        this.gemarkung = currentElement.getChild("Literal", OGC_NAMESPACE);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Gemarkung Literal gesetzt: " + this.gemarkung));
                        continue;
                    }
                    if (name.getText().equals("app:flur")) {
                        this.flur = currentElement.getChild("Literal", OGC_NAMESPACE);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Flur Literal gesetzt: " + this.flur));
                        continue;
                    }
                    if (name.getText().equals("app:flurstz")) {
                        this.flurstZaehler = currentElement.getChild("Literal", OGC_NAMESPACE);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Flur Z\u00e4hler Literal gesetzt: " + this.flurstZaehler));
                        continue;
                    }
                    if (name.getText().equals("app:flurstn")) {
                        this.flurstNenner = currentElement.getChild("Literal", OGC_NAMESPACE);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Flur Nenner Literal gesetzt: " + this.flurstNenner));
                        continue;
                    }
                    LOG.warn((Object)"Unbekanntes Literal");
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler bei der Konfiguration der WFSQuery/Request", (Throwable)ex);
        }
    }

    public void configure(Element parent) {
    }

    static {
        LOG = Logger.getLogger(WFSRetrieverFactory.class);
        OGC_NAMESPACE = Namespace.getNamespace((String)"", (String)"http://www.opengis.net/ogc");
        WFS_NAMESPACE = Namespace.getNamespace((String)"wfs", (String)"http://www.opengis.net/wfs");
    }
}

