/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.thread;

import de.cismet.lagis.interfaces.DoneDelegate;
import de.cismet.lagis.thread.ExtendedSwingWorker;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.deegree.model.feature.FeatureCollection;
import org.deegree.model.feature.GMLFeatureCollectionDocument;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public abstract class WFSWorkerThread<K, R>
extends ExtendedSwingWorker<R, Void> {
    private static final Logger LOG = Logger.getLogger(WFSWorkerThread.class);
    private final DoneDelegate doneDelegate;
    private final HashMap<Integer, Boolean> properties;
    private final K key;

    public WFSWorkerThread(K key, DoneDelegate doneDelegate, HashMap<Integer, Boolean> properties) {
        super(key);
        this.key = key;
        this.doneDelegate = doneDelegate;
        this.properties = properties;
    }

    protected K getKey() {
        return this.key;
    }

    protected abstract Element getQuery();

    protected abstract String getHostname();

    protected byte[] exec() throws Exception {
        try {
            int code;
            if (this.key == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"WFS retrieval unterbrochen Schl\u00fcssel null");
                }
                return null;
            }
            Document doc = new Document();
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"doInBackground (WFSRetriever) is canceled");
                }
                return null;
            }
            doc.setRootElement(this.getQuery());
            XMLOutputter out = new XMLOutputter();
            String postString = out.outputString(doc);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PostString f\u00fcr WFS :" + postString));
            }
            HttpClient client = new HttpClient();
            String proxySet = System.getProperty("proxySet");
            if (proxySet != null && proxySet.equals("true")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"proxyIs Set");
                    LOG.debug((Object)("ProxyHost:" + System.getProperty("http.proxyHost")));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ProxyPort:" + System.getProperty("http.proxyPort")));
                }
                try {
                    client.getHostConfiguration().setProxy(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")));
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem while setting proxy", (Throwable)e);
                }
            }
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"doInBackground (WFSRetriever) is canceled");
                }
                return null;
            }
            PostMethod httppost = new PostMethod(this.getHostname());
            httppost.setRequestEntity((RequestEntity)new StringRequestEntity(postString));
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"doInBackground (WFSRetriever) is canceled");
                }
                return null;
            }
            long start = System.currentTimeMillis();
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"doInBackground (WFSRetriever) is canceled");
                }
                return null;
            }
            LOG.info((Object)("doInBackground: start communication with host " + httppost.getHostConfiguration()));
            client.executeMethod((HttpMethod)httppost);
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"doInBackground (WFSRetriever) is canceled");
                }
                return null;
            }
            long stop = System.currentTimeMillis();
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)((double)(stop - start) / 1000.0 + " Sekunden dauerte das getFeature Request "));
            }
            if ((code = httppost.getStatusCode()) == 200) {
                if (this.isCancelled()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"doInBackground (WFSRetriever) is canceled");
                    }
                    httppost.releaseConnection();
                    return null;
                }
                return IOUtils.toByteArray((InputStream)httppost.getResponseBodyAsStream());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HTTP statuscode != ok: " + code));
            }
            httppost.releaseConnection();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim abrufen der WFS Geometrie ", (Throwable)ex);
        }
        return null;
    }

    @Override
    protected void done() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Job is Done calling Delegate");
        }
        if (this.doneDelegate != null) {
            this.doneDelegate.jobDone(this, this.properties);
        } else {
            LOG.warn((Object)"Delegate == null kann Job nicht beenden");
        }
    }

    public FeatureCollection parse(InputStreamReader reader) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"start parsing");
            }
            long start = System.currentTimeMillis();
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"parse() (WFSRetriever) is canceled");
                }
                return null;
            }
            GMLFeatureCollectionDocument doc = new GMLFeatureCollectionDocument();
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"parse()(WFSRetriever) is canceled");
                }
                return null;
            }
            doc.load((Reader)reader, "http://dummyID");
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"parse()(WFSRetriever) is canceled");
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("resultString :" + doc.toString()));
            }
            FeatureCollection tmp = doc.parse();
            if (this.isCancelled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"parse()(WFSRetriever) is canceled");
                }
                return null;
            }
            long stop = System.currentTimeMillis();
            LOG.info((Object)((double)(stop - start) / 1000.0 + " Sekunden dauerte das parsen"));
            return tmp;
        }
        catch (Exception e) {
            LOG.error((Object)"Fehler beim parsen der Features.", (Throwable)e);
            return null;
        }
    }
}

