/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.validation;

import de.cismet.lagis.validation.Validatable;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class Validator
implements ValidationStateChangedListener {
    JComponent comp = null;
    Validatable vali = null;
    ImageIcon valid = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/validation/green.png"));
    ImageIcon warning = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/validation/orange.png"));
    ImageIcon error = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/validation/red.png"));
    JLabel iconContainer = new JLabel();
    private final Logger log = Logger.getLogger(this.getClass());

    public Validator(JComponent comp) {
        this.comp = comp;
        this.iconContainer.setHorizontalAlignment(4);
        this.iconContainer.setVerticalAlignment(1);
        this.iconContainer.setCursor(Cursor.getPredefinedCursor(0));
        comp.setLayout(new BorderLayout());
        comp.add((Component)this.iconContainer, "East");
        this.iconContainer.setVisible(true);
        this.iconContainer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Validator.this.iconContainerMouseClicked(evt);
            }
        });
    }

    public Validator(JComponent comp, Validatable vali) {
        this(comp);
        this.reSetValidator(vali);
    }

    public void iconContainerMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (evt.getButton() == 1 && this.vali != null) {
                this.vali.showAssistent(this.comp);
            }
        }
    }

    public void reSetValidator(Validatable vali) {
        if (vali == null) {
            this.log.warn((Object)"VALI == NULL");
            this.iconContainer.setVisible(false);
        } else {
            this.vali = vali;
            this.comp.remove(this.iconContainer);
            this.iconContainer.setVisible(true);
            this.comp.setLayout(new BorderLayout());
            this.comp.add((Component)this.iconContainer, "East");
            vali.addValidationStateChangedListener(this);
            this.validationStateChanged(null);
        }
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        if (this.vali != null) {
            int status = this.vali.getStatus();
            this.iconContainer.setToolTipText(this.vali.getValidationMessage());
            this.iconContainer.setVisible(true);
            switch (status) {
                case 2: {
                    this.iconContainer.setIcon(this.error);
                    this.iconContainer.putClientProperty("state", "ERROR");
                    break;
                }
                case 1: {
                    this.iconContainer.setIcon(this.warning);
                    this.iconContainer.putClientProperty("state", "WARNING");
                    break;
                }
                case 0: {
                    this.iconContainer.setIcon(this.valid);
                    this.iconContainer.putClientProperty("state", "VALID");
                    Integer counter = (Integer)this.iconContainer.getClientProperty("validCounter");
                    if (counter != null) {
                        this.iconContainer.putClientProperty("validCounter", new Integer(counter + 1));
                    } else {
                        this.iconContainer.putClientProperty("validCounter", new Integer(1));
                    }
                    ActionListener timerAction = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            if (Validator.this.iconContainer.getClientProperty("state").equals("VALID")) {
                                Integer counter = (Integer)Validator.this.iconContainer.getClientProperty("validCounter");
                                Validator.this.iconContainer.putClientProperty("validCounter", new Integer(counter - 1));
                                if (counter.equals(new Integer(1))) {
                                    Validator.this.iconContainer.setVisible(false);
                                }
                            } else {
                                Validator.this.iconContainer.putClientProperty("validCounter", new Integer(0));
                            }
                        }
                    };
                    Timer timer = new Timer(4000, timerAction);
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        }
    }

    public int getValidationState() {
        if (this.vali == null) {
            return 2;
        }
        return this.vali.getStatus();
    }

    public String getValidationMessage() {
        if (this.vali == null && this.vali.getValidationMessage() != null) {
            return "Keine Fehlernachricht vorhanden";
        }
        return this.vali.getValidationMessage();
    }
}

