/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.wizard.GeometryWorker;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.netbeans.spi.wizard.WizardController;

public final class GeometryAreaChecker
implements GeometryWorker.IPostExecutionListener,
Runnable {
    private WizardController wizardCtrl;
    private JPanel panel;
    private List<FlurstueckSchluesselCustomBean> targetKeys;
    private Map<FlurstueckSchluesselCustomBean, Geometry> resultGeomsMap;
    private double sumArea;
    private double sumTargets;
    private Map<FlurstueckSchluesselCustomBean, Geometry> targetGeomsMap;
    private boolean hasProblem;

    public GeometryAreaChecker(List<FlurstueckSchluesselCustomBean> targetKeys, JPanel panel, WizardController wizardCtrl) {
        this.init(targetKeys, panel, wizardCtrl);
    }

    public GeometryAreaChecker(FlurstueckSchluesselCustomBean targetKey, JPanel panel, WizardController wizardCtrl) {
        ArrayList<FlurstueckSchluesselCustomBean> targetKeys = new ArrayList<FlurstueckSchluesselCustomBean>(1);
        targetKeys.add(targetKey);
        this.init(targetKeys, panel, wizardCtrl);
    }

    private void init(List<FlurstueckSchluesselCustomBean> targetKeys, JPanel panel, WizardController wizardCtrl) {
        if (wizardCtrl == null || panel == null || targetKeys == null) {
            throw new NullPointerException();
        }
        this.wizardCtrl = wizardCtrl;
        this.panel = panel;
        this.targetKeys = targetKeys;
        this.targetGeomsMap = new HashMap<FlurstueckSchluesselCustomBean, Geometry>(targetKeys.size());
        this.hasProblem = true;
        this.sumArea = 0.0;
        this.sumTargets = 0.0;
    }

    public boolean hasProblem() {
        return this.hasProblem;
    }

    public double getSumArea() {
        return this.sumArea;
    }

    public double getSumTargets() {
        return this.sumTargets;
    }

    public List<FlurstueckSchluesselCustomBean> getTargetFlurstueckKeys() {
        return this.targetKeys;
    }

    public Map<FlurstueckSchluesselCustomBean, Geometry> getTargetGeometriesMap() {
        return this.targetGeomsMap;
    }

    public Map<FlurstueckSchluesselCustomBean, Geometry> getResultGeometriesMap() {
        return this.resultGeomsMap;
    }

    private void enableChildren(Container container, boolean isEnabled) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof Container) {
                this.enableChildren((Container)components[i], isEnabled);
            }
            components[i].setEnabled(isEnabled);
        }
    }

    @Override
    public void run() {
        this.wizardCtrl.setBusy(true);
        this.enableChildren(this.panel, false);
        this.wizardCtrl.setProblem("Pr\u00fcfe Flurst\u00fccke...");
    }

    @Override
    public void done(Map<FlurstueckSchluesselCustomBean, Geometry> geometriesMap) {
        this.resultGeomsMap = geometriesMap;
        this.wizardCtrl.setBusy(false);
        this.enableChildren(this.panel, true);
        this.wizardCtrl.setProblem(null);
        double sumTargets = 0.0;
        for (FlurstueckSchluesselCustomBean targetKey : this.targetKeys) {
            Geometry geom = geometriesMap.remove(targetKey);
            if (geom == null) {
                this.wizardCtrl.setProblem(String.format("Konnte Geometrie zu Flurst\u00fcck %s nicht finden.", targetKey.getKeyString()));
                return;
            }
            sumTargets += geom == null ? 0.0 : geom.getArea();
            this.targetGeomsMap.put(targetKey, geom);
        }
        this.sumTargets = sumTargets;
        double sumArea = 0.0;
        for (Map.Entry<FlurstueckSchluesselCustomBean, Geometry> entry : geometriesMap.entrySet()) {
            Geometry geom2 = entry.getValue();
            if (geom2 == null) {
                this.wizardCtrl.setProblem(String.format("Konnte keine Geometrie zu Flurst\u00fcck %s finden.", entry.getKey().getKeyString()));
                return;
            }
            sumArea += geom2 == null ? 0.0 : geom2.getArea();
        }
        this.sumArea = sumArea;
        this.hasProblem = false;
    }

    @Override
    public void doneWithErrors(Exception e) {
        this.wizardCtrl.setProblem("Fehler beim Pr\u00fcfen der Geometrien");
    }

    public String toString() {
        return "GeometryAreaChecker{wizardCtrl=" + this.wizardCtrl + ", panel=" + this.panel + ", targetKeys=" + this.targetKeys + ", sumArea=" + this.sumArea + ", sumTargets=" + this.sumTargets + ", hasProblem=" + this.hasProblem + '}';
    }
}

