/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.panels;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.WizardController;

public class ActivateActionPanel
extends JPanel
implements ValidationStateChangedListener {
    public static final String KEY_ACTIVATE_CANDIDATE = "activateCandidate";
    private final Logger log = Logger.getLogger(this.getClass());
    private final WizardController wizardController;
    private final Map wizardData;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private FlurstueckChooser panActivate;

    public ActivateActionPanel(WizardController wizardController, Map wizardData) {
        this.initComponents();
        this.wizardController = wizardController;
        this.wizardData = wizardData;
        wizardController.setProblem("Bitte w\u00e4hlen Sie das Flurst\u00fcck aus das aktiviert werden soll");
        this.panActivate.addValidationStateChangedListener(this);
        this.panActivate.requestFlurstueck(LagisBroker.getInstance().getCurrentFlurstueckSchluessel());
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        if (this.panActivate.getStatus() == 0) {
            CidsBean sperre = LagisBroker.getInstance().isLocked(this.panActivate.getCurrentFlurstueckSchluessel());
            if (sperre != null) {
                this.wizardController.setProblem("Ausgew\u00e4hltes Flurst\u00fcck ist gesperrt von Benutzer: " + (String)sperre.getProperty("user_string"));
                return;
            }
            try {
                if (LagisBroker.getInstance().hasFlurstueckSucccessors(this.panActivate.getCurrentFlurstueckSchluessel())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Flurst\u00fcck kann nicht aktiviert werden es hat nachfogler");
                    }
                    this.wizardController.setProblem("Ausgew\u00e4hltes Flurst\u00fcck hat Nachfolger und kann nicht aktiviert werden ");
                    return;
                }
            }
            catch (ActionNotSuccessfulException ex) {
                this.log.error((Object)"Fehler beim Abfragen ob ein Flurst\u00fcck Nachfolger hat", (Throwable)ex);
                this.wizardController.setProblem(ex.getMessage());
                return;
            }
            this.wizardData.put(KEY_ACTIVATE_CANDIDATE, this.panActivate.getCurrentFlurstueckSchluessel());
            this.wizardController.setProblem(null);
            this.wizardController.setForwardNavigationMode(2);
        } else {
            this.wizardController.setProblem(this.panActivate.getValidationMessage());
        }
    }

    private void initComponents() {
        this.panActivate = new FlurstueckChooser(FlurstueckChooser.Mode.CONTINUATION_HISTORIC);
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1.setText("Flurst\u00fcck");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 381, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 58, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.panActivate, -2, 349, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panActivate, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

