/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.panels;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.interfaces.DoneDelegate;
import de.cismet.lagis.thread.ExtendedSwingWorker;
import de.cismet.lagis.thread.WFSRetrieverFactory;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.WizardController;

public class CreateActionPanel
extends JPanel
implements ValidationStateChangedListener,
ChangeListener {
    private static final Logger LOG = Logger.getLogger(CreateActionPanel.class);
    public static final String KEY_CREATE_CANDIDATE = "createCandidate";
    public static final String KEY_IS_STAEDTISCH = "isStaedtisch";
    private final WizardController wizardController;
    private final Map wizardData;
    private boolean isStaedtisch = true;
    private final Icon icoStaedtisch = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/current.png"));
    private final Icon icoAbteilungIX = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/abteilungIX.png"));
    private final Icon icoStaedtischHistoric = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic.png"));
    private final Icon icoAbteilungIXHistoric = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic_abteilungIX.png"));
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JLabel lblAbteilungIX;
    private JLabel lblStaedtisch;
    private JPanel pKind;
    private FlurstueckChooser panCreate;
    private JRadioButton rbAbteilungIX;
    private ButtonGroup rbGroup;
    private JRadioButton rbStaedtisch;

    public CreateActionPanel(WizardController wizardController, Map wizardData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Create Action Panel wird angelegt");
        }
        this.initComponents();
        this.jLabel3.setVisible(false);
        this.jLabel4.setVisible(false);
        this.rbGroup.add(this.rbStaedtisch);
        this.rbGroup.add(this.rbAbteilungIX);
        this.rbStaedtisch.setSelected(true);
        this.rbStaedtisch.getModel().addChangeListener(this);
        this.rbAbteilungIX.getModel().addChangeListener(this);
        this.wizardController = wizardController;
        this.wizardData = wizardData;
        wizardController.setProblem("Bitte geben Sie den neuen Flurst\u00fccksschl\u00fcssel ein");
        this.panCreate.addValidationStateChangedListener(this);
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        if (this.panCreate.getStatus() == 0) {
            final FlurstueckSchluesselCustomBean flurstueckSchluessel = this.panCreate.getCurrentFlurstueckSchluessel();
            CidsBean sperre = LagisBroker.getInstance().isLocked(flurstueckSchluessel);
            if (sperre != null) {
                this.wizardController.setProblem("Ausgew\u00e4hltes Flurst\u00fcck ist gesperrt von Benutzer: " + (String)sperre.getProperty("user_string"));
                return;
            }
            SwingWorker currentWFSRetriever = WFSRetrieverFactory.getInstance().getWFSRetriever(flurstueckSchluessel, new DoneDelegate<Geometry, Void>(){

                @Override
                public void jobDone(ExtendedSwingWorker<Geometry, Void> worker, HashMap<Integer, Boolean> properties) {
                    try {
                        Geometry result = (Geometry)worker.get();
                        CreateActionPanel.this.jLabel3.setVisible(result == null);
                        CreateActionPanel.this.jLabel4.setVisible(result == null);
                        if (result == null) {
                            CreateActionPanel.this.revalidate();
                            CreateActionPanel.this.repaint();
                        }
                        CreateActionPanel.this.wizardData.put(CreateActionPanel.KEY_CREATE_CANDIDATE, flurstueckSchluessel);
                        CreateActionPanel.this.wizardData.put(CreateActionPanel.KEY_IS_STAEDTISCH, CreateActionPanel.this.isStaedtisch);
                        CreateActionPanel.this.wizardController.setProblem(null);
                        WizardController wizardController = CreateActionPanel.this.wizardController;
                        CreateActionPanel.this.wizardController;
                        wizardController.setForwardNavigationMode(2);
                    }
                    catch (Exception ex) {
                        CreateActionPanel.this.wizardController.setProblem("Suche nach Geometry des ausgew\u00e4hlten Flurst\u00fccks gescheitert.");
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }, null);
            LagisBroker.getInstance().execute(currentWFSRetriever);
        } else {
            this.jLabel3.setVisible(false);
            this.jLabel4.setVisible(false);
            this.wizardController.setProblem(this.panCreate.getValidationMessage());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.rbStaedtisch.getModel())) {
            if (this.rbStaedtisch.isSelected()) {
                this.lblStaedtisch.setIcon(this.icoStaedtisch);
            } else {
                this.lblStaedtisch.setIcon(this.icoStaedtischHistoric);
            }
            this.validationStateChanged(this);
        } else {
            if (this.rbAbteilungIX.isSelected()) {
                this.lblAbteilungIX.setIcon(this.icoAbteilungIX);
            } else {
                this.lblAbteilungIX.setIcon(this.icoAbteilungIXHistoric);
            }
            this.validationStateChanged(this);
        }
    }

    private void initComponents() {
        this.rbGroup = new ButtonGroup();
        this.jPanel5 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.panCreate = new FlurstueckChooser(FlurstueckChooser.Mode.CREATION);
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.pKind = new JPanel();
        this.rbStaedtisch = new JRadioButton();
        this.rbAbteilungIX = new JRadioButton();
        this.lblAbteilungIX = new JLabel();
        this.lblStaedtisch = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setLayout(new GridBagLayout());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Neues Flurst\u00fcck");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.jPanel2.add((Component)this.panCreate, gridBagConstraints);
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/warn.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("<html><b color=\"red\">Achtung: Es konnte keine ALKIS-Geometrie zu diesem Flurst\u00fcck gefunden werden. \u00dcberpr\u00fcfen Sie bitte Ihre Flurst\u00fcckseingabe.<br><br>Befindet sich das Flurst\u00fcck au\u00dferhalb von Wuppertal, dann kann diese Warnung ignoriert werden.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.pKind.setLayout(new GridBagLayout());
        this.rbStaedtisch.setText("St\u00e4dtisch");
        this.rbStaedtisch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbStaedtisch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateActionPanel.this.rbStaedtischActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 12, 0);
        this.pKind.add((Component)this.rbStaedtisch, gridBagConstraints);
        this.rbAbteilungIX.setText("Abteilung IX");
        this.rbAbteilungIX.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbAbteilungIX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateActionPanel.this.rbAbteilungIXActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 12, 0);
        this.pKind.add((Component)this.rbAbteilungIX, gridBagConstraints);
        this.lblAbteilungIX.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic_abteilungIX.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 12, 0);
        this.pKind.add((Component)this.lblAbteilungIX, gridBagConstraints);
        this.lblStaedtisch.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/current.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 12, 0);
        this.pKind.add((Component)this.lblStaedtisch, gridBagConstraints);
        this.jLabel2.setText("Art des Flurst\u00fccks:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.pKind.add((Component)this.jLabel2, gridBagConstraints);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 105, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 57, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pKind.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.pKind, gridBagConstraints);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void rbStaedtischActionPerformed(ActionEvent evt) {
        if (this.rbStaedtisch.isSelected()) {
            this.isStaedtisch = true;
        }
    }

    private void rbAbteilungIXActionPerformed(ActionEvent evt) {
        if (this.rbAbteilungIX.isSelected()) {
            this.isStaedtisch = false;
        }
    }
}

