/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.panels;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.netbeans.spi.wizard.WizardController;

public class HistoricActionPanel
extends JPanel
implements ValidationStateChangedListener {
    public static final String KEY_HISTORIC_CANDIDATE = "historicCandidate";
    public static final String KEY_HISTORIC_DATE = "historicDate";
    private final Logger log = Logger.getLogger(this.getClass());
    private final WizardController wizardController;
    private final Map wizardData;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JXDatePicker jxdHistorischDatum;
    private FlurstueckChooser panHistoric;

    public HistoricActionPanel(WizardController wizardController, Map wizardData) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Historic Action Panel wird angelegt");
        }
        this.initComponents();
        this.wizardController = wizardController;
        this.wizardData = wizardData;
        wizardController.setProblem("Bitte w\u00e4hlen Sie das Flurst\u00fcck aus das historisch gesetzt werden soll");
        this.panHistoric.addValidationStateChangedListener(this);
        this.jxdHistorischDatum.setDate(new Date());
        this.panHistoric.requestFlurstueck(LagisBroker.getInstance().getCurrentFlurstueckSchluessel());
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        if (this.panHistoric.getStatus() == 0) {
            CidsBean sperre = LagisBroker.getInstance().isLocked(this.panHistoric.getCurrentFlurstueckSchluessel());
            if (sperre != null) {
                this.wizardController.setProblem("Ausgew\u00e4hltes Flurst\u00fcck ist gesperrt von Benutzer: " + (String)sperre.getProperty("user_string"));
                return;
            }
            this.wizardData.put(KEY_HISTORIC_CANDIDATE, this.panHistoric.getCurrentFlurstueckSchluessel());
            this.wizardController.setProblem(null);
            this.wizardController.setForwardNavigationMode(2);
        } else {
            this.wizardController.setProblem(this.panHistoric.getValidationMessage());
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.panHistoric = new FlurstueckChooser();
        this.jxdHistorischDatum = new JXDatePicker();
        this.jLabel2 = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 381, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 58, Short.MAX_VALUE));
        this.jLabel1.setText("Flurst\u00fcck");
        this.jxdHistorischDatum.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.jxdHistorischDatum.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HistoricActionPanel.this.jxdHistorischDatumPropertyChange(evt);
            }
        });
        this.jLabel2.setText("historisch seit:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jxdHistorischDatum, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.panHistoric, -2, 349, -2)))).addContainerGap(136, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panHistoric, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jxdHistorischDatum, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(82, Short.MAX_VALUE)));
    }

    private void jxdHistorischDatumPropertyChange(PropertyChangeEvent evt) {
        this.wizardData.put(KEY_HISTORIC_DATE, this.jxdHistorischDatum.getDate());
    }
}

