/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.panels;

import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import de.cismet.lagis.wizard.panels.ResultingPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.WizardController;

public class JoinActionChoosePanel
extends JPanel
implements ValidationStateChangedListener {
    public static final String KEY_JOIN_KEYS = "joinCandidates";
    private final Logger log = Logger.getLogger(this.getClass());
    private final WizardController wizardController;
    private Map wizardData;
    private final ArrayList<FlurstueckChooser> joinCandidates = new ArrayList();
    private ArrayList<FlurstueckSchluesselCustomBean> joinKeys;
    private JButton btnAddJoinMember;
    private JButton btnRemoveJoinMember;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel panJoinMembers;
    private JScrollPane spJoinMembers;

    public JoinActionChoosePanel(WizardController wizardController, Map wizardData) {
        this.initComponents();
        this.wizardController = wizardController;
        this.wizardData = wizardData;
        wizardController.setProblem("Bitte w\u00e4hlen Sie die Flurst\u00fccke aus, die zusammengelegt werden soll");
        this.btnRemoveJoinMember.setEnabled(false);
        this.addJoinMember(LagisBroker.getInstance().getCurrentFlurstueckSchluessel());
    }

    public void refresh(Map wizardData) {
        this.wizardData = wizardData;
        this.validationStateChanged(this);
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        Iterator<FlurstueckChooser> joinMembers = this.joinCandidates.iterator();
        this.joinKeys = new ArrayList();
        while (joinMembers.hasNext()) {
            FlurstueckChooser curJoinMember = joinMembers.next();
            if (curJoinMember.getStatus() == 2) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Mindestens ein Flurst\u00fcck ,dass gejoined werden soll, ist nicht valide");
                }
                this.wizardController.setProblem(curJoinMember.getValidationMessage());
                return;
            }
            CidsBean sperre = LagisBroker.getInstance().isLocked(curJoinMember.getCurrentFlurstueckSchluessel());
            if (sperre != null) {
                this.wizardController.setProblem("Ausgew\u00e4hltes Flurst\u00fcck ist gesperrt von Benutzer: " + (String)sperre.getProperty("user_string"));
                return;
            }
            this.joinKeys.add(curJoinMember.getCurrentFlurstueckSchluessel());
        }
        if (this.joinKeys.size() == 0) {
            this.wizardController.setProblem("Bitte w\u00e4hlen Sie die Flurst\u00fccke aus, die zusammengelegt werden soll");
            return;
        }
        if (this.joinKeys.size() < 2) {
            this.wizardController.setProblem("Es m\u00fcssen mindestens zwei Flurst\u00fccke ausgew\u00e4hlt werden");
            return;
        }
        if (ResultingPanel.checkForDuplicatedFlurstuecke(this.joinCandidates)) {
            this.wizardController.setProblem("Es darf kein Flurst\u00fcck doppelt ausgew\u00e4hlt werden.");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"keine Duplicate vorhanden");
        }
        FlurstueckArtCustomBean firstArt = null;
        for (FlurstueckSchluesselCustomBean current : this.joinKeys) {
            if (firstArt == null) {
                firstArt = current.getFlurstueckArt();
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flurst\u00fcckart ist == " + FlurstueckArtCustomBean.FLURSTUECK_ART_EQUALATOR.pedanticEquals(current.getFlurstueckArt(), firstArt)));
            }
            if (FlurstueckArtCustomBean.FLURSTUECK_ART_EQUALATOR.pedanticEquals(current.getFlurstueckArt(), firstArt)) continue;
            this.wizardController.setProblem("Alle Flurst\u00fccke m\u00fcssen dieselbe Art haben.");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Alle Flurst\u00fccke haben dieselbe Art");
        }
        this.wizardData.put(KEY_JOIN_KEYS, this.joinKeys);
        this.wizardController.setProblem(null);
        this.wizardController.setForwardNavigationMode(1);
    }

    private void initComponents() {
        this.spJoinMembers = new JScrollPane();
        this.panJoinMembers = new JPanel();
        this.btnAddJoinMember = new JButton();
        this.btnRemoveJoinMember = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.panJoinMembers.setLayout(new GridLayout(0, 1));
        this.spJoinMembers.setViewportView(this.panJoinMembers);
        this.btnAddJoinMember.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddJoinMember.setBorder(null);
        this.btnAddJoinMember.setOpaque(false);
        this.btnAddJoinMember.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoinActionChoosePanel.this.btnAddJoinMemberActionPerformed(evt);
            }
        });
        this.btnRemoveJoinMember.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveJoinMember.setBorder(null);
        this.btnRemoveJoinMember.setOpaque(false);
        this.btnRemoveJoinMember.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoinActionChoosePanel.this.btnRemoveJoinMemberActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Flurst\u00fccke");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 381, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 46, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnAddJoinMember).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemoveJoinMember, -2, 28, -2).addGap(13, 13, 13)).addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.spJoinMembers, -2, 359, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.btnAddJoinMember, this.btnRemoveJoinMember);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnAddJoinMember).addComponent(this.btnRemoveJoinMember, -2, 28, -2)).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spJoinMembers, -2, 139, -2).addContainerGap(75, Short.MAX_VALUE)));
        layout.linkSize(1, this.btnAddJoinMember, this.btnRemoveJoinMember);
    }

    private void btnRemoveJoinMemberActionPerformed(ActionEvent evt) {
        Component[] components = this.panJoinMembers.getComponents();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Anzahl JoinMembers: " + components.length));
        }
        if (components.length > 0) {
            this.panJoinMembers.remove(components[components.length - 1]);
            this.joinCandidates.remove(this.joinCandidates.get(this.joinCandidates.size() - 1));
        }
        if ((components = this.panJoinMembers.getComponents()).length == 0) {
            this.btnRemoveJoinMember.setEnabled(false);
        }
        this.spJoinMembers.repaint();
        this.spJoinMembers.getViewport().repaint();
        this.spJoinMembers.revalidate();
        this.validationStateChanged(null);
    }

    private void addJoinMember(FlurstueckSchluesselCustomBean key) {
        FlurstueckChooser tmp = new FlurstueckChooser(FlurstueckChooser.Mode.CONTINUATION);
        if (this.joinCandidates.size() > 0) {
            FlurstueckChooser lastChooser = this.joinCandidates.get(this.joinCandidates.size() - 1);
            if (lastChooser != null) {
                FlurstueckSchluesselCustomBean currentKey;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Letzter Chooser ist != null");
                }
                if ((currentKey = lastChooser.getCurrentFlurstueckSchluessel()) != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Neuer Flurst\u00fcckChooser wird nach letztem gesetzt");
                    }
                    tmp.doAutomaticRequest(3, currentKey);
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Flurst\u00fcckChooser kann nicht gesetzt werden");
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"letzter Chooser ist == null");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"weniger als 1 Chooser vorhanden");
        }
        tmp.addValidationStateChangedListener(this);
        if (key != null) {
            tmp.requestFlurstueck(key);
        }
        this.panJoinMembers.add(tmp);
        this.joinCandidates.add(tmp);
        this.btnRemoveJoinMember.setEnabled(true);
        this.spJoinMembers.repaint();
        this.spJoinMembers.getViewport().repaint();
        this.spJoinMembers.revalidate();
        this.validationStateChanged(null);
    }

    private void btnAddJoinMemberActionPerformed(ActionEvent evt) {
        this.addJoinMember(null);
    }
}

