/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.panels;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.WizardController;

public class RenameActionPanel
extends JPanel
implements ValidationStateChangedListener,
ActionListener {
    public static final String KEY_CREATE_CANDIDATE = "createCandidate";
    public static final String KEY_RENAME_CANDIDATE = "renameCreateCandidate";
    private final Logger log = Logger.getLogger(this.getClass());
    private final WizardController wizardController;
    private final Map wizardData;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private FlurstueckChooser panCreate;
    private FlurstueckChooser panRename;

    public RenameActionPanel(WizardController wizardController, Map wizardData) {
        this.initComponents();
        this.wizardController = wizardController;
        this.wizardData = wizardData;
        wizardController.setProblem("Bitte w\u00e4hlen Sie das Flurst\u00fcck aus, das umbenannt werden soll");
        this.panRename.addValidationStateChangedListener(this);
        this.panCreate.addValidationStateChangedListener(this);
        this.panRename.addComboBoxListener(this);
        this.panRename.requestFlurstueck(LagisBroker.getInstance().getCurrentFlurstueckSchluessel());
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Object to validate: " + validatedObject));
        }
        if (validatedObject.equals(this.panRename)) {
            FlurstueckSchluesselCustomBean key;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"panRename validation");
            }
            if (this.panRename.getStatus() != 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Rename unvalid");
                }
                this.wizardController.setProblem(this.panRename.getValidationMessage());
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Rename valid");
            }
            if ((key = this.panRename.getCurrentFlurstueckSchluessel()) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Vorauswahl kann getroffen werden");
                }
                this.panCreate.doAutomaticRequest(3, key);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Vorauswahl kann nicht getroffen werden");
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"panCreate Validation");
            }
            if (this.panCreate.getStatus() != 0) {
                this.wizardController.setProblem(this.panCreate.getValidationMessage());
                return;
            }
        }
        if (this.panCreate.getStatus() == 0 && this.panRename.getStatus() == 0) {
            CidsBean sperre = LagisBroker.getInstance().isLocked(this.panRename.getCurrentFlurstueckSchluessel());
            if (sperre != null) {
                this.wizardController.setProblem("Ausgew\u00e4hltes Flurst\u00fcck ist gesperrt von Benutzer: " + (String)sperre.getProperty("user_string"));
                return;
            }
        } else {
            this.wizardController.setProblem(this.panCreate.getValidationMessage());
            return;
        }
        this.panCreate.getCurrentFlurstueckSchluessel().setFlurstueckArt(this.panRename.getCurrentFlurstueckSchluessel().getFlurstueckArt());
        this.wizardData.put(KEY_CREATE_CANDIDATE, this.panCreate.getCurrentFlurstueckSchluessel());
        this.wizardData.put(KEY_RENAME_CANDIDATE, this.panRename.getCurrentFlurstueckSchluessel());
        this.wizardController.setProblem(null);
        this.wizardController.setForwardNavigationMode(2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.panCreate = new FlurstueckChooser(FlurstueckChooser.Mode.CREATION);
        this.panRename = new FlurstueckChooser();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 381, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 58, Short.MAX_VALUE));
        this.jLabel1.setText("Altes Flurst\u00fcck");
        this.jLabel2.setText("Neues Flurst\u00fcck");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.panCreate, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.panRename, GroupLayout.Alignment.LEADING, -1, 360, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panRename, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panCreate, -2, -1, -2)));
    }
}

