/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.panels;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import de.cismet.lagis.wizard.GeometryAreaChecker;
import de.cismet.lagis.wizard.GeometryWorker;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.WizardController;

public class ResultingPanel
extends JPanel
implements ValidationStateChangedListener {
    public static final String JOIN_ACTION_MODE = "joinAction";
    public static final String SPLIT_ACTION_MODE = "splitAction";
    public static final String SPLIT_JOIN_ACTION_MODE = "splitJoinAction";
    public static final String KEY_SPLIT_KEYS = "splitKeys";
    public static final String KEY_JOIN_KEY = "joinKey";
    private static final Logger log = Logger.getLogger(ResultingPanel.class);
    private WizardController wizardController;
    private Map wizardData;
    private String mode;
    private final ArrayList<FlurstueckChooser> resultCandidates = new ArrayList();
    private final ArrayList<FlurstueckSchluesselCustomBean> splitKeys = new ArrayList();
    private JPanel jPanel2;
    private JLabel lblErgebnis;
    private JPanel panAction;
    private JScrollPane spAction;

    public ResultingPanel(WizardController wizardController, Map wizardData, String resultMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Result Panel wird angelegt");
        }
        this.wizardController = wizardController;
        this.wizardData = wizardData;
        this.initComponents();
        this.mode = resultMode;
        FlurstueckSchluesselCustomBean splitCandidate = (FlurstueckSchluesselCustomBean)wizardData.get("splitCandidate");
        if (splitCandidate == null) {
            try {
                ArrayList joinKeys = (ArrayList)wizardData.get("joinCandidates");
                splitCandidate = (FlurstueckSchluesselCustomBean)joinKeys.get(joinKeys.size() - 1);
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Keine JoinKeys vorhanden", (Throwable)ex);
                }
                splitCandidate = null;
            }
        }
        if (this.mode.equals(SPLIT_ACTION_MODE) || this.mode.equals(SPLIT_JOIN_ACTION_MODE)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resultart: Splitaction");
            }
            int splitCount = (Integer)wizardData.get("splitCount");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Anzahl neu erstellter Flurst\u00fccke: " + splitCount));
            }
            for (int i = 0; i < splitCount; ++i) {
                FlurstueckChooser tmpFlst = new FlurstueckChooser(FlurstueckChooser.Mode.CREATION);
                tmpFlst.addValidationStateChangedListener(this);
                if (splitCandidate != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Vorauswahl f\u00fcr Chooser wird gesetzt");
                        log.debug((Object)("zu setzender Key: " + splitCandidate));
                    }
                    tmpFlst.doAutomaticRequest(3, splitCandidate);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Vorauswahl f\u00fcr Chooser wird nicht gesetzt");
                }
                this.resultCandidates.add(tmpFlst);
                this.panAction.add(tmpFlst);
            }
            this.spAction.repaint();
            this.spAction.getViewport().repaint();
            this.spAction.revalidate();
        } else if (this.mode.equals(JOIN_ACTION_MODE)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resultart: JoinAction");
            }
            FlurstueckChooser tmpFlst = new FlurstueckChooser(FlurstueckChooser.Mode.CREATION);
            tmpFlst.addValidationStateChangedListener(this);
            if (splitCandidate != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Vorauswahl f\u00fcr Chooser wird gesetzt");
                    log.debug((Object)("zu setzender Key: " + splitCandidate));
                }
                tmpFlst.doAutomaticRequest(3, splitCandidate);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Vorauswahl f\u00fcr Chooser wird nicht gesetzt");
            }
            this.resultCandidates.add(tmpFlst);
            this.panAction.add(tmpFlst);
            this.spAction.repaint();
            this.spAction.getViewport().repaint();
            this.spAction.revalidate();
        }
        wizardController.setProblem("Bitte vervollst\u00e4ndigen Sie alle Flurst\u00fccke");
    }

    public WizardController getWizardController() {
        return this.wizardController;
    }

    public synchronized void refresh(Map wizardData) {
        this.wizardData = wizardData;
        if (this.mode.equals(SPLIT_ACTION_MODE) || this.mode.equals(SPLIT_JOIN_ACTION_MODE)) {
            Integer splitCount;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resultart: refresh Count");
            }
            if ((splitCount = (Integer)wizardData.get("splitCount")) != null && this.resultCandidates != null && splitCount.intValue() != this.resultCandidates.size()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Anzahl neu erstellter Flurst\u00fccke: " + splitCount));
                }
                this.panAction.removeAll();
                this.resultCandidates.clear();
                this.splitKeys.clear();
                for (int i = 0; i < splitCount; ++i) {
                    FlurstueckChooser tmpFlst = new FlurstueckChooser(FlurstueckChooser.Mode.CREATION);
                    tmpFlst.addValidationStateChangedListener(this);
                    this.resultCandidates.add(tmpFlst);
                    this.panAction.add(tmpFlst);
                }
                this.spAction.repaint();
                this.spAction.getViewport().repaint();
                this.spAction.revalidate();
            }
        }
        this.validationStateChanged(this);
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        this.splitKeys.clear();
        for (FlurstueckChooser curSplitMember : this.resultCandidates) {
            if (curSplitMember.getStatus() == 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Mindestens ein Flurst\u00fcck ,dass aus dem Split entsteht, ist nicht valide");
                }
                this.wizardController.setProblem(curSplitMember.getValidationMessage());
                return;
            }
            this.splitKeys.add(curSplitMember.getCurrentFlurstueckSchluessel());
        }
        if (ResultingPanel.checkForDuplicatedFlurstuecke(this.resultCandidates)) {
            this.wizardController.setProblem("Es darf kein Flurst\u00fcck doppelt ausgew\u00e4hlt werden.");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Alle Flurst\u00fccke f\u00fcr Result sind valide");
        }
        if (JOIN_ACTION_MODE.equals(this.mode)) {
            this.splitKeys.addAll((ArrayList)this.wizardData.get("joinCandidates"));
            if (this.checkGeometryAreas(this.splitKeys.get(0), this.splitKeys)) {
                this.wizardData.put(KEY_JOIN_KEY, this.splitKeys.get(0));
                this.wizardController.setProblem(null);
                this.wizardController.setForwardNavigationMode(1);
            }
        } else if (SPLIT_ACTION_MODE.equals(this.mode)) {
            Object splitCandObj = this.wizardData.get("splitCandidate");
            if (splitCandObj instanceof FlurstueckSchluesselCustomBean) {
                FlurstueckSchluesselCustomBean targetKey = (FlurstueckSchluesselCustomBean)splitCandObj;
                ArrayList<FlurstueckSchluesselCustomBean> fsKeys = new ArrayList<FlurstueckSchluesselCustomBean>(this.splitKeys);
                fsKeys.add(targetKey);
                if (this.checkGeometryAreas(targetKey, fsKeys)) {
                    this.wizardData.put(KEY_SPLIT_KEYS, this.splitKeys);
                    this.wizardController.setProblem(null);
                    this.wizardController.setForwardNavigationMode(1);
                }
            } else {
                log.error((Object)("Split candidate has not type FlurstueckSchluessel: " + splitCandObj));
                this.wizardController.setProblem("Ein interner Fehler ist aufgetreten. Bitte benachrichtigen Sie den Support.");
            }
        } else if (SPLIT_JOIN_ACTION_MODE.equals(this.mode)) {
            Object joinData = this.wizardData.get("joinCandidates");
            if (!(joinData instanceof List)) {
                log.error((Object)("Join data does not have type 'List': " + joinData));
                this.wizardController.setProblem("Ein interner Fehler ist aufgetreten. Bitte benachrichtigen Sie den Support.");
                return;
            }
            List joinKeys = (List)joinData;
            ArrayList<FlurstueckSchluesselCustomBean> allKeys = new ArrayList<FlurstueckSchluesselCustomBean>();
            allKeys.addAll(this.splitKeys);
            allKeys.addAll(joinKeys);
            if (this.checkGeometryAreas(joinKeys, allKeys)) {
                this.wizardData.put("joinCandidates", joinKeys);
                this.wizardData.put(KEY_SPLIT_KEYS, this.splitKeys);
                this.wizardController.setProblem(null);
                this.wizardController.setForwardNavigationMode(1);
            }
        }
    }

    private boolean checkGeometryAreas(List<FlurstueckSchluesselCustomBean> targetKeys, List<FlurstueckSchluesselCustomBean> fsKeys) {
        GeometryWorker gw = new GeometryWorker(fsKeys);
        GeometryAreaChecker checker = new GeometryAreaChecker(targetKeys, (JPanel)this, this.wizardController);
        gw.addPreExecutionListener(checker);
        gw.addPostExecutionListener(checker);
        gw.call();
        this.wizardData.put("Geometry Area Checker", checker);
        return !checker.hasProblem();
    }

    private boolean checkGeometryAreas(FlurstueckSchluesselCustomBean targetKey, List<FlurstueckSchluesselCustomBean> fsKeys) {
        ArrayList<FlurstueckSchluesselCustomBean> targetKeys = new ArrayList<FlurstueckSchluesselCustomBean>(1);
        targetKeys.add(targetKey);
        return this.checkGeometryAreas(targetKeys, fsKeys);
    }

    public static boolean checkForDuplicatedFlurstuecke(ArrayList<FlurstueckChooser> flurstuecke) {
        try {
            if (flurstuecke != null && flurstuecke.size() > 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Anzahl Flurst\u00fccke die zu pr\u00fcfen sind > 1");
                }
                int counter = 0;
                for (FlurstueckChooser flurstueckToTest : flurstuecke) {
                    counter = 0;
                    for (FlurstueckChooser curFlurstueck : flurstuecke) {
                        FlurstueckSchluesselCustomBean schluesselToTest = flurstueckToTest.getCurrentFlurstueckSchluessel();
                        FlurstueckSchluesselCustomBean curSchluessel = curFlurstueck.getCurrentFlurstueckSchluessel();
                        if (schluesselToTest != null && curSchluessel != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Zu testende Schluessel sind != null");
                            }
                            if (FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(schluesselToTest, curSchluessel) && ++counter > 1) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Duplikat gefunden");
                                }
                                return true;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Schl\u00fcssel sind nicht gleich");
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Einer der beiden zu vergleichenden Schl\u00fcssel ist == null");
                    }
                }
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Flurst\u00fccke null oder Anzahl <2");
            }
            return false;
        }
        catch (Exception ex) {
            log.error((Object)"Fehler beim \u00dcberpr\u00fcfen von doppelten Eintr\u00e4gen: ", (Throwable)ex);
            return false;
        }
    }

    private void initComponents() {
        this.lblErgebnis = new JLabel();
        this.jPanel2 = new JPanel();
        this.spAction = new JScrollPane();
        this.panAction = new JPanel();
        this.lblErgebnis.setText("Ergebnis Flurst\u00fccke");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 381, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 58, Short.MAX_VALUE));
        this.panAction.setLayout(new GridLayout(0, 1));
        this.spAction.setViewportView(this.panAction);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblErgebnis)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.spAction, -2, 353, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblErgebnis).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spAction, -2, 136, -2).addContainerGap(80, Short.MAX_VALUE)));
    }
}

