/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.steps;

import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.wizard.panels.ChangeKindActionPanel;
import java.awt.EventQueue;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class ChangeKindActionSteps
extends WizardPanelProvider {
    public ChangeKindActionSteps() {
        super("Flurst\u00fcckart \u00e4ndern...", new String[]{"Flurst\u00fcck ausw\u00e4hlen"}, new String[]{"Auswahl des Flurst\u00fccks"});
    }

    protected JComponent createPanel(WizardController wizardController, String id, Map wizardData) {
        return new ChangeKindActionPanel(wizardController, wizardData);
    }

    public boolean cancel(Map settings) {
        boolean dialogShouldClose = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie den Bearbeitungsvorgang beenden?") == 0;
        return dialogShouldClose;
    }

    protected Object finish(Map settings) throws WizardException {
        return new BackgroundResultCreator();
    }

    static class BackgroundResultCreator
    extends DeferredWizardResult {
        private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

        BackgroundResultCreator() {
        }

        public void start(Map wizardData, ResultProgressHandle progress) {
            block20: {
                if (!LagisBroker.getInstance().checkFlurstueckWizardUserWantsToFinish()) {
                    progress.failed("Die Aktion wurde durch den Benutzer abgebrochen.", true);
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"WizardFinisher: Flurstueckart \u00e4ndern: ");
                }
                assert (!EventQueue.isDispatchThread());
                final FlurstueckSchluesselCustomBean key = (FlurstueckSchluesselCustomBean)wizardData.get("changeCandidate");
                FlurstueckArtCustomBean newArt = (FlurstueckArtCustomBean)wizardData.get("newKind");
                CidsBean sperre = null;
                try {
                    CidsBean other = LagisBroker.getInstance().isLocked(key);
                    if (other == null) {
                        sperre = LagisBroker.getInstance().createFlurstueckSchluesselLock(key);
                        if (sperre != null) {
                            block19: {
                                progress.setBusy("Flurst\u00fcckart wird ge\u00e4ndert");
                                key.setFlurstueckArt(newArt);
                                LagisBroker.getInstance().modifyFlurstueckSchluessel(key);
                                LagisBroker.getInstance().releaseLock(sperre);
                                if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() != null && FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), key)) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug((Object)"Art des aktuellen flurst\u00fccks wurde ge\u00e4ndert --> update");
                                    }
                                    try {
                                        LagisBroker.getInstance().loadFlurstueck(key);
                                    }
                                    catch (Exception ex) {
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug((Object)"Fehler beim updaten/laden der FlurstueckSchluessel/Flurst\u00fccks", (Throwable)ex);
                                        }
                                        break block19;
                                    }
                                }
                                final boolean changeFlurstueck = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie zu dem ge\u00e4nderten Flurst\u00fcck wechseln?", "Flurst\u00fcckwechsel", 0) == 0;
                                try {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (changeFlurstueck) {
                                                LagisBroker.getInstance().loadFlurstueck(key);
                                            } else {
                                                LagisBroker.getInstance().reloadFlurstueckKeys();
                                            }
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    if (!this.log.isDebugEnabled()) break block19;
                                    this.log.debug((Object)"Fehler beim updaten/laden der FlurstueckSchluessel/Flurst\u00fccks", (Throwable)ex);
                                }
                            }
                            Summary summary = Summary.create((String)("Die Art des Flurst\u00fcck: \n\t\"" + key.getKeyString() + "\" \n\nkonnte erfolgreich auf \"" + newArt.getBezeichnung() + "\" ge\u00e4ndert werden"), (Object)key);
                            progress.finished((Object)summary);
                            break block20;
                        }
                        progress.failed("Es war nicht m\u00f6glich die Art des Flurst\u00fccks:\n\t\"" + key.getKeyString() + "\"\nzu \u00e4ndern, es konnte keine Sperre angelegt werden.", false);
                        break block20;
                    }
                    progress.failed("Es war nicht m\u00f6glich die Art des Flurst\u00fccks:\n\t\"" + key.getKeyString() + "\"\nzu \u00e4ndern, es ist von einem anderen Benutzer gesperrt: " + (String)other.getProperty("user_string"), false);
                }
                catch (Exception e) {
                    try {
                        LagisBroker.getInstance().releaseLock(sperre);
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"Fehler beim l\u00f6sen der Sperre", (Throwable)ex);
                    }
                    StringBuffer buffer = new StringBuffer("Die Art des Flurst\u00fccks: \n\t\"" + key.getKeyString() + "\" \n\nkonnte nicht ge\u00e4ndert werden. Fehler:");
                    if (e instanceof ActionNotSuccessfulException) {
                        ActionNotSuccessfulException reason = (ActionNotSuccessfulException)e;
                        if (reason.hasNestedExceptions()) {
                            this.log.error((Object)"Nested changeKind Exceptions: ", (Throwable)reason.getNestedExceptions());
                        }
                        buffer.append(reason.getMessage());
                    } else {
                        this.log.error((Object)"Unbekannter Fehler: ", (Throwable)e);
                        buffer.append("Unbekannter Fehler bitte wenden Sie sich an Ihren Systemadministrator");
                    }
                    progress.failed(buffer.toString(), false);
                }
            }
        }
    }
}

