/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.steps;

import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.wizard.panels.CreateActionPanel;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class CreateActionSteps
extends WizardPanelProvider {
    public CreateActionSteps() {
        super("Flurst\u00fcck anlegen...", new String[]{"Flurst\u00fcck ausw\u00e4hlen"}, new String[]{"Auswahl des Flurst\u00fccks"});
    }

    protected JComponent createPanel(WizardController wizardController, String id, Map wizardData) {
        return new CreateActionPanel(wizardController, wizardData);
    }

    public boolean cancel(Map settings) {
        boolean dialogShouldClose = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie den Bearbeitungsvorgang beenden?") == 0;
        return dialogShouldClose;
    }

    protected Object finish(Map settings) throws WizardException {
        return new BackgroundResultCreator();
    }

    static class BackgroundResultCreator
    extends DeferredWizardResult {
        private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

        BackgroundResultCreator() {
        }

        public void start(Map wizardData, ResultProgressHandle progress) {
            if (!LagisBroker.getInstance().checkFlurstueckWizardUserWantsToFinish()) {
                progress.failed("Die Aktion wurde durch den Benutzer abgebrochen.", true);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"WizardFinisher: Flurstueck anlegen: ");
            }
            assert (!EventQueue.isDispatchThread());
            final FlurstueckSchluesselCustomBean key = (FlurstueckSchluesselCustomBean)wizardData.get("createCandidate");
            boolean isStaedtisch = (Boolean)wizardData.get("isStaedtisch");
            try {
                block17: {
                    progress.setBusy("Flurst\u00fcck wird angelegt");
                    Collection<FlurstueckArtCustomBean> flurstueckArten = LagisBroker.getInstance().getAllFlurstueckArten();
                    if (isStaedtisch) {
                        for (FlurstueckArtCustomBean art : flurstueckArten) {
                            if (!art.getBezeichnung().equals("st\u00e4dtisch")) continue;
                            key.setFlurstueckArt(art);
                        }
                    } else {
                        for (FlurstueckArtCustomBean art : flurstueckArten) {
                            if (!art.getBezeichnung().equals("Abteilung IX")) continue;
                            key.setFlurstueckArt(art);
                        }
                    }
                    if (key.getFlurstueckArt() == null) {
                        throw new Exception("Die Flurst\u00fccksart des Servers passte nicht");
                    }
                    LagisBroker.getInstance().createFlurstueck(key);
                    if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() != null && FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), key)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Aktuelles flurst\u00fcck wurde eingepflegt --> update");
                        }
                        try {
                            LagisBroker.getInstance().loadFlurstueck(key);
                        }
                        catch (Exception ex) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Fehler beim updaten/laden der FlurstueckSchluessel/Flurst\u00fccks", (Throwable)ex);
                            }
                            break block17;
                        }
                    }
                    final boolean changeFlurstueck = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie zu dem neuangelegten Flurst\u00fcck wechseln?", "Flurst\u00fcckwechsel", 0) == 0;
                    try {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (changeFlurstueck) {
                                    LagisBroker.getInstance().loadFlurstueck(key);
                                } else {
                                    LagisBroker.getInstance().reloadFlurstueckKeys();
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        if (!this.log.isDebugEnabled()) break block17;
                        this.log.debug((Object)"Fehler beim updaten/laden der FlurstueckSchluessel/Flurst\u00fccks", (Throwable)ex);
                    }
                }
                Summary summary = Summary.create((String)("Flurst\u00fcck: \n\t\"" + key.getKeyString() + "\" \n\nkonnte erfolgreich angelegt werden"), (Object)key);
                progress.finished((Object)summary);
            }
            catch (Exception e) {
                progress.failed("Flurst\u00fcck: \n\t\"" + key.getKeyString() + "\" \n\nkonnte nicht angelegt werden", false);
                this.log.warn((Object)"Flurst\u00fcck konnte nicht durch Wizard angelegt werden", (Throwable)e);
            }
        }
    }
}

