/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.steps;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.wizard.panels.RenameActionPanel;
import java.awt.EventQueue;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class RenameActionSteps
extends WizardPanelProvider {
    public RenameActionSteps() {
        super("Flurst\u00fcck umbenennen...", new String[]{"Flurst\u00fcck ausw\u00e4hlen"}, new String[]{"Auswahl des Flurst\u00fccks"});
    }

    protected JComponent createPanel(WizardController wizardController, String id, Map wizardData) {
        return new RenameActionPanel(wizardController, wizardData);
    }

    public boolean cancel(Map settings) {
        boolean dialogShouldClose = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie den Bearbeitungsvorgang beenden?") == 0;
        return dialogShouldClose;
    }

    protected Object finish(Map settings) throws WizardException {
        return new BackgroundResultCreator();
    }

    static class BackgroundResultCreator
    extends DeferredWizardResult {
        private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

        BackgroundResultCreator() {
        }

        public void start(Map wizardData, ResultProgressHandle progress) {
            if (!LagisBroker.getInstance().checkFlurstueckWizardUserWantsToFinish()) {
                progress.failed("Die Aktion wurde durch den Benutzer abgebrochen.", true);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"WizardFinisher: Flurstueck renamen: ");
            }
            assert (!EventQueue.isDispatchThread());
            final FlurstueckSchluesselCustomBean createdKey = (FlurstueckSchluesselCustomBean)wizardData.get("createCandidate");
            FlurstueckSchluesselCustomBean renamedKey = (FlurstueckSchluesselCustomBean)wizardData.get("renameCreateCandidate");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flurst\u00fcck das umbenannt werden soll: " + renamedKey.getKeyString()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flurst\u00fcck in das umbenannt werden soll: " + createdKey.getKeyString()));
            }
            try {
                block19: {
                    progress.setBusy("Flurst\u00fcck wird angelegt");
                    LagisBroker.getInstance().renameFlurstueck(renamedKey, createdKey, LagisBroker.getInstance().getAccountName());
                    if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() != null && (FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), renamedKey) || FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), createdKey))) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Aktuelles flurst\u00fcck wurde umbenannt --> update");
                        }
                        try {
                            renamedKey.setId(null);
                            renamedKey.setFlurstueckArt(null);
                            if (FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), renamedKey)) {
                                LagisBroker.getInstance().loadFlurstueck(renamedKey);
                            } else if (FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), createdKey)) {
                                LagisBroker.getInstance().loadFlurstueck(createdKey);
                            }
                        }
                        catch (Exception ex) {
                            if (!this.log.isDebugEnabled()) break block19;
                            this.log.debug((Object)"Fehler beim updaten/laden der FlurstueckSchluessel/Flurst\u00fccks", (Throwable)ex);
                        }
                    }
                }
                if (!FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), createdKey)) {
                    final boolean changeFlurstueck = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie zu dem neuangelegten Flurst\u00fcck wechseln?", "Flurst\u00fcckwechsel", 0) == 0;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (changeFlurstueck) {
                                LagisBroker.getInstance().loadFlurstueck(createdKey);
                            } else {
                                LagisBroker.getInstance().reloadFlurstueckKeys();
                            }
                        }
                    });
                }
                Summary summary = Summary.create((String)("Flurst\u00fcck: \n\n\t\"" + renamedKey.getKeyString() + "\" \n\nkonnte erfolgreich in \n\n\t" + createdKey.getKeyString() + "\n\numbenannt werden."), (Object)createdKey);
                progress.finished((Object)summary);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Flurst\u00fcck konnte erfolgreich umbenannt werden: ");
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Fehler beim renamen eines Flurst\u00fccks: ", (Throwable)e);
                StringBuffer buffer = new StringBuffer("Flurst\u00fcck: \n\t\"" + renamedKey.getKeyString() + "\" \n\nkonnte nicht in\n\t" + createdKey.getKeyString() + "\n\numbenannt werden. Fehler:\n");
                if (e instanceof ActionNotSuccessfulException) {
                    ActionNotSuccessfulException reason = (ActionNotSuccessfulException)e;
                    if (reason.hasNestedExceptions()) {
                        this.log.error((Object)"Nested Rename Exceptions: ", (Throwable)reason.getNestedExceptions());
                    }
                    buffer.append(reason.getMessage());
                } else {
                    this.log.error((Object)"Unbekannter Fehler: ", (Throwable)e);
                    buffer.append("Unbekannter Fehler bitte wenden Sie sich an Ihren Systemadministrator");
                }
                progress.failed(buffer.toString(), false);
            }
        }
    }
}

