/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.steps;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.wizard.panels.ResultingPanel;
import de.cismet.lagis.wizard.panels.SplitActionChoosePanel;
import de.cismet.lagis.wizard.panels.SummaryPanel;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class SplitActionSteps
extends WizardPanelProvider {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private SplitActionChoosePanel splitPanel;
    private ResultingPanel resultingPanel;
    private SummaryPanel summaryPanel;

    public SplitActionSteps() {
        super("Flurst\u00fcck umbenennen...", new String[]{"Teilung", "Ergebnis", "Zusammenfasusung"}, new String[]{"Auswahl des Flurst\u00fccks", "Flurst\u00fccke anlegen", "Zusammenfassung"});
    }

    protected JComponent createPanel(WizardController wizardController, String id, Map wizardData) {
        switch (this.indexOfStep(id)) {
            case 0: {
                this.splitPanel = new SplitActionChoosePanel(wizardController, wizardData, "splitAction");
                return this.splitPanel;
            }
            case 1: {
                this.resultingPanel = new ResultingPanel(wizardController, wizardData, "splitAction");
                return this.resultingPanel;
            }
            case 2: {
                this.summaryPanel = new SummaryPanel();
                this.summaryPanel.refresh(wizardData);
                return this.summaryPanel;
            }
        }
        throw new IllegalArgumentException(id);
    }

    public boolean cancel(Map settings) {
        boolean dialogShouldClose = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie den Bearbeitungsvorgang beenden?") == 0;
        return dialogShouldClose;
    }

    protected Object finish(Map wizardData) throws WizardException {
        return new BackgroundResultCreator();
    }

    protected void recycleExistingPanel(String id, WizardController controller, Map wizardData, JComponent panel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Recycle existing panel: " + id));
        }
        controller.setProblem(null);
        controller.setBusy(false);
        if (this.splitPanel == panel) {
            this.splitPanel.refresh(wizardData);
        } else if (this.resultingPanel == panel) {
            this.resultingPanel.refresh(wizardData);
        } else if (this.summaryPanel == panel) {
            this.summaryPanel.refresh(wizardData);
        } else {
            this.log.warn((Object)("recycleExistingPanel(): Unknown panel " + panel));
        }
    }

    static class BackgroundResultCreator
    extends DeferredWizardResult {
        private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

        BackgroundResultCreator() {
        }

        public void start(Map wizardData, ResultProgressHandle progress) {
            if (!LagisBroker.getInstance().checkFlurstueckWizardUserWantsToFinish()) {
                progress.failed("Die Aktion wurde durch den Benutzer abgebrochen.", true);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"WizardFinisher: Flurstueck splitten: ");
            }
            assert (!EventQueue.isDispatchThread());
            final FlurstueckSchluesselCustomBean splitCandidate = (FlurstueckSchluesselCustomBean)wizardData.get("splitCandidate");
            final ArrayList splitKeys = (ArrayList)wizardData.get("splitKeys");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flurst\u00fcck das gesplittet werden soll: " + splitCandidate.getKeyString()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flurst\u00fcck in entstehen sollen: " + splitKeys));
            }
            try {
                progress.setBusy("Flurst\u00fcck wird geteilt");
                for (FlurstueckSchluesselCustomBean current : splitKeys) {
                    current.setFlurstueckArt(splitCandidate.getFlurstueckArt());
                }
                LagisBroker.getInstance().splitFlurstuecke(splitCandidate, splitKeys, LagisBroker.getInstance().getAccountName());
                StringBuffer resultString = new StringBuffer("Flurst\u00fcck: \n\t\"" + splitCandidate.getKeyString() + "\" \n\nkonnte erfolgreich in die Flurst\u00fccke\n");
                Iterator it = splitKeys.iterator();
                while (it.hasNext()) {
                    resultString.append("\n\t\"").append(((FlurstueckSchluesselCustomBean)it.next()).getKeyString()).append("\"");
                }
                resultString.append("\n\n aufgeteilt werden");
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() != null && FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), splitCandidate)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Das aktuelle Flurst\u00fcck wurde ge\u00e4ndert --> lade Flurstueck neu");
                            }
                            LagisBroker.getInstance().loadFlurstueck(splitCandidate);
                            return;
                        }
                        for (FlurstueckSchluesselCustomBean current : splitKeys) {
                            if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() == null || !FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), current)) continue;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Das aktuelle Flurst\u00fcck wurde ge\u00e4ndert --> lade Flurstueck neu");
                            }
                            LagisBroker.getInstance().loadFlurstueck(current);
                            return;
                        }
                        LagisBroker.getInstance().reloadFlurstueckKeys();
                    }
                });
                Summary summary = Summary.create((String)resultString.toString(), (Object)splitKeys);
                progress.finished((Object)summary);
            }
            catch (Exception e) {
                StringBuffer resultString = new StringBuffer("Flurst\u00fcck: \n\t\"" + splitCandidate.getKeyString() + "\" \n\nkonnte nicht in die Flurst\u00fccke\n");
                Iterator it = splitKeys.iterator();
                while (it.hasNext()) {
                    resultString.append("\n\t\"").append(((FlurstueckSchluesselCustomBean)it.next()).getKeyString()).append("\"");
                }
                resultString.append("\n\n aufgeteilt werden. Fehler:\n");
                if (e instanceof ActionNotSuccessfulException) {
                    ActionNotSuccessfulException reason = (ActionNotSuccessfulException)e;
                    if (reason.hasNestedExceptions()) {
                        this.log.error((Object)"Nested split Exceptions: ", (Throwable)reason.getNestedExceptions());
                    }
                    resultString.append(reason.getMessage());
                } else {
                    this.log.error((Object)"Unbekannter Fehler: ", (Throwable)e);
                    resultString.append("Unbekannter Fehler bitte wenden Sie sich an Ihren Systemadministrator");
                }
                progress.failed(resultString.toString(), false);
            }
        }
    }
}

