/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.lagis.gui.optionspanels;

import org.apache.log4j.Logger;

import org.jdom.Element;

import org.openide.util.lookup.ServiceProvider;

import de.cismet.lagis.broker.LagisBroker;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;

import de.cismet.lookupoptions.options.SecurityOptionsCategory;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = OptionsPanelController.class)
public class FlurstueckAssistentOptionsPanel extends AbstractOptionsPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(FlurstueckAssistentOptionsPanel.class);

    //~ Instance fields --------------------------------------------------------

    private boolean skipSecurityCheck = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new FlurstueckAssistentOptionsPanel object.
     */
    public FlurstueckAssistentOptionsPanel() {
        super("Flurstück Assistent", SecurityOptionsCategory.class);
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jCheckBox1 = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jCheckBox1,
            org.openide.util.NbBundle.getMessage(
                FlurstueckAssistentOptionsPanel.class,
                "FlurstueckAssistentOptionsPanel.jCheckBox1.text")); // NOI18N
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jCheckBox1ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(jCheckBox1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jPanel1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(jPanel2, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jCheckBox1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jCheckBox1ActionPerformed
        skipSecurityCheck = jCheckBox1.isSelected();
    }                                                                              //GEN-LAST:event_jCheckBox1ActionPerformed

    @Override
    public void update() {
        skipSecurityCheck = LagisBroker.getInstance().isSkipSecurityCheckFlurstueckAssistent();

        jCheckBox1.setSelected(skipSecurityCheck);
    }

    @Override
    public void applyChanges() {
        LagisBroker.getInstance().setSkipSecurityCheckFlurstueckAssistent(skipSecurityCheck);
    }

    @Override
    public boolean isChanged() {
        return LagisBroker.getInstance().isSkipSecurityCheckFlurstueckAssistent() != skipSecurityCheck;
    }

    @Override
    public Element getConfiguration() {
        final Element conf = new Element("flurstueckAssistentSecurityConfiguration");
        final Element skipSecurityCheckElementElement = new Element("skipSecurityCheck");
        skipSecurityCheckElementElement.addContent(Boolean.toString(skipSecurityCheck));
        conf.addContent(skipSecurityCheckElementElement);
        return conf;
    }

    @Override
    public void configure(final Element parent) {
        if (parent != null) {
            final Element conf = parent.getChild("flurstueckAssistentSecurityConfiguration");

            if (conf != null) {
                LagisBroker.getInstance()
                        .setSkipSecurityCheckFlurstueckAssistent(
                            (conf.getChild("skipSecurityCheck") != null)
                                ? Boolean.valueOf(conf.getChildText("skipSecurityCheck")) : false);
            }
        }
        update();
    }

    @Override
    public void masterConfigure(final Element parent) {
        configure(parent);
    }
}
