/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.lagis.gui.panels;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;

import com.vividsolutions.jts.geom.Geometry;

import org.apache.log4j.Logger;

import org.jdesktop.swingx.JXTable;

import java.awt.Point;

import java.util.Collection;
import java.util.Date;

import javax.swing.JTable;
import javax.swing.SwingWorker;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.KassenzeichenCustomBean;

import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;

import de.cismet.lagis.gui.tables.KassenzeichenTable;

import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;

import de.cismet.lagis.models.KassenzeichenTableModel;

import de.cismet.lagis.renderer.DateRenderer;
import de.cismet.lagis.renderer.KassenzeichenRenderer;

import de.cismet.lagis.util.LagISUtils;
import de.cismet.lagis.util.TableSelectionUtils;

import de.cismet.lagis.widget.AbstractWidget;

import de.cismet.verdis.server.search.KassenzeichenGeomSearch;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class KassenzeichenPanel extends AbstractWidget implements FlurstueckChangeListener, FlurstueckSaver {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = org.apache.log4j.Logger.getLogger(KassenzeichenPanel.class);
    private static KassenzeichenPanel INSTANCE;

    //~ Instance fields --------------------------------------------------------

    private final KassenzeichenTableModel tableModel = new KassenzeichenTableModel();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAddKassenzeichen;
    private javax.swing.JButton btnMagicAddKassenzeichen;
    private javax.swing.JButton btnRemoveKassenzeichen;
    private javax.swing.JToggleButton btnSort;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable tKassenzeichen;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form KassenzeichenPanel.
     */
    private KassenzeichenPanel() {
        setIsCoreWidget(true);
        initComponents();
        TableSelectionUtils.crossReferenceModelAndTable(tableModel, (KassenzeichenTable)tKassenzeichen);
        tKassenzeichen.setDefaultRenderer(Integer.class, new KassenzeichenRenderer());
        tKassenzeichen.setDefaultRenderer(Date.class, new DateRenderer());
        ((KassenzeichenTable)tKassenzeichen).setSortButton(btnSort);
        ((JXTable)tKassenzeichen).setHighlighters(LagisBroker.ALTERNATE_ROW_HIGHLIGHTER);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static KassenzeichenPanel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KassenzeichenPanel();
        }
        return INSTANCE;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public JTable getTable() {
        return tKassenzeichen;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        tKassenzeichen = new KassenzeichenTable();
        jPanel3 = new javax.swing.JPanel();
        btnAddKassenzeichen = new javax.swing.JButton();
        btnRemoveKassenzeichen = new javax.swing.JButton();
        btnSort = new javax.swing.JToggleButton();
        btnMagicAddKassenzeichen = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(100, 100));

        tKassenzeichen.setBackground(javax.swing.UIManager.getDefaults().getColor("Panel.background"));
        tKassenzeichen.setModel(tableModel);
        tKassenzeichen.setToolTipText(org.openide.util.NbBundle.getMessage(
                KassenzeichenPanel.class,
                "KassenzeichenPanel.tKassenzeichen.toolTipText")); // NOI18N
        tKassenzeichen.setMinimumSize(new java.awt.Dimension(225, 48));
        tKassenzeichen.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    tKassenzeichenMouseClicked(evt);
                }
            });
        jScrollPane1.setViewportView(tKassenzeichen);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        btnAddKassenzeichen.setAction(((KassenzeichenTable)tKassenzeichen).getAddAction());
        btnAddKassenzeichen.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png"))); // NOI18N
        btnAddKassenzeichen.setBorder(null);
        btnAddKassenzeichen.setBorderPainted(false);
        btnAddKassenzeichen.setMaximumSize(new java.awt.Dimension(25, 25));
        btnAddKassenzeichen.setMinimumSize(new java.awt.Dimension(25, 25));
        btnAddKassenzeichen.setPreferredSize(new java.awt.Dimension(25, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        jPanel3.add(btnAddKassenzeichen, gridBagConstraints);

        btnRemoveKassenzeichen.setAction(((KassenzeichenTable)tKassenzeichen).getRemoveAction());
        btnRemoveKassenzeichen.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png"))); // NOI18N
        btnRemoveKassenzeichen.setBorder(null);
        btnRemoveKassenzeichen.setBorderPainted(false);
        btnRemoveKassenzeichen.setMaximumSize(new java.awt.Dimension(25, 25));
        btnRemoveKassenzeichen.setMinimumSize(new java.awt.Dimension(25, 25));
        btnRemoveKassenzeichen.setPreferredSize(new java.awt.Dimension(25, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 0);
        jPanel3.add(btnRemoveKassenzeichen, gridBagConstraints);

        btnSort.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));          // NOI18N
        btnSort.setToolTipText(org.openide.util.NbBundle.getMessage(
                KassenzeichenPanel.class,
                "KassenzeichenPanel.btnSort.toolTipText"));                                             // NOI18N
        btnSort.setBorderPainted(false);
        btnSort.setContentAreaFilled(false);
        btnSort.setMaximumSize(new java.awt.Dimension(25, 25));
        btnSort.setMinimumSize(new java.awt.Dimension(25, 25));
        btnSort.setPreferredSize(new java.awt.Dimension(25, 25));
        btnSort.setSelectedIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png"))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 3);
        jPanel3.add(btnSort, gridBagConstraints);
        btnSort.addItemListener(((KassenzeichenTable)tKassenzeichen).getSortItemListener());

        btnMagicAddKassenzeichen.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/addMagic.png"))); // NOI18N
        btnMagicAddKassenzeichen.setBorder(null);
        btnMagicAddKassenzeichen.setBorderPainted(false);
        btnMagicAddKassenzeichen.setMaximumSize(new java.awt.Dimension(25, 25));
        btnMagicAddKassenzeichen.setMinimumSize(new java.awt.Dimension(25, 25));
        btnMagicAddKassenzeichen.setPreferredSize(new java.awt.Dimension(25, 25));
        btnMagicAddKassenzeichen.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnMagicAddKassenzeichenActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        jPanel3.add(btnMagicAddKassenzeichen, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 12, 12);
        add(jPanel1, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void tKassenzeichenMouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_tKassenzeichenMouseClicked
        if (evt.getClickCount() > 1) {
            final int rowAtPoint = tKassenzeichen.rowAtPoint(new Point(evt.getX(), evt.getY()));
            if ((rowAtPoint != -1)
                        && ((tableModel.getCidsBeanAtRow(
                                    ((JXTable)tKassenzeichen).convertRowIndexToModel(
                                        rowAtPoint))) != null)) {
                final KassenzeichenCustomBean kassenzeichenEintrag = (tableModel.getCidsBeanAtRow(
                            ((JXTable)tKassenzeichen).convertRowIndexToModel(
                                rowAtPoint)));
                final MetaClass mcKassenzeichen = CidsBroker.getInstance()
                            .getMetaClass("kassenzeichen", "VERDIS_GRUNDIS");

                final String query = "SELECT " + mcKassenzeichen.getId()
                            + ", id, kassenzeichennummer8 FROM kassenzeichen WHERE kassenzeichennummer8 = "
                            + kassenzeichenEintrag.getKassenzeichennummer()
                            + ";";
                final MetaObject[] mos = CidsBroker.getInstance().getMetaObject(query, "VERDIS_GRUNDIS");

                if ((mos == null) || (mos.length < 1)) {
                } else {
                    final MetaObject mo = mos[0];
                    LagisBroker.getInstance().openKassenzeichenInVerdis(mo.getBean());
                }
            }
        }
    } //GEN-LAST:event_tKassenzeichenMouseClicked

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMagicAddKassenzeichenActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnMagicAddKassenzeichenActionPerformed
        final Geometry geometry = LagisBroker.getInstance().getCurrentWFSGeometry().buffer(-0.05);
        final KassenzeichenGeomSearch search = new KassenzeichenGeomSearch();
        search.setGeometry(geometry);
        setComponentEditable(false);
        new SwingWorker<Collection, Void>() {

                @Override
                protected Collection doInBackground() throws Exception {
                    return CidsBroker.getInstance().executeSearch(search);
                }

                @Override
                protected void done() {
                    if (LagisBroker.getInstance().isInEditMode()) {
                        try {
                            final Collection<Integer> kassenzeichenNumern = get();
                            for (final Integer kassenzeichenNummer : kassenzeichenNumern) {
                                ((KassenzeichenTable)tKassenzeichen).addNewKassenzeichen(kassenzeichenNummer);
                            }
                        } catch (final Exception ex) {
                            LOG.fatal(ex, ex);
                        } finally {
                            setComponentEditable(true);
                        }
                    }
                }
            }.execute();
    } //GEN-LAST:event_btnMagicAddKassenzeichenActionPerformed

    @Override
    public void clearComponent() {
        tableModel.refreshTableModel(null);
    }

    @Override
    public void refresh(final Object refreshObject) {
    }

    @Override
    public void setComponentEditable(final boolean isEditable) {
        btnAddKassenzeichen.setEnabled(isEditable);
        btnMagicAddKassenzeichen.setEnabled(isEditable);
        btnRemoveKassenzeichen.setEnabled(isEditable);
    }

    @Override
    public void flurstueckChanged(final FlurstueckCustomBean newFlurstueck) {
        try {
            LOG.info("FlurstueckChanged");
            clearComponent();
            tableModel.refreshTableModel(newFlurstueck.getN_kassenzeichen());
        } catch (Exception ex) {
            LOG.error("Fehler beim Flurstückswechsel: ", ex);
        } finally {
            LagisBroker.getInstance().flurstueckChangeFinished(KassenzeichenPanel.this);
        }
    }

    @Override
    public void updateFlurstueckForSaving(final FlurstueckCustomBean flurstueck) {
        LagISUtils.makeCollectionContainSameAsOtherCollection(flurstueck.getN_kassenzeichen(),
            tableModel.getCidsBeans());
    }
}
