/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.lagis.report.printing;

import javafx.application.Platform;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

import javafx.concurrent.Worker;

import javafx.embed.swing.SwingFXUtils;

import javafx.geometry.Rectangle2D;

import javafx.scene.SnapshotParameters;
import javafx.scene.image.WritableImage;

import netscape.javascript.JSObject;

import org.apache.commons.io.IOUtils;

import org.openide.util.Exceptions;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.image.RenderedImage;

import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import javax.swing.SwingWorker;

import de.cismet.tools.gui.FXWebViewPanel;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
public class JFXOffscreenSnapshotTester extends javax.swing.JFrame {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            JFXOffscreenSnapshotTester.class);
    private static final String DIAG_HTML = "/home/jruiz/diag.html";
    private static final String CAP_PNG = "/home/jruiz/cap.png";
    private static final String CAP2_PNG = "/home/jruiz/cap2.png";
    private static final String GRAPH =
        "digraph G{\"Barmen 201 250/0\"->\"Barmen 201 253/0\" [lineInterpolate=\"linear\"];\"Barmen 201 250/0\"->\"Barmen 201 254/0\" [lineInterpolate=\"linear\"];\"Barmen 206 132/0\"->\"Barmen 206 133/0\" [lineInterpolate=\"linear\"];\"Barmen 206 132/0\"->\"Barmen 206 134/0\" [lineInterpolate=\"linear\"];\"Barmen 206 132/0\"->\"Barmen 206 135/0\" [lineInterpolate=\"linear\"];\"Barmen 206 135/0\"->\"Barmen 205 709/0\" [lineInterpolate=\"linear\"];\"Barmen 206 134/0\"->\"Barmen 201 255/0\" [lineInterpolate=\"linear\"];\"Barmen 205 688/0\"->\"pseudo Schluessel18746\" [lineInterpolate=\"linear\"];\"pseudo Schluessel18746\"->\"Barmen 200 316/0\" [lineInterpolate=\"linear\"];\"pseudo Schluessel18746\"->\"Barmen 201 250/0\" [lineInterpolate=\"linear\"];\"pseudo Schluessel18746\"->\"Barmen 201 251/0\" [lineInterpolate=\"linear\"];\"pseudo Schluessel18746\"->\"Barmen 201 252/0\" [lineInterpolate=\"linear\"];\"pseudo Schluessel18746\"->\"Barmen 206 132/0\" [lineInterpolate=\"linear\"];\"Barmen 205 688/0\"  [style=\"fill: #eee; font-weight: bold\"];\"pseudo Schluessel18746\" [label=\"    \"]}";

    //~ Instance fields --------------------------------------------------------

    private FXWebViewPanel myWeb = null;
    private final String graph;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JPanel panMain;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form NewJFrame.
     */
    public JFXOffscreenSnapshotTester() {
        initComponents();

        String template = null;
        try {
            template = IOUtils.toString(this.getClass().getResourceAsStream("dagreReportingTemplate.html"));
        } catch (IOException ex) {
            LOG.fatal(ex, ex);
        }
        graph = template.replaceAll("__graphString__", GRAPH);
        doGraph(1135, 440);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        panMain = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jProgressBar1 = new javax.swing.JProgressBar();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton1,
            org.openide.util.NbBundle.getMessage(
                JFXOffscreenSnapshotTester.class,
                "JFXOffscreenSnapshotTester.jButton1.text")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jButton1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton2,
            org.openide.util.NbBundle.getMessage(
                JFXOffscreenSnapshotTester.class,
                "JFXOffscreenSnapshotTester.jButton2.text")); // NOI18N
        jButton2.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton2ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jButton2, gridBagConstraints);

        panMain.setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jProgressBar1, gridBagConstraints);

        panMain.add(jPanel2, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(panMain, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  x  DOCUMENT ME!
     * @param  y  DOCUMENT ME!
     */
    private void doGraph(final int x, final int y) {
        try {
//            IOUtils.write(s, new FileWriter(new File("/Users/thorsten/tmp/x/diag.html")));
//            FileUtils.writeStringToFile(new File(DIAG_HTML), graph);
            LOG.info(graph.substring(graph.length() - 100));
            LOG.info("init FXWexxxbViewPanel");

            new SwingWorker<Void, Void>() {

                    @Override
                    protected Void doInBackground() throws Exception {
                        if (myWeb == null) {
                            myWeb = new FXWebViewPanel();
                            LOG.info("FXWebViewPanel inited");
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        Platform.runLater(new Runnable() {

                                @Override
                                public void run() {
                                    try {
                                        myWeb.setVisible(true);
                                        myWeb.setSize(new Dimension(x, y));
                                        myWeb.getWebEngine()
                                                .getLoadWorker()
                                                .stateProperty()
                                                .addListener(new MyChangeListener());
                                        myWeb.loadContent(graph);
                                    } catch (final Throwable t) {
                                        LOG.fatal(t, t);
                                    }
                                }
                            });
                    }
                }.execute();
        } catch (final Exception exception) {
            LOG.fatal(exception, exception);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        doGraph(1135, 440);
    }                                                                            //GEN-LAST:event_jButton1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton2ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton2ActionPerformed
        doSnap(CAP_PNG);
    }                                                                            //GEN-LAST:event_jButton2ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  filename  DOCUMENT ME!
     */
    public void doSnap(final String filename) {
        jProgressBar1.setIndeterminate(true);

        Platform.runLater(new Runnable() {

                @Override
                public void run() {
                    try {
                        final SnapshotParameters params = new SnapshotParameters();
                        params.setViewport(new Rectangle2D(0, 0, myWeb.getWidth(), myWeb.getHeight()));
                        final WritableImage snapshot = myWeb.getWebView().snapshot(params, null);
                        final RenderedImage renderedImage = SwingFXUtils.fromFXImage(snapshot, null);

                        final File captureFile = new File(filename);
                        ImageIO.write(renderedImage, "png", captureFile);
                        EventQueue.invokeLater(new Runnable() {

                                @Override
                                public void run() {
                                    jProgressBar1.setIndeterminate(false);
                                    jProgressBar1.setValue(jProgressBar1.getMaximum());
                                }
                            });
                    } catch (final Throwable t) {
                        LOG.fatal(t, t);
                    }
                }
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (final javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(JFXOffscreenSnapshotTester.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(JFXOffscreenSnapshotTester.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(JFXOffscreenSnapshotTester.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(JFXOffscreenSnapshotTester.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>

        Log4JQuickConfig.configure4LumbermillOnLocalhost();

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    new JFXOffscreenSnapshotTester().setVisible(true);
                }
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param  zoomlevel  DOCUMENT ME!
     */
    public void pageRendered(final String zoomlevel) {
        final double zl = Double.parseDouble(zoomlevel);
        LOG.fatal(zl);
        if (zl < 1) {
            doSnap(CAP_PNG);

            doGraph((int)(1135 / zl), (int)(440 / zl));
        } else {
            doSnap(CAP2_PNG);
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class MyChangeListener implements ChangeListener<javafx.concurrent.Worker.State> {

        //~ Methods ------------------------------------------------------------

        @Override
        public void changed(
                final ObservableValue<? extends Worker.State> observable,
                final Worker.State oldValue,
                final Worker.State newValue) {
            LOG.info(newValue);
            if (newValue == Worker.State.SUCCEEDED) {
                final JSObject jsobj = (JSObject)myWeb.getWebEngine().executeScript("window");
                jsobj.setMember("java", JFXOffscreenSnapshotTester.this);
            }
        }
    }
}
