/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.lagis;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungBuchungCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.Exception.AddingOfBuchungNotPossibleException;
import de.cismet.lagis.Exception.BuchungNotInNutzungException;
import de.cismet.lagis.Exception.IllegalNutzungStateException;
import de.cismet.lagis.Exception.TerminateNutzungNotPossibleException;
import de.cismet.lagis.util.SortedList;
import de.cismet.lagisEE.entity.basic.BasicEntity;
import de.cismet.lagisEE.entity.core.Nutzung;
import de.cismet.lagisEE.entity.core.NutzungsBuchung;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class NutzungCustomBean
extends BasicEntity
implements Nutzung {
    private static final Logger LOG = Logger.getLogger(NutzungCustomBean.class);
    private static final String[] PROPERTY_NAMES = new String[]{"id", "fk_flurstueck", "n_buchungen"};
    private Integer id;
    private FlurstueckCustomBean fk_flurstueck;
    private Collection<NutzungBuchungCustomBean> n_buchungen;
    private Boolean historisch = null;
    private final List<NutzungBuchungCustomBean> sortedBuchungen = new SortedList<NutzungBuchungCustomBean>(new Comparator<NutzungBuchungCustomBean>(){

        @Override
        public int compare(NutzungBuchungCustomBean o1, NutzungBuchungCustomBean o2) {
            long comp = o1.getGueltig_von().getTime() - o2.getGueltig_von().getTime();
            if (comp < 0L) {
                return -1;
            }
            if (comp > 0L) {
                return 1;
            }
            return 0;
        }
    });

    public static NutzungCustomBean createNew(boolean addDummyBuchung) {
        try {
            NutzungCustomBean nutzung = (NutzungCustomBean)CidsBean.createNewCidsBeanFromTableName((String)"LAGIS", (String)"nutzung");
            if (addDummyBuchung) {
                NutzungBuchungCustomBean buchung = NutzungBuchungCustomBean.createNew();
                buchung.setIstBuchwert(true);
                nutzung.addBuchung(buchung);
            }
            return nutzung;
        }
        catch (Exception ex) {
            LOG.error((Object)"error creating nutzung bean", (Throwable)ex);
            return null;
        }
    }

    public static NutzungCustomBean createNew() {
        return NutzungCustomBean.createNew(true);
    }

    public static NutzungCustomBean createNew(NutzungBuchungCustomBean initialBuchwert) throws AddingOfBuchungNotPossibleException, IllegalNutzungStateException {
        NutzungCustomBean bean = NutzungCustomBean.createNew(false);
        if (initialBuchwert == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Initial Buchwert is null... creating buchung.");
            }
            try {
                initialBuchwert = (NutzungBuchungCustomBean)CidsBean.createNewCidsBeanFromTableName((String)"LAGIS", (String)"nutzung_buchung");
            }
            catch (Exception ex) {
                LOG.error((Object)"error creating nutzung_buchung bean", (Throwable)ex);
            }
        }
        initialBuchwert.setIstBuchwert(true);
        bean.addBuchung(initialBuchwert);
        return bean;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer val) {
        this.id = val;
        this.propertyChangeSupport.firePropertyChange("id", null, this.id);
    }

    public FlurstueckCustomBean getFk_flurstueck() {
        return this.fk_flurstueck;
    }

    public void setFk_flurstueck(FlurstueckCustomBean val) {
        this.fk_flurstueck = val;
        this.propertyChangeSupport.firePropertyChange("fk_flurstueck", null, this.fk_flurstueck);
    }

    public Boolean getHistorisch() {
        return this.historisch;
    }

    public void setHistorisch(Boolean val) {
        Boolean oldValue = this.historisch;
        this.historisch = val;
        this.propertyChangeSupport.firePropertyChange("historisch", oldValue, this.historisch);
    }

    public Collection<NutzungBuchungCustomBean> getN_buchungen() {
        return this.n_buchungen;
    }

    public void setN_buchungen(Collection<NutzungBuchungCustomBean> val) {
        this.n_buchungen = val;
        this.propertyChangeSupport.firePropertyChange("n_buchungen", null, this.n_buchungen);
        for (NutzungBuchungCustomBean buchung : val) {
            buchung.setNutzung(this);
        }
        this.sortedBuchungen.clear();
        this.sortedBuchungen.addAll(val);
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public void addBuchung(NutzungBuchungCustomBean val) throws AddingOfBuchungNotPossibleException, IllegalNutzungStateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"addBuchung");
        }
        if (val == null) {
            return;
        }
        if (this.hasNewBuchung()) {
            throw new AddingOfBuchungNotPossibleException("Hinzuf\u00fcgen einer neuen Buchung nicht m\u00f6glich. Die bereits vorhanden \u00c4nderungen m\u00fcssen zuerst gespeichert werden.");
        }
        if (val.getNutzung() != null) {
            throw new AddingOfBuchungNotPossibleException("Buchung kann nicht hinzugef\u00fcgt werden, die Buchung geh\u00f6rt schon zu einer Nutzung.");
        }
        if (val.getId() != -1) {
            throw new AddingOfBuchungNotPossibleException("Buchung kann nicht hinzugef\u00fcgt werden, die Buchung wurde schon einmal gespeichert");
        }
        val.setSollGeloeschtWerden(false);
        val.setGueltigbis(null);
        Date bookingDate = new Date();
        val.setGueltigvon(bookingDate);
        if (this.getBuchungsCount() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Keine Nutzung vorhanden");
            }
            val.setIstBuchwert(true);
            val.setNutzung(this);
            this.n_buchungen.add(val);
            this.getNutzungsBuchungen().add(val);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Checke Buchwert");
        }
        this.getBuchwert();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Ende getBuchwert");
        }
        if (this.isTerminated()) {
            throw new AddingOfBuchungNotPossibleException("Die Nutzung ist Terminiert, hinzuf\u00fcgen neuer Nutzungen nicht m\u00f6glich");
        }
        NutzungBuchungCustomBean lastBuchung = this.getOpenBuchung();
        lastBuchung.setGueltigbis(bookingDate);
        val.setNutzung(this);
        this.n_buchungen.add(val);
        this.getNutzungsBuchungen().add(val);
    }

    @Override
    public void flipBuchungsBuchwertValue(NutzungBuchungCustomBean val) throws IllegalNutzungStateException, BuchungNotInNutzungException {
        if (val == null) {
            return;
        }
        if (!this.isBuchungInNutzung(val)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Buchung geh\u00f6rt nicht zu dieser Nutzung");
            }
            throw new BuchungNotInNutzungException();
        }
        if (this.getBuchungsCount() < 1) {
            throw new IllegalNutzungStateException("Keine Buchungen vorhanden.");
        }
        if (this.getNutzungsBuchungen().indexOf(val) == 0) {
            throw new IllegalNutzungStateException("Erste Buchung muss immer Buchwert sein");
        }
        if (val.getIstBuchwert()) {
            Object otherBuchwert = null;
            if (this.getBuchungsCount() == 1) {
                throw new IllegalNutzungStateException("Letzer Buchwert, kann nicht geflipped werden.");
            }
            for (NutzungBuchungCustomBean currentBuchung : this.getNutzungsBuchungen()) {
                if (currentBuchung.equals(val) || !currentBuchung.getIstBuchwert()) continue;
                val.setIstBuchwert(false);
                return;
            }
            throw new IllegalNutzungStateException("Letzer Buchwert, kann nicht geflipped werden.");
        }
        val.setIstBuchwert(true);
    }

    @Override
    public NutzungBuchungCustomBean getBuchungForDate(Date val) {
        if (this.getBuchungsCount() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Nutzungen vorhanden");
            }
            if (val == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Ziel Datum ist null --> nur aktuelle Nutzungen");
                }
                return this.getOpenBuchung();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Zieldatum vorhanden Nutzung wird gesucht");
            }
            NutzungBuchungCustomBean foundNutzung = null;
            for (NutzungBuchungCustomBean curNutzung : this.getNutzungsBuchungen()) {
                if (curNutzung.getGueltigvon() == null || curNutzung.getGueltigvon().compareTo(val) > 0 || (curNutzung.getGueltigbis() != null || new Date().compareTo(val) < 0) && (curNutzung.getGueltigbis() == null || curNutzung.getGueltigbis().compareTo(val) < 0)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Passende Nutzung mit gew\u00fcnschtem Zeitbereich gefunden");
                }
                foundNutzung = curNutzung;
            }
            if (foundNutzung == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)"Keine passende Nutzung gefunden");
            }
            return foundNutzung;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Keine Nutzungen vorhanden");
        }
        return null;
    }

    public Collection<Date> getDatesForDay(Date day) {
        HashSet<Date> result = new HashSet<Date>();
        if (this.getBuchungsCount() > 0) {
            if (day == null) {
                NutzungBuchungCustomBean openBuchung = this.getOpenBuchung();
                if (openBuchung != null) {
                    result.add(openBuchung.getGueltigbis());
                }
            } else {
                Date date = NutzungCustomBean.getDateWithoutTime(day);
                for (NutzungBuchungCustomBean curBuchung : this.getNutzungsBuchungen()) {
                    Date gueltigBis = curBuchung.getGueltigbis();
                    Date gueltigBisDay = NutzungCustomBean.getDateWithoutTime(gueltigBis);
                    if (gueltigBisDay == null || !gueltigBisDay.equals(date)) continue;
                    result.add(gueltigBis);
                }
            }
        }
        return result;
    }

    public Collection<NutzungBuchungCustomBean> getBuchungForDate(Date val, boolean daySensitive) {
        Date date = val;
        HashSet<NutzungBuchungCustomBean> result = new HashSet<NutzungBuchungCustomBean>();
        if (this.getBuchungsCount() > 0) {
            if (date == null) {
                NutzungBuchungCustomBean openBuchung = this.getOpenBuchung();
                if (openBuchung != null) {
                    result.add(openBuchung);
                }
            } else {
                date = daySensitive ? NutzungCustomBean.getDateWithoutTime(date) : date;
                for (NutzungBuchungCustomBean curBuchung : this.getNutzungsBuchungen()) {
                    Date gueltigBis;
                    Date gueltigVon = daySensitive ? NutzungCustomBean.getDateWithoutTime(curBuchung.getGueltigvon()) : curBuchung.getGueltigvon();
                    Date date2 = gueltigBis = daySensitive ? NutzungCustomBean.getDateWithoutTime(curBuchung.getGueltigbis()) : curBuchung.getGueltigbis();
                    if (gueltigBis == null) {
                        Date date3 = gueltigBis = daySensitive ? NutzungCustomBean.getDateWithoutTime(new Date()) : new Date();
                    }
                    if (gueltigVon == null || !date.after(gueltigVon) && !NutzungCustomBean.getDateWithoutTime(date).equals(NutzungCustomBean.getDateWithoutTime(gueltigVon)) || !date.before(gueltigBis) && !date.equals(gueltigBis)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Passende Nutzung mit gew\u00fcnschtem Zeitbereich gefunden");
                    }
                    result.add(curBuchung);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<NutzungBuchungCustomBean> getBuchungForDay(Date val) {
        return this.getBuchungForDate(val, true);
    }

    @Override
    public int getBuchungsCount() {
        if (this.getNutzungsBuchungen() != null) {
            return this.getNutzungsBuchungen().size();
        }
        return 0;
    }

    @Override
    public int getBuchungsNummerForBuchung(NutzungBuchungCustomBean val) {
        if (val != null && this.getBuchungsCount() > 0 && val.getNutzung() != null && val.getNutzung().equals(this)) {
            return this.getNutzungsBuchungen().indexOf(val) + 1;
        }
        return -1;
    }

    @Override
    public NutzungBuchungCustomBean getBuchwert() throws IllegalNutzungStateException {
        block4: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"getBuchwert()");
            }
            if (this.getBuchungsCount() > 0) {
                try {
                    return this.getBuchwert(this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1));
                }
                catch (Exception silent) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)"error getting Buchwert", (Throwable)silent);
                }
            }
        }
        throw new IllegalNutzungStateException("Kein Buchwert");
    }

    @Override
    public NutzungBuchungCustomBean getBuchwert(NutzungBuchungCustomBean val) throws IllegalNutzungStateException, NullPointerException, BuchungNotInNutzungException {
        if (val == null) {
            throw new NullPointerException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getBuchwert(NutzungsBuchung)");
        }
        if (this.getBuchungsCount() > 0) {
            if (!this.isBuchungInNutzung(val)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Buchung geh\u00f6rt nicht zu Nutzung");
                }
                throw new BuchungNotInNutzungException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Nutzungen vorhanden");
            }
            int index = -1;
            if (this.getNutzungsBuchungen() != null && (index = this.getNutzungsBuchungen().indexOf(val)) != -1) {
                ListIterator<NutzungBuchungCustomBean> buchungsItr;
                NutzungBuchungCustomBean lastListValue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Startindex ist: " + index));
                }
                if ((lastListValue = (buchungsItr = this.getNutzungsBuchungen().listIterator(index)).next()).getIstBuchwert()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Letzter Eintrag ist Buchwert");
                    }
                    return lastListValue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Letzte Buchung ist nicht buchwert");
                }
                NutzungBuchungCustomBean lastBuchwert = null;
                while (buchungsItr.hasPrevious()) {
                    NutzungBuchungCustomBean curBuchwert = buchungsItr.previous();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Pr\u00fcfe Nutzung: " + curBuchwert.getId()));
                    }
                    if (!curBuchwert.getIstBuchwert()) continue;
                    lastBuchwert = curBuchwert;
                    break;
                }
                if (lastBuchwert != null) {
                    return lastBuchwert;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Kein Buchwert gefunden");
                }
            }
        }
        throw new IllegalNutzungStateException("Kein Buchwert");
    }

    @Override
    public Double getBuchwertBetrag() throws IllegalNutzungStateException {
        NutzungBuchungCustomBean buchwert = this.getBuchwert();
        if (buchwert != null && buchwert.getGesamtpreis() != null) {
            return buchwert.getGesamtpreis();
        }
        return null;
    }

    @Override
    public Double getBuchwertDifference() throws IllegalNutzungStateException {
        Double currentValue;
        Double bookValue;
        if (this.getBuchungsCount() == 1) {
            if (this.getBuchwert() != null) {
                return 0.0;
            }
        } else if (this.getBuchungsCount() > 1 && (bookValue = this.getBuchwertBetrag()) != null & (currentValue = this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1).getGesamtpreis()) != null) {
            return currentValue - bookValue;
        }
        return null;
    }

    @Override
    public Collection<NutzungsBuchung.NUTZUNG_BUCHUNG_FIELDS> getDifferenceBetweenLastBuchung() {
        if (this.getBuchungsCount() > 1) {
            NutzungBuchungCustomBean lastBuchung = this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1);
            NutzungBuchungCustomBean previousBuchung = this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 2);
            return NutzungBuchungCustomBean.NUTZUNG_HISTORY_EQUALATOR.determineUnequalFields(lastBuchung, previousBuchung);
        }
        return new HashSet<NutzungsBuchung.NUTZUNG_BUCHUNG_FIELDS>();
    }

    @Override
    public Double getDifferenceToPreviousBuchung() {
        if (this.getBuchungsCount() > 1) {
            NutzungBuchungCustomBean currentBuchung = this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1);
            NutzungBuchungCustomBean previousBuchung = this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 2);
            if (previousBuchung != null && currentBuchung != null && previousBuchung.getGesamtpreis() != null && currentBuchung.getGesamtpreis() != null) {
                return currentBuchung.getGesamtpreis() - previousBuchung.getGesamtpreis();
            }
        }
        return null;
    }

    @Override
    public List<NutzungBuchungCustomBean> getNutzungsBuchungen() {
        return this.sortedBuchungen;
    }

    @Override
    public Collection<Nutzung.NUTZUNG_STATES> getNutzungsState() throws IllegalNutzungStateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Bestimme Status der Nutzungskette");
        }
        HashSet<Nutzung.NUTZUNG_STATES> nutzungStates = new HashSet<Nutzung.NUTZUNG_STATES>();
        if (this.getId() == null || this.getId() == -1) {
            nutzungStates.add(Nutzung.NUTZUNG_STATES.NUTZUNG_CREATED);
        }
        if (this.getBuchungsCount() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Es sind Buchungen vorhanden");
            }
            if (this.mustBeTerminated()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Nutzung soll terminiert werden");
                }
                nutzungStates.add(Nutzung.NUTZUNG_STATES.NUTZUNG_TERMINATED);
            }
            if (this.getBuchungsCount() == 1) {
                Integer id;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Es ist genau eine Buchung vorhanden");
                }
                if ((id = this.getNutzungsBuchungen().get(0).getId()) == null || id == -1) {
                    nutzungStates.add(Nutzung.NUTZUNG_STATES.BUCHUNG_CREATED);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Mehr als eine Buchung vorhanden");
                }
                if (this.hasNewBuchung()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Neue Buchung vorhanden.");
                        LOG.debug((Object)"Pr\u00fcfe Feld\u00e4nderungen...");
                    }
                    Collection<NutzungsBuchung.NUTZUNG_BUCHUNG_FIELDS> changeSet = this.getDifferenceBetweenLastBuchung();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Neue Buchungen vorhanden");
                    }
                    nutzungStates.add(Nutzung.NUTZUNG_STATES.BUCHUNG_CREATED);
                    if (changeSet.size() == 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Keine Benutzer \u00c4nderungen");
                        }
                    } else {
                        int distanceBWToLastBuchung;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Nutzung Changed");
                        }
                        nutzungStates.add(Nutzung.NUTZUNG_STATES.NUTZUNG_CHANGED);
                        if (changeSet.contains((Object)NutzungsBuchung.NUTZUNG_BUCHUNG_FIELDS.NUTZUNGSART)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Nutzungsart changed");
                            }
                            nutzungStates.add(Nutzung.NUTZUNG_STATES.NUTZUNGSART_CHANGED);
                        }
                        if ((distanceBWToLastBuchung = this.getDistanceFromLastBuchungToBuchwert()) != -1) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Pr\u00fcfe Stille Reserve...");
                            }
                            if (changeSet.contains((Object)NutzungsBuchung.NUTZUNG_BUCHUNG_FIELDS.FLAECHE) || changeSet.contains((Object)NutzungsBuchung.NUTZUNG_BUCHUNG_FIELDS.QUADRADMETERPREIS)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"Fl\u00e4che oder Preis hat sich ge\u00e4ndert");
                                }
                                if (distanceBWToLastBuchung == 0) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"Sollte nicht vorkommen Fall schon abgefangen");
                                    }
                                } else if (distanceBWToLastBuchung == 1) {
                                    Double deltaLastBuchung;
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"Die Buchung folgt direkt auf den Buchwert");
                                    }
                                    if ((deltaLastBuchung = this.getDifferenceToPreviousBuchung()) != null) {
                                        if (deltaLastBuchung > 0.0) {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)"Stille Reserve gebildet");
                                            }
                                            nutzungStates.add(Nutzung.NUTZUNG_STATES.STILLE_RESERVE_CREATED);
                                            nutzungStates.add(Nutzung.NUTZUNG_STATES.POSITIVE_BUCHUNG);
                                        } else {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)"Negative Buchung keine Stille Reserve");
                                            }
                                            nutzungStates.add(Nutzung.NUTZUNG_STATES.NEGATIVE_BUCHUNG);
                                        }
                                    }
                                } else {
                                    Double deltaBuchwert = this.getBuchwertDifference();
                                    Double deltaLastBuchung = this.getDifferenceToPreviousBuchung();
                                    if (deltaLastBuchung != null) {
                                        if (deltaLastBuchung > 0.0) {
                                            nutzungStates.add(Nutzung.NUTZUNG_STATES.POSITIVE_BUCHUNG);
                                        } else {
                                            nutzungStates.add(Nutzung.NUTZUNG_STATES.NEGATIVE_BUCHUNG);
                                        }
                                    }
                                    if (deltaBuchwert != null) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("delta Buchwert: " + deltaBuchwert));
                                        }
                                        if (deltaBuchwert > 0.0) {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)"Stille Reserve vorhanden");
                                            }
                                            if (deltaLastBuchung != null) {
                                                if (LOG.isDebugEnabled()) {
                                                    LOG.debug((Object)("deltaLastBuchung: " + deltaLastBuchung));
                                                }
                                                if (deltaLastBuchung >= deltaBuchwert) {
                                                    if (LOG.isDebugEnabled()) {
                                                        LOG.debug((Object)"Stille Reserve wurde angelegt");
                                                    }
                                                    nutzungStates.add(Nutzung.NUTZUNG_STATES.STILLE_RESERVE_CREATED);
                                                } else if (deltaLastBuchung > 0.0) {
                                                    if (LOG.isDebugEnabled()) {
                                                        LOG.debug((Object)"Stille Reserve wurde erh\u00f6t");
                                                    }
                                                    nutzungStates.add(Nutzung.NUTZUNG_STATES.STILLE_RESERVE_INCREASED);
                                                    nutzungStates.add(Nutzung.NUTZUNG_STATES.STILLE_RESERVE_EXISTING);
                                                } else if (deltaLastBuchung < 0.0) {
                                                    if (LOG.isDebugEnabled()) {
                                                        LOG.debug((Object)"Stille Reserve wurde vermindert");
                                                    }
                                                    nutzungStates.add(Nutzung.NUTZUNG_STATES.STILLE_RESERVE_DECREASED);
                                                    nutzungStates.add(Nutzung.NUTZUNG_STATES.STILLE_RESERVE_EXISTING);
                                                }
                                            }
                                        } else {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)"Keine Stille Reserve vorhanden");
                                            }
                                            if (deltaLastBuchung < deltaBuchwert) {
                                                if (LOG.isDebugEnabled()) {
                                                    LOG.debug((Object)"Stille Reserve wurde aufgel\u00f6st");
                                                }
                                                nutzungStates.add(Nutzung.NUTZUNG_STATES.STILLE_RESERVE_DISOLVED);
                                            } else if (deltaLastBuchung > 0.0) {
                                                if (LOG.isDebugEnabled()) {
                                                    LOG.debug((Object)"Positive Buchung");
                                                }
                                            } else if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)"Negative Buchung");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Keine neue Buchung vorhanden");
                }
            }
        }
        return nutzungStates;
    }

    @Override
    public NutzungBuchungCustomBean getOpenBuchung() {
        if (this.getBuchungsCount() > 0 && !this.isTerminated()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"nutzungen available, not terminated");
            }
            return this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1);
        }
        return null;
    }

    public NutzungBuchungCustomBean getLastBuchung() {
        if (this.getBuchungsCount() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"nutzungen available");
            }
            return this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1);
        }
        return null;
    }

    @Override
    public NutzungBuchungCustomBean getPredecessorBuchung(NutzungBuchungCustomBean val) {
        int successorIndex;
        if (val != null && this.getBuchungsCount() > 1 && (successorIndex = this.getNutzungsBuchungen().indexOf(val)) != -1 && successorIndex > 0) {
            return this.getNutzungsBuchungen().get(successorIndex - 1);
        }
        return null;
    }

    @Override
    public NutzungBuchungCustomBean getPreviousBuchung() {
        if (this.getBuchungsCount() > 1) {
            return this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 2);
        }
        return null;
    }

    @Override
    public Double getStilleReserve() throws IllegalNutzungStateException {
        Double bookValueDifference = this.getBuchwertDifference();
        return bookValueDifference != null && bookValueDifference > 0.0 ? bookValueDifference : 0.0;
    }

    @Override
    public Double getStilleReserveForBuchung(NutzungBuchungCustomBean val) throws IllegalNutzungStateException, BuchungNotInNutzungException {
        if (val != null && this.getBuchungsCount() > 0 && val.getGesamtpreis() != null) {
            if (!this.isBuchungInNutzung(val)) {
                throw new BuchungNotInNutzungException();
            }
            NutzungBuchungCustomBean buchwert = this.getBuchwert(val);
            if (buchwert != null && buchwert.getGesamtpreis() != null) {
                double difference = val.getGesamtpreis() - buchwert.getGesamtpreis();
                if (difference >= 0.0) {
                    return difference;
                }
                return 0.0;
            }
        }
        return null;
    }

    @Override
    public NutzungBuchungCustomBean getTerminalBuchung() {
        if (this.getBuchungsCount() > 0 && this.isTerminated()) {
            return this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1);
        }
        return null;
    }

    @Override
    public boolean hasNewBuchung() {
        if (this.getBuchungsCount() > 0) {
            Integer id = this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1).getId();
            return id == null || id == -1;
        }
        return false;
    }

    @Override
    public boolean isBuchungFlippable(NutzungBuchungCustomBean val) {
        if (val == null) {
            return false;
        }
        if (this.getBuchungsCount() < 1 || !this.isBuchungInNutzung(val)) {
            return false;
        }
        return this.getNutzungsBuchungen().indexOf(val) != 0;
    }

    @Override
    public boolean isTerminated() {
        NutzungBuchungCustomBean lastBuchung;
        return this.getBuchungsCount() > 0 && (lastBuchung = this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1)).getGueltigbis() != null;
    }

    @Override
    public boolean mustBeTerminated() {
        NutzungBuchungCustomBean terminalBuchung = this.getTerminalBuchung();
        return terminalBuchung != null && terminalBuchung.getSollGeloeschtWerden();
    }

    @Override
    public boolean removeOpenNutzung() {
        if (this.getBuchungsCount() > 1 && this.hasNewBuchung()) {
            this.getPreviousBuchung().setGueltigbis(null);
            this.getNutzungsBuchungen().remove(this.getNutzungsBuchungen().size() - 1);
            return true;
        }
        return false;
    }

    public void removeBuchungWithoutCreatingAHistory(NutzungBuchungCustomBean buchung) {
        if (buchung != this.getLastBuchung()) {
            LOG.warn((Object)"Entfernen von Buchung nicht m\u00f6glich. Buchung ist nicht die chronologisch letzte Buchung.");
            return;
        }
        if (!this.isTerminated()) {
            this.getPreviousBuchung().setGueltigbis(null);
        }
        this.getNutzungsBuchungen().remove(buchung);
        this.n_buchungen.remove(buchung);
    }

    @Override
    public void setNutzungsBuchungen(List<NutzungBuchungCustomBean> val) {
    }

    @Override
    public void terminateNutzung(Date val) throws TerminateNutzungNotPossibleException {
        if (val == null) {
            throw new TerminateNutzungNotPossibleException("Terminierung nicht m\u00f6glich datum ist Null");
        }
        if (this.getOpenBuchung() == null) {
            throw new TerminateNutzungNotPossibleException("Nutzung hat keine offene Buchung");
        }
        NutzungBuchungCustomBean terminalBuchung = this.getOpenBuchung();
        terminalBuchung.setGueltigbis(val);
        terminalBuchung.setSollGeloeschtWerden(true);
    }

    public String toString() {
        return "de.cismet.lagisEE.entity.core.Nutzung[id=" + this.getId() + "]";
    }

    protected Object clone() throws CloneNotSupportedException {
        block8: {
            try {
                if (this.getBuchungsCount() > 0) {
                    NutzungBuchungCustomBean[] nutzungBuchungen = this.getNutzungsBuchungen().toArray(new NutzungBuchungCustomBean[0]);
                    NutzungCustomBean clone = NutzungCustomBean.createNew((NutzungBuchungCustomBean)nutzungBuchungen[0].clone());
                    for (int i = 1; i < nutzungBuchungen.length; ++i) {
                        try {
                            clone.addBuchung((NutzungBuchungCustomBean)nutzungBuchungen[i].clone());
                            continue;
                        }
                        catch (Exception ex) {
                            throw new CloneNotSupportedException();
                        }
                    }
                    return clone;
                }
            }
            catch (AddingOfBuchungNotPossibleException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Clonen nicht m\u00f6glich --> Problem beim hinzuf\u00fcgen", (Throwable)ex);
                }
            }
            catch (IllegalNutzungStateException ex) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)"Clonen nicht m\u00f6glich --> Kein Buchwert", (Throwable)ex);
            }
        }
        throw new CloneNotSupportedException();
    }

    private boolean isBuchungInNutzung(NutzungBuchungCustomBean buchung) {
        if (this.getBuchungsCount() > 0) {
            return this.getNutzungsBuchungen().contains(buchung);
        }
        return false;
    }

    private static Date getDateWithoutTime(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calender = new GregorianCalendar();
        calender.setTime(date);
        calender.set(10, 0);
        calender.set(12, 0);
        calender.set(13, 0);
        calender.set(14, 0);
        calender.set(9, 0);
        return calender.getTime();
    }

    private int getDistanceFromLastBuchungToBuchwert() throws IllegalNutzungStateException {
        if (this.getBuchungsCount() > 0) {
            NutzungBuchungCustomBean buchwert = this.getBuchwert();
            NutzungBuchungCustomBean lastBuchung = this.getNutzungsBuchungen().get(this.getNutzungsBuchungen().size() - 1);
            int buchwertIndex = this.getNutzungsBuchungen().indexOf(buchwert);
            int lastBuchungIndex = this.getNutzungsBuchungen().indexOf(lastBuchung);
            if (buchwertIndex != -1 && lastBuchungIndex != -1) {
                if (buchwertIndex == lastBuchungIndex) {
                    return 0;
                }
                return lastBuchungIndex - buchwertIndex;
            }
        }
        return -1;
    }
}

